// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MoniTool_DB_HeaderFile
#define _MoniTool_DB_HeaderFile

#ifndef _Handle_MoniTool_SignText_HeaderFile
#include <Handle_MoniTool_SignText.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfTransient_HeaderFile
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_MoniTool_CaseData_HeaderFile
#include <Handle_MoniTool_CaseData.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class MoniTool_SignText;
class TColStd_HSequenceOfTransient;
class Standard_Transient;
class MoniTool_CaseData;
class TopoDS_Shape;
class gp_XYZ;
class gp_XY;
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This rather internal class is intended to give access to data <br>
//!           which caused an internal problem (exception, error ...). <br>
//! <br>
//!           The standard dbx allows to see immediate values, additional <br>
//!           features offered by DRAW allow to store or record shapes, <br>
//!           but in a very restrictive sense <br>
//!           In addition, to count steps can be tedious and not reliable <br>
//! <br>
//!           This tool allows to record data which have caused a problem, <br>
//!           then to restitute them after <br>
//! <br>
//!           While each processor can have one, a current DB is provided <br>
//!           This allow to fill it by getting it as static Cur <br>
class MoniTool_DB  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT MoniTool_DB();

//! Sets a SignText to print status of a recorded entity <br>
Standard_EXPORT   void SetSignEntity(const Handle(MoniTool_SignText)& asign) ;

//! Returns the current DB <br>
//!           Remark : it is locked if the (setenv) variable WB is not set <br>
Standard_EXPORT static  MoniTool_DB& Cur() ;

//! Clears all the recorded data <br>
Standard_EXPORT   void Clear() ;

//! Returns the lock  flag, can be modified (passed by address) <br>
//!           When it is set, Add actions are inhibited <br>
Standard_EXPORT   Standard_Boolean& Lock() ;

//! Returns the trace flag, can be modified (passed by address) <br>
//!           When it is set, Add(Set only) actions are traced (set name) on <br>
//!           standard C++ output (cout) <br>
Standard_EXPORT   Standard_Boolean& Trace() ;

//! Records an Entity to be added later, by AddRecorded <br>
//!           This allows a calling program to "preset" a starting entity, <br>
//!           unknown from the called routine <br>
//!           It can then be used to query transfer maps (ignored elsewhere) <br>
Standard_EXPORT   void Record(const Handle(Standard_Transient)& ent) ;

//! Clears the pre-recorded Entity <br>
Standard_EXPORT   void RecordClear() ;

//! Removes a Set at the number <num> <br>
//!           Does nothing if <num> is out of range <br>
Standard_EXPORT   void RemoveSet(const Standard_Integer num) ;

//! Gets the recorded data set from <other> and adds them to <me> <br>
Standard_EXPORT   void AddFrom(const MoniTool_DB& other) ;

//! Adds an already defined set of data <br>
Standard_EXPORT   void AddSet(const Handle(MoniTool_CaseData)& aset) ;

//! Adds a new set of data <br>
//!           The following methods Add... add data to this set <br>
Standard_EXPORT   void Add(const Standard_CString name) ;

//! Unitary adding a data; rather internal <br>
Standard_EXPORT   void AddData(const Handle(Standard_Transient)& val,const Standard_Integer kind,const Standard_CString name) ;

//! Adds the currently caught exception <br>
Standard_EXPORT   void AddRaised(const Standard_CString name = "") ;

//! Adds a Shape (recorded as a HShape) <br>
Standard_EXPORT   void AddShape(const TopoDS_Shape& sh,const Standard_CString name = "") ;

//! Adds a XYZ <br>
Standard_EXPORT   void AddXYZ(const gp_XYZ& aXYZ,const Standard_CString name = "") ;

//! Adds a XY <br>
Standard_EXPORT   void AddXY(const gp_XY& aXY,const Standard_CString name = "") ;

//! Adds a Real <br>
Standard_EXPORT   void AddReal(const Standard_Real val,const Standard_CString name = "") ;

//! Adds two reals (for instance, two parameters) <br>
Standard_EXPORT   void AddReals(const Standard_Real v1,const Standard_Real v2,const Standard_CString name = "") ;

//! Adds the CPU time between lastCPU and now <br>
//!           if <curCPU> is given, the CPU amount is  curCPU-lastCPU <br>
//!           else it is currently measured CPU - lastCPU <br>
//!           lastCPU has been read by call to GetCPU <br>
//!           See GetCPU to get amount, and LargeCPU to test large amount <br>
Standard_EXPORT   void AddCPU(const Standard_Real lastCPU,const Standard_Real curCPU = 0,const Standard_CString name = "") ;

//! Returns the current amount of CPU <br>
//!           This allows to laterly test and record CPU amount <br>
//!           Its value has to be given to LargeCPU and AddCPU <br>
Standard_EXPORT   Standard_Real GetCPU() const;

//! Tells if a CPU time amount is large <br>
//!           <maxCPU>  gives the amount over which an amount is large <br>
//!           <lastCPU> gives the start CPU amount <br>
//!           if <curCPU> is given, the tested CPU amount is curCPU-lastCPU <br>
//!           else it is currently measured CPU - lastCPU <br>
Standard_EXPORT   Standard_Boolean LargeCPU(const Standard_Real maxCPU,const Standard_Real lastCPU,const Standard_Real curCPU = 0) const;

//! Adds a Geometric as a Transient (Curve, Surface ...) <br>
Standard_EXPORT   void AddGeom(const Handle(Standard_Transient)& geom,const Standard_CString name = "") ;

//! Adds a Transient, as an Entity from an InterfaceModel for <br>
//!           instance : it will then be printed with the help of a DBPE <br>
Standard_EXPORT   void AddEntity(const Handle(Standard_Transient)& ent,const Standard_CString name = "") ;

//! Adds the pre-recorded Entity, if defined; else does nothing <br>
Standard_EXPORT   void AddRecorded(const Standard_CString name = "") ;

//! Adds a Text (as HAsciiString) <br>
Standard_EXPORT   void AddText(const Standard_CString text,const Standard_CString name = "") ;

//! Adds an Integer <br>
Standard_EXPORT   void AddInteger(const Standard_Integer val,const Standard_CString name = "") ;

//! Adds a Transient, with no more meaning <br>
Standard_EXPORT   void AddAny(const Handle(Standard_Transient)& val,const Standard_CString name = "") ;

//! Returns the count of recorded sets <br>
Standard_EXPORT   Standard_Integer NbSets() const;

//! Returns a set <br>
Standard_EXPORT   Handle_MoniTool_CaseData Set(const Standard_Integer num) const;

//! Returns the name attached to a set <br>
Standard_EXPORT   Standard_CString Name(const Standard_Integer num) const;

//! Returns the Number of a Set which has a given Name <br>
//!           By default, searches for the first one <br>
//!           May search after a given number <br>
//!           Returns 0 if not found <br>
Standard_EXPORT   Standard_Integer NameNum(const Standard_CString name,const Standard_Integer after = 0) const;

//! Returns the count of data recorded to a set <br>
Standard_EXPORT   Standard_Integer NbData(const Standard_Integer num) const;

//! Returns a data item (n0 <nd> in the set <num>) <br>
Standard_EXPORT   Handle_Standard_Transient Data(const Standard_Integer num,const Standard_Integer nd) const;

//! Returns the kind of a data : See class CaseData <br>
Standard_EXPORT   Standard_Integer Kind(const Standard_Integer num,const Standard_Integer nd) const;

//! Returns the name of a data item (n0 <nd> in set <num>) <br>
//!           Empty if not named <br>
Standard_EXPORT  const TCollection_AsciiString& DataName(const Standard_Integer num,const Standard_Integer nd) const;

//! Returns the rank of a named item in the data set <num>, <br>
//!           zero if not found. <br>
//!           For more details, see class CaseData <br>
Standard_EXPORT   Standard_Integer DataNum(const Standard_Integer num,const Standard_CString name) const;

//! Returns a data as a shape, Null if not a shape <br>
Standard_EXPORT   TopoDS_Shape Shape(const Standard_Integer num,const Standard_Integer nd) const;

//! Returns a data as a XYZ (i.e. Geom_CartesianPoint) <br>
//!           Returns False if not the good type <br>
Standard_EXPORT   Standard_Boolean XYZ(const Standard_Integer num,const Standard_Integer nd,gp_XYZ& val) const;

//! Returns a data as a XY  (i.e. Geom2d_CartesianPoint) <br>
//!           Returns False if not the good type <br>
Standard_EXPORT   Standard_Boolean XY(const Standard_Integer num,const Standard_Integer nd,gp_XY& val) const;

//! Returns a couple of reals  (stored in Geom2d_CartesianPoint) <br>
Standard_EXPORT   Standard_Boolean Reals(const Standard_Integer num,const Standard_Integer nd,Standard_Real& v1,Standard_Real& v2) const;

//! Returns a real or CPU amount (stored in Geom2d_CartesianPoint) <br>
Standard_EXPORT   Standard_Boolean Real(const Standard_Integer num,const Standard_Integer nd,Standard_Real& val) const;

//! Returns a text (stored in TCollection_HAsciiString) <br>
Standard_EXPORT   Standard_Boolean Text(const Standard_Integer num,const Standard_Integer nd,Standard_CString& text) const;

//! Returns a real or CPU amount (stored in Geom2d_CartesianPoint) <br>
Standard_EXPORT   Standard_Boolean Integer(const Standard_Integer num,const Standard_Integer nd,Standard_Integer& val) const;

//! Prints the CPU amount between lastCPU and curCPU. If curCPU is <br>
//!           0, the current CPU amount is taken <br>
Standard_EXPORT   void PrintCPU(Standard_OStream& S,const Standard_CString mess,const Standard_Real lastCPU,const Standard_Real curCPU = 0) const;

//! Prints content (short form) to an ostream, according to n1,n2: <br>
//!           n1 = n2 = 0 : count of sets <br>
//!           n1 > 0 : for each set, its name and count of data, between <br>
//!             n1 and n2, or n1 and end if n2=0 (n1=1,n2=0 : all sets) <br>
//!           n1 = 0, n2 > 0 : for the set n0 n2, short printing of its data <br>
//! <br>
//!           <context> is used for Entity kind data : the function DBPE, <br>
//!           if defined, is then used to print its type and identification <br>
//!           For instance, context can be an InterfaceModel. But this <br>
//!           package has no link with Interface : upper level packages <br>
//!           can set a specific DBPE to exploit <context> <br>
//!           If DBPE is not set, just DynamicType is printed <br>
Standard_EXPORT   void Print(Standard_OStream& S,const Handle(Standard_Transient)& context,const Standard_Integer n1 = 0,const Standard_Integer n2 = 0) const;

//! Prints content (short form) to an ostream, according to n1,n2: <br>
//!           As precedent form, but entities are just printed their <br>
//!           DynamicType <br>
Standard_EXPORT   void Print(Standard_OStream& S,const Standard_Integer n1 = 0,const Standard_Integer n2 = 0) const;

//! Dumps a data (nd of set num) to an ostream <br>
//!           <level> not yet used, to give a level <br>
//!           Returns True if done, False if not implemented <br>
Standard_EXPORT   Standard_Boolean Dump(Standard_OStream& S,const Standard_Integer num,const Standard_Integer nd,const Standard_Integer level = 1) const;

//! Writes a data according to its type, to a file with a name <br>
//!           Returns True if done, False if not implemented <br>
//!           Data is num,nd if nd > 0 <br>
//!           mode = 0 (D) : takes the file name exactly <br>
//!           mode = 1 : adds a suffix to the file name : _nd <br>
//! <br>
//!           If nd = 0, writes all the data, as follows <br>
//!           mode = 0 (D) : each file suffixed by _nd, all data are written <br>
//!           mode = 1 : only Shapes and Geoms are written <br>
Standard_EXPORT   Standard_Boolean Write(const Standard_CString file,const Standard_Integer num,const Standard_Integer nd,const Standard_Integer mode) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_MoniTool_SignText thesignent;
Handle_TColStd_HSequenceOfTransient thesets;
Handle_Standard_Transient therec;
Handle_Standard_Transient thered;
Standard_Integer thelast;
Standard_Boolean thelock;
Standard_Boolean thetrace;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
