// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _PTopLoc_Location_HeaderFile
#define _PTopLoc_Location_HeaderFile

#ifndef _Handle_PTopLoc_ItemLocation_HeaderFile
#include <Handle_PTopLoc_ItemLocation.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Handle_PTopLoc_Datum3D_HeaderFile
#include <Handle_PTopLoc_Datum3D.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class PTopLoc_ItemLocation;
class Standard_NoSuchObject;
class PTopLoc_Datum3D;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& PTopLoc_Location_Type_();

//! A Storable  composed local coordinate system. Made <br>
//!          with local   coordinate systems raised   to  power <br>
//!          elevation. <br>
//! <br>
//!          A Location is either : <br>
//! <br>
//!          * The Identity. <br>
//! <br>
//!          * The product  of a Datum3D raised  to a power and <br>
//!          an other Location called the next Location. <br>
class PTopLoc_Location  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 

//! Creates an Identity Location. <br>
Standard_EXPORT PTopLoc_Location();

//! Creates a location being the product. <br>
//!          N * D ^ P <br>
Standard_EXPORT PTopLoc_Location(const Handle(PTopLoc_Datum3D)& D,const Standard_Integer P,const PTopLoc_Location& N);

//! True when the location is an identity. <br>
Standard_EXPORT   Standard_Boolean IsIdentity() const;

//! Returns the first Datum. An error is raised if the <br>
//!          location is an identity. <br>
Standard_EXPORT   Handle_PTopLoc_Datum3D Datum3D() const;

//! Returns the power elevation of the first datum. An <br>
//!          error is raised if the location is an identity. <br>
Standard_EXPORT   Standard_Integer Power() const;

//! Returns next Location. An error is raised if the <br>
//!          location is an identity. <br>
Standard_EXPORT   PTopLoc_Location Next() const;
    Handle(PTopLoc_ItemLocation) _CSFDB_GetPTopLoc_LocationmyData() const { return myData; }
    void _CSFDB_SetPTopLoc_LocationmyData(const Handle(PTopLoc_ItemLocation)& p) { myData = p; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& PTopLoc_Location_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_PTopLoc_ItemLocation myData;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
