// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _PrsMgr_Presentation2d_HeaderFile
#define _PrsMgr_Presentation2d_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_PrsMgr_Presentation2d_HeaderFile
#include <Handle_PrsMgr_Presentation2d.hxx>
#endif

#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _PrsMgr_Presentation_HeaderFile
#include <PrsMgr_Presentation.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager2d_HeaderFile
#include <Handle_PrsMgr_PresentationManager2d.hxx>
#endif
#ifndef _PrsMgr_KindOfPrs_HeaderFile
#include <PrsMgr_KindOfPrs.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Graphic2d_GraphicObject;
class PrsMgr_PresentationManager2d;
class PrsMgr_PresentableObject;


//! A framework to manage 2D displays, graphic entities <br>
//! and their updates. Plotters, Highlights, Minima <br>
//! maxima, immediate display. <br>
class PrsMgr_Presentation2d : public PrsMgr_Presentation {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT   PrsMgr_KindOfPrs KindOfPresentation() const;

//! removes the whole content of the presentation. <br>
Standard_EXPORT virtual  void Clear() ;

//! Specifies an Offset applied to the original color <br>
//!	    index of all primitives in the graphic object <me>. <br>
//!  Warning: To reset the real color of the primitives <br>
//!	    you have to call this method with <anOffset> = 0. <br>
Standard_EXPORT   void SetOffset(const Standard_Integer anOffset) ;

//! Returns the Offset applied to the original color <br>
//!	    index of all primitives in the graphic object <me>. <br>
Standard_EXPORT   Standard_Integer Offset() const;


Standard_EXPORT   Handle_Graphic2d_GraphicObject Presentation() const;
//Standard_EXPORT ~PrsMgr_Presentation2d();


friend class PrsMgr_PresentationManager2d;
friend class PrsMgr_PresentableObject;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Creates a framework to manage displays and graphic <br>
//! entities with the 2D view aStructureManager. <br>
Standard_EXPORT PrsMgr_Presentation2d(const Handle(PrsMgr_PresentationManager2d)& aPresentationManager2d);


Standard_EXPORT   void Display() ;


Standard_EXPORT   void Erase() const;


Standard_EXPORT   void Highlight() ;


Standard_EXPORT   void Unhighlight() const;


Standard_EXPORT   Standard_Boolean IsDisplayed() const;


Standard_EXPORT   Standard_Boolean IsHighlighted() const;


Standard_EXPORT   Standard_Integer DisplayPriority() const;


Standard_EXPORT   void SetDisplayPriority(const Standard_Integer aNewPrior) ;


Standard_EXPORT   void Highlight(const Standard_Integer anIndex) const;

//! Allows the drawing on a plotter of the graphic object <br>
//! aPresentableObject with the display mode aMode. <br>
Standard_EXPORT   void EnablePlot() const;

//! Forbids the drawing on a plotter of the graphic object <br>
//! aPresentableObject with the display mode aMode. <br>
Standard_EXPORT   void DisablePlot() const;

//! Returns true if the graphic object aPresentableObject <br>
//! with the display mode aMode can be plotted. <br>
Standard_EXPORT   Standard_Boolean IsPlottable() const;


 // Fields PRIVATE
 //
Handle_Graphic2d_GraphicObject myStructure;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
