// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_FunctionRoot_HeaderFile
#define _math_FunctionRoot_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_FunctionWithDerivative;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements the computation of a root of a function of <br>
//! a single variable which is near an initial guess using a minimization <br>
//! algorithm.Knowledge of the derivative is required. The <br>
//! algorithm used is the same as in <br>
class math_FunctionRoot  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! The Newton-Raphson method is done to find the root of the function F <br>
//! from the initial guess Guess.The tolerance required on <br>
//! the root is given by Tolerance. Iterations are stopped if <br>
//! the expected solution does not stay in the range A..B. <br>
//! The solution is found when abs(Xi - Xi-1) <= Tolerance; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
Standard_EXPORT math_FunctionRoot(math_FunctionWithDerivative& F,const Standard_Real Guess,const Standard_Real Tolerance,const Standard_Integer NbIterations = 100);


//! The Newton-Raphson method is done to find the root of the function F <br>
//! from the initial guess Guess. <br>
//! The tolerance required on the root is given by Tolerance. <br>
//! Iterations are stopped if the expected solution does not stay in the <br>
//! range A..B <br>
//! The solution is found when abs(Xi - Xi-1) <= Tolerance; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
Standard_EXPORT math_FunctionRoot(math_FunctionWithDerivative& F,const Standard_Real Guess,const Standard_Real Tolerance,const Standard_Real A,const Standard_Real B,const Standard_Integer NbIterations = 100);
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;
//! returns the value of the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
  Standard_Real Root() const;
//! returns the value of the derivative at the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
  Standard_Real Derivative() const;
//! returns the value of the function at the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
  Standard_Real Value() const;
//! returns the number of iterations really done on the <br>
//! computation of the Root. <br>
//! Exception NotDone is raised if the root was not found. <br>
  Standard_Integer NbIterations() const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;
Standard_Real TheRoot;
Standard_Real TheError;
Standard_Real TheDerivative;
Standard_Integer NbIter;


};


#include <math_FunctionRoot.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
