/*********************************************************
 This file is part of the OpusTeX system.
 You are not allowed to change this file.
 For distribution see the copyright notice in 00readme.txt
*********************************************************/

#define VERSION "0.91ae\0"

/*********************************************************
 autonotes, error-hunting, optimizing program for OpusTeX.
 Andreas Egler, November 1996.
*********************************************************/

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define TRUE  1
#define FALSE 0

#define sCopy(x,y) strcpy(search,x); strcpy(replace,y);

#define CHG(x,y) sCopy(x,y) CHGI CHGII CHGIII CHGIV

#define CHGI   pos=posi(search);j=(int)strlen(replace);
#define CHGII  while(pos>=0){for(i=pos;i<j+pos;++i) Line[i]=replace[i-pos];
#define CHGIII for(i=pos+(int)strlen(search);i<=(int)strlen(Line);++i)
#define CHGIV  Line[i-((int)strlen(search)-j)]=Line[i];pos=posi(search);}

#define ChG(x,y) sCopy(x,y) ChGi ChGii ChGiii ChGiv

#define ChGi   pos=posi(search);j=(int)strlen(replace);diff=j-(int)strlen(search);
#define ChGii  while(pos>=0){ ii=pos+(int)strlen(search);for(i=(int)strlen(Line);
#define ChGiii i>ii-1;--i) Line[i+diff]=Line[i];for(i=pos;
#define ChGiv  i<j+pos;++i)Line[i]=replace[i-pos];pos=posi(search);}

FILE *infile, *outfile;
char *tok, Line[256], tmp[256];
int  linenr;
char name_of_file[256], n_o_f[256], name_tok[256], search[256], replace[256];

int posi(char dest[]);
void error_exit(int error_number);

int posi(dest) char dest[];
{ int i=0, j=0, Dest=(int)strlen(dest), Src=(int)strlen(Line);
  while (i < Src)
  { if (Line[i]==dest[j]) {++j; if (j==Dest) break;}
    else j=0;
    ++i;}
  if (j==Dest) return(++i-j); else return(-1);}

void error_exit(error_number) int error_number;
{ switch (error_number){
  case 0:
    printf("\nFile error: Disk full ?\n"); break;
  case 1:
    printf("\nUsage: autonote filename\n"); break;
  }
    printf("Program aborted. Check it out.\n");
    remove(n_o_f); exit(3);}

int main(argc, argv) int argc; char **argv;
{ register int pos, i, j, ii;
  int posi(), diff,
      inside=FALSE,
      old_inside=FALSE,
      found=FALSE,
      empty_line=FALSE;

  printf("\n <<< autonote %s >>>\n", VERSION);
  printf("\n ... decode command line\n");

  if (argc<2 || argc>3) error_exit(1);

/********************
 Open the input file.
*********************/

  strcpy(name_of_file, argv[1]);
  strcpy(n_o_f, strtok(name_of_file, "."));
  strcpy(name_tok, n_o_f);
  strcat(name_of_file, ".tex");

  printf(" ... open <%s> for input\n", name_of_file);

  infile = fopen( name_of_file, "r");
  if (!infile) {printf("\nFile not found: %s\n", name_of_file); exit(3);}

/*********************
 Open the output file.
**********************/

  strcat(n_o_f, ".tmp");
  printf(" ... open <%s> for output\n", n_o_f);
  remove(n_o_f);
  outfile = fopen( n_o_f, "w");
  if (!outfile) {printf("\nCan't create: %s\n", n_o_f); exit(3);}

/*****
 Scan.
******/

  printf(" ... scan header\n");

  while (fgets(Line, (int)sizeof(Line), infile))
  { linenr++;
    if(Line[0]==37) fputs(Line, outfile);
    else
    { empty_line=FALSE;
      if (!strcmp(Line, "\n\0")) empty_line=TRUE;   /* UNIX */
      if (!strcmp(Line, "\r\0")) empty_line=TRUE;   /* MAC */
      if (!strcmp(Line, "\r\n\0")) empty_line=TRUE; /* DOS */

      j=(int)strlen(Line)-1;
      if (j>0)
      {
        strcpy (Line, (strtok(Line, "\r\n")));   /* remove newline */
        strcpy (Line, (strtok(Line, "\r")));
        strcpy (Line, (strtok(Line, "\n")));
        while (Line[j-1]==' ') {Line[--j]='\0';} /* remove endline spaces */

        if(posi("\\zendpiece")>=0) inside=FALSE;
        if(posi("\\endpiece")>=0) inside=FALSE;
        if(posi("\\Endpiece")>=0) inside=FALSE;

        if (inside!=old_inside)
           {old_inside=inside; printf(" ... leave body\n");}

        if(posi("\\startpiece")>=0) inside=TRUE;
        if(posi("\\contpiece")>=0) inside=TRUE;
        if(posi("\\Contpiece")>=0) inside=TRUE;

        if (inside!=old_inside)
           {old_inside=inside; printf(" ... scan body\n");}

     /* optimizing */

        CHG("\\enotes", "\\en");
        CHG("&\\en", "\\en");
        CHG("|\\en", "\\en");
        CHG("|&", "&");
        CHG(" &", "&");
        CHG(" |", "|");
        CHG(" \\", "\\");
        CHG("\\tb0\\qb0", "\\tbq0");
        CHG("\\tb1\\qb1", "\\tbq1");
        CHG("\\tb2\\qb2", "\\tbq2");
        CHG("\\tb3\\qb3", "\\tbq3");
        CHG("\\tb4\\qb4", "\\tbq4");
        CHG("\\tb5\\qb5", "\\tbq5");
        CHG("\\tb6\\qb6", "\\tbq6");
        CHG("\\tb7\\qb7", "\\tbq7");
        CHG("\\tb8\\qb8", "\\tbq8");
        CHG("\\tb0\\zqb0", "\\tbzq0");
        CHG("\\tb1\\zqb1", "\\tbzq1");
        CHG("\\tb2\\zqb2", "\\tbzq2");
        CHG("\\tb3\\zqb3", "\\tbzq3");
        CHG("\\tb4\\zqb4", "\\tbzq4");
        CHG("\\tb5\\zqb5", "\\tbzq5");
        CHG("\\tb6\\zqb6", "\\tbzq6");
        CHG("\\tb7\\zqb7", "\\tbzq7");
        CHG("\\tb8\\zqb8", "\\tbzq8");

    /* decode line */

        strcpy (tmp, Line);
        tok=strtok(tmp,"\\");
        while (tok != NULL) {
          printf (":%s", tok);
/*

          if (!strcmp(tok,"an")) printf("Found \\an at line %i\n", linenr);
          if (!strcmp(tok,"en")) printf("Found \\en at line %i\n", linenr);
          if(posi("\\en ")>=0 || posi("\\en\0")>=0 || posi("\\en%%")>=0)
            printf("Found \\en at line %i\n", linenr);
*/
          tok=strtok(NULL,"\\");
        }
        printf("\n");
      }

  /* search for trouble at eoline */

      if (inside&&(posi("%")<0))
      { i=(int)strlen(Line)-1;
        while (Line[i]==' ') --i;
        if (!isalpha(Line[i])) found=TRUE; /* test last char in line */
        else
          while (isalpha(Line[i])) --i; /* skip all alphachars */
            if (Line[i]!='\\') found=TRUE;
      }

      if (found) {strcat(Line, "%"); found=FALSE;}

      if (!empty_line) {strcat(Line, "\n"); fputs(Line, outfile);}
      if (!inside&&empty_line) fputs(Line, outfile);

    } /* eo else */

  } /* eo while*/

/*************
 closing files
**************/

  fclose(infile);
  fclose(outfile);
  if (!outfile) error_exit(0);
  strcat(name_tok, ".ori");
  remove(name_tok);
  rename(name_of_file, name_tok);
  rename(n_o_f, name_of_file);
  remove(n_o_f);
  printf(" ... thats all, bye\n");

  return(0);
}
/*** eof ***/
