
/*	USER SIDE PRINTF 
 * Copyright Finite State Machine Labs Inc. March 2001.
 * by Victor Yodaiken
 *
 * All rights reserved. You are not permitted to remove
 * or modify this copyright notice and you may not 
 * modify or distribute this
 * code without explicit authorization from Finite State Machine Labs Inc.
 *
 * */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#define BUFSIZE 500
int buf[BUFSIZE];
int sz, IN;
void format_and_print(int fmtlen, char *fmt, char *data);

int main(){

	IN = open("/dev/rtf0",O_RDONLY);
	if(IN < 0){
		fprintf(stderr,"Can't open the fifo\n");
		exit(-1);
	}

	while( read(IN,&sz,sizeof(sz))  == sizeof(sz)){
		/* this is the start */
		if(read(IN,buf,sz) != sz){
			printf("Format error!\n");
		}
		else{
			int fmtlen = strlen( (char *)buf);
			char *fmt = (char *)buf;
			char *data = ((char *)buf)+fmtlen+1;
			format_and_print(fmtlen,fmt,data);
		}
	}

	return 0;
}

static int find_delim(const char *s,int index){
	while( s[index] && (s[index] !='%'))index++;
	return index;
}
static void ncpy(char *d, char *s,int n){
	while(n--){  *d++ = *s++;}
	return;
}
void format_and_print(int fmtlen, char *fmt, char *data)
{
       	double D;
       	int I;
       	char *S;
	char delim;
	int i,start=0;

	while(fmt[start]){
		i = find_delim(fmt,start);
		delim = fmt[i];
		fmt[i] = 0;
		fputs(&fmt[start],stdout);
		if(delim) // not at the end, must be a %
		{
			start = i+2; // skip format letter
			switch(fmt[i+1]) {
			       	case 's':         
				       	S = data;
					data += strlen(S)+1;
					printf("%s",S);
				       	break;
			       	case 'd':          
					ncpy((char *)&I,data,sizeof(I));
					printf("%d",I);
					data += sizeof(I);
					break;
			       	case 'c':           /* C "promotes" chars*/
					ncpy((char *)&I,data,sizeof(I));
					printf("%c",I);
					data += sizeof(I);
					break;
			       	case 'f':           
					ncpy((char *)&D,data,sizeof(D));
					printf("%f",D);
					data += sizeof(D);
				       	break;
		       	}
		}else start = i; // we're done.
	}
	fflush(stdout);
}
