/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout {
    Device device;
    Font font;
    String text;
    String segmentsText;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void breakRun(StyleItem styleItem) {
        if (styleItem.psla != 0) {
            return;
        }
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n = OS.GetProcessHeap();
        styleItem.psla = OS.HeapAlloc(n, 8, 1 * cArray.length);
        OS.ScriptBreak(cArray, cArray.length, styleItem.analysis, styleItem.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        int n;
        int n2;
        int n3;
        Object object;
        if (this.runs != null) {
            return;
        }
        int n4 = gC != null ? gC.handle : this.device.internal_new_GC(null);
        int n5 = OS.CreateCompatibleDC(n4);
        this.allRuns = this.itemize();
        int n6 = 0;
        while (n6 < this.allRuns.length - 1) {
            object = this.allRuns[n6];
            OS.SelectObject(n5, this.getItemFont((StyleItem)object));
            this.shape(n5, (StyleItem)object);
            ++n6;
        }
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        object = new SCRIPT_PROPERTIES();
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        int n10 = 0;
        while (n10 < this.allRuns.length - 1) {
            int n11;
            int n12;
            StyleItem styleItem = this.allRuns[n10];
            if (styleItem.length == 1) {
                n3 = this.segmentsText.charAt(styleItem.start);
                switch (n3) {
                    case 9: {
                        styleItem.tab = true;
                        if (this.tabs == null) break;
                        n2 = this.tabs.length;
                        n12 = 0;
                        while (n12 < n2) {
                            if (this.tabs[n12] > n7) {
                                styleItem.width = this.tabs[n12] - n7;
                                break;
                            }
                            ++n12;
                        }
                        if (n12 != n2) break;
                        n = this.tabs[n2 - 1];
                        int n13 = n11 = n2 > 1 ? this.tabs[n2 - 1] - this.tabs[n2 - 2] : this.tabs[0];
                        if (n11 <= 0) break;
                        while (n <= n7) {
                            n += n11;
                        }
                        styleItem.width = n - n7;
                        break;
                    }
                    case 10: {
                        styleItem.lineBreak = true;
                        break;
                    }
                    case 13: {
                        styleItem.lineBreak = true;
                        StyleItem styleItem2 = this.allRuns[n10 + 1];
                        if (styleItem2.length == 0 || this.segmentsText.charAt(styleItem2.start) != '\n') break;
                        ++styleItem.length;
                        styleItem2.free();
                        ++n10;
                    }
                }
            }
            if (this.wrapWidth != -1 && n7 + styleItem.width > this.wrapWidth && !styleItem.tab) {
                StyleItem[] styleItemArray;
                n3 = 0;
                int[] nArray = new int[styleItem.length];
                OS.ScriptGetLogicalWidths(styleItem.analysis, styleItem.length, styleItem.glyphCount, styleItem.advances, styleItem.clusters, styleItem.visAttrs, nArray);
                n12 = 0;
                n = this.wrapWidth - n7;
                while (n12 + nArray[n3] < n) {
                    n12 += nArray[n3++];
                }
                n11 = n3;
                int n14 = n10;
                while (n10 >= n8) {
                    this.breakRun(styleItem);
                    while (n3 >= 0) {
                        OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n3 * 1, 1);
                        if (sCRIPT_LOGATTR.fSoftBreak || sCRIPT_LOGATTR.fWhiteSpace) break;
                        --n3;
                    }
                    if (n3 == 0 && n10 != n8 && !styleItem.tab && sCRIPT_LOGATTR.fSoftBreak && !sCRIPT_LOGATTR.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem.analysis.eScript], 8);
                        short s = ((SCRIPT_PROPERTIES)object).langid;
                        styleItemArray = this.allRuns[n10 - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItemArray.analysis.eScript], 8);
                        if (((SCRIPT_PROPERTIES)object).langid == s || s == 0 || ((SCRIPT_PROPERTIES)object).langid == 0) {
                            this.breakRun((StyleItem)styleItemArray);
                            OS.MoveMemory(sCRIPT_LOGATTR, styleItemArray.psla + (styleItemArray.length - 1) * 1, 1);
                            if (!sCRIPT_LOGATTR.fWhiteSpace) {
                                n3 = -1;
                            }
                        }
                    }
                    if (n3 >= 0 || n10 == n8) break;
                    styleItem = this.allRuns[--n10];
                    n3 = styleItem.length - 1;
                }
                if (n3 == 0 && n10 != n8 && !styleItem.tab) {
                    styleItem = this.allRuns[--n10];
                } else if (n3 <= 0 && n10 == n8) {
                    n10 = n14;
                    styleItem = this.allRuns[n10];
                    n3 = Math.max(1, n11);
                }
                this.breakRun(styleItem);
                while (n3 < styleItem.length) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n3 * 1, 1);
                    if (!sCRIPT_LOGATTR.fWhiteSpace) break;
                    ++n3;
                }
                if (n3 > 0 && n3 < styleItem.length) {
                    StyleItem styleItem3 = new StyleItem();
                    styleItem3.start = styleItem.start + n3;
                    styleItem3.length = styleItem.length - n3;
                    styleItem3.style = styleItem.style;
                    styleItem3.analysis = styleItem.analysis;
                    styleItem.free();
                    styleItem.length = n3;
                    OS.SelectObject(n5, this.getItemFont(styleItem));
                    this.shape(n5, styleItem);
                    this.shape(n5, styleItem3);
                    styleItemArray = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, styleItemArray, 0, n10 + 1);
                    System.arraycopy(this.allRuns, n10 + 1, styleItemArray, n10 + 2, this.allRuns.length - n10 - 1);
                    this.allRuns = styleItemArray;
                    this.allRuns[n10 + 1] = styleItem3;
                }
                if (n10 != this.allRuns.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n7 += styleItem.width;
            if (styleItem.lineBreak) {
                n8 = n10 + 1;
                n7 = 0;
                ++n9;
            }
            ++n10;
        }
        n7 = 0;
        this.runs = new StyleItem[n9][];
        this.lineOffset = new int[n9 + 1];
        this.lineY = new int[n9 + 1];
        this.lineWidth = new int[n9];
        n10 = 0;
        int n15 = 0;
        n3 = Math.max(0, this.ascent);
        n2 = Math.max(0, this.descent);
        StyleItem[] styleItemArray = new StyleItem[this.allRuns.length];
        n = 0;
        while (n < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n];
            styleItemArray[n10++] = styleItem;
            n7 += styleItem.width;
            n3 = Math.max(n3, styleItem.ascent);
            n2 = Math.max(n2, styleItem.descent);
            if (styleItem.lineBreak || n == this.allRuns.length - 1) {
                if (n10 == 1 && n == this.allRuns.length - 1) {
                    TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.SelectObject(n5, this.getItemFont(styleItem));
                    OS.GetTextMetrics(n5, tEXTMETRIC);
                    styleItem.ascent = tEXTMETRIC.tmAscent;
                    styleItem.descent = tEXTMETRIC.tmDescent;
                    n3 = Math.max(n3, styleItem.ascent);
                    n2 = Math.max(n2, styleItem.descent);
                }
                this.runs[n15] = new StyleItem[n10];
                System.arraycopy(styleItemArray, 0, this.runs[n15], 0, n10);
                StyleItem styleItem4 = this.runs[n15][n10 - 1];
                this.runs[n15] = this.reorder(this.runs[n15]);
                this.lineWidth[n15] = n7;
                this.lineY[++n15] = this.lineY[n15 - 1] + n3 + n2 + this.lineSpacing;
                this.lineOffset[n15] = styleItem4.start + styleItem4.length;
                n7 = 0;
                n10 = 0;
                n3 = Math.max(0, this.ascent);
                n2 = Math.max(0, this.descent);
            }
            ++n;
        }
        if (n5 != 0) {
            OS.DeleteDC(n5);
        }
        if (gC == null) {
            this.device.internal_dispose_GC(n4, null);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        boolean bl;
        int n5;
        this.checkLayout();
        this.computeRuns(gC);
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n5 = this.text.length()) == 0) {
            return;
        }
        int n6 = gC.handle;
        boolean bl2 = bl = n3 <= n4 && n3 != -1 && n4 != -1;
        if (bl) {
            n3 = Math.min(Math.max(0, n3), n5 - 1);
            n4 = Math.min(Math.max(0, n4), n5 - 1);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
        }
        int n7 = OS.GetTextColor(n6);
        int n8 = OS.SaveDC(n6);
        RECT rECT = new RECT();
        int n9 = 0;
        if (bl) {
            n9 = OS.CreateSolidBrush(color2.handle);
        }
        int n10 = 0;
        if (OS.IsWinCE) {
            n10 = OS.SetROP2(n6, 13);
            OS.SetROP2(n6, n10);
        } else {
            n10 = OS.GetROP2(n6);
        }
        int n11 = n10 == 7 ? 5898313 : 15728673;
        OS.SetBkMode(n6, 1);
        Rectangle rectangle = gC.getClipping();
        int n12 = 0;
        while (n12 < this.runs.length) {
            int n13 = n;
            int n14 = n2 + this.lineY[n12];
            if (this.wrapWidth != -1) {
                switch (this.alignment) {
                    case 0x1000000: {
                        n13 += (this.wrapWidth - this.lineWidth[n12]) / 2;
                        break;
                    }
                    case 131072: {
                        n13 += this.wrapWidth - this.lineWidth[n12];
                    }
                }
            }
            if (n13 <= rectangle.x + rectangle.width && n13 + this.lineWidth[n12] >= rectangle.x) {
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                StyleItem styleItem;
                StyleItem[] styleItemArray = this.runs[n12];
                int n23 = Math.max(0, this.ascent);
                int n24 = 0;
                while (n24 < styleItemArray.length) {
                    n23 = Math.max(n23, styleItemArray[n24].ascent);
                    ++n24;
                }
                n24 = this.lineY[n12 + 1] - this.lineY[n12];
                int n25 = n13;
                int n26 = 0;
                while (n26 < styleItemArray.length) {
                    styleItem = styleItemArray[n26];
                    if (styleItem.length != 0) {
                        if (n13 > rectangle.x + rectangle.width) break;
                        if (n13 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                            n22 = styleItem.start + styleItem.length - 1;
                            int n27 = n21 = bl && n3 <= styleItem.start && n4 >= n22 ? 1 : 0;
                            if (n21 != 0) {
                                OS.SelectObject(n6, n9);
                                OS.PatBlt(n6, n13, n14, styleItem.width, n24, n11);
                            } else {
                                if (styleItem.style != null && styleItem.style.background != null) {
                                    n20 = styleItem.style.background.handle;
                                    n19 = n14 + (n23 - styleItem.ascent);
                                    n18 = OS.CreateSolidBrush(n20);
                                    n17 = OS.SelectObject(n6, n18);
                                    OS.PatBlt(n6, n13, n19, styleItem.width, styleItem.ascent + styleItem.descent, n11);
                                    OS.SelectObject(n6, n17);
                                    OS.DeleteObject(n18);
                                }
                                int n28 = n20 = bl && n3 <= n22 && styleItem.start <= n4 ? 1 : 0;
                                if (n20 != 0) {
                                    OS.SelectObject(n6, n9);
                                    n19 = Math.max(n3, styleItem.start) - styleItem.start;
                                    n18 = Math.min(n4, n22) - styleItem.start;
                                    n17 = styleItem.length;
                                    n16 = styleItem.glyphCount;
                                    int[] nArray = new int[1];
                                    OS.ScriptCPtoX(n19, false, n17, n16, styleItem.clusters, styleItem.visAttrs, styleItem.advances, styleItem.analysis, nArray);
                                    n15 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.left = n13 + n15;
                                    rECT.top = n14;
                                    OS.ScriptCPtoX(n18, true, n17, n16, styleItem.clusters, styleItem.visAttrs, styleItem.advances, styleItem.analysis, nArray);
                                    n15 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.right = n13 + n15;
                                    rECT.bottom = n14 + n24;
                                    OS.PatBlt(n6, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, n11);
                                }
                            }
                        }
                        n13 += styleItem.width;
                    }
                    ++n26;
                }
                n13 = n25;
                n26 = 0;
                while (n26 < styleItemArray.length) {
                    styleItem = styleItemArray[n26];
                    if (styleItem.length != 0) {
                        if (n13 > rectangle.x + rectangle.width) break;
                        if (!(n13 + styleItem.width < rectangle.x || styleItem.tab || styleItem.lineBreak && !styleItem.softBreak)) {
                            n22 = styleItem.start + styleItem.length - 1;
                            n21 = n7;
                            int n29 = n20 = bl && n3 <= styleItem.start && n4 >= n22 ? 1 : 0;
                            if (n20 != 0) {
                                n21 = color.handle;
                            } else if (styleItem.style != null && styleItem.style.foreground != null) {
                                n21 = styleItem.style.foreground.handle;
                            }
                            OS.SetTextColor(n6, n21);
                            OS.SelectObject(n6, this.getItemFont(styleItem));
                            n19 = n14 + (n23 - styleItem.ascent);
                            OS.ScriptTextOut(n6, styleItem.psc, n13, n19, 0, null, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, null, styleItem.goffsets);
                            int n30 = n18 = bl && n3 <= n22 && styleItem.start <= n4 ? 1 : 0;
                            if (n20 == 0 && n18 != 0 && n21 != color.handle) {
                                OS.SetTextColor(n6, color.handle);
                                n17 = Math.max(n3, styleItem.start) - styleItem.start;
                                n16 = Math.min(n4, n22) - styleItem.start;
                                int n31 = styleItem.length;
                                n15 = styleItem.glyphCount;
                                int[] nArray = new int[1];
                                OS.ScriptCPtoX(n17, false, n31, n15, styleItem.clusters, styleItem.visAttrs, styleItem.advances, styleItem.analysis, nArray);
                                int n32 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.left = n13 + n32;
                                rECT.top = n14;
                                OS.ScriptCPtoX(n16, true, n31, n15, styleItem.clusters, styleItem.visAttrs, styleItem.advances, styleItem.analysis, nArray);
                                n32 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.right = n13 + n32;
                                rECT.bottom = n14 + n24;
                                OS.ScriptTextOut(n6, styleItem.psc, n13, n19, 4, rECT, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, null, styleItem.goffsets);
                            }
                        }
                        n13 += styleItem.width;
                    }
                    ++n26;
                }
            }
            ++n12;
        }
        OS.RestoreDC(n6, n8);
        if (n9 != 0) {
            OS.DeleteObject(n9);
        }
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int n = 0;
        while (n < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n];
            styleItem.free();
            ++n;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n = 0;
        if (this.wrapWidth != -1) {
            n = this.wrapWidth;
        } else {
            int n2 = 0;
            while (n2 < this.runs.length) {
                n = Math.max(n, this.lineWidth[n2]);
                ++n2;
            }
        }
        return new Rectangle(0, 0, n, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n, int n2) {
        int[] nArray;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.checkLayout();
        this.computeRuns(null);
        int n9 = this.text.length();
        if (n9 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n9 - 1);
        n2 = Math.min(Math.max(0, n2), n9 - 1);
        int n10 = this.getLineIndex(n);
        int n11 = this.getLineIndex(n2);
        n9 = this.segmentsText.length();
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        if (n10 != n11) {
            int n12 = 0;
            int n13 = this.lineY[n10];
            while (n10 <= n11) {
                n12 = Math.max(n12, this.lineWidth[n10++]);
            }
            return new Rectangle(0, n13, n12, this.lineY[n11 + 1] - n13);
        }
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        StyleItem styleItem = null;
        StyleItem styleItem2 = null;
        StyleItem[] styleItemArray = this.runs[n10];
        while (n17 < styleItemArray.length) {
            StyleItem styleItem3 = styleItemArray[n17];
            n8 = styleItem3.start + styleItem3.length;
            if (n8 == n9) {
                ++n8;
            }
            if (styleItem3.start <= n && n < n8) {
                styleItem = styleItem3;
                n15 = n14;
                break;
            }
            n14 += styleItem3.width;
            ++n17;
        }
        boolean bl = false;
        StyleItem styleItem4 = styleItem;
        n8 = ((this.orientation & 0x4000000) != 0 ? 1 : 0) ^ ((styleItem4.analysis.s.uBidiLevel & 1) != 0 ? 1 : 0);
        while (n17 < styleItemArray.length) {
            StyleItem styleItem5 = styleItemArray[n17];
            if (styleItem5 != styleItem4) {
                if (n8 != 0) {
                    bl = styleItem5.start + styleItem5.length != styleItem4.start;
                } else {
                    boolean bl2 = bl = styleItem4.start + styleItem4.length != styleItem5.start;
                }
            }
            if (bl) break;
            styleItem4 = styleItem5;
            n7 = styleItem5.start + styleItem5.length;
            if (n7 == n9) {
                ++n7;
            }
            if (styleItem5.start <= n2 && n2 < n7) {
                styleItem2 = styleItem5;
                n16 = n14;
                break;
            }
            n14 += styleItem5.width;
            ++n17;
        }
        if (bl || styleItem2 == null) {
            int n18 = this.lineY[n10];
            return new Rectangle(0, n18, this.lineWidth[n10], this.lineY[n10 + 1] - n18);
        }
        if ((styleItem.analysis.s.uBidiLevel & 1) != 0 ^ (styleItem2.analysis.s.uBidiLevel & 1) != 0) {
            int n19 = this.lineY[n10];
            return new Rectangle(n15, n19, n16 + styleItem2.width, this.lineY[n10 + 1] - n19);
        }
        if (styleItem.tab) {
            n6 = n15;
        } else {
            n5 = n - styleItem.start;
            n4 = styleItem.length;
            n3 = styleItem.glyphCount;
            nArray = new int[1];
            OS.ScriptCPtoX(n5, false, n4, n3, styleItem.clusters, styleItem.visAttrs, styleItem.advances, styleItem.analysis, nArray);
            if ((this.orientation & 0x4000000) != 0) {
                nArray[0] = styleItem.width - nArray[0];
            }
            n6 = n15 + nArray[0];
        }
        if (styleItem2.tab) {
            n7 = n16 + styleItem2.width;
        } else {
            n5 = n2 - styleItem2.start;
            n4 = styleItem2.length;
            n3 = styleItem2.glyphCount;
            nArray = new int[1];
            OS.ScriptCPtoX(n5, true, n4, n3, styleItem2.clusters, styleItem2.visAttrs, styleItem2.advances, styleItem2.analysis, nArray);
            if ((this.orientation & 0x4000000) != 0) {
                nArray[0] = styleItem2.width - nArray[0];
            }
            n7 = n16 + nArray[0];
        }
        if (n6 > n7) {
            n5 = n6;
            n6 = n7;
            n7 = n5;
        }
        n5 = n7 - n6;
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    n6 += (this.wrapWidth - this.lineWidth[n10]) / 2;
                    break;
                }
                case 131072: {
                    n6 += this.wrapWidth - this.lineWidth[n10];
                }
            }
        }
        n4 = this.lineY[n10];
        return new Rectangle(n6, n4, n5, this.lineY[n10 + 1] - n4);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    int getItemFont(StyleItem styleItem) {
        if (styleItem.fallbackFont != 0) {
            return styleItem.fallbackFont;
        }
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.getSystemFont().handle;
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 1;
        while (n3 < this.allRuns.length) {
            if (this.allRuns[n3].start > n) {
                return this.allRuns[n3 - 1].analysis.s.uBidiLevel;
            }
            ++n3;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = 0;
        int n3 = this.lineY[n];
        int n4 = this.lineWidth[n];
        int n5 = this.lineY[n + 1] - n3;
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    n2 = (this.wrapWidth - n4) / 2;
                    break;
                }
                case 131072: {
                    n2 = this.wrapWidth - n4;
                }
            }
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) {
                return n3;
            }
            ++n3;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n) {
        TEXTMETRIC tEXTMETRIC;
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.device.internal_new_GC(null);
        int n3 = OS.CreateCompatibleDC(n2);
        TEXTMETRIC tEXTMETRIC2 = tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        if (this.text.length() == 0) {
            Font font = this.font != null ? this.font : this.device.getSystemFont();
            OS.SelectObject(n3, font.handle);
            OS.GetTextMetrics(n3, tEXTMETRIC);
            tEXTMETRIC.tmAscent = Math.max(tEXTMETRIC.tmAscent, this.ascent);
            tEXTMETRIC.tmDescent = Math.max(tEXTMETRIC.tmDescent, this.descent);
        } else {
            int n4 = this.ascent;
            int n5 = this.descent;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            StyleItem[] styleItemArray = this.runs[n];
            int n9 = 0;
            while (n9 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n9];
                OS.SelectObject(n3, this.getItemFont(styleItem));
                OS.GetTextMetrics(n3, tEXTMETRIC);
                n4 = Math.max(n4, tEXTMETRIC.tmAscent);
                n5 = Math.max(n5, tEXTMETRIC.tmDescent);
                n8 = Math.max(n8, tEXTMETRIC.tmHeight);
                n6 = Math.max(n6, tEXTMETRIC.tmInternalLeading);
                n7 += tEXTMETRIC.tmAveCharWidth;
                ++n9;
            }
            tEXTMETRIC.tmAscent = n4;
            tEXTMETRIC.tmDescent = n5;
            tEXTMETRIC.tmHeight = n8;
            tEXTMETRIC.tmInternalLeading = n6;
            tEXTMETRIC.tmAveCharWidth = n7 / styleItemArray.length;
        }
        if (n3 != 0) {
            OS.DeleteDC(n3);
        }
        this.device.internal_dispose_GC(n2, null);
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.untranslateOffset(this.lineOffset[n]);
            ++n;
        }
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n2 = this.segmentsText.length();
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) break;
            ++n3;
        }
        n3 = Math.min(n3, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n3];
        Point point = null;
        if (n == n2) {
            point = new Point(this.lineWidth[n3], this.lineY[n3]);
        } else {
            int n4 = 0;
            int n5 = 0;
            while (n5 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n5];
                int n6 = styleItem.start + styleItem.length;
                if (styleItem.start <= n && n < n6) {
                    if (styleItem.tab) {
                        if (bl || n == n2) {
                            n4 += styleItem.width;
                        }
                        point = new Point(n4, this.lineY[n3]);
                        break;
                    }
                    int n7 = n - styleItem.start;
                    int n8 = styleItem.length;
                    int n9 = styleItem.glyphCount;
                    int[] nArray = new int[1];
                    OS.ScriptCPtoX(n7, bl, n8, n9, styleItem.clusters, styleItem.visAttrs, styleItem.advances, styleItem.analysis, nArray);
                    if ((this.orientation & 0x4000000) != 0) {
                        point = new Point(n4 + (styleItem.width - nArray[0]), this.lineY[n3]);
                        break;
                    }
                    point = new Point(n4 + nArray[0], this.lineY[n3]);
                    break;
                }
                n4 += styleItem.width;
                ++n5;
            }
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    point.x += (this.wrapWidth - this.lineWidth[n3]) / 2;
                    break;
                }
                case 131072: {
                    point.x += this.wrapWidth - this.lineWidth[n3];
                }
            }
        }
        return point;
    }

    public int getNextOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.computeRuns(null);
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        n4 = this.segmentsText.length();
        n = this.translateOffset(n);
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        int n6 = bl ? 0 : this.allRuns.length - 1;
        n = this.validadeOffset(n, n3);
        do {
            boolean bl2;
            StyleItem styleItem = this.allRuns[n6];
            if (styleItem.start > n || n >= styleItem.start + styleItem.length) continue;
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (styleItem.tab) {
                return this.untranslateOffset(styleItem.start);
            }
            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], 8);
            boolean bl3 = bl2 = sCRIPT_PROPERTIES.fNeedsCaretInfo || sCRIPT_PROPERTIES.fNeedsWordBreaking;
            if (bl2) {
                this.breakRun(styleItem);
            }
            while (styleItem.start <= n && n < styleItem.start + styleItem.length) {
                if (bl2) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (n - styleItem.start) * 1, 1);
                }
                switch (n2) {
                    case 2: {
                        if (sCRIPT_PROPERTIES.fNeedsCaretInfo) {
                            if (sCRIPT_LOGATTR.fInvalid || !sCRIPT_LOGATTR.fCharStop) break;
                            return this.untranslateOffset(n);
                        }
                        return this.untranslateOffset(n);
                    }
                    case 4: {
                        boolean bl4;
                        boolean bl5;
                        if (!(sCRIPT_PROPERTIES.fNeedsWordBreaking ? !sCRIPT_LOGATTR.fInvalid && sCRIPT_LOGATTR.fWordStop : n > 0 && ((bl5 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n))) != (bl4 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1))) || !bl5) && !Compatibility.isWhitespace(this.segmentsText.charAt(n)))) break;
                        return this.untranslateOffset(n);
                    }
                }
                n = this.validadeOffset(n, n3);
            }
        } while ((n6 += n3) >= 0 && n6 < this.allRuns.length - 1 && n >= 0 && n < n4);
        return bl ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        boolean bl;
        this.checkLayout();
        this.computeRuns(null);
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n3 = this.runs.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.lineY[n4 + 1] > n2) break;
            ++n4;
        }
        n4 = Math.min(n4, this.runs.length - 1);
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    n -= (this.wrapWidth - this.lineWidth[n4]) / 2;
                    break;
                }
                case 131072: {
                    n -= this.wrapWidth - this.lineWidth[n4];
                }
            }
        }
        StyleItem[] styleItemArray = this.runs[n4];
        boolean bl2 = bl = (this.orientation & 0x4000000) != 0;
        if (n < 0) {
            StyleItem styleItem = styleItemArray[0];
            if (styleItem.analysis.fRTL ^ bl) {
                if (nArray != null) {
                    nArray[0] = 1;
                }
                return this.untranslateOffset(styleItem.start + styleItem.length - 1);
            }
            if (nArray != null) {
                nArray[0] = 0;
            }
            return this.untranslateOffset(styleItem.start);
        }
        if (n > this.lineWidth[n4]) {
            int n5 = styleItemArray.length - 1;
            if (n4 == n3 - 1 && styleItemArray.length > 1) {
                --n5;
            }
            StyleItem styleItem = styleItemArray[n5];
            if (styleItem.analysis.fRTL ^ bl) {
                if (nArray != null) {
                    nArray[0] = 0;
                }
                return this.untranslateOffset(styleItem.start);
            }
            if (nArray != null) {
                nArray[0] = 1;
            }
            return this.untranslateOffset(styleItem.start + styleItem.length - 1);
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < styleItemArray.length) {
            StyleItem styleItem = styleItemArray[n7];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (n6 + styleItem.width > n) {
                if (styleItem.tab) {
                    if (nArray != null) {
                        nArray[0] = n < n6 + styleItem.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(styleItem.start);
                }
                int n8 = styleItem.length;
                int n9 = styleItem.glyphCount;
                int n10 = n - n6;
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                if ((this.orientation & 0x4000000) != 0) {
                    n10 = styleItem.width - n10;
                }
                OS.ScriptXtoCP(n10, n8, n9, styleItem.clusters, styleItem.visAttrs, styleItem.advances, styleItem.analysis, nArray2, nArray3);
                if (nArray != null) {
                    nArray[0] = nArray3[0];
                }
                return this.untranslateOffset(styleItem.start + nArray2[0]);
            }
            n6 += styleItem.width;
            ++n7;
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[n4 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, false);
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n = this.segments.length;
        if (n <= 1) {
            return this.text;
        }
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (n == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
            return this.text;
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n3 < n2) {
            if (n4 < n && n3 == this.segments[n4]) {
                cArray2[n3 + n4++] = n5;
                continue;
            }
            cArray2[n3 + n4] = cArray[n3++];
        }
        if (n4 < n) {
            this.segments[n4] = n3;
            cArray2[n3 + n4++] = n5;
        }
        return new String(cArray2, 0, Math.min(n3 + n4, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.styles.length) {
            if (this.styles[n3].start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int n = this.segmentsText.length();
        SCRIPT_CONTROL sCRIPT_CONTROL = new SCRIPT_CONTROL();
        SCRIPT_STATE sCRIPT_STATE = new SCRIPT_STATE();
        int n2 = n + 1;
        if ((this.orientation & 0x4000000) != 0) {
            sCRIPT_STATE.uBidiLevel = 1;
            sCRIPT_STATE.fArabicNumContext = true;
        }
        int n3 = OS.GetProcessHeap();
        int n4 = OS.HeapAlloc(n3, 8, n2 * 8);
        int[] nArray = new int[1];
        char[] cArray = new char[n];
        this.segmentsText.getChars(0, n, cArray, 0);
        OS.ScriptItemize(cArray, n, n2, sCRIPT_CONTROL, sCRIPT_STATE, n4, nArray);
        StyleItem[] styleItemArray = this.merge(n4, nArray[0]);
        OS.HeapFree(n3, 0, n4);
        return styleItemArray;
    }

    StyleItem[] merge(int n, int n2) {
        StyleItem styleItem;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.segmentsText.length();
        int n6 = 0;
        int n7 = 0;
        StyleItem[] styleItemArray = new StyleItem[n2 + this.styles.length];
        SCRIPT_ITEM sCRIPT_ITEM = new SCRIPT_ITEM();
        while (n4 < n5) {
            styleItem = new StyleItem();
            styleItem.start = n4;
            styleItem.style = this.styles[n7].style;
            styleItemArray[n3++] = styleItem;
            OS.MoveMemory(sCRIPT_ITEM, n + n6 * 8, 8);
            styleItem.analysis = sCRIPT_ITEM.a;
            sCRIPT_ITEM.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory(sCRIPT_ITEM, n + (n6 + 1) * 8, 8);
            int n8 = sCRIPT_ITEM.iCharPos;
            int n9 = this.translateOffset(this.styles[n7 + 1].start);
            if (n9 <= n8) {
                ++n7;
                n4 = n9;
            }
            if (n8 <= n9) {
                ++n6;
                n4 = n8;
            }
            styleItem.length = n4 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n5;
        OS.MoveMemory(sCRIPT_ITEM, n + n2 * 8, 8);
        styleItem.analysis = sCRIPT_ITEM.a;
        styleItemArray[n3++] = styleItem;
        if (styleItemArray.length != n3) {
            StyleItem[] styleItemArray2 = new StyleItem[n3];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n3);
            return styleItemArray2;
        }
        return styleItemArray;
    }

    StyleItem[] reorder(StyleItem[] styleItemArray) {
        byte[] byArray = new byte[styleItemArray.length];
        int n = 0;
        while (n < styleItemArray.length) {
            byArray[n] = (byte)(styleItemArray[n].analysis.s.uBidiLevel & 0x1F);
            ++n;
        }
        int[] nArray = new int[styleItemArray.length];
        OS.ScriptLayout(styleItemArray.length, byArray, null, nArray);
        StyleItem[] styleItemArray2 = new StyleItem[styleItemArray.length];
        int n2 = 0;
        while (n2 < styleItemArray.length) {
            styleItemArray2[nArray[n2]] = styleItemArray[n2];
            ++n2;
        }
        if ((this.orientation & 0x4000000) != 0) {
            n2 = 0;
            while (n2 < (styleItemArray2.length - 1) / 2) {
                StyleItem styleItem = styleItemArray2[n2];
                styleItemArray2[n2] = styleItemArray2[styleItemArray2.length - n2 - 2];
                styleItemArray2[styleItemArray2.length - n2 - 2] = styleItem;
                ++n2;
            }
        }
        return styleItemArray2;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        this.alignment = n;
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        this.freeRuns();
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n;
    }

    /*
     * Unable to fully structure code
     */
    public void setStyle(TextStyle var1_1, int var2_2, int var3_3) {
        block13: {
            this.checkLayout();
            var4_4 = this.text.length();
            if (var4_4 == 0) {
                return;
            }
            if (var2_2 > var3_3) {
                return;
            }
            var2_2 = Math.min(Math.max(0, var2_2), var4_4 - 1);
            var3_3 = Math.min(Math.max(0, var3_3), var4_4 - 1);
            var5_5 = -1;
            var6_6 = this.styles.length;
            while (var6_6 - var5_5 > 1) {
                var7_7 = (var6_6 + var5_5) / 2;
                if (var2_2 <= this.styles[var7_7].start) {
                    var6_6 = var7_7;
                    continue;
                }
                var5_5 = var7_7;
            }
            if (var6_6 >= 0 && var6_6 < this.styles.length) {
                var7_8 = this.styles[var6_6];
                if (var7_8.start == var2_2 && this.styles[var6_6 + 1].start - 1 == var3_3 && (var1_1 == null ? var7_8.style == null : var1_1.equals(var7_8.style) != false)) {
                    return;
                }
            }
            this.freeRuns();
            var7_7 = 0;
            var9_9 = new StyleItem[this.styles.length + 2];
            var8_10 = 0;
            while (var8_10 < this.styles.length) {
                var10_11 = this.styles[var8_10];
                if (var10_11.start >= var2_2) break;
                var9_9[var7_7++] = var10_11;
                ++var8_10;
            }
            var10_11 = new StyleItem();
            var10_11.start = var2_2;
            var10_11.style = var1_1;
            var9_9[var7_7++] = var10_11;
            if (this.styles[var8_10].start <= var3_3) ** GOTO lbl45
            var10_11 = new StyleItem();
            var10_11.start = var3_3 + 1;
            var10_11.style = this.styles[var8_10 - 1].style;
            var9_9[var7_7++] = var10_11;
            break block13;
lbl-1000:
            // 1 sources

            {
                var11_12 = this.styles[var8_10];
                if (var11_12.start > var3_3) break;
                ++var8_10;
lbl45:
                // 2 sources

                ** while (var8_10 < this.styles.length)
            }
lbl46:
            // 2 sources

            if (var3_3 != this.styles[var8_10].start - 1) {
                this.styles[--var8_10].start = var3_3 + 1;
            }
        }
        while (var8_10 < this.styles.length) {
            var11_12 = this.styles[var8_10];
            if (var11_12.start > var3_3) {
                var9_9[var7_7++] = var11_12;
            }
            ++var8_10;
        }
        if (var9_9.length != var7_7) {
            this.styles = new StyleItem[var7_7];
            System.arraycopy(var9_9, 0, this.styles, 0, var7_7);
        } else {
            this.styles = var9_9;
        }
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
    }

    boolean shape(int n, StyleItem styleItem, char[] cArray, int[] nArray, int n2) {
        int n3 = OS.ScriptShape(n, styleItem.psc, cArray, cArray.length, n2, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
        styleItem.glyphCount = nArray[0];
        if (n3 != -2147220992) {
            SCRIPT_FONTPROPERTIES sCRIPT_FONTPROPERTIES = new SCRIPT_FONTPROPERTIES();
            sCRIPT_FONTPROPERTIES.cBytes = 16;
            OS.ScriptGetFontProperties(n, styleItem.psc, sCRIPT_FONTPROPERTIES);
            short[] sArray = new short[nArray[0]];
            OS.MoveMemory(sArray, styleItem.glyphs, sArray.length * 2);
            int n4 = 0;
            while (n4 < sArray.length) {
                if (sArray[n4] == sCRIPT_FONTPROPERTIES.wgDefault) break;
                ++n4;
            }
            if (n4 == sArray.length) {
                return true;
            }
        }
        if (styleItem.psc != 0) {
            OS.ScriptFreeCache(styleItem.psc);
            nArray[0] = 0;
            OS.MoveMemory(styleItem.psc, nArray, 4);
        }
        styleItem.glyphCount = 0;
        return false;
    }

    void shape(final int n, final StyleItem styleItem) {
        final int[] nArray = new int[1];
        final char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        final int n2 = cArray.length * 3 / 2 + 16;
        int n3 = OS.GetProcessHeap();
        styleItem.glyphs = OS.HeapAlloc(n3, 8, n2 * 2);
        styleItem.clusters = OS.HeapAlloc(n3, 8, n2 * 2);
        styleItem.visAttrs = OS.HeapAlloc(n3, 8, n2 * 2);
        styleItem.psc = OS.HeapAlloc(n3, 8, 4);
        if (!this.shape(n, styleItem, cArray, nArray, n2)) {
            LOGFONT lOGFONT;
            final short s = styleItem.analysis.eScript;
            final int n4 = OS.GetCurrentObject(n, 6);
            final LOGFONT lOGFONT2 = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.GetObject(n4, LOGFONT.sizeof, lOGFONT2);
            LOGFONT lOGFONT3 = lOGFONT = this.device.logFontsCache != null ? this.device.logFontsCache[s] : null;
            if (lOGFONT != null) {
                lOGFONT.lfHeight = lOGFONT2.lfHeight;
                lOGFONT.lfWeight = lOGFONT2.lfWeight;
                lOGFONT.lfItalic = lOGFONT2.lfItalic;
                lOGFONT.lfWidth = lOGFONT2.lfWidth;
                int n5 = OS.CreateFontIndirect(lOGFONT);
                OS.SelectObject(n, n5);
                OS.ScriptShape(n, styleItem.psc, cArray, cArray.length, n2, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
                styleItem.glyphCount = nArray[0];
                styleItem.fallbackFont = n5;
            } else {
                LOGFONT lOGFONT4;
                LOGFONT lOGFONT5 = lOGFONT4 = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                if (this.device.logFontsCache == null) {
                    this.device.logFontsCache = new LOGFONT[this.device.scripts.length];
                }
                SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
                OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[s], 8);
                byte by = sCRIPT_PROPERTIES.fAmbiguousCharSet ? (byte)1 : sCRIPT_PROPERTIES.bCharSet;
                Object object = new Object(){

                    public int EnumFontFamExProc(int n6, int n22, int n3, int n42) {
                        OS.MoveMemory(lOGFONT4, n6, LOGFONT.sizeof);
                        if (n3 == 1) {
                            return 1;
                        }
                        lOGFONT4.lfHeight = lOGFONT2.lfHeight;
                        lOGFONT4.lfWeight = lOGFONT2.lfWeight;
                        lOGFONT4.lfItalic = lOGFONT2.lfItalic;
                        lOGFONT4.lfWidth = lOGFONT2.lfWidth;
                        int n5 = OS.CreateFontIndirect(lOGFONT4);
                        OS.SelectObject(n, n5);
                        if (TextLayout.this.shape(n, styleItem, cArray, nArray, n2)) {
                            styleItem.fallbackFont = n5;
                            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                            OS.MoveMemory(lOGFONT, n6, LOGFONT.sizeof);
                            TextLayout.this.device.logFontsCache[s] = lOGFONT;
                            return 0;
                        }
                        OS.SelectObject(n, n4);
                        OS.DeleteObject(n5);
                        return 1;
                    }
                };
                Callback callback = new Callback(object, "EnumFontFamExProc", 4);
                int n6 = callback.getAddress();
                if (n6 == 0) {
                    SWT.error(3);
                }
                lOGFONT4.lfCharSet = by;
                OS.EnumFontFamiliesEx(n, lOGFONT4, n6, 0, 0);
                callback.dispose();
                if (styleItem.fallbackFont == 0) {
                    OS.ScriptShape(n, styleItem.psc, cArray, cArray.length, n2, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
                    this.device.logFontsCache[s] = lOGFONT2;
                    styleItem.glyphCount = nArray[0];
                }
            }
        }
        int[] nArray2 = new int[3];
        styleItem.advances = OS.HeapAlloc(n3, 8, styleItem.glyphCount * 4);
        styleItem.goffsets = OS.HeapAlloc(n3, 8, styleItem.glyphCount * 8);
        OS.ScriptPlace(n, styleItem.psc, styleItem.glyphs, styleItem.glyphCount, styleItem.visAttrs, styleItem.analysis, styleItem.advances, styleItem.goffsets, nArray2);
        styleItem.width = nArray2[0] + nArray2[1] + nArray2[2];
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n, tEXTMETRIC);
        styleItem.ascent = tEXTMETRIC.tmAscent;
        styleItem.descent = tEXTMETRIC.tmDescent;
    }

    int validadeOffset(int n, int n2) {
        n += n2;
        if (this.segments != null && this.segments.length > 2) {
            int n3 = 0;
            while (n3 < this.segments.length) {
                if (this.translateOffset(this.segments[n3]) - 1 == n) {
                    n += n2;
                    break;
                }
                ++n3;
            }
        }
        return n;
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        if (n2 <= 1) {
            return n;
        }
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (n2 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
            return n;
        }
        int n4 = 0;
        while (n4 < n2 && n - n4 >= this.segments[n4]) {
            ++n;
            ++n4;
        }
        return n;
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        if (n2 <= 1) {
            return n;
        }
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (n2 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
            return n;
        }
        int n4 = 0;
        while (n4 < n2 && n > this.segments[n4]) {
            --n;
            ++n4;
        }
        return n;
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int n = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(n, 0, this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree(n, 0, this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree(n, 0, this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree(n, 0, this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree(n, 0, this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree(n, 0, this.goffsets);
                this.goffsets = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree(n, 0, this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                OS.DeleteObject(this.fallbackFont);
                this.fallbackFont = 0;
            }
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }
    }
}

