/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int id;
    int accelerator;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        menu.createItem(this, menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        menu.createItem(this, n2);
    }

    MenuItem(Menu menu, Menu menu2, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.menu = menu2;
        if (menu2 != null) {
            menu2.cascade = this;
        }
        this.display.addMenuItem(this);
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        return Widget.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    void fillAccel(ACCEL aCCEL) {
        aCCEL.fVirt = 0;
        aCCEL.key = 0;
        aCCEL.cmd = 0;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        boolean bl = true;
        int n = this.accelerator & 0x100FFFF;
        int n2 = Display.untranslateKey(n);
        if (n2 != 0) {
            n = n2;
        } else {
            switch (n) {
                case 27: {
                    n = 27;
                    break;
                }
                case 127: {
                    n = 46;
                    break;
                }
                default: {
                    n = Display.wcsToMbcs((char)n);
                    if (n == 0) {
                        return;
                    }
                    if (OS.IsWinCE) {
                        n = OS.CharUpper((short)n);
                        break;
                    }
                    n2 = OS.VkKeyScan((short)n) & 0xFF;
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    n = n2;
                }
            }
        }
        aCCEL.key = (short)n;
        aCCEL.cmd = (short)this.id;
        aCCEL.fVirt = (byte)(bl ? 1 : 0);
        if ((this.accelerator & 0x10000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 0x10);
        }
        if ((this.accelerator & 0x20000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 4);
        }
        if ((this.accelerator & 0x40000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 8);
        }
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public boolean getEnabled() {
        boolean bl;
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = 32;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            return (tBBUTTONINFO.fsState & 4) != 0;
        }
        int n = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        if (OS.IsWinCE) {
            int n2 = this.parent.indexOf(this);
            if (n2 == -1) {
                this.error(31);
            }
            bl = OS.GetMenuItemInfo(n, n2, true, mENUITEMINFO);
        } else {
            bl = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
        }
        if (!bl) {
            this.error(31);
        }
        return (mENUITEMINFO.fState & 3) == 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return false;
        }
        int n = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
        if (!bl) {
            this.error(9);
        }
        return (mENUITEMINFO.fState & 8) != 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChild() {
        super.releaseChild();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
        this.parent.destroyItem(this);
    }

    void releaseMenu() {
        if (!OS.IsSP) {
            this.setMenu(null);
        }
        this.menu = null;
    }

    void releaseWidget() {
        if (this.menu != null) {
            this.menu.releaseResources();
        }
        this.menu = null;
        super.releaseWidget();
        if (this.accelerator != 0) {
            this.parent.destroyAccelerators();
        }
        this.accelerator = 0;
        this.display.removeMenuItem(this);
        this.parent = null;
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        int n = 0;
        MenuItem[] menuItemArray = this.parent.getItems();
        while (n < menuItemArray.length && menuItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && menuItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < menuItemArray.length && menuItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        this.accelerator = n;
        this.parent.destroyAccelerators();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = 32;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB);
            if (bl) {
                tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState | 4);
            }
            OS.SendMessage(n, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        } else {
            int n = this.parent.handle;
            if (OS.IsWinCE) {
                int n2 = this.parent.indexOf(this);
                if (n2 == -1) {
                    return;
                }
                int n3 = 0x400 | (bl ? 0 : 1);
                OS.EnableMenuItem(n, n2, n3);
            } else {
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 1;
                boolean bl2 = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
                if (!bl2) {
                    this.error(30);
                }
                int n4 = 3;
                if (bl) {
                    if ((mENUITEMINFO.fState & n4) == 0) {
                        return;
                    }
                    mENUITEMINFO.fState &= ~n4;
                } else {
                    if ((mENUITEMINFO.fState & n4) == n4) {
                        return;
                    }
                    mENUITEMINFO.fState |= n4;
                }
                bl2 = OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO);
                if (!bl2) {
                    this.error(30);
                }
            }
        }
        this.parent.destroyAccelerators();
        this.parent.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
                int n = this.parent.hwndCB;
                TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                tBBUTTONINFO.cbSize = 32;
                tBBUTTONINFO.dwMask = 1;
                tBBUTTONINFO.iImage = this.parent.imageIndex(image);
                OS.SendMessage(n, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
            }
            return;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 128;
        if (image != null) {
            mENUITEMINFO.hbmpItem = -1;
        }
        int n = this.parent.handle;
        OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO);
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            if (OS.IsPPC) {
                int n = this.parent.hwndCB;
                int n2 = menu == null ? 0 : menu.handle;
                OS.SendMessage(n, 1424, this.id, n2);
            }
            if (OS.IsSP) {
                this.error(29);
            }
        } else {
            int n = this.parent.handle;
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 32;
            int n3 = 0;
            while (OS.GetMenuItemInfo(n, n3, true, mENUITEMINFO)) {
                if (mENUITEMINFO.dwItemData == this.id) break;
                ++n3;
            }
            if (mENUITEMINFO.dwItemData != this.id) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (!OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
                mENUITEMINFO.fMask = 128;
                OS.GetMenuItemInfo(n, n3, true, mENUITEMINFO);
                boolean bl3 = bl = mENUITEMINFO.hbmpItem != 0;
                if (bl) {
                    mENUITEMINFO.hbmpItem = 0;
                    bl2 = OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO);
                }
            }
            int n4 = 128;
            int n5 = OS.GetProcessHeap();
            int n6 = n4 * TCHAR.sizeof;
            int n7 = OS.HeapAlloc(n5, 8, n6);
            mENUITEMINFO.fMask = 51;
            mENUITEMINFO.dwTypeData = n7;
            mENUITEMINFO.cch = n4;
            bl2 = OS.GetMenuItemInfo(n, n3, true, mENUITEMINFO);
            if (menu != null) {
                menu.cascade = this;
                mENUITEMINFO.fMask |= 4;
                mENUITEMINFO.hSubMenu = menu.handle;
            }
            OS.RemoveMenu(n, n3, 1024);
            if (OS.IsWinCE) {
                TCHAR tCHAR;
                int n8 = this.id;
                int n9 = 1024;
                if (menu != null) {
                    n9 |= 0x10;
                    n8 = menu.handle;
                }
                if (bl2 = OS.InsertMenu(n, n3, n9, n8, tCHAR = new TCHAR(0, " ", true))) {
                    mENUITEMINFO.fMask = 48;
                    bl2 = OS.SetMenuItemInfo(n, n3, true, mENUITEMINFO);
                    if ((mENUITEMINFO.fState & 3) != 0) {
                        OS.EnableMenuItem(n, n3, 1025);
                    }
                    if ((mENUITEMINFO.fState & 8) != 0) {
                        OS.CheckMenuItem(n, n3, 1032);
                    }
                }
            } else {
                bl2 = OS.InsertMenuItem(n, n3, true, mENUITEMINFO);
                if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154 && bl) {
                    mENUITEMINFO.fMask = 128;
                    mENUITEMINFO.hbmpItem = -1;
                    bl2 = OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO);
                }
            }
            if (n7 != 0) {
                OS.HeapFree(n5, 0, n7);
            }
            if (!bl2) {
                this.error(29);
            }
        }
        this.parent.destroyAccelerators();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return;
        }
        int n = this.parent.handle;
        if (OS.IsWinCE) {
            int n2 = this.parent.indexOf(this);
            if (n2 == -1) {
                return;
            }
            int n3 = 0x400 | (bl ? 8 : 0);
            OS.CheckMenuItem(n, n2, n3);
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 1;
            boolean bl2 = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
            if (!bl2) {
                this.error(28);
            }
            mENUITEMINFO.fState &= 0xFFFFFFF7;
            if (bl) {
                mENUITEMINFO.fState |= 8;
            }
            if (!(bl2 = OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO))) {
                this.error(28);
            }
        }
        this.parent.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        int n = OS.GetProcessHeap();
        int n2 = 0;
        boolean bl = false;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n3;
            if (string.indexOf(38) != -1) {
                int n4 = string.length();
                char[] cArray = new char[n4];
                string.getChars(0, n4, cArray, 0);
                n3 = 0;
                int n5 = 0;
                n3 = 0;
                while (n3 < n4) {
                    if (cArray[n3] != '&') {
                        cArray[n5++] = cArray[n3];
                    }
                    ++n3;
                }
                if (n5 < n3) {
                    string = new String(cArray, 0, n5);
                }
            }
            TCHAR tCHAR = new TCHAR(0, string, true);
            int n6 = tCHAR.length() * TCHAR.sizeof;
            n2 = OS.HeapAlloc(n, 8, n6);
            OS.MoveMemory(n2, tCHAR, n6);
            n3 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = 32;
            tBBUTTONINFO.dwMask = 2;
            tBBUTTONINFO.pszText = n2;
            bl = OS.SendMessage(n3, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO) != 0;
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            int n7 = this.parent.handle;
            boolean bl2 = false;
            if (!OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
                mENUITEMINFO.fMask = 128;
                OS.GetMenuItemInfo(n7, this.id, false, mENUITEMINFO);
                bl2 = mENUITEMINFO.hbmpItem != 0;
            }
            TCHAR tCHAR = new TCHAR(0, string, true);
            int n8 = tCHAR.length() * TCHAR.sizeof;
            n2 = OS.HeapAlloc(n, 8, n8);
            OS.MoveMemory(n2, tCHAR, n8);
            mENUITEMINFO.fMask = 16;
            mENUITEMINFO.fType = this.widgetStyle();
            mENUITEMINFO.dwTypeData = n2;
            bl = OS.SetMenuItemInfo(n7, this.id, false, mENUITEMINFO);
            if (!OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154 && bl2) {
                mENUITEMINFO.fMask = 128;
                mENUITEMINFO.hbmpItem = -1;
                bl = OS.SetMenuItemInfo(n7, this.id, false, mENUITEMINFO);
            }
        }
        if (n2 != 0) {
            OS.HeapFree(n, 0, n2);
        }
        if (!bl) {
            this.error(13);
        }
        this.parent.redraw();
    }

    int widgetStyle() {
        int n = 0;
        Decorations decorations = this.parent.parent;
        if ((decorations.style & 0x8000000) != 0) {
            if ((this.parent.style & 0x2000000) != 0) {
                n |= 0x6000;
            }
        } else if ((this.parent.style & 0x4000000) != 0) {
            n |= 0x6000;
        }
        if ((this.style & 2) != 0) {
            return n | 0x800;
        }
        if ((this.style & 0x10) != 0) {
            return n | 0x200;
        }
        return n;
    }

    LRESULT wmCommandChild(int n, int n2) {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        Event event = new Event();
        this.setInputState(event, 13);
        this.postEvent(13, event);
        return null;
    }

    LRESULT wmDrawChild(int n, int n2) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n2, 48);
        if (this.image != null) {
            GCData gCData = new GCData();
            gCData.device = this.display;
            GC gC = GC.win32_new(dRAWITEMSTRUCT.hDC, gCData);
            int n3 = (this.parent.style & 2) != 0 ? (OS.IsWin95 ? 4 : 2) : dRAWITEMSTRUCT.left;
            gC.drawImage(this.image, n3, dRAWITEMSTRUCT.top + 2);
            gC.dispose();
        }
        return null;
    }

    LRESULT wmMeasureChild(int n, int n2) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n2, 24);
        int n3 = 0;
        int n4 = 0;
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            n3 = rectangle.width;
            n4 = rectangle.height;
        } else {
            MENUINFO mENUINFO = new MENUINFO();
            mENUINFO.cbSize = 28;
            mENUINFO.fMask = 16;
            int n5 = this.parent.handle;
            OS.GetMenuInfo(n5, mENUINFO);
            if ((mENUINFO.dwStyle & 0x4000000) == 0) {
                MenuItem[] menuItemArray = this.parent.getItems();
                int n6 = 0;
                while (n6 < menuItemArray.length) {
                    MenuItem menuItem = menuItemArray[n6];
                    if (menuItem.image != null) {
                        Rectangle rectangle = menuItem.image.getBounds();
                        n3 = Math.max(n3, rectangle.width);
                    }
                    ++n6;
                }
            }
        }
        if (n3 != 0 || n4 != 0) {
            mEASUREITEMSTRUCT.itemWidth = n3 + (OS.IsWin95 ? 4 : 2);
            mEASUREITEMSTRUCT.itemHeight = n4 + 4;
            OS.MoveMemory(n2, mEASUREITEMSTRUCT, 24);
        }
        return null;
    }
}

