#include <stdio.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/scrollbar.h>

#include "generic.h"

#include "canvas.h"
#include "context.h"

typedef enum {
	d_line,
	d_text,
	d_arc,
	d_rect,
	d_fillrect,
	d_fillarc,
	d_point,
	d_none
	} draw_op;
#define grey_width 16
#define grey_height 16
static char grey_bits[] = {
	0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
	0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
	0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa};


setup_gc(c, tgc, op)
ltcanvas c;
ltcontext tgc;
draw_op op;
{
	static char dashes[2];
	XRectangle rects[1];
	int needchange;
	int zlw, zlh;
	ltcontext cgc;

	cgc=c->tgc;
	/* function */
	if(op==d_line || op==d_text || op==d_arc || op==d_rect || op==d_point ||
		op==d_fillrect || op==d_fillarc)
		if(tgc->f!=cgc->f)
		{
			switch(tgc->f)
			{
				case tc_copy:
					cgc->f=tgc->f;
					XSetFunction(c->xdpy, c->xgc, GXcopy);
					break;
				case tc_xor:
					cgc->f=tgc->f;
					XSetFunction(c->xdpy, c->xgc, GXxor);
					break;
				case tc_or:
					cgc->f=tgc->f;
					XSetFunction(c->xdpy, c->xgc, GXor);
					break;
				case tc_clear:
					cgc->f=tgc->f;
					XSetFunction(c->xdpy, c->xgc, GXclear);
					break;
				default:
					break;
			}
		}
		
	/* foreground */
	if(op==d_line || op==d_text || op==d_arc || op==d_rect || op==d_point ||
		op==d_fillrect || op==d_fillarc)
		if(tgc->fg!=cgc->fg)
		{
			cgc->fg=tgc->fg;
			XSetForeground(c->xdpy, c->xgc, tcolor_Xpixel(cgc->fg));
		}

	/* background */
	if(op==d_line || op==d_text || op==d_arc || op==d_rect ||
		op==d_fillrect || op==d_fillarc)
		if(tgc->bg!=cgc->bg)
		{
			cgc->bg=tgc->bg;
			XSetBackground(c->xdpy, c->xgc, tcolor_Xpixel(cgc->bg));
		}

	/* line width, line style, cap style, dashes */
	if(op==d_line || op==d_arc || op==d_rect ||
		op==d_fillrect || op==d_fillarc)
	{
		needchange=0;

		zlw=tgc->linewidth;
		size_to_x(c, &zlw, &zlh);
		if(zlw!=cgc->linewidth)
		{
			needchange=1;
			cgc->linewidth=zlw;
		}
		if(tgc->capstyle!=cgc->capstyle)
		{
			needchange=1;
			cgc->capstyle=tgc->capstyle;
		}
		if(tgc->solid!=cgc->solid)
		{
			needchange=1;
			cgc->solid=tgc->solid;
		}
		if(needchange)
			if(cgc->solid)
				XSetLineAttributes(c->xdpy, c->xgc, cgc->linewidth,
					LineSolid, tcontext_xcap_style(cgc->capstyle),
					JoinBevel);
			else
				XSetLineAttributes(c->xdpy, c->xgc, cgc->linewidth,
					LineOnOffDash, tcontext_xcap_style(cgc->capstyle),
					JoinBevel);

		if(!tgc->solid && 
			(tgc->offset!=cgc->offset || tgc->l1!=cgc->l1 || tgc->l2!=cgc->l2))
		{
			cgc->offset=tgc->offset;
			dashes[0]=cgc->l1=tgc->l1;
			dashes[1]=cgc->l2=tgc->l2;
			XSetDashes(c->xdpy, c->xgc, cgc->offset, dashes, 2);
		}
	}

	/* font */
	if(op==d_text)
		if(tgc->font!=cgc->font)
		{
			cgc->font=tgc->font;
			XSetFont(c->xdpy, c->xgc, tfont_Xid(cgc->font));
		}

	/* clipping */
	/* ignore clipping for now, not used by treetool */
	/*if(op==d_line || op==d_text || op==d_arc || op==d_rect || op==d_point ||*/
		/*op==d_fillrect || op==d_fillarc)*/
		/*if(tgc->clippingon)*/
		/*{*/
			/* must be on with tgc's area */
			/*if(cgc->x!=tgc->x ||*/
				/*cgc->y!=tgc->y ||*/
				/*cgc->w!=tgc->w ||*/
				/*cgc->h!=tgc->h || !cgc->clippingon)*/
			/*{*/
				/*rects[1].x=cgc->x=tgc->x;*/
				/*rects[1].y=cgc->y=tgc->y;*/
				/*rects[1].width=cgc->w=tgc->w;*/
				/*rects[1].height=cgc->h=tgc->h;*/
				/*cgc->clippingon=1;*/
				/*XSetClipRectangles(c->xdpy, c->xgc, 0, 0, rects, 1, Unsorted);*/
			/*}*/
		/*}*/
		/*else if(cgc->clippingon)*/
		/*{*/
			/* must be off, but set to entire window */
			/*cgc->clippingon=0;*/
			/*rects[1].x=0;*/
			/*rects[1].y=0;*/
			/*rects[1].width=c->cw;*/
			/*rects[1].height=c->ch;*/
			/*XSetClipRectangles(c->xdpy, c->xgc, 0, 0, rects, 1, Unsorted);*/
		/*}*/

	/* fillstyle */
	if(op==d_line || op==d_text || op==d_arc || op==d_rect || op==d_point ||
		op==d_fillrect || op==d_fillarc)
		if(tgc->fillstyle!=cgc->fillstyle)
		{
			switch(tgc->fillstyle)
			{
				case tfill_solid:
					cgc->fillstyle=tgc->fillstyle;
					XSetFillStyle(c->xdpy, c->xgc, FillSolid);
					break;
				case tfill_tiled:
					cgc->fillstyle=tgc->fillstyle;
					XSetFillStyle(c->xdpy, c->xgc, FillTiled);
					break;
				case tfill_stippled:
					cgc->fillstyle=tgc->fillstyle;
					XSetFillStyle(c->xdpy, c->xgc, FillStippled);
					break;
				case tfill_opaquestippled:
					cgc->fillstyle=tgc->fillstyle;
					XSetFillStyle(c->xdpy, c->xgc, FillOpaqueStippled);
					break;
				default:
					break;
			}
		}
	
	/* stipple */
	if(op==d_line || op==d_text || op==d_arc || op==d_rect || op==d_point ||
		op==d_fillrect || op==d_fillarc)
		if(tgc->stipple!=cgc->stipple)
		{
			if(tgc->fillstyle==FillStippled ||
				tgc->fillstyle==FillOpaqueStippled)
			{
				cgc->stipple=tgc->stipple;
				XSetStipple(c->xdpy, c->xgc,
					xv_get(tpic_xview(cgc->stipple), SERVER_IMAGE_PIXMAP));
			}
		}
}

draw_text(c, gc, x, y, s, l)
ltcanvas c;
ltcontext gc;
int x, y;
char *s;
int l;
{
	int bx, by, bw, bh;
	static XCharStruct overall;
	int dir, ascent, descent;

	if(c->printing)
	{
		pdraw_text(gc, x, y, s, l);
		return;
	}


	bx=x;
	by=y;
	tfont_get_extents(gc->font, s, l, &bx, &by, &bw, &bh);
	if(c->clipping && (by>c->ay+c->ah-1 || bx>c->ax+c->aw ||
		by+bh<c->ay-1 || bx+bw<c->ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_text);
		point_to_x(c, &x, &y);
		if(gc->fillstyle==tfill_stippled ||
			gc->fillstyle==tfill_opaquestippled)
			XDrawString(c->xdpy, c->buf, c->xgc, x, y, s, l);
		else
			XDrawImageString(c->xdpy, c->buf, c->xgc, x, y, s, l);
	}
}

draw_text_transparent(c, gc, x, y, s, l)
ltcanvas c;
ltcontext gc;
int x, y;
char *s;
int l;
{
	int bx, by, bw, bh;
	static XCharStruct overall;
	int dir, ascent, descent;

	if(c->printing)
	{
		pdraw_text(gc, x, y, s, l);
		return;
	}


	bx=x;
	by=y;
	tfont_get_extents(gc->font, s, l, &bx, &by, &bw, &bh);
	if(c->clipping && (by>c->ay+c->ah-1 || bx>c->ax+c->aw ||
		by+bh<c->ay-1 || bx+bw<c->ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_text);
		point_to_x(c, &x, &y);
		XDrawString(c->xdpy, c->buf, c->xgc, x, y, s, l);
	}
}

draw_arc(c, gc, x, y, w, h, a1, a2)
ltcanvas c;
ltcontext gc;
int x, y, w, h, a1, a2;
{
	if(c->printing)
	{
		pdraw_arc(gc, x, y, w, h, a1, a2);
		return;
	}

	if(c->clipping && (y>c->ay+c->ah || x>c->ax+c->aw ||
		y+h<c->ay-1 || x+w<c->ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		point_to_x(c, &x, &y);
		size_to_x(c, &w, &h);
		XFillArc(c->xdpy, c->buf, c->xgc, x, y, w, h, a1, a2);
	}
}

draw_line(c, gc, x, y, x2, y2)
ltcanvas c;
ltcontext gc;
int x, y, x2, y2;
{
	int t;
	int l;

	if(c->printing)
	{
		pdraw_line(gc, x, y, x2, y2);
		return;
	}

	if(c->clipping && ((y>c->ay+c->ah && y2>c->ay+c->ah) ||
		(x>c->ax+c->aw && x2>c->ax+c->aw) ||
		(y2<c->ay-1 && y<c->ay-1) ||
		(x2<c->ax-1 && x<c->ax-1)))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_line);
		point_to_x(c, &x, &y);
		point_to_x(c, &x2, &y2);
		XDrawLine(c->xdpy, c->buf, c->xgc, x, y, x2, y2);
	}
}

drag_line(c, x, y, x2, y2)
ltcanvas c;
int x, y, x2, y2;
{
	if(c->printing)
	{
		/* never print dragging items */
		return;
	}

	point_to_x(c, &x, &y);
	point_to_x(c, &x2, &y2);
	XDrawRectangle(c->xdpy, c->win, c->gcdrag, x, y, x2, y2);
}

draw_rect(c, gc, x, y, w, h)
ltcanvas c;
ltcontext gc;
int x, y, w, h;
{
	if(c->printing)
	{
		pdraw_rect(gc, x, y, w, h);
		return;
	}

	if(c->clipping && (y>c->ay+c->ah || x>c->ax+c->aw ||
		y+h<c->ay-1 || x+w<c->ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_rect);
		point_to_x(c, &x, &y);
		size_to_x(c, &w, &h);
		XDrawRectangle(c->xdpy, c->buf, c->xgc, x, y, w, h);
	}
}

draw_filled_rect(c, gc, x, y, w, h)
ltcanvas c;
ltcontext gc;
int x, y, w, h;
{
	if(c->printing)
	{
		pdraw_rect(gc, x, y, w, h);
		return;
	}

	if(c->clipping && (y>c->ay+c->ah || x>c->ax+c->aw ||
		y+h<c->ay-1 || x+w<c->ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_rect);
		point_to_x(c, &x, &y);
		size_to_x(c, &w, &h);
		XFillRectangle(c->xdpy, c->buf, c->xgc, x, y, w, h);
	}
}

draw_clear_rect(c, x, y, w, h)
ltcanvas c;
int x, y, w, h;
{
	if(c->printing)
	{
		return;
	}

	if(c->clipping && (y>c->ay+c->ah || x>c->ax+c->aw ||
		y+h<c->ay-1 || x+w<c->ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		point_to_x(c, &x, &y);
		size_to_x(c, &w, &h);
		XFillRectangle(c->xdpy, c->buf, c->gcerase, x, y, w+1, h+1);
	}
}

draw_square_handle(c, gc, x, y, r)
ltcanvas c;
ltcontext gc;
int x, y, r;
{
	int ax, ay, aw, ah;

	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	/* don't change size */
	ax=c->ax;
	ay=c->ay;
	aw=c->aw;
	ah=c->ah;
	point_to_x(c, &ax, &ay);
	size_to_x(c, &aw, &ah);

	if(c->clipping && (y-r>ay+ah || x-r>ax+aw ||
		y+r<ay-1 || x+r<ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_rect);
		XDrawRectangle(c->xdpy, c->buf, c->xgc, x-r, y-r, 2*r, 2*r);
	}
}

draw_filled_square_handle(c, gc, x, y, r)
ltcanvas c;
ltcontext gc;
int x, y, r;
{
	int ax, ay, aw, ah;

	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	/* don't change size */
	ax=c->ax;
	ay=c->ay;
	aw=c->aw;
	ah=c->ah;
	point_to_x(c, &ax, &ay);
	size_to_x(c, &aw, &ah);

	if(c->clipping && (y-r>ay+ah || x-r>ax+aw ||
		y+r<ay-1 || x+r<ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_rect);
		XFillRectangle(c->xdpy, c->buf, c->xgc, x-r, y-r, 2*r+1, 2*r+1);
	}
}

draw_x_handle(c, gc, x, y, r)
ltcanvas c;
ltcontext gc;
int x, y, r;
{
	int ax, ay, aw, ah;

	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	/* don't change size */
	ax=c->ax;
	ay=c->ay;
	aw=c->aw;
	ah=c->ah;
	point_to_x(c, &ax, &ay);
	size_to_x(c, &aw, &ah);

	if(c->clipping && (y-r>ay+ah || x-r>ax+aw ||
		y+r<ay-1 || x+r<ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_arc);
		XDrawLine(c->xdpy, c->buf, c->xgc, x-r, y-r, x+r, y+r);
		XDrawLine(c->xdpy, c->buf, c->xgc, x-r, y+r, x+r, y-r);
	}
}

draw_circle_handle(c, gc, x, y, r)
ltcanvas c;
ltcontext gc;
int x, y, r;
{
	int ax, ay, aw, ah;

	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	/* don't change size */
	ax=c->ax;
	ay=c->ay;
	aw=c->aw;
	ah=c->ah;
	point_to_x(c, &ax, &ay);
	size_to_x(c, &aw, &ah);

	if(c->clipping && (y-r>ay+ah || x-r>ax+aw ||
		y+r<ay-1 || x+r<ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_arc);
		XDrawArc(c->xdpy, c->buf, c->xgc, x-r, y-r, 2*r, 2*r, 0, 23040);
	}
}

draw_filled_circle_handle(c, gc, x, y, r)
ltcanvas c;
ltcontext gc;
int x, y, r;
{
	int ax, ay, aw, ah;

	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	/* don't change size */
	ax=c->ax;
	ay=c->ay;
	aw=c->aw;
	ah=c->ah;
	point_to_x(c, &ax, &ay);
	size_to_x(c, &aw, &ah);

	if(c->clipping && (y-r>ay+ah || x-r>ax+aw ||
		y+r<ay-1 || x+r<ax-1))
	{
		/* don't draw */
		return;
	}
	else
	{
		setup_gc(c, gc, d_fillarc);
		XFillArc(c->xdpy, c->buf, c->xgc, x-r, y-r, 2*r, 2*r, 0, 23040);
	}
}

drag_square_handle(c, x, y, r)
ltcanvas c;
int x, y, r;
{
	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	/* don't change size */
	/* draws directly to window */
	XDrawRectangle(c->xdpy, c->win, c->gcdrag, x-r, y-r, 2*r, 2*r);
}

drag_x_handle(c, x, y, r)
ltcanvas c;
int x, y, r;
{
	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	/* don't change size */
	/* draws directly to window */
	XDrawLine(c->xdpy, c->win, c->gcdragsolid, x-r, y-r, x+r, y+r);
	XDrawLine(c->xdpy, c->win, c->gcdragsolid, x-r, y+r, x+r, y-r);
}

drag_circle_handle(c, x, y, r)
ltcanvas c;
int x, y, r;
{
	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	XDrawArc(c->xdpy, c->win, c->gcdragsolid, x-r, y-r, 2*r, 2*r, 0, 23040);
}

drag_rectangle(c, x, y, w, h)
ltcanvas c;
int x, y, w, h;
{
	if(c->printing)
	{
		/* never print handles */
		return;
	}

	point_to_x(c, &x, &y);
	size_to_x(c, &w, &h);
	XDrawRectangle(c->xdpy, c->win, c->gcdrag, x, y, w, h);
}

int in_handle(c, x, y, hx, hy, hr)
ltcanvas c;
int x, y, hx, hy, hr;
{
	point_to_x(c, &x, &y);
	point_to_x(c, &hx, &hy);

	return(pt_in_rect(x, y, hx-hr, hy-hr, hr+hr, hr+hr));
}
