#include <stdio.h>

#ifdef MEMDBG
#include "memdbg.h"
#endif

#include "treestruct.h"

treegen newspace(t)
/* allocates space for a new data item */
data_type t;
{
	treegen tmp;

	switch(t)
	{
		case tr_tree:
			tmp=(treegen)malloc(sizeof(treed));
			break;
		case tr_node:
			tmp=(treegen)malloc(sizeof(treenoded));
			break;
		case tr_branch:
			tmp=(treegen)malloc(sizeof(treebranchd));
			break;
		default:
			tmp=NULL;
			break;
	}
	if(tmp==NULL)
		return(NULL);
	tmp->type=t;
	tmp->t=NULL;
	tmp->intdata=NULL;
	tmp->data=NULL;
	return(tmp);
}

tree tree_get_tree(i)
treegen i;
{
	if(i==NULL)
		return(0);
	return(i->t);
}

void *tree_get_tree_data(i)
treegen i;
{
	if(i==NULL)
		return(NULL);
	return(((treegen)i->t)->data);
}

int tree_set_tree(i, d)
treegen i;
void *d;
{
	if(i==NULL)
		return(0);
	i->t=d;
	return(1);
}

char *tree_get_name(i)
treegen i;
{
	if(i==NULL)
		return(NULL);
	if(i->type==tr_tree)
		return(((tree)i)->name);
	else if(i->type==tr_node)
		return(((treenode)i)->name);
	else
		return(NULL);
}
