/*
 * ParserDemo.java
 * pw ("parse world") sample app
 * usage: ParserDemo VRMLfile
 * Copyright (c) 1997 IICM
 *
 * created: mpichler, 19970114
 * changed: mpichler, 19970114
 *
 * $Id: ParserDemo.java,v 1.4 1997/05/22 16:25:30 apesen Exp $
 */


package iicm.vrml.pwsample;

import iicm.vrml.pw.*;

import java.io.*;


class ParserDemo
{
  public static void main (String args[])
  {
    if (args.length < 1)
    {
      System.out.println ("usage: ParserDemo VRMLFILE");
      return;
    }

    try
    {
      VRMLparser parser = new VRMLparser (new BufferedInputStream (new FileInputStream (args [0])));
      long time = System.currentTimeMillis ();
      GroupNode root = parser.readStream ();
      time = System.currentTimeMillis () - time;

      System.out.println ("*** Parsing time (ms): " + time);
      if (root != null)
      {
        SampleTraverser traverser = new SampleTraverser ();
        // traverser.sep_ = "\t";  // some people might prefer

        System.out.println ("====================");
        traverser.traverse (root);
        System.out.println ("====================");

/*
        // dumping data to file/terminal; see also ReadTest
        if (false)  // dump to terminal
        {
          System.out.println ("====================");
          parser.writeHeader (System.out);
          root.writeNodes (System.out);
          System.out.println ("====================");
        }
        else  // dump to file
        {
          FileOutputStream file = new FileOutputStream ("pwout.wrl");
          PrintStream os = new PrintStream (file);  // wrapper
          System.out.println ("=== dumping data to pwout.wrl ===");
          parser.writeHeader (os);
          root.writeNodes (os);
          os.close ();
          System.out.println ("=== finished ===");
        }
*/
      }
      else
        System.out.println ("error on parsing " + args [0]);
    }
    catch (IOException e)
    {
      System.out.println ("error on reading " + args [0]);
      // e.printStackTrace ();
      System.out.println (e.getMessage ());  // just prints file name
    }
//     catch (FileNotFoundException e)

  }
} // ParserDemo
