/*
 * ColField - colour field (used by colour chooser)
 *
 * created: apesen, 19961101
 *
 * changed: apesen, 19961126
 * changed: mpichler, 19970320
 *
 * $Id: ColField.java,v 1.2 1997/03/20 20:00:44 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;


/* ColField - colour field */

class ColField extends Canvas
{
  static final int DESELECTED = 0;
  static final int NEXT_TO    = 1;
  static final int SELECTED   = 2;
  private Color col;
  static Color selectedframe = Color.gray;
  static Color matchingframe = new Color (160, 160, 160);

  Dimension prefsize;
  int selected;

  ColField (Color c, int width, int height)
  {
    col = c;
    setBackground (c);
    selected = DESELECTED;
    prefsize = new Dimension (width, height);
  }

  public Color getCol ()
  {
    return col;
  }

  public void setCol(Color c)
  {
    col = c;
    setBackground (c);
    repaint();
  }

  public void select()
  {
    selected = SELECTED;
    repaint();
  }

  public void select(int s)
  {
    selected = s;
    repaint();
  }

  public void deselect()
  {
    selected = DESELECTED;
    repaint();
  }

  public Dimension preferredSize ()
  {
    return prefsize;
  }

  public synchronized Dimension minimumSize () 
  {
    return new Dimension (10, 5);
  }

  public void paint (Graphics g)
  {
    // update already cleared this cell with the background color
    if (selected == DESELECTED)
      return;

    Dimension dim = size ();
    g.setColor (matchingframe);  // ((selected == SELECTED) ? selectedframe : matchingframe);
    g.draw3DRect (0, 0, dim.width, dim.height, selected != SELECTED);
    g.draw3DRect (1, 1, dim.width-2, dim.height-2, selected != SELECTED);
    g.draw3DRect (2, 2, dim.width-4, dim.height-4, selected != SELECTED);
  } // paint

  int distance2 (ColField cf)
  {
    int dr = col.getRed() - cf.col.getRed();
    int dg = col.getGreen() - cf.col.getGreen();
    int db = col.getBlue() - cf.col.getBlue();

    return dr*dr + dg*dg + db*db;  // square of euclidean distance
  } 

  public ColField minDistance (ColField[] cTab)
  {
    int cmin = 0;
    int dmin = this.distance2 (cTab[0]);
    for (int i = 1; i < cTab.length;  i++)
    {
      int dact = distance2 (cTab[i]);
      if (dact < dmin)
      {
        dmin = dact;
        cmin = i;
      }
    }
    return cTab[cmin];  
  }
} // ColField
