// pkg_subtree.h (this is -*-c++-*-)
//
//  Copyright 1999-2002 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A subtree which contains packages (and other subtrees)

#ifndef PKG_SUBTREE_H
#define PKG_SUBTREE_H

#include "vscreen/vs_subtree.h"

#include "pkg_node.h"

class pkg_subtree:public vs_subtree<pkg_tree_node>,
		  public pkg_tree_node
{
  std::string name;
  std::string description; // This is like a Description: field.

  SigC::Signal1<void, std::string> *info_signal;
protected:
  void set_label(std::string _name) {name=_name;}
public:
  pkg_subtree(std::string _name, std::string _description="",
	      SigC::Signal1<void, std::string> *_info_signal=NULL,
	      bool _expanded=false):
    vs_subtree<pkg_tree_node>(_expanded), name(_name),
    description(_description), info_signal(_info_signal)
  {}

  pkg_subtree(std::string _name, bool _expanded):
    vs_subtree<pkg_tree_node>(_expanded), name(_name),
    description(""), info_signal(NULL)
  {
  }

  virtual void paint(vs_tree *win, int y, bool hierarchical);
  virtual const char *tag() const;
  virtual const char *label() const;

  virtual void select(undo_group *undo);
  virtual void hold(undo_group *undo);
  virtual void keep(undo_group *undo);
  virtual void remove(undo_group *undo);
  virtual void purge(undo_group *undo);
  virtual void reinstall(undo_group *undo);
  virtual void set_auto(bool isauto, undo_group *undo);

  virtual void highlighted(vs_tree *win);
  virtual void unhighlighted(vs_tree *win);

  std::string get_name() {return name;}
  std::string get_description() {return description;}

  bool dispatch_char(chtype ch, vs_tree *owner);
};

#endif
