#ifndef _TABS_H
#define _TABS_H

/*
 * autor
 * Michal Podsiadlik
 * michal at gov.one.pl 
 */

#include <qobject.h>
#include <qtimer.h>

#include <misc.h>
#include <chat_manager.h>
#include <kadu.h>

#include "tabwidget.h"

class QPopupMenu;

class TabsManager : public QObject 
{
	Q_OBJECT

	public:	
		TabsManager();
		~TabsManager();
	public slots:
		void onNewChat(const UserGroup* senders);
		void onDestroyChat(const UserGroup* senders);
		void onOpenChat(UserListElements senders);
		void onStatusChanged(UserListElement, QString, const UserStatus &, bool, bool);
		void onChatMsgReceived(Protocol* protocol, UserListElements senders, const QString& msg, time_t time, bool& grab);
		void onTabChange(QWidget *);		
		void onApplyConfig();
		void onNewTab();
		void onPopupMenu();
		void onTabAttach(const UserGroup*);
	private:
		TabWidget* tabdialog;
		QTimer timer;
		UserListElements newmsgs, newchats;
		bool no_tabs, autoswith;
		void insertTab(Chat* chat);
		void makePopupMenu();
		int menuitem;
		Chat* selectedchat;
		QPopupMenu* menu;
	private slots:
		void onTimer();
		void onContextMenu(QWidget* w, const QPoint& pos);
		void onMenu(int id);
};

extern TabsManager* tabs_manager;

#endif
