/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlistbox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

#include "modules/notify/notify.h"
#include "i_hide_from_u.h"
#include "powerkadu.h"

#include "icons_manager.h"
#include "config_dialog.h"
#include "userlist.h"
#include "gadu.h"
#include "misc.h"
#include "debug.h"

IHideFromU::IHideFromU(QObject *parent, const char *name)
: QObject(parent, name)
{
	kdebugf();
	ConfigDialog::addVGroupBox("PowerKadu", "PowerKadu",
			QT_TRANSLATE_NOOP("@default", "\"I hide from you\" list"), NULL, Advanced);
	ConfigDialog::addCheckBox("PowerKadu", "\"I hide from you\" list",
			QT_TRANSLATE_NOOP("@default", "Use \"I hide from you\" list"), "powerkadu_i_hide_from_u",
			false, QT_TRANSLATE_NOOP("@default", "Toggle usage of \"I hide from you\" list"),
			NULL, Advanced);
	ConfigDialog::addCheckBox("PowerKadu", "\"I hide from you\" list",
			QT_TRANSLATE_NOOP("@default", "Notify about hiding"), "powerkadu_i_hide_from_u_notify",
			false, QT_TRANSLATE_NOOP("@default", "Use hint module to notify when hiding"),
			NULL, Advanced);
	
	ConfigDialog::addGrid("PowerKadu", "\"I hide from you\" list", "listboxes", 3);
	ConfigDialog::addGrid("PowerKadu", "listboxes", "all_contacts", 1);
	ConfigDialog::addGrid("PowerKadu", "listboxes", "buttons", 1);
	ConfigDialog::addGrid("PowerKadu", "listboxes", "selected_contacts", 1);
	
	ConfigDialog::addLabel("PowerKadu", "all_contacts", QT_TRANSLATE_NOOP("@default", "Available"),
			NULL, Advanced);
	ConfigDialog::addListBox("PowerKadu", "all_contacts",
			"List of available contacts", QT_TRANSLATE_NOOP("@default", "Available contacts."), 
			NULL, Advanced);
	
	ConfigDialog::addPushButton("PowerKadu", "buttons", NULL, "AddToNotifyList", NULL,
			"forward_button", Advanced);
	ConfigDialog::addPushButton("PowerKadu", "buttons", NULL, "RemoveFromNotifyList", 
			NULL, "backward_button", Advanced);
	
	ConfigDialog::addLabel("PowerKadu", "selected_contacts", QT_TRANSLATE_NOOP("@default", "Selected"),
			NULL, Advanced);
	ConfigDialog::addListBox("PowerKadu", "selected_contacts",
			"List of contacts to avoid",
			QT_TRANSLATE_NOOP("@default", "List of you want to avoid"), NULL, Advanced);

	connect(userlist,
		SIGNAL( statusChanged(UserListElement, QString, const UserStatus &, bool, bool)  ),
		this,
		SLOT( onUserStatusChangedSlot(UserListElement, QString, const UserStatus &, bool, bool) ));

	ConfigDialog::registerSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));
	ConfigDialog::registerSlotOnApplyTab("PowerKadu", this, SLOT(onApplyTab()));
	ConfigDialog::registerSlotOnCloseTab("PowerKadu", this, SLOT(onCloseTab()));

	kdebugf2();
}

IHideFromU::~IHideFromU()
{
	kdebugf();
	ConfigDialog::removeControl("PowerKadu", "List of contacts to avoid");
	ConfigDialog::removeControl("PowerKadu", "Selected");
	ConfigDialog::removeControl("PowerKadu", NULL, "backward_button");
	ConfigDialog::removeControl("PowerKadu", NULL, "forward_button");
	ConfigDialog::removeControl("PowerKadu", "List of available contacts");
	ConfigDialog::removeControl("PowerKadu", "Available");
	ConfigDialog::removeControl("PowerKadu", "selected_contacts");
	ConfigDialog::removeControl("PowerKadu", "buttons");
	ConfigDialog::removeControl("PowerKadu", "all_contacts");
	ConfigDialog::removeControl("PowerKadu", "listboxes");
	ConfigDialog::removeControl("PowerKadu", "Notify about hiding");
	ConfigDialog::removeControl("PowerKadu", "Use \"I hide from you\" list");
	ConfigDialog::removeControl("PowerKadu", "\"I hide from you\" list");
	
	disconnect(userlist, 
		SIGNAL( statusChanged(UserListElement, QString, const UserStatus &, bool, bool)  ),
		this,
		SLOT( onUserStatusChangedSlot(UserListElement, QString, const UserStatus &, bool, bool) ));
			
	ConfigDialog::unregisterSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));
	ConfigDialog::unregisterSlotOnApplyTab("PowerKadu", this, SLOT(onApplyTab()));
	ConfigDialog::unregisterSlotOnCloseTab("PowerKadu", this, SLOT(onCloseTab()));
	kdebugf2();
}

void IHideFromU::onUserStatusChangedSlot(UserListElement elem, QString protocolName, const UserStatus &oldStatus,
		bool massively, bool last)
{
	kdebugf();
	if(config_file.readBoolEntry("PowerKadu", "powerkadu_i_hide_from_u", false) &&
		(gadu->status().isOnline() || gadu->status().isBusy()) &&
		(oldStatus.isOffline() || oldStatus.isInvisible()) && 
		(elem.status(protocolName).isOnline() || elem.status(protocolName).isBusy()) &&
		(contacts.contains(elem.ID(protocolName))))
	{
		QMap<QString,QVariant> parameters;
		parameters["Pixmap"] = icons_manager->loadIcon(dataPath("kadu/modules/data/powerkadu/powerkadu_32x32.png"));
		parameters["ShowSource"] = bool(FALSE);
		parameters["Foreground color"] = config_file.readEntry("PowerKadu", "hint_text_color");
		parameters["Background color"] = config_file.readEntry("PowerKadu", "hint_bg_color");
		parameters["Timeout"] = powerKadu->cfg()->readEntry("PowerKadu", "time");
		if(config_file.readBoolEntry("PowerKadu", "powerkadu_i_hide_from_u_notify", false))
			notify->emitMessage(QString::null, QString::null, tr("I\'m hiding from ") +
				elem.altNick(), &parameters);
		if(gadu->status().hasDescription())
			gadu->status().setInvisible(gadu->status().description());
		else
			gadu->status().setInvisible();
	}
	
	kdebugf2();
}

void IHideFromU::onCreateTab()
{
	kdebugf();
	QCheckBox *useIHideFromUCheckbox = ConfigDialog::getCheckBox("PowerKadu", "Use \"I hide from you\" list");
	QCheckBox *notifyCheckBox = ConfigDialog::getCheckBox("PowerKadu", "Notify about hiding");
	QListBox *availableList = ConfigDialog::getListBox("PowerKadu", "List of available contacts");
	QListBox *selectedList = ConfigDialog::getListBox("PowerKadu", "List of contacts to avoid");
	QPushButton *addButton = ConfigDialog::getPushButton("PowerKadu", NULL, "forward_button");
	QPushButton *removeButton = ConfigDialog::getPushButton("PowerKadu", NULL, "backward_button");
	setListBoxes();
	bool enabled = config_file.readBoolEntry("PowerKadu", "powerkadu_i_hide_from_u", false);
	notifyCheckBox->setEnabled(enabled);
	availableList->setEnabled(enabled);
	selectedList->setEnabled(enabled);
	addButton->setEnabled(enabled);
	removeButton->setEnabled(enabled);
	connect(useIHideFromUCheckbox, SIGNAL( toggled(bool) ), this, SLOT( onUseIHideFromUSlot(bool) ));
	connect(addButton, SIGNAL( clicked() ), this, SLOT( onAddSlot() ));
	connect(availableList, SIGNAL( selected(const QString&) ), this, SLOT( onAddSlot() ));
	connect(removeButton, SIGNAL( clicked() ), this, SLOT( onRemoveSlot() ));
	connect(selectedList, SIGNAL( selected(const QString&) ), this, SLOT(onRemoveSlot() ));
	kdebugf2();
}

void IHideFromU::onApplyTab()
{
	kdebugf();
	//QListBox *availableList = ConfigDialog::getListBox("PowerKadu", "List of available contacts");
	QListBox *selectedList = ConfigDialog::getListBox("PowerKadu", "List of contacts to avoid");
	QStringList list;
	for(uint i = 0; i < selectedList->count(); i++)
		list += selectedList->text(i);
	contacts.set(list);
	kdebugf2();
}

void IHideFromU::onCloseTab()
{
	kdebugf();
	QCheckBox *useIHideFromUCheckbox = ConfigDialog::getCheckBox("PowerKadu", "Use \"I hide from you\" list");
	QListBox *availableList = ConfigDialog::getListBox("PowerKadu", "List of available contacts");
	QListBox *selectedList = ConfigDialog::getListBox("PowerKadu", "List of contacts to avoid");
	QPushButton *addButton = ConfigDialog::getPushButton("PowerKadu", NULL, "forward_button");
	QPushButton *removeButton = ConfigDialog::getPushButton("PowerKadu", NULL, "backward_button");
	disconnect(addButton, SIGNAL( clicked() ), this, SLOT( onAddSlot() ));
	disconnect(useIHideFromUCheckbox, SIGNAL( toggled(bool) ), this, SLOT( onUseIHideFromUSlot(bool) ));
	disconnect(availableList, SIGNAL( selected(const QString&) ), this, SLOT( onAddSlot() ));
	disconnect(removeButton, SIGNAL( clicked() ), this, SLOT( onRemoveSlot() ));
	disconnect(selectedList, SIGNAL( selected(const QString&) ), this, SLOT(onRemoveSlot() ));
	kdebugf2();
}
void IHideFromU::onUseIHideFromUSlot(bool toggled)
{
	kdebugf();
	QCheckBox *notifyCheckBox = ConfigDialog::getCheckBox("PowerKadu", "Notify about hiding");
	QListBox *availableList = ConfigDialog::getListBox("PowerKadu", "List of available contacts");
	QListBox *selectedList = ConfigDialog::getListBox("PowerKadu", "List of contacts to avoid");
	QPushButton *addButton = ConfigDialog::getPushButton("PowerKadu", NULL, "forward_button");
	QPushButton *removeButton = ConfigDialog::getPushButton("PowerKadu", NULL, "backward_button");
	notifyCheckBox->setEnabled(toggled);
	availableList->setEnabled(toggled);
	selectedList->setEnabled(toggled);
	addButton->setEnabled(toggled);
	removeButton->setEnabled(toggled);
	kdebugf2();
}

void IHideFromU::onAddSlot()
{
	kdebugf();
	QListBox *availableList = ConfigDialog::getListBox("PowerKadu", "List of available contacts");
	QListBox *selectedList = ConfigDialog::getListBox("PowerKadu", "List of contacts to avoid");

	selectedList->insertItem(availableList->currentText());
	selectedList->sort();
	availableList->removeItem(availableList->currentItem());
	kdebugf2();
}

void IHideFromU::onRemoveSlot()
{
	kdebugf();
	QListBox *availableList = ConfigDialog::getListBox("PowerKadu", "List of available contacts");
	QListBox *selectedList = ConfigDialog::getListBox("PowerKadu", "List of contacts to avoid");

	availableList->insertItem(selectedList->currentText());
	availableList->sort();
	selectedList->removeItem(selectedList->currentItem());
	kdebugf2();
}

void IHideFromU::setListBoxes()
{
	kdebugf();
	QListBox *availableList = ConfigDialog::getListBox("PowerKadu", "List of available contacts");
	QListBox *selectedList = ConfigDialog::getListBox("PowerKadu", "List of contacts to avoid");
	availableList->clear();
	availableList->insertStringList(contacts.getAvailableContacts());
	availableList->sort();
	selectedList->clear();
	selectedList->insertStringList(contacts.getAvoidedContacts());	
	selectedList->sort();
	kdebugf2();
}
