#ifndef COMMON_TYPES_H
#define COMMON_TYPES_H

#include <qdatastream.h>

#include <kdemacros.h>

struct ClientPlayData { Q_UINT8 height, gift, end; };
KDE_EXPORT QDataStream &operator <<(QDataStream &s, const ClientPlayData &d);
KDE_EXPORT QDataStream &operator >>(QDataStream &s, ClientPlayData &d);

struct ServerPlayData { Q_UINT8 prevHeight, nextHeight, gift; };
KDE_EXPORT QDataStream &operator <<(QDataStream &s, const ServerPlayData &d);
KDE_EXPORT QDataStream &operator >>(QDataStream &s, ServerPlayData &d);

class ServerInitData
{
 public:
	QString  prevName, nextName, name;
	Q_UINT32 initLevel, seed;
};
KDE_EXPORT QDataStream &operator <<(QDataStream &s, const ServerInitData &d);
KDE_EXPORT QDataStream &operator >>(QDataStream &s, ServerInitData &d);

#endif
