/*
 * This file is part of the KDE project
 *  Copyright (C) 2002 Laurent Montel <lmontel@mandrakesoft.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef KIS_IMAGE_IFACE_H
#define KIS_IMAGE_IFACE_H

#include <KoViewIface.h>
#include <dcopref.h>
#include <qstring.h>

class KisImage;

class KIsImageIface : virtual public DCOPObject
{
	K_DCOP
public:
	KIsImageIface( KisImage *img_ );
k_dcop:
	QString name()const;
	int height() const;
	int width() const;
	bool empty() const;

	void setName(const QString& name);

private:

	KisImage *m_img;
};

#endif
