/*
 * This file is part of Krita
 *
 * Copyright (c) 2004 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef EXAMPLE_H
#define EXAMPLE_H

#include <kparts/plugin.h>
#include "kis_filter.h"

class KritaExample : public KParts::Plugin
{
public:
	KritaExample(QObject *parent, const char *name, const QStringList &);
	virtual ~KritaExample();

private:

	KisView * m_view;

};

class KisFilterInvert : public KisFilter
{
public:
	KisFilterInvert(KisView * view);
public:
	virtual void process(KisPaintDeviceSP src, KisPaintDeviceSP dst, KisFilterConfiguration*, const QRect&);
	static inline KisID id() { return KisID("invert", i18n("Invert")); };
	virtual bool supportsPainting() { return true; }
	virtual bool supportsIncrementalPainting() { return false; }
};

#endif
