/***************************************************************************
                          subtitlenavigator.h  -  description
                             -------------------
    begin                : Tue Feb 25 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SUBTITLENAVIGATOR_H
#define SUBTITLENAVIGATOR_H

#include <qwidget.h>
#include <qlabel.h>
#include <qpixmap.h>

#include "csubtitles.h"

/**
  *@author Tom Deblauwe
  */

class SubtitleNavigator : public QLabel  {
  Q_OBJECT
  public:
	  SubtitleNavigator(QWidget *parent=0, const char *name=0);
	  ~SubtitleNavigator();
	  /** Draws the given subtitles on the navigator.  There is always one highlightSub normally, but you
	    * can draw subs without a highlightSub too, but it is not used in KSubtile
        * @param subtitles A subtitles object containing zero or more subtitles.
		* @param newSubs If the subs in subtitles have a new total endtime compared to the existing ones, then this must be set to true.
		* @param highlightSub The subtitle which must be highlighted(have a different color).  This subtitle is the currently selected one.
	  */
    void drawSubs(CSubtitles * subtitles, bool newSubs = false, CSubtitle * highlightSub=0);
    /** Gives you how many ms the subtitles occupy
	  * @return Endtime of last subtitle.
	*/
	long getWidthMSecs(void);

    /** The selected subtitle
	  * @return The selected subtitle
	*/
	CSubtitle* getSelectedSubtitle(void);
    /** Sets if, when you use drawSubs, the highlightSub is centered on the widget.
	*/
	void setSelectedSubtitleCentered(bool centered);
    /** Selects a subtitle as the current one and redraws the widget so this subtitle now has a different color.
	*/
	void selectSubtitle(CSubtitle * sub);

  protected:
    virtual void mousePressEvent( QMouseEvent* );
    virtual void mouseMoveEvent( QMouseEvent* );
    virtual void paintEvent( QPaintEvent* );
    virtual void resizeEvent( QResizeEvent* );

  private:
    /** The buffer we draw onto.  This buffer is then used in the paintEvent function.
	*/
    QPixmap buffer;
	/** The CSubtitles object which contains the subtitles to be displayed.
	*/
    CSubtitles* subtitles;
	/** The starttime from which the subtitles on the navigator are visible
	*/
    long zoomStartTime;
	/** The endtime at which the subtitles on the navigator stop being visible
	*/
	long zoomEndTime;
    /** The minimum amount of ms we want the navigator to show.  There can not be zoomed more than this amount.
	  * Default is 3000 ms.
	*/
	long minVisibleMSecs;
    CSubtitle* highlightSub;
    bool selectedSubtitleCentered;

  public slots:
    /** Zoom in on the given subtitle, or zoom in on the center of the widget if it is ommitted
	  * @param zoomSubTitle The subtitle to zoom into.
	*/
    void slotZoomIn(CSubtitle* zoomSubTitle=0);
    void slotZoomOut(void);
    void slotGoRight(int nrOfMSecs);
    void slotGoLeft(int nrOfMSecs);
	/** Shows a given sub on the navigator, without selecting it, just centers it.
	*/
    void slotShowSub(CSubtitle*);

  signals:
    void rightEndReached(bool isReached);
    void leftEndReached(bool isReached);
    void maxZoomedIn(bool isMax);
    void maxZoomedOut(bool isMax);
    void zoomStartTimeChanged(long newTime);
    void zoomEndTimeChanged(long newTime);
    void subClicked(CSubtitle * sub);
    void noSubs(bool areThereNoSubs);


};

#endif
