// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Copyright (c) 2005 Novell, Inc. (http://www.novell.com)
//
// Authors:
//	Peter Bartok	(pbartok@novell.com)
//
//

// COMPLETE

namespace System.Windows.Forms {
	internal enum Minor {
		Undefined	= -1,

		// Major.CharSet
		AnsiCharSet	= 0,
		MacCharSet	= 1,
		PcCharSet	= 2,
		PcaCharSet	= 3,

		// Major.Destination
		FontTbl		= 0,
		FontAltName	= 1,
		EmbeddedFont	= 2,
		FontFile	= 3,
		FileTbl		= 4,
		FileInfo	= 5,
		ColorTbl	= 6,
		StyleSheet	= 7,
		KeyCode		= 8,
		RevisionTbl	= 9,
		Info		= 10,
		ITitle		= 11,
		ISubject	= 12,
		IAuthor		= 13,
		IOperator	= 14,
		IKeywords	= 15,
		IComment	= 16,
		IVersion	= 17,
		IDoccomm	= 18,
		IVerscomm	= 19,
		NextFile	= 20,
		Template	= 21,
		FNSep		= 22,
		FNContSep	= 23,
		FNContNotice	= 24,
		ENSep		= 25,
		ENContSep	= 26,
		ENContNotice	= 27,
		PageNumLevel	= 28,
		ParNumLevelStyle= 29,
		Header		= 30,
		Footer		= 31,
		HeaderLeft	= 32,
		HeaderRight	= 33,
		HeaderFirst	= 34,
		FooterLeft	= 35,
		FooterRight	= 36,
		FooterFirst	= 37,
		ParNumText	= 38,
		ParNumbering	= 39,
		ParNumTextAfter	= 40,
		ParNumTextBefore= 41,
		BookmarkStart	= 42,
		BookmarkEnd	= 43,
		Pict		= 44,
		Object		= 45,
		ObjClass	= 46,
		ObjName		= 47,
		ObjTime		= 48,
		ObjData		= 49,
		ObjAlias	= 50,
		ObjSection	= 51,
		ObjResult	= 52,
		ObjItem		= 53,
		ObjTopic	= 54,
		DrawObject	= 55,
		Footnote	= 56,
		AnnotRefStart	= 57,
		AnnotRefEnd	= 58,
		AnnotID		= 59,
		AnnotAuthor	= 60,
		Annotation	= 61,
		AnnotRef	= 62,
		AnnotTime	= 63,
		AnnotIcon	= 64,
		Field		= 65,
		FieldInst	= 66,
		FieldResult	= 67,
		DataField	= 68,
		Index		= 69,
		IndexText	= 70,
		IndexRange	= 71,
		TOC		= 72,
		NeXTGraphic	= 73,
		MaxDestination	= 74,

		// Major.FontFamily
		FFNil		= 0,
		FFRoman		= 1,
		FFSwiss		= 2,
		FFModern	= 3,
		FFScript	= 4,
		FFDecor		= 5,
		FFTech		= 6,
		FFBidirectional	= 7,

		// Major.ColorName
		Red		= 0,
		Green		= 1,
		Blue		= 2,

		// Major.SpecialChar
		IIntVersion	= 0,
		ICreateTime	= 1,
		IRevisionTime	= 2,
		IPrintTime	= 3,
		IBackupTime	= 4,
		IEditTime	= 5,
		IYear		= 6,
		IMonth		= 7,
		IDay		= 8,
		IHour		= 9,
		IMinute		= 10,
		ISecond		= 11,
		INPages		= 12,
		INWords		= 13,
		INChars		= 14,
		IIntID		= 15,
		CurHeadDate	= 16,
		CurHeadDateLong	= 17,
		CurHeadDateAbbrev= 18,
		CurHeadTime	= 19,
		CurHeadPage	= 20,
		SectNum		= 21,
		CurFNote	= 22,
		CurAnnotRef	= 23,
		FNoteSep	= 24,
		FNoteCont	= 25,
		Cell		= 26,
		Row		= 27,
		Par		= 28,
		Sect		= 29,
		Page		= 30,
		Column		= 31,
		Line		= 32,
		SoftPage	= 33,
		SoftColumn	= 34,
		SoftLine	= 35,
		SoftLineHt	= 36,
		Tab		= 37,
		EmDash		= 38,
		EnDash		= 39,
		EmSpace		= 40,
		EnSpace		= 41,
		Bullet		= 42,
		LQuote		= 43,
		RQuote		= 44,
		LDblQuote	= 45,
		RDblQuote	= 46,
		Formula		= 47,
		NoBrkSpace	= 49,
		NoReqHyphen	= 50,
		NoBrkHyphen	= 51,
		OptDest		= 52,
		LTRMark		= 53,
		RTLMark		= 54,
		NoWidthJoiner	= 55,
		NoWidthNonJoiner= 56,
		CurHeadPict	= 57,

		// Major.StyleAttr
		Additive	= 0,
		BasedOn		= 1,
		Next		= 2,

		// Major.DocAttr
		DefTab		= 0,
		HyphHotZone	= 1,
		HyphConsecLines	= 2,
		HyphCaps	= 3,
		HyphAuto	= 4,
		LineStart	= 5,
		FracWidth	= 6,
		MakeBackup	= 7,
		RTFDefault	= 8,
		PSOverlay	= 9,
		DocTemplate	= 10,
		DefLanguage	= 11,
		FENoteType	= 12,
		FNoteEndSect	= 13,
		FNoteEndDoc	= 14,
		FNoteText	= 15,
		FNoteBottom	= 16,
		ENoteEndSect	= 17,
		ENoteEndDoc	= 18,
		ENoteText	= 19,
		ENoteBottom	= 20,
		FNoteStart	= 21,
		ENoteStart	= 22,
		FNoteRestartPage= 23,
		FNoteRestart	= 24,
		FNoteRestartCont= 25,
		ENoteRestart	= 26,
		ENoteRestartCont= 27,
		FNoteNumArabic	= 28,
		FNoteNumLLetter	= 29,
		FNoteNumULetter	= 30,
		FNoteNumLRoman	= 31,
		FNoteNumURoman	= 32,
		FNoteNumChicago	= 33,
		ENoteNumArabic	= 34,
		ENoteNumLLetter	= 35,
		ENoteNumULetter	= 36,
		ENoteNumLRoman	= 37,
		ENoteNumURoman	= 38,
		ENoteNumChicago	= 39,
		PaperWidth	= 40,
		PaperHeight	= 41,
		PaperSize	= 42,
		LeftMargin	= 43,
		RightMargin	= 44,
		TopMargin	= 45,
		BottomMargin	= 46,
		FacingPage	= 47,
		GutterWid	= 48,
		MirrorMargin	= 49,
		Landscape	= 50,
		PageStart	= 51,
		WidowCtrl	= 52,
		LinkStyles	= 53,
		NoAutoTabIndent	= 54,
		WrapSpaces	= 55,
		PrintColorsBlack= 56,
		NoExtraSpaceRL	= 57,
		NoColumnBalance	= 58,
		CvtMailMergeQuote= 59,
		SuppressTopSpace= 60,
		SuppressPreParSpace= 61,
		CombineTblBorders= 62,
		TranspMetafiles	= 63,
		SwapBorders	= 64,
		ShowHardBreaks	= 65,
		FormProtected	= 66,
		AllProtected	= 67,
		FormShading	= 68,
		FormDisplay	= 69,
		PrintData	= 70,
		RevProtected	= 71,
		Revisions	= 72,
		RevDisplay	= 73,
		RevBar		= 74,
		AnnotProtected	= 75,
		RTLDoc		= 76,
		LTRDoc		= 77,

		// Major.SectAttr

		SectDef		= 0,
		ENoteHere	= 1,
		PrtBinFirst	= 2,
		PrtBin		= 3,
		SectStyleNum	= 4,
		NoBreak		= 5,
		ColBreak	= 6,
		PageBreak	= 7,
		EvenBreak	= 8,
		OddBreak	= 9,
		Columns		= 10,
		ColumnSpace	= 11,
		ColumnNumber	= 12,
		ColumnSpRight	= 13,
		ColumnWidth	= 14,
		ColumnLine	= 15,
		LineModulus	= 16,
		LineDist	= 17,
		LineStarts	= 18,
		LineRestart	= 19,
		LineRestartPg	= 20,
		LineCont	= 21,
		SectPageWid	= 22,
		SectPageHt	= 23,
		SectMarginLeft	= 24,
		SectMarginRight	= 25,
		SectMarginTop	= 26,
		SectMarginBottom= 27,
		SectMarginGutter= 28,
		SectLandscape	= 29,
		TitleSpecial	= 30,
		HeaderY		= 31,
		FooterY		= 32,
		PageStarts	= 33,
		PageCont	= 34,
		PageRestart	= 35,
		PageNumRight	= 36,
		PageNumTop	= 37,
		PageDecimal	= 38,
		PageURoman	= 39,
		PageLRoman	= 40,
		PageULetter	= 41,
		PageLLetter	= 42,
		PageNumHyphSep	= 43,
		PageNumSpaceSep	= 44,
		PageNumColonSep	= 45,
		PageNumEmdashSep= 46,
		PageNumEndashSep= 47,
		TopVAlign	= 48,
		BottomVAlign	= 49,
		CenterVAlign	= 50,
		JustVAlign	= 51,
		RTLSect		= 52,
		LTRSect		= 53,

		// Major.TblAttr
		RowDef		= 0,
		RowGapH		= 1,
		CellPos		= 2,
		MergeRngFirst	= 3,
		MergePrevious	= 4,
		RowLeft		= 5,
		RowRight	= 6,
		RowCenter	= 7,
		RowLeftEdge	= 8,
		RowHt		= 9,
		RowHeader	= 10,
		RowKeep		= 11,
		RTLRow		= 12,
		LTRRow		= 13,
		RowBordTop	= 14,
		RowBordLeft	= 15,
		RowBordBottom	= 16,
		RowBordRight	= 17,
		RowBordHoriz	= 18,
		RowBordVert	= 19,
		CellBordBottom	= 20,
		CellBordTop	= 21,
		CellBordLeft	= 22,
		CellBordRight	= 23,
		CellShading	= 24,
		CellBgPatH	= 25,
		CellBgPatV	= 26,
		CellFwdDiagBgPat= 27,
		CellBwdDiagBgPat= 28,
		CellHatchBgPat	= 29,
		CellDiagHatchBgPat	= 30,
		CellDarkBgPatH	= 31,
		CellDarkBgPatV	= 32,
		CellFwdDarkBgPat= 33,
		CellBwdDarkBgPat= 34,
		CellDarkHatchBgPat	= 35,
		CellDarkDiagHatchBgPat	= 36,
		CellBgPatLineColor	= 37,
		CellBgPatColor	= 38,

		// Major.ParAttr
		ParDef		= 0,
		StyleNum	= 1,
		Hyphenate	= 2,
		InTable		= 3,
		Keep		= 4,
		NoWidowControl	= 5,
		KeepNext	= 6,
		OutlineLevel	= 7,
		NoLineNum	= 8,
		PBBefore	= 9,
		SideBySide	= 10,
		QuadLeft	= 11,
		QuadRight	= 12,
		QuadJust	= 13,
		QuadCenter	= 14,
		FirstIndent	= 15,
		LeftIndent	= 16,
		RightIndent	= 17,
		SpaceBefore	= 18,
		SpaceAfter	= 19,
		SpaceBetween	= 20,
		SpaceMultiply	= 21,
		SubDocument	= 22,
		RTLPar		= 23,
		LTRPar		= 24,
		TabPos		= 25,
		TabLeft		= 26,
		TabRight	= 27,
		TabCenter	= 28,
		TabDecimal	= 29,
		TabBar		= 30,
		LeaderDot	= 31,
		LeaderHyphen	= 32,
		LeaderUnder	= 33,
		LeaderThick	= 34,
		LeaderEqual	= 35,
		ParLevel	= 36,
		ParBullet	= 37,
		ParSimple	= 38,
		ParNumCont	= 39,
		ParNumOnce	= 40,
		ParNumAcross	= 41,
		ParHangIndent	= 42,
		ParNumRestart	= 43,
		ParNumCardinal	= 44,
		ParNumDecimal	= 45,
		ParNumULetter	= 46,
		ParNumURoman	= 47,
		ParNumLLetter	= 48,
		ParNumLRoman	= 49,
		ParNumOrdinal	= 50,
		ParNumOrdinalText= 51,
		ParNumBold	= 52,
		ParNumItalic	= 53,
		ParNumAllCaps	= 54,
		ParNumSmallCaps	= 55,
		ParNumUnder	= 56,
		ParNumDotUnder	= 57,
		ParNumDbUnder	= 58,
		ParNumNoUnder	= 59,
		ParNumWordUnder	= 60,
		ParNumStrikethru= 61,
		ParNumForeColor	= 62,
		ParNumFont	= 63,
		ParNumFontSize	= 64,
		ParNumIndent	= 65,
		ParNumSpacing	= 66,
		ParNumInclPrev	= 67,
		ParNumCenter	= 68,
		ParNumLeft	= 69,
		ParNumRight	= 70,
		ParNumStartAt	= 71,
		BorderTop	= 72,
		BorderBottom	= 73,
		BorderLeft	= 74,
		BorderRight	= 75,
		BorderBetween	= 76,
		BorderBar	= 77,
		BorderBox	= 78,
		BorderSingle	= 79,
		BorderThick	= 80,
		BorderShadow	= 81,
		BorderDouble	= 82,
		BorderDot	= 83,
		BorderDash	= 84,
		BorderHair	= 85,
		BorderWidth	= 86,
		BorderColor	= 87,
		BorderSpace	= 88,
		Shading		= 89,
		BgPatH		= 90,
		BgPatV		= 91,
		FwdDiagBgPat	= 92,
		BwdDiagBgPat	= 93,
		HatchBgPat	= 94,
		DiagHatchBgPat	= 95,
		DarkBgPatH	= 96,
		DarkBgPatV	= 97,
		FwdDarkBgPat	= 98,
		BwdDarkBgPat	= 99,
		DarkHatchBgPat	= 100,
		DarkDiagHatchBgPat= 101,
		BgPatLineColor	= 102,
		BgPatColor	= 103,

		// Major.CharAttr
		Plain		= 0,
		Bold		= 1,
		AllCaps		= 2,
		Deleted		= 3,
		SubScript	= 4,
		SubScrShrink	= 5,
		NoSuperSub	= 6,
		Expand		= 7,
		ExpandTwips	= 8,
		Kerning		= 9,
		FontNum		= 10,
		FontSize	= 11,
		Italic		= 12,
		Outline		= 13,
		Revised		= 14,
		RevAuthor	= 15,
		RevDTTM		= 16,
		SmallCaps	= 17,
		Shadow		= 18,
		StrikeThru	= 19,
		Underline	= 20,
		DotUnderline	= 21,
		DbUnderline	= 22,
		NoUnderline	= 23,
		WordUnderline	= 24,
		SuperScript	= 25,
		SuperScrShrink	= 26,
		Invisible	= 27,
		ForeColor	= 28,
		BackColor	= 29,
		RTLChar		= 30,
		LTRChar		= 31,
		CharStyleNum	= 32,
		CharCharSet	= 33,
		Language	= 34,
		Gray		= 35,

		// Major.PictAttr
		MacQD		= 0,
		PMMetafile	= 1,
		WinMetafile	= 2,
		DevIndBitmap	= 3,
		WinBitmap	= 4,
		PixelBits	= 5,
		BitmapPlanes	= 6,
		BitmapWid	= 7,
		PicWid		= 8,
		PicHt		= 9,
		PicGoalWid	= 10,
		PicGoalHt	= 11,
		PicScaleX	= 12,
		PicScaleY	= 13,
		PicScaled	= 14,
		PicCropTop	= 15,
		PicCropBottom	= 16,
		PicCropLeft	= 17,
		PicCropRight	= 18,
		PicMFHasBitmap	= 19,
		PicMFBitsPerPixel= 20,
		PicBinary	= 21,

		// Major.BookmarkAttr
		BookmarkFirstCol= 0,
		BookmarkLastCol = 1,

		// Major.NeXTGrAttr
		NeXTGWidth	= 0,
		NeXTGHeight	= 1,

		// Major.FieldAttr
		FieldDirty	= 0,
		FieldEdited	= 1,
		FieldLocked	= 2,
		FieldPrivate	= 3,
		FieldAlt	= 4,

		// Major.TOCAttr
		TOCType		= 0,
		TOCLevel	= 1,

		// Major.PosAttr
		AbsWid		= 0,
		AbsHt		= 1,
		RPosMargH	= 2,
		RPosPageH	= 3,
		RPosColH	= 4,
		PosX		= 5,
		PosNegX		= 6,
		PosXCenter	= 7,
		PosXInside	= 8,
		PosXOutSide	= 9,
		PosXRight	= 10,
		PosXLeft	= 11,
		RPosMargV	= 12,
		RPosPageV	= 13,
		RPosParaV	= 14,
		PosY		= 15,
		PosNegY		= 16,
		PosYInline	= 17,
		PosYTop		= 18,
		PosYCenter	= 19,
		PosYBottom	= 20,
		NoWrap		= 21,
		DistFromTextAll	= 22,
		DistFromTextX	= 23,
		DistFromTextY	= 24,
		TextDistY	= 25,
		DropCapLines	= 26,
		DropCapType	= 27,

		// Major.ObjAttr
		ObjEmb		= 0,
		ObjLink		= 1,
		ObjAutoLink	= 2,
		ObjSubscriber	= 3,
		ObjPublisher	= 4,
		ObjICEmb	= 5,
		ObjLinkSelf	= 6,
		ObjLock		= 7,
		ObjUpdate	= 8,
		ObjHt		= 9,
		ObjWid		= 10,
		ObjSetSize	= 11,
		ObjAlign	= 12,
		ObjTransposeY	= 13,
		ObjCropTop	= 14,
		ObjCropBottom	= 15,
		ObjCropLeft	= 16,
		ObjCropRight	= 17,
		ObjScaleX	= 18,
		ObjScaleY	= 19,
		ObjResRTF	= 20,
		ObjResPict	= 21,
		ObjResBitmap	= 22,
		ObjResText	= 23,
		ObjResMerge	= 24,
		ObjBookmarkPubObj= 25,
		ObjPubAutoUpdate= 26,

		// Major.FNoteAttr
		FNAlt		= 0,

		// Major.KeyCodeAttr
		AltKey		= 0,
		ShiftKey	= 1,
		ControlKey	= 2,
		FunctionKey	= 3,

		// Major.ACharAttr
		ACBold		= 0,
		ACAllCaps	= 1,
		ACForeColor	= 2,
		ACSubScript	= 3,
		ACExpand	= 4,
		ACFontNum	= 5,
		ACFontSize	= 6,
		ACItalic	= 7,
		ACLanguage	= 8,
		ACOutline	= 9,
		ACSmallCaps	= 10,
		ACShadow	= 11,
		ACStrikeThru	= 12,
		ACUnderline	= 13,
		ACDotUnderline	= 14,
		ACDbUnderline	= 15,
		ACNoUnderline	= 16,
		ACWordUnderline	= 17,
		ACSuperScript	= 18,

		// Major.FontAttr
		FontCharSet	= 0,
		FontPitch	= 1,
		FontCodePage	= 2,
		FTypeNil	= 3,
		FTypeTrueType	= 4,

		// Major.FileAttr
		FileNum		= 0,
		FileRelPath	= 1,
		FileOSNum	= 2,

		// Major.FileSource
		SrcMacintosh	= 0,
		SrcDOS		= 1,
		SrcNTFS		= 2,
		SrcHPFS		= 3,
		SrcNetwork	= 4,

		// Major.DrawAttr
		DrawLock	= 0,
		DrawPageRelX	= 1,
		DrawColumnRelX	= 2,
		DrawMarginRelX	= 3,
		DrawPageRelY	= 4,
		DrawColumnRelY	= 5,
		DrawMarginRelY	= 6,
		DrawHeight	= 7,
		DrawBeginGroup	= 8,
		DrawGroupCount	= 9,
		DrawEndGroup	= 10,
		DrawArc		= 11,
		DrawCallout	= 12,
		DrawEllipse	= 13,
		DrawLine	= 14,
		DrawPolygon	= 15,
		DrawPolyLine	= 16,
		DrawRect	= 17,
		DrawTextBox	= 18,
		DrawOffsetX	= 19,
		DrawSizeX	= 20,
		DrawOffsetY	= 21,
		DrawSizeY	= 22,
		COAngle		= 23,
		COAccentBar	= 24,
		COBestFit	= 25,
		COBorder	= 26,
		COAttachAbsDist	= 27,
		COAttachBottom	= 28,
		COAttachCenter	= 29,
		COAttachTop	= 30,
		COLength	= 31,
		CONegXQuadrant	= 32,
		CONegYQuadrant	= 33,
		COOffset	= 34,
		COAttachSmart	= 35,
		CODoubleLine	= 36,
		CORightAngle	= 37,
		COSingleLine	= 38,
		COTripleLine	= 39,
		DrawTextBoxMargin= 40,
		DrawTextBoxText	= 41,
		DrawRoundRect	= 42,
		DrawPointX	= 43,
		DrawPointY	= 44,
		DrawPolyCount	= 45,
		DrawArcFlipX	= 46,
		DrawArcFlipY	= 47,
		DrawLineBlue	= 48,
		DrawLineGreen	= 49,
		DrawLineRed	= 50,
		DrawLinePalette	= 51,
		DrawLineDashDot	= 52,
		DrawLineDashDotDot= 53,
		DrawLineDash	= 54,
		DrawLineDot	= 55,
		DrawLineGray	= 56,
		DrawLineHollow	= 57,
		DrawLineSolid	= 58,
		DrawLineWidth	= 59,
		DrawHollowEndArrow	= 60,
		DrawEndArrowLength	= 61,
		DrawSolidEndArrow	= 62,
		DrawEndArrowWidth	= 63,
		DrawHollowStartArrow	= 64,
		DrawStartArrowLength	= 65,
		DrawSolidStartArrow	= 66,
		DrawStartArrowWidth	= 67,
		DrawBgFillBlue		= 68,
		DrawBgFillGreen		= 69,
		DrawBgFillRed		= 70,
		DrawBgFillPalette	= 71,
		DrawBgFillGray		= 72,
		DrawFgFillBlue		= 73,
		DrawFgFillGreen		= 74,
		DrawFgFillRed		= 75,
		DrawFgFillPalette	= 76,
		DrawFgFillGray		= 77,
		DrawFillPatIndex	= 78,
		DrawShadow		= 79,
		DrawShadowXOffset	= 80,
		DrawShadowYOffset	= 81,

		// Major.IndexAttr
		IndexNumber	= 0,
		IndexBold	= 1,
		IndexItalic	= 2,

		// Major.Unicode
		UnicodeCharBytes	= 0,
		UnicodeChar		= 1,
		UnicodeDestination	= 2,
		UnicodeDualDestination	= 3,
		UnicodeAnsiCodepage	= 4

	}
}
