//
// X509CrlTest.cs - NUnit Test Cases for the X509Crl class
//
// Authors:
//	Sebastien Pouliot  <sebastien@ximian.com>
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//

using System;
using Mono.Security.X509;

using NUnit.Framework;


namespace MonoTests.Mono.Security.X509 {

	[TestFixture]
	public class X509CrlTest {

		static public byte[] emptyCrl = { 0x30, 0x82, 0x02, 0x08, 0x30, 0x81, 0xF1, 0x02, 0x01, 0x01, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x31, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x44, 0x4B, 0x31, 0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x03, 0x54, 0x44, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x0B, 0x54, 0x44, 0x43, 0x20, 0x4F, 0x43, 0x45, 0x53, 0x20, 0x43, 0x41, 0x17, 0x0D, 0x30, 0x35, 0x30, 0x36, 0x32, 0x38, 0x30, 0x38, 0x30, 0x38, 0x30, 0x33, 0x5A, 0x17, 0x0D, 0x30, 0x35, 0x30, 0x36, 0x32, 0x38, 0x32, 0x31, 
			0x30, 0x38, 0x30, 0x33, 0x5A, 0xA0, 0x81, 0x8B, 0x30, 0x81, 0x88, 0x30, 0x59, 0x06, 0x03, 0x55, 0x1D, 0x1C, 0x01, 0x01, 0xFF, 0x04, 0x4F, 0x30, 0x4D, 0xA0, 0x48, 0xA0, 0x46, 0xA4, 0x44, 0x30, 0x42, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x44, 0x4B, 0x31, 0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x03, 0x54, 0x44, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x0B, 0x54, 0x44, 0x43, 0x20, 0x4F, 0x43, 0x45, 0x53, 0x20, 0x43, 0x41, 0x31, 0x0F, 0x30, 0x0D, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x06, 0x43, 0x52, 0x4C, 0x37, 0x30, 0x36, 0x81, 
			0x01, 0xFF, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x1D, 0x14, 0x04, 0x03, 0x02, 0x01, 0x01, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x60, 0xB5, 0x85, 0xEC, 0x56, 0x64, 0x7E, 0x12, 0x19, 0x27, 0x67, 0x1D, 0x50, 0x15, 0x4B, 0x73, 0xAE, 0x3B, 0xF9, 0x12, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x7B, 0x45, 0x18, 0xCC, 0x96, 0xBD, 0x82, 0x87, 0x42, 0xA0, 0xAD, 0x82, 0x28, 0x0C, 0x62, 0x2C, 0x25, 0x51, 0x0D, 0x86, 0xC4, 0x07, 0x3C, 0xFA, 0x64, 0x42, 0x38, 0x33, 0x0B, 0x36, 0xE2, 0xC9, 0xAA, 
			0xBA, 0x33, 0x8F, 0x94, 0xBD, 0xCF, 0x58, 0x4F, 0xD9, 0xA5, 0x18, 0xE1, 0x55, 0x79, 0xD5, 0xD1, 0x74, 0x10, 0xE3, 0x32, 0x3F, 0x28, 0x81, 0x2B, 0x56, 0x22, 0x0B, 0x54, 0x19, 0x86, 0xA9, 0xF6, 0x9F, 0x44, 0x25, 0x2F, 0x8E, 0x2E, 0x38, 0xA7, 0x6C, 0x91, 0x75, 0xDD, 0xD5, 0x52, 0x2D, 0x52, 0x7D, 0xA7, 0x9D, 0x6B, 0x3E, 0xA0, 0xD9, 0x64, 0x08, 0xED, 0xC9, 0xC4, 0xA3, 0x4A, 0x4E, 0xE0, 0xBA, 0x96, 0x20, 0x93, 0xF5, 0x2F, 0x2E, 0x5F, 0x58, 0xFB, 0x84, 0x83, 0x31, 0xF0, 0x77, 0x61, 0x22, 0x34, 0x3A, 0x0C, 0x93, 0x0E, 0x20, 0xFE, 0x2A, 0xBB, 0x51, 0xA8, 0x17, 0xCA, 0x40, 0x77, 0xA2, 0x99, 0x19, 0x77, 
			0xBB, 0xAD, 0x82, 0x70, 0xE3, 0xCA, 0x5C, 0xC1, 0xF3, 0xF3, 0x3E, 0x6F, 0x77, 0xF9, 0x0B, 0x30, 0xDF, 0xAD, 0x2E, 0x8F, 0x7B, 0xF9, 0x8D, 0x76, 0xBF, 0xDA, 0x2A, 0x36, 0x59, 0x55, 0x43, 0x4F, 0xEC, 0xE5, 0xB6, 0x95, 0x10, 0xFB, 0xDC, 0x74, 0x13, 0xC3, 0x26, 0x8D, 0x24, 0x65, 0xF1, 0x66, 0x07, 0x7B, 0xAD, 0x5D, 0xC6, 0x77, 0xB9, 0x53, 0x15, 0xF2, 0xBE, 0xFD, 0x2E, 0x66, 0xF7, 0x2F, 0xBD, 0x28, 0xBB, 0x2E, 0x32, 0x8D, 0x72, 0xE9, 0x19, 0x74, 0x79, 0x0D, 0xBE, 0xFF, 0xBA, 0x57, 0xF0, 0x89, 0xE4, 0x27, 0x23, 0x47, 0x46, 0x1A, 0x5A, 0x27, 0xFB, 0x17, 0xF7, 0x24, 0xA4, 0x0E, 0xFD, 0xEC, 0x44, 0xA0, 
			0x37, 0x26, 0xF7, 0xD2, 0x6B, 0xE8, 0xD8, 0x3C, 0xBB, 0x8F, 0x61, 0x87, 0x7D, 0xFF, 0x3A, 0x6F, 0x7F, 0x53, 0x03, 0x2A, 0x11, 0xFA, 0xDC };

		[Test]
		public void EmptyCrl ()
		{
			// bug #75406
			// http://bugzilla.ximian.com/show_bug.cgi?id=75406
			X509Crl crl = new X509Crl (emptyCrl);
			Assert.AreEqual (0, crl.Entries.Count, "Count");
		}
	}
}
