//
// System.Web.UI.WebControls.TreeViewTest.cs
//	- Unit tests for System.Web.UI.Webcontrols.TreeView
// 
//
// Authors:
//	Chris Toshok (toshok@ximian.com)
//
// (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//

#if NET_2_0
using System;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;

using NUnit.Framework;

namespace MonoTests.System.Web.UI.WebControls {
	public class TreeViewPoker : TreeView {
	}

	[TestFixture]
	public class TreeViewTest {

		[Test]
		public void Defaults ()
		{
			TreeViewPoker p = new TreeViewPoker ();

			Assert.AreEqual ("Collapse {0}", p.CollapseImageToolTip, "A1");
			Assert.IsTrue (p.AutoGenerateDataBindings, "A2");
			Assert.AreEqual ("", p.CollapseImageUrl, "A3");
			Assert.IsNotNull (p.DataBindings, "A4");
			Assert.AreEqual (0, p.DataBindings.Count, "A4.1");
			Assert.IsTrue (p.EnableClientScript, "A5");
			Assert.AreEqual (-1, p.ExpandDepth, "A6");
			Assert.AreEqual ("Expand {0}", p.ExpandImageToolTip, "A7");
			Assert.AreEqual ("", p.ExpandImageUrl, "A8");
			Assert.IsNotNull (p.HoverNodeStyle, "A9");
			Assert.AreEqual (TreeViewImageSet.Custom, p.ImageSet, "A10");
			Assert.IsNotNull (p.LeafNodeStyle, "A11");
			Assert.IsNotNull (p.LevelStyles, "A12");
			Assert.AreEqual (0, p.LevelStyles.Count, "A12.1");
			Assert.AreEqual ("", p.LineImagesFolder, "A13");
			Assert.AreEqual (-1, p.MaxDataBindDepth, "A14");
			Assert.AreEqual (20, p.NodeIndent, "A15");
			Assert.IsNotNull (p.Nodes, "A16");
			Assert.AreEqual (0, p.Nodes.Count, "A16.1");
			Assert.IsNotNull (p.NodeStyle, "A17");
			Assert.IsFalse (p.NodeWrap, "A18");
			Assert.AreEqual ("", p.NoExpandImageUrl, "A19");
			Assert.IsNotNull (p.ParentNodeStyle, "A20");
			Assert.AreEqual ('/', p.PathSeparator, "A21");
			Assert.IsTrue (p.PopulateNodesFromClient, "A22");
			Assert.IsNotNull (p.RootNodeStyle, "A23");
			Assert.IsNotNull (p.SelectedNodeStyle, "A24");
			Assert.AreEqual (TreeNodeTypes.None, p.ShowCheckBoxes, "A25");
			Assert.IsTrue (p.ShowExpandCollapse, "A26");
			Assert.AreEqual ("Skip Navigation Links.", p.SkipLinkText, "A27");
			Assert.IsNull (p.SelectedNode, "A28");
			Assert.AreEqual ("", p.SelectedValue, "A29");
			Assert.AreEqual ("", p.Target, "A30");
			Assert.IsTrue (p.Visible, "A31");
		}
	}

}

#endif
