/* Copyright (C) 2005 MySQL AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#ifndef myx_util_h
#define myx_util_h

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
  #define __LCC__
  //#define _WINDOWS
  #define HAVE_UNICODE_PCRE
#endif

// Definition of the character property for a typical MySQL identifier. Since PCRE does not support every
// possible character property there might still be some failures.
// However most cases should be caught be the definition below (any letter [case insensitiv], any number, underscore,
// white spaces [which should only appear in quoted form], connector and dash punctuation [also only meaningfull in
// quoted ids], marks [any form], math/currency/modifier symbols). Anything not being a letter or number should only
// appear in quoted form.
#ifdef HAVE_UNICODE_PCRE
  #define UNICODE_CHAR_PCRE "\\pL|\\pN|\\pM|\\p{Pc}|\\p{Pd}|_|:"
  #define UNICODE_ID_PCRE "(?:(?:\\pL|_|\\pN)(?:" UNICODE_CHAR_PCRE ")*)"
  #define UNICODE_ID_PCRE_AND_WHITESPACE "(?:(?:\\pL|_|\\pN)(?:\\p{Zs}|" UNICODE_CHAR_PCRE ")*)"
#else
  #define UNICODE_CHAR_PCRE "\\w|_"
  #define UNICODE_ID_PCRE "(?:(?:\\w|_)(?:" UNICODE_CHAR_PCRE ")*)"
  #define UNICODE_ID_PCRE_AND_WHITESPACE "(?:(?:\\w|_)(?: |" UNICODE_CHAR_PCRE ")*)"
#endif
#define IDENTIFIER_PCRE "`" UNICODE_ID_PCRE_AND_WHITESPACE "`|\"" UNICODE_ID_PCRE_AND_WHITESPACE "\"|" UNICODE_ID_PCRE
#define IDENTIFIER_IGNORE_PCRE "(?:" IDENTIFIER_PCRE ")"
#define QUALIFIED_IDENTIFIER_PCRE "(?:(" IDENTIFIER_PCRE ")\\.)?(" IDENTIFIER_PCRE ")"
#define QUALIFIED_IDENTIFIER_IGNORE_PCRE "(?:(?:" IDENTIFIER_PCRE ")\\.)?(?:" IDENTIFIER_PCRE ")"

#include "myx_util_public_interface.h"
#include "myx_util_functions.h"
#include "myx_shared_util_functions.h"

/*
 * Enums
 */


/*
 * Structs
 */


/*
 * Functions
 */

#endif

