/*
	Description: start-up dialog

	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qsettings.h>
#include "common.h"
#include "rangeselectimpl.h"

using namespace QGit;

RangeSelectImpl::RangeSelectImpl(QString& args, const QStringList& tl, QWidget *p,
                                 QString& opt, bool* q) : RangeSelectBase(p, 0, true) {
	quit = q;
	*quit = true; // if user press ESC everything works as expected
	output = &args;
	options = &opt;
	QStringList tmp1(tl), tmp2; // tl is unsorted
	tmp1.sort();
	loopList(it, tmp1)
		tmp2.prepend(*it);

	comboBoxTo->insertStringList(tmp2);
	comboBoxTo->insertItem("HEAD", 0);
	comboBoxFrom->insertStringList(tmp2);
	comboBoxFrom->setFocus();
	lineEditOptions->setText(opt);

	int f = flags();
	checkBoxDiffCache->setChecked(f & DIFF_INDEX_F);
	checkBoxShowAll->setChecked(f & ALL_BRANCHES_F);
	checkBoxShowWholeHistory->setChecked(f & WHOLE_HISTORY_F);
	checkBoxShowDialog->setChecked(f & RANGE_SELECT_F);
}

void RangeSelectImpl::pushButtonOk_clicked() {

	if (comboBoxFrom->currentText().isEmpty())
		*output = comboBoxTo->currentText();
	else {
		*output = comboBoxFrom->currentText();
		output->append("..");
		output->append(comboBoxTo->currentText());
	}
	*options = lineEditOptions->text();
	output->prepend(*options + " ");
	*output = output->stripWhiteSpace();
	*quit = false;
	close();
}

void RangeSelectImpl::checkBoxShowAll_toggled(bool b) {

	QString opt = lineEditOptions->text();
	if (b) {
		if (!opt.contains("--all"))
			opt = opt.append(" --all").stripWhiteSpace();
	} else
		opt = opt.remove("--all").stripWhiteSpace();

	lineEditOptions->setText(opt);
	setFlag(ALL_BRANCHES_F, opt.contains("--all"));
}

void RangeSelectImpl::checkBoxShowWholeHistory_toggled(bool b) {

	if (b) {
		fromTmp = comboBoxFrom->currentText();
		toTmp = comboBoxTo->currentText();
		comboBoxFrom->setCurrentText("");
		comboBoxTo->setCurrentText("HEAD");
		comboBoxFrom->setEnabled(false);
		comboBoxTo->setEnabled(false);
	} else {
		comboBoxFrom->setCurrentText(fromTmp);
		comboBoxTo->setCurrentText(toTmp);
		comboBoxFrom->setEnabled(true);
		comboBoxTo->setEnabled(true);
	}
	setFlag(WHOLE_HISTORY_F, b);
}

void RangeSelectImpl::checkBoxDiffCache_toggled(bool b) {

	setFlag(DIFF_INDEX_F, b);
}

void RangeSelectImpl::checkBoxShowDialog_toggled(bool b) {

	setFlag(RANGE_SELECT_F, b);
}
