/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void htaccess(const char *name)
{
   char htname[MAXLEN];
   FILE *fp_auth;
   int i;

   if(!UserAuthentication)
      return;

   sprintf(htname,"%s/%s/.htaccess",dirname,name);
   if((fp_auth=fopen(htname,"w"))==NULL) {
      fprintf(stderr, "SARG: (auth) %s: %s - %s\n",text[45],htname,strerror(errno));
      exit(1);
   }

   fprintf(fp_auth,"AuthUserFile %s\n",AuthUserFile);
   if(strchr(AuthName,'\"') == 0)
      fprintf(fp_auth,"AuthName \"%s\"\n",AuthName);
   else
      fprintf(fp_auth,"AuthName %s\n",AuthName);
   fprintf(fp_auth,"AuthType %s\n",AuthType);
   fputs("<Limit GET POST>\nRequire ",fp_auth);
   for (i=0 ; Require[i] ; i++)
      if (Require[i]=='%' && Require[i+1]=='u') {
         fputs(name,fp_auth);
         i++;
      } else {
         fputc(Require[i],fp_auth);
   }
   fputs("\n</LIMIT>\n",fp_auth);

   fclose(fp_auth);

   return;
}
