import interface
import xml.dom.minidom

import form_gtk
import tree_gtk

from form import ViewForm
from list import ViewList

parsers = {
	'form': form_gtk.parser_form,
	'tree': tree_gtk.parser_tree,
}


parsers2 = {
	'form': ViewForm,
	'tree': ViewList
}

class widget_parse(interface.parser_interface):
	def parse(self, screen, root_node, fields):
		widget = None
		for node in root_node.childNodes:
			if not node.nodeType == node.ELEMENT_NODE:
				continue
			if node.localName in parsers:
				widget = parsers[node.localName](self.window, self.parent, self.attrs)
				wid, child, buttons, on_write = widget.parse(screen.resource, node, fields)
				screen.set_on_write(on_write)
				res = parsers2[node.localName](screen, wid, child, buttons)
				res.title = widget.title
				return res
			else:
				pass
		return widget

