<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Relay Configuration Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.es">Principal</a>
<a href="../overview.html.es">Perspectiva</a>
<a href="../download.html.es">Descarga</a>
<a href="../documentation.html.es">Documentación</a>
<a href="../volunteer.html.es">Colabora</a>
<a href="../people.html.es">Gente</a>
<a href="https://blog.torproject.org/">Blog</a>
<a href="../donate.html.es">¡Dona!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Configurar un servidor Tor</h1>
<!-- BEGIN SIDEBAR -->
<div class="sidebar-left">
<h3>Pasos de configuración</h3>
<ol>
<li><a href="../docs/tor-doc-relay.html.es#install">Descarga e instalación</a></li>
<li><a href="../docs/tor-doc-relay.html.es#setup">Configuración</a></li>
<li><a href="../docs/tor-doc-relay.html.es#check">Check & Confirmar</a></li>
<li><a href="../docs/tor-doc-relay.html.es#after">Pasos finales</a></li>
</ol>
</div>
<!-- END SIDEBAR -->
<hr>
<p>
La red Tor se apoya en voluntarios que donen ancho de banda. Cuanta más
gente ejecute repetidores, más rápida será la red Tor ser. Si tiene al menos
20 kilobytes / s bidireccional, por favor ayuda a Tor configurando su Tor
para que sea repetidor también. Tenemos muchas características que hacen los
repetidores Tor fáciles y convenientes, incluyendo la <a href="../faq.html
RelayFlexible">limitación del ancho de banda, políticas de salida para que
pueda limitar su exposición a quejas de abuso, y soporte para direcciones IP
dinámicas</a>.
</p>
<p>Se puede ejecutar un repetidor Tor en <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayOS">casi
cualquier</a>sistema operativo. Los repetidores Tor funcionan mejor en
Linux, OS X Tiger o posterior, 5.x + FreeBSD, NetBSD 5.x +, y Windows Server
2003 o posterior.
</p>
<hr> <a id="zero"></a> <a id="install"></a>
<h2><a class="anchor" href="#install">Paso Uno: Descargar e Instalar Tor</a></h2>
<br>
<p>Antes de empezar, es necesario asegurarse de que Tor está activo y
ejecutándose.
</p>
<p>Visite nuestro <a href="../easy-download.html.es">página de descarga</a> e
instalar el "paquete de instalación" para su sistema operativo.
</p>
<p>Si es oportuno, también podría utilizar como un cliente por un tiempo para
asegurarse de que realmente funciona.</p>
<hr> <a id="setup"></a>
<h2><a class="anchor" href="#setup">Paso Dos: Configurarlo como repetidor</a></h2>
<br>
<ol>
<li>Verifique que su reloj y la zona horaria están configurados
correctamente. Si es posible, sincronice su reloj con <a público
href="http://en.wikipedia.org/wiki/Network_Time_Protocol">servidores de
tiempo</a>.
</li>
<li><strong>Configuración de Tor con la interfaz gráfica de Vidalia</strong>:
<ol>
<li>
	<dt>Haga clic derecho sobre el icono de Vidalia en la barra de tareas. Elija
<tt>Panel de control</tt>.</dt>
	<dd><img alt="vidalia right click menu"
src="../img/screenshot-win32-vidalia.png" width="132" height="252"></dd>
</li>
<li>Haga clic en <tt>Configuración de la retransmisión</tt>.</li>
<li>
	<dt>Elija <tt>tráfico para la red Tor</tt> si desea que sea un repetidor público
(recomendado), o elegir <tt> Ayuda censurado llegar a los usuarios de la
red Tor</tt> si desea una <a href="../faq.html#RelayOrBridge">puente</a> para
los usuarios en los países que censuran la Internet.</dt>
<dd><img alt="vidalia basic settings"
src="../img/screenshot-win32-configure-relay-1.png" width="624" height="558"></dd>
</li>
<li>Introduzca un alias para su servidor, y escriba la información de contacto
en caso de que necesitemos comunicarnos con usted acerca de los problemas.</li>
<li>Deja <tt>Intenta configurar automáticamente el reenvío de
puertos</tt>clic. Empuje el <tt>Test</tt> botón para ver si funciona. Si
funciona, estupendo. Si no, véase el número 3.</li>
<li><dt>Elija el <tt>límites de ancho de banda</tt> ficha. Seleccione la cantidad de
ancho de banda que desea proporcionar a los usuarios de Tor como tú.</dt>
<dd><img alt="vidalia bandwidth limits"
src="../img/screenshot-win32-configure-relay-2.png" width="622" height="562"></dd>
</li>
<li><dt>Elija el <tt>políticas de salida</tt> ficha. Si desea permitir que otros
utilicen su servidor para estos servicios, no cambia nada. Elimina la marca
de los servicios que usted no quiere permitir a la gente a la <a href="../faq.html#ExitPolicies"> alcance de su servidor </a>. Si usted desea ser un
no-relé de salida, elimina la marca de todos los servicios.</dt>
<dd><img alt="vidalia exit policies"
src="../img/screenshot-win32-configure-relay-3.png" width="624" height="560"></dd>
</li>
<li>Haga clic en el <tt>Ok</tt> botón. Vea el Paso Tres por debajo de la
confirmación de que el relé está funcionando correctamente.</li>
</ol>
<br> <strong>Manual de configuración</strong>:
<ul>
<li>Modificar la parte inferior de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">su
fichero torrc</a>. Si usted desea ser un relé público (recomendado),
asegúrese de definir ORPort y <a href="../faq.html#ExitPolicies">ver
ExitPolicy</a>, de lo contrario, si usted desea ser un <a href="../faq.html#RelayOrBridge">puente</a> para los usuarios en los países que censuran
la Internet, sólo tiene que utilizar <a href="../bridges.html.es#RunningABridge">estas líneas</a>.
</li>
</ul></li>
<li>Si usted está usando un cortafuegos, abra un agujero en el cortafuegos para
que las conexiones entrantes puedan alcanzar los puertos que ha configurado
(ORPort, más DirPort si lo ha activado). Si usted tiene un firewall de
hardware (cuadro de Linksys, cablemodem, etc) que te gustaría <a
href="http://portforward.com/">portforward.com</a>. También, asegúrese de
que todos los <em>saliente</em> demasiadas conexiones, por lo que su
repetidor pueda llegar a los otros repetidores Tor.
</li>
<li>Rearranque su repetidor. Si <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">log
aparecen advertencias</a>, la dirección de ellos.
</li>
<li>Suscribirse a la <a
href="http://archives.seul.org/or/announce/">or-announce</a> lista de
correo. Es muy poco tráfico, y le mantendrá informado de nuevas versiones
estables. También puede considerar subscribirse a la <a href="../documentation.html.es#MailingLists">el mayor volumen de las listas de Tor</a>
también.
</li>
</ol>
<hr> <a id="check"></a>
<h2><a class="anchor" href="#check">Paso Tres: Asegurarse de que funciona</a></h2>
<br>
<p>En cuanto su repetidor consiga conectarse a la red, intentará determinar si
los puertos que configuró son accesibles desde el exterior. Este paso suele
ser rápido, pero puede tardar hasta 20 minutos. Busque un <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">registro
de entrada</a> como <tt>Autoevaluación indica su ORPort es accesible desde
el exterior. Excelente.</tt> Si no ve este mensaje, significa que su
servidor no es accesible desde el exterior &mdash; debería re-revisar sus
cortafuegos, comprobar que esté comprobando la IP y el puerto que usted crea
que debería estar comprobando, etc.
</p>
<p>When it decides that it's reachable, it will upload a "server descriptor" to
the directories, to let clients know what address, ports, keys, etc your
relay is using. You can <a
href="http://194.109.206.212/tor/status-vote/current/consensus">load one of
the network statuses manually</a> and look through it to find the nickname
you configured, to make sure it's there. You may need to wait up to one hour
to give enough time for it to make a fresh directory.</p>
<hr> <a id="after"></a>
<h2><a class="anchor" href="#after">Cuarto paso: Una vez que se está
trabajando</a></h2>
<br>
<p>
Nosotros recomendamos los siguientes pasos, así:
</p>
<p>
6. Leer <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/OperationalSecurity">sobre
seguridad operacional</a> para obtener ideas de cómo aumentar la seguridad
de su repetidor.
</p>
<p>
7. Si quiere ejecutar más de un repetidor estupendo, pero por favor active
<a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#MultipleRelays">la
opción MyFamily</a> en todos sus repetidores archivos de configuración.
</p>
<p>
8. Decidir acerca de la limitación de velocidad. El módem de cable, DSL, y
otros usuarios que tienen ancho de banda asimétrico (por ejemplo, más que de
subida) deberían limitar la velocidad a su ancho de banda más lento, para
evitar la congestión. Ver la <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">limitación
de velocidad de la FAQ</a> para más detalles.
</p>
<p>
9. Copias de seguridad de la clave privada de su servidor Tor (almacenada en
"keys/secret_id_key" en su DataDirectory). Esto es "de su repetidor de
identidad", y que necesita para mantener a salvo para que nadie pueda leer
el tráfico que pasa a través de su repetidor. Este es el fichero crítico a
guardar si necesita <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#UpgradeRelay">mover
o restaurar su servidor Tor</a> si algo va mal.
</p>
<p>
10. Si controla los servidores de nombres para su dominio, considere llamar
a su host 'anonymous-relay', 'proxy' o 'tor-proxy', para que cuando otra
gente vea la dirección en sus web logs, entiendan más rápido lo que está
pasando. Adición de la <a
href="http://gitweb.torproject.org/tor.git?a=blob_plain;hb=HEAD;f=contrib/tor-salida-notice.html">aviso de salida de Tor</a> en
un vhost para este nombre puede ir un largo camino para disuadir a las
denuncias de abuso a usted y su proveedor de Internet si usted está
ejecutando un nodo de salida.
</p>
<p>
11. Si su equipo no está ejecutando un servidor web, por favor considere
cambiar su ORPort a 443 y su DirPort el 80. Muchos usuarios de Tor están
atrapados detrás de cortafuegos que sólo les permiten ver la web, y este
cambio les permitirá acceder a su servidor Tor. Los repetidores en Win32
pueden simplemente cambiar su ORPort y DirPort directamente en su torrc y
reiniciar Tor. Repetidores OS X y Unix servers no pueden escuchar
directamente en esos puertos (ya que no se ejecutan como root), por lo que
tendrán que establecer algún tipo de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">reenvío
de puertos </a> para que las conexiones puedan acceder a su servidor Tor. Si
usted está usando los puertos 80 y 443 pero todavía quiere ayudar, otros
puertos útiles son el 22, 110 y 143.
</p>
<p>
12. Si su servidor Tor da otros servicios en la misma dirección IP - como un
servidor web público - asegúrese de que las conexiones al servidor web se
permiten desde el host local también. Necesitará permitir estas conexiones
porque los clientes Tor detectarán que su repetidor Tor es la <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ExitEavesdroppers">manera
más segura de llegar a ese servidor web</a>, y siempre construirán un
circuito que termine en su relevo. Si usted no quiere permitir las
conexiones, debe rechazarlas explícitamente en su política de salida.
</p>
<p>
13. (Sólo Unix). Cree un usuario separado para ejecutar el repetidor. Si
instaló el paquete OS X o el deb o el rpm, ya está hecho. De lo contrario,
usted puede hacerlo a mano. (El repetidor Tor no necesita ejecutarse como
root, así que es buena práctica no ejecutarlo como root. Ejecuta como el
usuario 'tor' evita problemas con identd y otros servicios que detectan el
nombre de usuario. Si usted es el paranoico tipo, no dude en <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorInChroot">poner
Tor en una cárcel chroot</a>.)
</p>
<p>
14. (Sólo Unix.) Su sistema operativo probablemente limita el número de
descriptores de fichero abiertos por proceso a 1024 (o incluso menos). Si
planea ejecutar un nodo de salida rápido, probablemente no sea
suficiente. En Linux, debería añadir una línea como "toruser hard nofile
8192" a su archivo / etc / security / limits.conf (donde toruser es el
usuario que ejecuta el proceso Tor), y reiniciar Tor si se instaló como
paquete (o cerrar la sesión y vuelva a entrar si lo ejecuta directamente).
</p>
<p>
15. Si instaló Tor usando algún paquete o instalador, probablemente ejecute
Tor automáticamente al arrancar. Pero si lo instaló desde las fuentes, puede
encontrar los scripts de arranque en contrib/tor.sh o contrib/torctl útiles.
</p>
<p>
Cuando cambie su configuración Tor, recuerde verificar que su repetidor
todavía funciona correctamente tras el cambio. Asegúrese de configurar su
línea "ContactInfo" en el torrc para que podamos contactar con usted si
necesita actualizarse o algo va mal. Si tiene problemas o preguntas,
consulte la <a href="../documentation.html.es#Support">Support</a> o <a
href="../contact.html.es">contacto</a> en el tor-ops lista. Gracias por ayudar a
hacer crecer la red Tor!
</p>
<hr>
<p>Si tiene sugerencias para mejorar este documento, por favor <a href="../contact.html.es">envíanoslas</a>. Gracias!</p>
  </div>
<!-- #main -->
</div>
</div>
  <div class="bottom" id="bottom">
     <p>
     <i><a href="../contact.html.es" class="smalllink">Webmaster</a></i> -
      Última modificación: Thu Apr 15 14:45:16 2010
      -
      Última compilación: Sun May 2 18:40:54 2010
     </p>
<p>"Tor" y el "Logo de la Cebolla" son <a href="../trademark-faq.html.es">
marcas registradas</a> de El Proyecto Tor, S.A.
</p>
     <p>
	Aviso: Esta traducción podría estar obsoleta. La revisión original en inglés es la
      22144 mientras que esta revisión está basada en la
      (unknown).
     </p>
     <p>
	Esta página también está disponible en los siguientes idiomas:
           <a href="tor-doc-relay.html.de">Deutsch</a>, <a href="tor-doc-relay.html.en">English</a>, <a href="tor-doc-relay.html.fr">fran&ccedil;ais</a>, <a href="tor-doc-relay.html.it">Italiano</a>, <a href="tor-doc-relay.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-relay.html.pl">polski</a>, <a href="tor-doc-relay.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-doc-relay.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Cómo establecer <a href="http://www.debian.org/intro/cn#howtoset">el idioma por defecto del documento</a>.
     </p>
<p>Los desarrolladores de Tor no han revisado esta traduccion
en cuanto a exactitud o correcciones. Puede ser obsoleta o erronea.
La pagina oficial de Tor es la version en Ingles, disponible en
<a href="https://www.torproject.org/">https://www.torproject.org/</a>.
</p>
  </div>
</body>
</html>
