/*
   CIPE - encrypted IP over UDP tunneling

   module.c - kernel module interface stuff

   Copyright 1996 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: module.c,v 1.3 1998/10/18 15:38:41 olaf Exp $ */

#include "cipe.h"
#include <linux/module.h>

/* We put this all here so that none of the other source files needs
   to include <linux/module.h>, which could lead to collisions. */

#ifdef LINUX_21
MODULE_AUTHOR("Olaf Titz <olaf@bigred.inka.de>");
MODULE_DESCRIPTION("Encrypting IP-over-UDP tunnel");
MODULE_SUPPORTED_DEVICE(DEVNAME);
MODULE_PARM(cipe_maxdev,"i");
MODULE_PARM_DESC(cipe_maxdev,"Maximum device number supported");
#ifdef DEBUG
MODULE_PARM(cipe_debug,"i");
MODULE_PARM_DESC(cipe_debug,"Debugging level");
#endif
#endif

void cipe_use_module(void)
{
    MOD_INC_USE_COUNT;
}

void cipe_unuse_module(void)
{
    MOD_DEC_USE_COUNT;
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,0,30)
/* older kernel not always exported this */

int bad_user_access_length(void)
{
    panic("bad_user_access_length in " DEVNAME);
}

#endif
