/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <Nws/Toggle.h>
#include <Nws/SButton.h>

static void RemoveCB();
static void SwitchCB();

ToggleGroup * CreateToggleGroup()
{
	ToggleGroup *retp = (ToggleGroup *) XtMalloc(sizeof(ToggleGroup));

	retp->group = NULL;
	retp->num = 0;
	retp->active = -1;
	retp->cb = NULL;
	retp->cbnum = 0;

	return retp;
}

void ToggleAddCallback(gr , proc , data)
ToggleGroup *gr;
ToggleCallbackProc proc;
XtPointer data;
{
	gr->cbnum++;
	gr->cb = (ToggleCallbackList) XtRealloc((XtPointer)gr->cb , 
			sizeof(ToggleCallbackRec) * gr->cbnum);
	gr->cb[gr->cbnum - 1].adata = data;
	gr->cb[gr->cbnum - 1].callback = proc;
}

void ToggleRemoveCallback(gr , proc , data)
ToggleGroup *gr;
ToggleCallbackProc proc;
XtPointer data;
{
	int i;

	for(i = 0; i < gr->cbnum ; i++)
	{
		if (gr->cb[i].adata == data && gr->cb[i].callback == proc)
		{
			gr->cbnum --;
			if (i != gr->cbnum)
				memmove(gr->cb + i , gr->cb + i + 1 , 
					gr->cbnum - i);
		}
	}	
}

Widget ToggleGroupGetActive(gr)
ToggleGroup *gr;
{
	if (gr->active == -1) return NULL;
	else return gr->group[gr->active];
}

void ToggleGroupSetActive(gr , w)
ToggleGroup *gr;
Widget w;
{
	int i,j;

	if (gr->active != -1)
	{
		XtVaSetValues(gr->group[gr->active] , XtNon , False , NULL);
	}

	for(i = 0 ; i < gr->num ; i++)
	{
		if (w == gr->group[i])
		{
			if (i != gr->active)
			{
				for(j = 0 ; j < gr->cbnum ; j++)
				{
					gr->cb[j].callback(gr , 
						gr->group[i] , gr->cb[j].adata);
				}
			}

			gr->active = i;
			XtVaSetValues(gr->group[gr->active] , XtNon , True , NULL);
			return;
		}
	}	
}

void DestroyToggleGroup(gr)
ToggleGroup *gr;
{
	int i;

	for( i = 0; i < gr->num ; i++)
	{
		XtRemoveCallback(gr->group[i] , XtNdestroyCallback , RemoveCB , (XtPointer) gr);
		XtRemoveCallback(gr->group[i] , XtNswitch , SwitchCB , (XtPointer) gr);
	}
	XtFree((XtPointer)gr->group);
	XtFree((XtPointer)gr->cb);
	XtFree((XtPointer)gr);	
}

void AddWidgetToToggleGroup(gr , w)
ToggleGroup *gr;
Widget w;
{
	gr->num++;
	gr->group = (Widget *) XtRealloc((XtPointer) gr->group , sizeof(Widget) * (1 + gr->num));
	gr->group[gr->num - 1] = w;
	XtAddCallback(w , XtNdestroyCallback , RemoveCB , (XtPointer) gr);
	XtAddCallback(w , XtNswitch , SwitchCB , (XtPointer) gr);
}

void RemoveWidgetFromToggleGroup(gr , w)
ToggleGroup *gr;
Widget w;
{
	int i;

	for(i = 0 ; i < gr->num ; i++)
	{
		if (w == gr->group[i])
		{
			if (gr->active == i) gr->active = -1;

			gr->num--;

			XtRemoveCallback(w , XtNdestroyCallback , RemoveCB , (XtPointer) gr);
			XtRemoveCallback(w , XtNswitch , SwitchCB , (XtPointer) gr);

			if (i != gr->num)
				memmove(gr->group + i , gr->group + i + 1 , 
					gr->num - i);

			return;
		}
	}
}

static void RemoveCB(w , client_data , call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ToggleGroup *gr = (ToggleGroup *) client_data;

	RemoveWidgetFromToggleGroup(gr , w);
}

static void SwitchCB(w , client_data , call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int i,j;
	ToggleGroup *gr = (ToggleGroup *) client_data;

	if (gr->active != -1)
	{
		XtVaSetValues(gr->group[gr->active] , XtNon , False , NULL);
	}

	for(i = 0 ; i < gr->num ; i++)
	{
		if (w == gr->group[i])
		{
			if (i != gr->active)
			{
				for(j = 0 ; j < gr->cbnum ; j++)
				{
					gr->cb[j].callback(gr , 
						gr->group[i] , gr->cb[j].adata);
				}
			}

			gr->active = i;
			XtVaSetValues(gr->group[gr->active] , XtNon , True , NULL);
			return;
		}
	}	
}

Widget ToggleGetWidgetByWid(gr , wid)
ToggleGroup *gr;
int wid;
{
	int i,j;

	for(i = 0 ; i < gr->num ; i++)
	{
		XtVaGetValues(gr->group[i] , XtNwid , &j , NULL);
		if (wid == j)
		{
			return 	gr->group[i];
		}
	}
	return NULL;
}