/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * DnsBind.h
 *   Implement the BIND nameserver driver.
 *
 * $Id: DnsBind.h,v 1.5 2001/01/01 20:14:20 rex Exp $
 *
 * Copyright (c) 2000-2001 Remi Lefebvre <remi@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef DNSBIND_H
#define DNSBIND_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>
#include <stdlib.h>
#include <netinet/in.h>

#undef __P
#define __P(args) args

extern "C" {
#include <res_update.h>
}

/* we need to redefine this because ISC apparently doesn't care for C++ */
#undef INIT_LINK
#define INIT_LINK(elt, link) \
	do { \
		(elt)->link.prev = NULL; \
		(elt)->link.next = NULL; \
	} while (0)


#include "Logger.h"
#include "Exception.h"
#include "Db.h"
#include "Dns.h"
#include "global.h"

/**
 * @class DnsBind
 * @brief Class to make Dynamic Name Server updates using the bind nameserver.
 */
class DnsBind : public Dns
{
  public:
    /// Constructor
    DnsBind(Logger *log);

    /// Destructor
    ~DnsBind();

    void addDnsRecord(int id, const char *dname, DnsRecordType type,
                      const char *data);

    void delDnsRecords(char *dname);

    void delDnsRecord(int id, const char *dname, DnsRecordType type,
                      const char *data);
    
    void updateDnsRecord(int id, const char *dname, DnsRecordType type,
                         const char *data);

  private:
    /// update a record of type ns_type
    int updateRecord(ns_sect r_section, const char *dname, const char *data, 
                     int r_opcode, ns_type r_type);

    /// flush the query queue
    int flush();

  protected:
    /// Hidden default constructor
    DnsBind() { };

  private:
    res_state statp;
    ns_updque listupdrec;
    ns_updrec *rrecp_in;
    Logger *log;
};

#endif // DNSBIND_H
