/*
 * libpam-sfs - Pluggable Authentication Module for SFS
 * 
 * Copyright (C) 2000, 2001 Luca Filipozzi
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59 
 * Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 */

#ifndef HANDLER_H
#define HANDLER_H

#include <arpc.h>
#include <sfsmisc.h>
#include <sfsagent.h>

class handler
{
  public:
                        handler();
                        ~handler();
    int                 pam_sm_authenticate(    const char *service,
                                                int         flags,
                                                int         argc,
                                                const char *argv[],
                                                const char *username,
                                                const char *password);

    int                 pam_sm_open_session(    const char *service,
                                                int         flags,
                                                int         argc,
                                                const char *argv[],
                                                const char *username,
                                                int        *lockfilefdp);

    int                 pam_sm_close_session(   const char *service,
                                                int         flags,
                                                int         argc,
                                                const char *argv[],
                                                const char *username,
                                                int         lockfilefd);

  protected:
    bool                ParseOptions(int argc, const char *argv[]);
    bool                IsUsernameValid();
    bool                IsPasswordValid();
    bool                IsHomeInSFS();
    bool                FindServer();

    int                 AuthenticateUser();

    bool                BecomeUser();

    bool                ExecAgent();

    bool                OpenAgentConnection();
    bool                CloseAgentConnection();

    bool                HasKey();
    bool                AddKey();
    bool                KillAgent();

  private:
    const char         *service_;
    int                 flags_;
    const char         *username_;
    const char         *password_;
    char               *hostname_;
    char               *keyname_;
    pid_t               pid_;
    struct passwd      *pw_;
    bool                debug_;

    int                 sfscdfd_;
    ptr<axprt_unix>     sfscdxprt_;
    ptr<aclnt>          sfscdclnt_;
    int                 agentfd_;
    ptr<axprt_stream>   agentxprt_;
    ptr<aclnt>          agentclnt_;
};

#endif // HANDLER_H
