// -*-c++-*-
/* $Id: parseopt.h,v 1.5 2001/01/13 19:46:10 dm Exp $ */

/*
 *
 * Copyright (C) 1998 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#ifndef _ASYNC_PARSEOPT_
#define _ASYNC_PARSEOPT_ 1

#include "vec.h"
#include "str.h"

class parseargs {
  static char *errorbuf;

  char *buf;
  const char *lim;
  const char *p;

  void skipblanks ();
  void skiplwsp ();
  str getarg ();

protected:
  str filename;
  int lineno;

  virtual void error (str);

public:
  parseargs (str file, int fd = -1);
  virtual ~parseargs ();

  bool getline (vec<str> *args, int *linep = NULL);
};

int64_t strtoi64 (const char *nptr, char **endptr = NULL, int base = 0);

template<class T> bool
convertint (const char *cp, T *resp)
{
  if (!*cp)
    return false;
  char *end;
  T res = strtoi64 (cp, &end, 0);
  if (*end)
    return false;
  *resp = res;
  return true;
}

#endif /* !_ASYNC_PARSEOPT_ */
