// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateRepository = "AssociateRepository"

// AssociateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateRepository for more information on using the AssociateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateRepositoryRequest method.
//    req, resp := client.AssociateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/AssociateRepository
func (c *CodeGuruReviewer) AssociateRepositoryRequest(input *AssociateRepositoryInput) (req *request.Request, output *AssociateRepositoryOutput) {
	op := &request.Operation{
		Name:       opAssociateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/associations",
	}

	if input == nil {
		input = &AssociateRepositoryInput{}
	}

	output = &AssociateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateRepository API operation for Amazon CodeGuru Reviewer.
//
// Use to associate an AWS CodeCommit repository or a repostory managed by AWS
// CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a
// repository, CodeGuru Reviewer reviews source code changes in the repository's
// pull requests and provides automatic recommendations. You can view recommendations
// using the CodeGuru Reviewer console. For more information, see Recommendations
// in Amazon CodeGuru Reviewer (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html)
// in the Amazon CodeGuru Reviewer User Guide.
//
// If you associate a CodeCommit repository, it must be in the same AWS Region
// and AWS account where its CodeGuru Reviewer code reviews are configured.
//
// Bitbucket and GitHub Enterprise Server repositories are managed by AWS CodeStar
// Connections to connect to CodeGuru Reviewer. For more information, see Connect
// to a repository source provider (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/reviewer-ug/step-one.html#select-repository-source-provider)
// in the Amazon CodeGuru Reviewer User Guide.
//
// You cannot use the CodeGuru Reviewer SDK or the AWS CLI to associate a GitHub
// repository with Amazon CodeGuru Reviewer. To associate a GitHub repository,
// use the console. For more information, see Getting started with CodeGuru
// Reviewer (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html)
// in the CodeGuru Reviewer User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation AssociateRepository for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/AssociateRepository
func (c *CodeGuruReviewer) AssociateRepository(input *AssociateRepositoryInput) (*AssociateRepositoryOutput, error) {
	req, out := c.AssociateRepositoryRequest(input)
	return out, req.Send()
}

// AssociateRepositoryWithContext is the same as AssociateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) AssociateRepositoryWithContext(ctx aws.Context, input *AssociateRepositoryInput, opts ...request.Option) (*AssociateRepositoryOutput, error) {
	req, out := c.AssociateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCodeReview = "CreateCodeReview"

// CreateCodeReviewRequest generates a "aws/request.Request" representing the
// client's request for the CreateCodeReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCodeReview for more information on using the CreateCodeReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCodeReviewRequest method.
//    req, resp := client.CreateCodeReviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/CreateCodeReview
func (c *CodeGuruReviewer) CreateCodeReviewRequest(input *CreateCodeReviewInput) (req *request.Request, output *CreateCodeReviewOutput) {
	op := &request.Operation{
		Name:       opCreateCodeReview,
		HTTPMethod: "POST",
		HTTPPath:   "/codereviews",
	}

	if input == nil {
		input = &CreateCodeReviewInput{}
	}

	output = &CreateCodeReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCodeReview API operation for Amazon CodeGuru Reviewer.
//
// Use to create a code review with a CodeReviewType (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html)
// of RepositoryAnalysis. This type of code review analyzes all code under a
// specified branch in an associated repository. PullRequest code reviews are
// automatically triggered by a pull request so cannot be created using this
// method.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation CreateCodeReview for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/CreateCodeReview
func (c *CodeGuruReviewer) CreateCodeReview(input *CreateCodeReviewInput) (*CreateCodeReviewOutput, error) {
	req, out := c.CreateCodeReviewRequest(input)
	return out, req.Send()
}

// CreateCodeReviewWithContext is the same as CreateCodeReview with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCodeReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) CreateCodeReviewWithContext(ctx aws.Context, input *CreateCodeReviewInput, opts ...request.Option) (*CreateCodeReviewOutput, error) {
	req, out := c.CreateCodeReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCodeReview = "DescribeCodeReview"

// DescribeCodeReviewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCodeReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCodeReview for more information on using the DescribeCodeReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCodeReviewRequest method.
//    req, resp := client.DescribeCodeReviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeCodeReview
func (c *CodeGuruReviewer) DescribeCodeReviewRequest(input *DescribeCodeReviewInput) (req *request.Request, output *DescribeCodeReviewOutput) {
	op := &request.Operation{
		Name:       opDescribeCodeReview,
		HTTPMethod: "GET",
		HTTPPath:   "/codereviews/{CodeReviewArn}",
	}

	if input == nil {
		input = &DescribeCodeReviewInput{}
	}

	output = &DescribeCodeReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCodeReview API operation for Amazon CodeGuru Reviewer.
//
// Returns the metadata associated with the code review along with its status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation DescribeCodeReview for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeCodeReview
func (c *CodeGuruReviewer) DescribeCodeReview(input *DescribeCodeReviewInput) (*DescribeCodeReviewOutput, error) {
	req, out := c.DescribeCodeReviewRequest(input)
	return out, req.Send()
}

// DescribeCodeReviewWithContext is the same as DescribeCodeReview with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCodeReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) DescribeCodeReviewWithContext(ctx aws.Context, input *DescribeCodeReviewInput, opts ...request.Option) (*DescribeCodeReviewOutput, error) {
	req, out := c.DescribeCodeReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRecommendationFeedback = "DescribeRecommendationFeedback"

// DescribeRecommendationFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecommendationFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecommendationFeedback for more information on using the DescribeRecommendationFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRecommendationFeedbackRequest method.
//    req, resp := client.DescribeRecommendationFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRecommendationFeedback
func (c *CodeGuruReviewer) DescribeRecommendationFeedbackRequest(input *DescribeRecommendationFeedbackInput) (req *request.Request, output *DescribeRecommendationFeedbackOutput) {
	op := &request.Operation{
		Name:       opDescribeRecommendationFeedback,
		HTTPMethod: "GET",
		HTTPPath:   "/feedback/{CodeReviewArn}",
	}

	if input == nil {
		input = &DescribeRecommendationFeedbackInput{}
	}

	output = &DescribeRecommendationFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecommendationFeedback API operation for Amazon CodeGuru Reviewer.
//
// Describes the customer feedback for a CodeGuru Reviewer recommendation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation DescribeRecommendationFeedback for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRecommendationFeedback
func (c *CodeGuruReviewer) DescribeRecommendationFeedback(input *DescribeRecommendationFeedbackInput) (*DescribeRecommendationFeedbackOutput, error) {
	req, out := c.DescribeRecommendationFeedbackRequest(input)
	return out, req.Send()
}

// DescribeRecommendationFeedbackWithContext is the same as DescribeRecommendationFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecommendationFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) DescribeRecommendationFeedbackWithContext(ctx aws.Context, input *DescribeRecommendationFeedbackInput, opts ...request.Option) (*DescribeRecommendationFeedbackOutput, error) {
	req, out := c.DescribeRecommendationFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRepositoryAssociation = "DescribeRepositoryAssociation"

// DescribeRepositoryAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRepositoryAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRepositoryAssociation for more information on using the DescribeRepositoryAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRepositoryAssociationRequest method.
//    req, resp := client.DescribeRepositoryAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRepositoryAssociation
func (c *CodeGuruReviewer) DescribeRepositoryAssociationRequest(input *DescribeRepositoryAssociationInput) (req *request.Request, output *DescribeRepositoryAssociationOutput) {
	op := &request.Operation{
		Name:       opDescribeRepositoryAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/associations/{AssociationArn}",
	}

	if input == nil {
		input = &DescribeRepositoryAssociationInput{}
	}

	output = &DescribeRepositoryAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRepositoryAssociation API operation for Amazon CodeGuru Reviewer.
//
// Returns a RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
// object that contains information about the requested repository association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation DescribeRepositoryAssociation for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRepositoryAssociation
func (c *CodeGuruReviewer) DescribeRepositoryAssociation(input *DescribeRepositoryAssociationInput) (*DescribeRepositoryAssociationOutput, error) {
	req, out := c.DescribeRepositoryAssociationRequest(input)
	return out, req.Send()
}

// DescribeRepositoryAssociationWithContext is the same as DescribeRepositoryAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRepositoryAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) DescribeRepositoryAssociationWithContext(ctx aws.Context, input *DescribeRepositoryAssociationInput, opts ...request.Option) (*DescribeRepositoryAssociationOutput, error) {
	req, out := c.DescribeRepositoryAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateRepository = "DisassociateRepository"

// DisassociateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateRepository for more information on using the DisassociateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateRepositoryRequest method.
//    req, resp := client.DisassociateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DisassociateRepository
func (c *CodeGuruReviewer) DisassociateRepositoryRequest(input *DisassociateRepositoryInput) (req *request.Request, output *DisassociateRepositoryOutput) {
	op := &request.Operation{
		Name:       opDisassociateRepository,
		HTTPMethod: "DELETE",
		HTTPPath:   "/associations/{AssociationArn}",
	}

	if input == nil {
		input = &DisassociateRepositoryInput{}
	}

	output = &DisassociateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateRepository API operation for Amazon CodeGuru Reviewer.
//
// Removes the association between Amazon CodeGuru Reviewer and a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation DisassociateRepository for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DisassociateRepository
func (c *CodeGuruReviewer) DisassociateRepository(input *DisassociateRepositoryInput) (*DisassociateRepositoryOutput, error) {
	req, out := c.DisassociateRepositoryRequest(input)
	return out, req.Send()
}

// DisassociateRepositoryWithContext is the same as DisassociateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) DisassociateRepositoryWithContext(ctx aws.Context, input *DisassociateRepositoryInput, opts ...request.Option) (*DisassociateRepositoryOutput, error) {
	req, out := c.DisassociateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCodeReviews = "ListCodeReviews"

// ListCodeReviewsRequest generates a "aws/request.Request" representing the
// client's request for the ListCodeReviews operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCodeReviews for more information on using the ListCodeReviews
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCodeReviewsRequest method.
//    req, resp := client.ListCodeReviewsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListCodeReviews
func (c *CodeGuruReviewer) ListCodeReviewsRequest(input *ListCodeReviewsInput) (req *request.Request, output *ListCodeReviewsOutput) {
	op := &request.Operation{
		Name:       opListCodeReviews,
		HTTPMethod: "GET",
		HTTPPath:   "/codereviews",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCodeReviewsInput{}
	}

	output = &ListCodeReviewsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCodeReviews API operation for Amazon CodeGuru Reviewer.
//
// Lists all the code reviews that the customer has created in the past 90 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation ListCodeReviews for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListCodeReviews
func (c *CodeGuruReviewer) ListCodeReviews(input *ListCodeReviewsInput) (*ListCodeReviewsOutput, error) {
	req, out := c.ListCodeReviewsRequest(input)
	return out, req.Send()
}

// ListCodeReviewsWithContext is the same as ListCodeReviews with the addition of
// the ability to pass a context and additional request options.
//
// See ListCodeReviews for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListCodeReviewsWithContext(ctx aws.Context, input *ListCodeReviewsInput, opts ...request.Option) (*ListCodeReviewsOutput, error) {
	req, out := c.ListCodeReviewsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCodeReviewsPages iterates over the pages of a ListCodeReviews operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCodeReviews method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCodeReviews operation.
//    pageNum := 0
//    err := client.ListCodeReviewsPages(params,
//        func(page *codegurureviewer.ListCodeReviewsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeGuruReviewer) ListCodeReviewsPages(input *ListCodeReviewsInput, fn func(*ListCodeReviewsOutput, bool) bool) error {
	return c.ListCodeReviewsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCodeReviewsPagesWithContext same as ListCodeReviewsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListCodeReviewsPagesWithContext(ctx aws.Context, input *ListCodeReviewsInput, fn func(*ListCodeReviewsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCodeReviewsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCodeReviewsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCodeReviewsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendationFeedback = "ListRecommendationFeedback"

// ListRecommendationFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendationFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendationFeedback for more information on using the ListRecommendationFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecommendationFeedbackRequest method.
//    req, resp := client.ListRecommendationFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRecommendationFeedback
func (c *CodeGuruReviewer) ListRecommendationFeedbackRequest(input *ListRecommendationFeedbackInput) (req *request.Request, output *ListRecommendationFeedbackOutput) {
	op := &request.Operation{
		Name:       opListRecommendationFeedback,
		HTTPMethod: "GET",
		HTTPPath:   "/feedback/{CodeReviewArn}/RecommendationFeedback",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationFeedbackInput{}
	}

	output = &ListRecommendationFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendationFeedback API operation for Amazon CodeGuru Reviewer.
//
// Returns a list of RecommendationFeedbackSummary (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html)
// objects that contain customer recommendation feedback for all CodeGuru Reviewer
// users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation ListRecommendationFeedback for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRecommendationFeedback
func (c *CodeGuruReviewer) ListRecommendationFeedback(input *ListRecommendationFeedbackInput) (*ListRecommendationFeedbackOutput, error) {
	req, out := c.ListRecommendationFeedbackRequest(input)
	return out, req.Send()
}

// ListRecommendationFeedbackWithContext is the same as ListRecommendationFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendationFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRecommendationFeedbackWithContext(ctx aws.Context, input *ListRecommendationFeedbackInput, opts ...request.Option) (*ListRecommendationFeedbackOutput, error) {
	req, out := c.ListRecommendationFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationFeedbackPages iterates over the pages of a ListRecommendationFeedback operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendationFeedback method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecommendationFeedback operation.
//    pageNum := 0
//    err := client.ListRecommendationFeedbackPages(params,
//        func(page *codegurureviewer.ListRecommendationFeedbackOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeGuruReviewer) ListRecommendationFeedbackPages(input *ListRecommendationFeedbackInput, fn func(*ListRecommendationFeedbackOutput, bool) bool) error {
	return c.ListRecommendationFeedbackPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationFeedbackPagesWithContext same as ListRecommendationFeedbackPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRecommendationFeedbackPagesWithContext(ctx aws.Context, input *ListRecommendationFeedbackInput, fn func(*ListRecommendationFeedbackOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationFeedbackInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationFeedbackRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationFeedbackOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendations = "ListRecommendations"

// ListRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendations for more information on using the ListRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecommendationsRequest method.
//    req, resp := client.ListRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRecommendations
func (c *CodeGuruReviewer) ListRecommendationsRequest(input *ListRecommendationsInput) (req *request.Request, output *ListRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListRecommendations,
		HTTPMethod: "GET",
		HTTPPath:   "/codereviews/{CodeReviewArn}/Recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationsInput{}
	}

	output = &ListRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendations API operation for Amazon CodeGuru Reviewer.
//
// Returns the list of all recommendations for a completed code review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation ListRecommendations for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRecommendations
func (c *CodeGuruReviewer) ListRecommendations(input *ListRecommendationsInput) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	return out, req.Send()
}

// ListRecommendationsWithContext is the same as ListRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRecommendationsWithContext(ctx aws.Context, input *ListRecommendationsInput, opts ...request.Option) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationsPages iterates over the pages of a ListRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecommendations operation.
//    pageNum := 0
//    err := client.ListRecommendationsPages(params,
//        func(page *codegurureviewer.ListRecommendationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeGuruReviewer) ListRecommendationsPages(input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool) error {
	return c.ListRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationsPagesWithContext same as ListRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRecommendationsPagesWithContext(ctx aws.Context, input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRepositoryAssociations = "ListRepositoryAssociations"

// ListRepositoryAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositoryAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositoryAssociations for more information on using the ListRepositoryAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRepositoryAssociationsRequest method.
//    req, resp := client.ListRepositoryAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRepositoryAssociations
func (c *CodeGuruReviewer) ListRepositoryAssociationsRequest(input *ListRepositoryAssociationsInput) (req *request.Request, output *ListRepositoryAssociationsOutput) {
	op := &request.Operation{
		Name:       opListRepositoryAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoryAssociationsInput{}
	}

	output = &ListRepositoryAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositoryAssociations API operation for Amazon CodeGuru Reviewer.
//
// Returns a list of RepositoryAssociationSummary (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html)
// objects that contain summary information about a repository association.
// You can filter the returned list by ProviderType (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType),
// Name (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name),
// State (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State),
// and Owner (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation ListRepositoryAssociations for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRepositoryAssociations
func (c *CodeGuruReviewer) ListRepositoryAssociations(input *ListRepositoryAssociationsInput) (*ListRepositoryAssociationsOutput, error) {
	req, out := c.ListRepositoryAssociationsRequest(input)
	return out, req.Send()
}

// ListRepositoryAssociationsWithContext is the same as ListRepositoryAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositoryAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRepositoryAssociationsWithContext(ctx aws.Context, input *ListRepositoryAssociationsInput, opts ...request.Option) (*ListRepositoryAssociationsOutput, error) {
	req, out := c.ListRepositoryAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoryAssociationsPages iterates over the pages of a ListRepositoryAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositoryAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRepositoryAssociations operation.
//    pageNum := 0
//    err := client.ListRepositoryAssociationsPages(params,
//        func(page *codegurureviewer.ListRepositoryAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeGuruReviewer) ListRepositoryAssociationsPages(input *ListRepositoryAssociationsInput, fn func(*ListRepositoryAssociationsOutput, bool) bool) error {
	return c.ListRepositoryAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoryAssociationsPagesWithContext same as ListRepositoryAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRepositoryAssociationsPagesWithContext(ctx aws.Context, input *ListRepositoryAssociationsInput, fn func(*ListRepositoryAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoryAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoryAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRepositoryAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListTagsForResource
func (c *CodeGuruReviewer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CodeGuru Reviewer.
//
// Returns the list of tags associated with an associated repository resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListTagsForResource
func (c *CodeGuruReviewer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecommendationFeedback = "PutRecommendationFeedback"

// PutRecommendationFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the PutRecommendationFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecommendationFeedback for more information on using the PutRecommendationFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRecommendationFeedbackRequest method.
//    req, resp := client.PutRecommendationFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/PutRecommendationFeedback
func (c *CodeGuruReviewer) PutRecommendationFeedbackRequest(input *PutRecommendationFeedbackInput) (req *request.Request, output *PutRecommendationFeedbackOutput) {
	op := &request.Operation{
		Name:       opPutRecommendationFeedback,
		HTTPMethod: "PUT",
		HTTPPath:   "/feedback",
	}

	if input == nil {
		input = &PutRecommendationFeedbackInput{}
	}

	output = &PutRecommendationFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutRecommendationFeedback API operation for Amazon CodeGuru Reviewer.
//
// Stores customer feedback for a CodeGuru Reviewer recommendation. When this
// API is called again with different reactions the previous feedback is overwritten.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation PutRecommendationFeedback for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/PutRecommendationFeedback
func (c *CodeGuruReviewer) PutRecommendationFeedback(input *PutRecommendationFeedbackInput) (*PutRecommendationFeedbackOutput, error) {
	req, out := c.PutRecommendationFeedbackRequest(input)
	return out, req.Send()
}

// PutRecommendationFeedbackWithContext is the same as PutRecommendationFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecommendationFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) PutRecommendationFeedbackWithContext(ctx aws.Context, input *PutRecommendationFeedbackInput, opts ...request.Option) (*PutRecommendationFeedbackOutput, error) {
	req, out := c.PutRecommendationFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/TagResource
func (c *CodeGuruReviewer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CodeGuru Reviewer.
//
// Adds one or more tags to an associated repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/TagResource
func (c *CodeGuruReviewer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/UntagResource
func (c *CodeGuruReviewer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CodeGuru Reviewer.
//
// Removes a tag from an associated repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * ResourceNotFoundException
//   The resource specified in the request was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/UntagResource
func (c *CodeGuruReviewer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// Amazon CodeGuru Reviewer uses this value to prevent the accidental creation
	// of duplicate repository associations if there are failures and retries.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The repository to associate.
	//
	// Repository is a required field
	Repository *Repository `type:"structure" required:"true"`

	// An array of key-value pairs used to tag an associated repository. A tag is
	// a custom attribute label with two parts:
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case sensitive.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s AssociateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateRepositoryInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Repository != nil {
		if err := s.Repository.Validate(); err != nil {
			invalidParams.AddNested("Repository", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateRepositoryInput) SetClientRequestToken(v string) *AssociateRepositoryInput {
	s.ClientRequestToken = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *AssociateRepositoryInput) SetRepository(v *Repository) *AssociateRepositoryInput {
	s.Repository = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssociateRepositoryInput) SetTags(v map[string]*string) *AssociateRepositoryInput {
	s.Tags = v
	return s
}

type AssociateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository association.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`

	// An array of key-value pairs used to tag an associated repository. A tag is
	// a custom attribute label with two parts:
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case sensitive.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s AssociateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryAssociation sets the RepositoryAssociation field's value.
func (s *AssociateRepositoryOutput) SetRepositoryAssociation(v *RepositoryAssociation) *AssociateRepositoryOutput {
	s.RepositoryAssociation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssociateRepositoryOutput) SetTags(v map[string]*string) *AssociateRepositoryOutput {
	s.Tags = v
	return s
}

// Information about an AWS CodeCommit repository. The CodeCommit repository
// must be in the same AWS Region and AWS account where its CodeGuru Reviewer
// code reviews are configured.
type CodeCommitRepository struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeCommit repository. For more information, see repositoryName
	// (https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName)
	// in the AWS CodeCommit API Reference.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeCommitRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeCommitRepository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeCommitRepository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeCommitRepository"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CodeCommitRepository) SetName(v string) *CodeCommitRepository {
	s.Name = &v
	return s
}

// Information about a code review. A code review belongs to the associated
// repository that contains the reviewed code.
type CodeReview struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// that contains the reviewed source code. You can retrieve associated repository
	// ARNs by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	AssociationArn *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	CodeReviewArn *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the code review was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the code review was last
	// updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The statistics from the code review.
	Metrics *Metrics `type:"structure"`

	// The name of the code review.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub, GitHub
	// Enterprise Server, or Bitbucket repository, this is the username for the
	// account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The type of repository that contains the reviewed code (for example, GitHub
	// or Bitbucket).
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The pull request ID for the code review.
	PullRequestId *string `min:"1" type:"string"`

	// The name of the repository.
	RepositoryName *string `min:"1" type:"string"`

	// The type of the source code for the code review.
	SourceCodeType *SourceCodeType `type:"structure"`

	// The valid code review states are:
	//
	//    * Completed: The code review is complete.
	//
	//    * Pending: The code review started and has not completed or failed.
	//
	//    * Failed: The code review failed.
	//
	//    * Deleting: The code review is being deleted.
	State *string `type:"string" enum:"JobState"`

	// The reason for the state of the code review.
	StateReason *string `type:"string"`

	// The type of code review.
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation
func (s CodeReview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeReview) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *CodeReview) SetAssociationArn(v string) *CodeReview {
	s.AssociationArn = &v
	return s
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *CodeReview) SetCodeReviewArn(v string) *CodeReview {
	s.CodeReviewArn = &v
	return s
}

// SetCreatedTimeStamp sets the CreatedTimeStamp field's value.
func (s *CodeReview) SetCreatedTimeStamp(v time.Time) *CodeReview {
	s.CreatedTimeStamp = &v
	return s
}

// SetLastUpdatedTimeStamp sets the LastUpdatedTimeStamp field's value.
func (s *CodeReview) SetLastUpdatedTimeStamp(v time.Time) *CodeReview {
	s.LastUpdatedTimeStamp = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *CodeReview) SetMetrics(v *Metrics) *CodeReview {
	s.Metrics = v
	return s
}

// SetName sets the Name field's value.
func (s *CodeReview) SetName(v string) *CodeReview {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *CodeReview) SetOwner(v string) *CodeReview {
	s.Owner = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *CodeReview) SetProviderType(v string) *CodeReview {
	s.ProviderType = &v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *CodeReview) SetPullRequestId(v string) *CodeReview {
	s.PullRequestId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CodeReview) SetRepositoryName(v string) *CodeReview {
	s.RepositoryName = &v
	return s
}

// SetSourceCodeType sets the SourceCodeType field's value.
func (s *CodeReview) SetSourceCodeType(v *SourceCodeType) *CodeReview {
	s.SourceCodeType = v
	return s
}

// SetState sets the State field's value.
func (s *CodeReview) SetState(v string) *CodeReview {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CodeReview) SetStateReason(v string) *CodeReview {
	s.StateReason = &v
	return s
}

// SetType sets the Type field's value.
func (s *CodeReview) SetType(v string) *CodeReview {
	s.Type = &v
	return s
}

// Information about the summary of the code review.
type CodeReviewSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	CodeReviewArn *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the code review was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the code review was last
	// updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The statistics from the code review.
	MetricsSummary *MetricsSummary `type:"structure"`

	// The name of the code review.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub, GitHub
	// Enterprise Server, or Bitbucket repository, this is the username for the
	// account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The pull request ID for the code review.
	PullRequestId *string `min:"1" type:"string"`

	// The name of the repository.
	RepositoryName *string `min:"1" type:"string"`

	// The state of the code review.
	//
	// The valid code review states are:
	//
	//    * Completed: The code review is complete.
	//
	//    * Pending: The code review started and has not completed or failed.
	//
	//    * Failed: The code review failed.
	//
	//    * Deleting: The code review is being deleted.
	State *string `type:"string" enum:"JobState"`

	// The type of the code review.
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation
func (s CodeReviewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeReviewSummary) GoString() string {
	return s.String()
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *CodeReviewSummary) SetCodeReviewArn(v string) *CodeReviewSummary {
	s.CodeReviewArn = &v
	return s
}

// SetCreatedTimeStamp sets the CreatedTimeStamp field's value.
func (s *CodeReviewSummary) SetCreatedTimeStamp(v time.Time) *CodeReviewSummary {
	s.CreatedTimeStamp = &v
	return s
}

// SetLastUpdatedTimeStamp sets the LastUpdatedTimeStamp field's value.
func (s *CodeReviewSummary) SetLastUpdatedTimeStamp(v time.Time) *CodeReviewSummary {
	s.LastUpdatedTimeStamp = &v
	return s
}

// SetMetricsSummary sets the MetricsSummary field's value.
func (s *CodeReviewSummary) SetMetricsSummary(v *MetricsSummary) *CodeReviewSummary {
	s.MetricsSummary = v
	return s
}

// SetName sets the Name field's value.
func (s *CodeReviewSummary) SetName(v string) *CodeReviewSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *CodeReviewSummary) SetOwner(v string) *CodeReviewSummary {
	s.Owner = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *CodeReviewSummary) SetProviderType(v string) *CodeReviewSummary {
	s.ProviderType = &v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *CodeReviewSummary) SetPullRequestId(v string) *CodeReviewSummary {
	s.PullRequestId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CodeReviewSummary) SetRepositoryName(v string) *CodeReviewSummary {
	s.RepositoryName = &v
	return s
}

// SetState sets the State field's value.
func (s *CodeReviewSummary) SetState(v string) *CodeReviewSummary {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *CodeReviewSummary) SetType(v string) *CodeReviewSummary {
	s.Type = &v
	return s
}

// The type of a code review. There are two code review types:
//
//    * PullRequest - A code review that is automatically triggered by a pull
//    request on an assocaited repository. Because this type of code review
//    is automatically generated, you cannot specify this code review type using
//    CreateCodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
//
//    * RepositoryAnalysis - A code review that analyzes all code under a specified
//    branch in an associated respository. The assocated repository is specified
//    using its ARN in CreateCodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
type CodeReviewType struct {
	_ struct{} `type:"structure"`

	// A code review that analyzes all code under a specified branch in an associated
	// respository. The assocated repository is specified using its ARN in CreateCodeReview
	// (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
	//
	// RepositoryAnalysis is a required field
	RepositoryAnalysis *RepositoryAnalysis `type:"structure" required:"true"`
}

// String returns the string representation
func (s CodeReviewType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeReviewType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeReviewType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeReviewType"}
	if s.RepositoryAnalysis == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryAnalysis"))
	}
	if s.RepositoryAnalysis != nil {
		if err := s.RepositoryAnalysis.Validate(); err != nil {
			invalidParams.AddNested("RepositoryAnalysis", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryAnalysis sets the RepositoryAnalysis field's value.
func (s *CodeReviewType) SetRepositoryAnalysis(v *RepositoryAnalysis) *CodeReviewType {
	s.RepositoryAnalysis = v
	return s
}

// A type of SourceCodeType (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
// that specifies the commit diff for a pull request on an associated repository.
type CommitDiffSourceCodeType struct {
	_ struct{} `type:"structure"`

	// The SHA of the destination commit used to generate a commit diff.
	DestinationCommit *string `min:"6" type:"string"`

	// The SHA of the source commit used to generate a commit diff.
	SourceCommit *string `min:"6" type:"string"`
}

// String returns the string representation
func (s CommitDiffSourceCodeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommitDiffSourceCodeType) GoString() string {
	return s.String()
}

// SetDestinationCommit sets the DestinationCommit field's value.
func (s *CommitDiffSourceCodeType) SetDestinationCommit(v string) *CommitDiffSourceCodeType {
	s.DestinationCommit = &v
	return s
}

// SetSourceCommit sets the SourceCommit field's value.
func (s *CommitDiffSourceCodeType) SetSourceCommit(v string) *CommitDiffSourceCodeType {
	s.SourceCommit = &v
	return s
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateCodeReviewInput struct {
	_ struct{} `type:"structure"`

	// Amazon CodeGuru Reviewer uses this value to prevent the accidental creation
	// of duplicate code reviews if there are failures and retries.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the code review. The name of each code review in your AWS account
	// must be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object. You can retrieve this ARN by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	//
	// A code review can only be created on an associated repository. This is the
	// ARN of the associated repository.
	//
	// RepositoryAssociationArn is a required field
	RepositoryAssociationArn *string `min:"1" type:"string" required:"true"`

	// The type of code review to create. This is specified using a CodeReviewType
	// (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html)
	// object. You can create a code review only of type RepositoryAnalysis.
	//
	// Type is a required field
	Type *CodeReviewType `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCodeReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCodeReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCodeReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCodeReviewInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RepositoryAssociationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryAssociationArn"))
	}
	if s.RepositoryAssociationArn != nil && len(*s.RepositoryAssociationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryAssociationArn", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateCodeReviewInput) SetClientRequestToken(v string) *CreateCodeReviewInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCodeReviewInput) SetName(v string) *CreateCodeReviewInput {
	s.Name = &v
	return s
}

// SetRepositoryAssociationArn sets the RepositoryAssociationArn field's value.
func (s *CreateCodeReviewInput) SetRepositoryAssociationArn(v string) *CreateCodeReviewInput {
	s.RepositoryAssociationArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateCodeReviewInput) SetType(v *CodeReviewType) *CreateCodeReviewInput {
	s.Type = v
	return s
}

type CreateCodeReviewOutput struct {
	_ struct{} `type:"structure"`

	// Information about a code review. A code review belongs to the associated
	// repository that contains the reviewed code.
	CodeReview *CodeReview `type:"structure"`
}

// String returns the string representation
func (s CreateCodeReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCodeReviewOutput) GoString() string {
	return s.String()
}

// SetCodeReview sets the CodeReview field's value.
func (s *CreateCodeReviewOutput) SetCodeReview(v *CodeReview) *CreateCodeReviewOutput {
	s.CodeReview = v
	return s
}

type DescribeCodeReviewInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	//
	// CodeReviewArn is a required field
	CodeReviewArn *string `location:"uri" locationName:"CodeReviewArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCodeReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCodeReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCodeReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCodeReviewInput"}
	if s.CodeReviewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeReviewArn"))
	}
	if s.CodeReviewArn != nil && len(*s.CodeReviewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeReviewArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *DescribeCodeReviewInput) SetCodeReviewArn(v string) *DescribeCodeReviewInput {
	s.CodeReviewArn = &v
	return s
}

type DescribeCodeReviewOutput struct {
	_ struct{} `type:"structure"`

	// Information about the code review.
	CodeReview *CodeReview `type:"structure"`
}

// String returns the string representation
func (s DescribeCodeReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCodeReviewOutput) GoString() string {
	return s.String()
}

// SetCodeReview sets the CodeReview field's value.
func (s *DescribeCodeReviewOutput) SetCodeReview(v *CodeReview) *DescribeCodeReviewOutput {
	s.CodeReview = v
	return s
}

type DescribeRecommendationFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	//
	// CodeReviewArn is a required field
	CodeReviewArn *string `location:"uri" locationName:"CodeReviewArn" min:"1" type:"string" required:"true"`

	// The recommendation ID that can be used to track the provided recommendations
	// and then to collect the feedback.
	//
	// RecommendationId is a required field
	RecommendationId *string `location:"querystring" locationName:"RecommendationId" min:"1" type:"string" required:"true"`

	// Optional parameter to describe the feedback for a given user. If this is
	// not supplied, it defaults to the user making the request.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserId *string `location:"querystring" locationName:"UserId" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeRecommendationFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecommendationFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecommendationFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecommendationFeedbackInput"}
	if s.CodeReviewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeReviewArn"))
	}
	if s.CodeReviewArn != nil && len(*s.CodeReviewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeReviewArn", 1))
	}
	if s.RecommendationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationId"))
	}
	if s.RecommendationId != nil && len(*s.RecommendationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationId", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *DescribeRecommendationFeedbackInput) SetCodeReviewArn(v string) *DescribeRecommendationFeedbackInput {
	s.CodeReviewArn = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *DescribeRecommendationFeedbackInput) SetRecommendationId(v string) *DescribeRecommendationFeedbackInput {
	s.RecommendationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeRecommendationFeedbackInput) SetUserId(v string) *DescribeRecommendationFeedbackInput {
	s.UserId = &v
	return s
}

type DescribeRecommendationFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// The recommendation feedback given by the user.
	RecommendationFeedback *RecommendationFeedback `type:"structure"`
}

// String returns the string representation
func (s DescribeRecommendationFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecommendationFeedbackOutput) GoString() string {
	return s.String()
}

// SetRecommendationFeedback sets the RecommendationFeedback field's value.
func (s *DescribeRecommendationFeedbackOutput) SetRecommendationFeedback(v *RecommendationFeedback) *DescribeRecommendationFeedbackOutput {
	s.RecommendationFeedback = v
	return s
}

type DescribeRepositoryAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object. You can retrieve this ARN by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	//
	// AssociationArn is a required field
	AssociationArn *string `location:"uri" locationName:"AssociationArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRepositoryAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoryAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRepositoryAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRepositoryAssociationInput"}
	if s.AssociationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationArn"))
	}
	if s.AssociationArn != nil && len(*s.AssociationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *DescribeRepositoryAssociationInput) SetAssociationArn(v string) *DescribeRepositoryAssociationInput {
	s.AssociationArn = &v
	return s
}

type DescribeRepositoryAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository association.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`

	// An array of key-value pairs used to tag an associated repository. A tag is
	// a custom attribute label with two parts:
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case sensitive.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s DescribeRepositoryAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoryAssociationOutput) GoString() string {
	return s.String()
}

// SetRepositoryAssociation sets the RepositoryAssociation field's value.
func (s *DescribeRepositoryAssociationOutput) SetRepositoryAssociation(v *RepositoryAssociation) *DescribeRepositoryAssociationOutput {
	s.RepositoryAssociation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeRepositoryAssociationOutput) SetTags(v map[string]*string) *DescribeRepositoryAssociationOutput {
	s.Tags = v
	return s
}

type DisassociateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object. You can retrieve this ARN by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	//
	// AssociationArn is a required field
	AssociationArn *string `location:"uri" locationName:"AssociationArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateRepositoryInput"}
	if s.AssociationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationArn"))
	}
	if s.AssociationArn != nil && len(*s.AssociationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *DisassociateRepositoryInput) SetAssociationArn(v string) *DisassociateRepositoryInput {
	s.AssociationArn = &v
	return s
}

type DisassociateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the disassociated repository.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`

	// An array of key-value pairs used to tag an associated repository. A tag is
	// a custom attribute label with two parts:
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case sensitive.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s DisassociateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryAssociation sets the RepositoryAssociation field's value.
func (s *DisassociateRepositoryOutput) SetRepositoryAssociation(v *RepositoryAssociation) *DisassociateRepositoryOutput {
	s.RepositoryAssociation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DisassociateRepositoryOutput) SetTags(v map[string]*string) *DisassociateRepositoryOutput {
	s.Tags = v
	return s
}

// The server encountered an internal error and is unable to complete the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCodeReviewsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that are returned per call. The default is
	// 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// List of provider types for filtering that needs to be applied before displaying
	// the result. For example, providerTypes=[GitHub] lists code reviews from GitHub.
	ProviderTypes []*string `location:"querystring" locationName:"ProviderTypes" min:"1" type:"list"`

	// List of repository names for filtering that needs to be applied before displaying
	// the result.
	RepositoryNames []*string `location:"querystring" locationName:"RepositoryNames" min:"1" type:"list"`

	// List of states for filtering that needs to be applied before displaying the
	// result. For example, states=[Pending] lists code reviews in the Pending state.
	//
	// The valid code review states are:
	//
	//    * Completed: The code review is complete.
	//
	//    * Pending: The code review started and has not completed or failed.
	//
	//    * Failed: The code review failed.
	//
	//    * Deleting: The code review is being deleted.
	States []*string `location:"querystring" locationName:"States" min:"1" type:"list"`

	// The type of code reviews to list in the response.
	//
	// Type is a required field
	Type *string `location:"querystring" locationName:"Type" type:"string" required:"true" enum:"Type"`
}

// String returns the string representation
func (s ListCodeReviewsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCodeReviewsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCodeReviewsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCodeReviewsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProviderTypes != nil && len(s.ProviderTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderTypes", 1))
	}
	if s.RepositoryNames != nil && len(s.RepositoryNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryNames", 1))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("States", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCodeReviewsInput) SetMaxResults(v int64) *ListCodeReviewsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCodeReviewsInput) SetNextToken(v string) *ListCodeReviewsInput {
	s.NextToken = &v
	return s
}

// SetProviderTypes sets the ProviderTypes field's value.
func (s *ListCodeReviewsInput) SetProviderTypes(v []*string) *ListCodeReviewsInput {
	s.ProviderTypes = v
	return s
}

// SetRepositoryNames sets the RepositoryNames field's value.
func (s *ListCodeReviewsInput) SetRepositoryNames(v []*string) *ListCodeReviewsInput {
	s.RepositoryNames = v
	return s
}

// SetStates sets the States field's value.
func (s *ListCodeReviewsInput) SetStates(v []*string) *ListCodeReviewsInput {
	s.States = v
	return s
}

// SetType sets the Type field's value.
func (s *ListCodeReviewsInput) SetType(v string) *ListCodeReviewsInput {
	s.Type = &v
	return s
}

type ListCodeReviewsOutput struct {
	_ struct{} `type:"structure"`

	// A list of code reviews that meet the criteria of the request.
	CodeReviewSummaries []*CodeReviewSummary `type:"list"`

	// Pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCodeReviewsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCodeReviewsOutput) GoString() string {
	return s.String()
}

// SetCodeReviewSummaries sets the CodeReviewSummaries field's value.
func (s *ListCodeReviewsOutput) SetCodeReviewSummaries(v []*CodeReviewSummary) *ListCodeReviewsOutput {
	s.CodeReviewSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCodeReviewsOutput) SetNextToken(v string) *ListCodeReviewsOutput {
	s.NextToken = &v
	return s
}

type ListRecommendationFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	//
	// CodeReviewArn is a required field
	CodeReviewArn *string `location:"uri" locationName:"CodeReviewArn" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. The default is
	// 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// Used to query the recommendation feedback for a given recommendation.
	RecommendationIds []*string `location:"querystring" locationName:"RecommendationIds" min:"1" type:"list"`

	// An AWS user's account ID or Amazon Resource Name (ARN). Use this ID to query
	// the recommendation feedback for a code review from that user.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserIds []*string `location:"querystring" locationName:"UserIds" min:"1" type:"list"`
}

// String returns the string representation
func (s ListRecommendationFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationFeedbackInput"}
	if s.CodeReviewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeReviewArn"))
	}
	if s.CodeReviewArn != nil && len(*s.CodeReviewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeReviewArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RecommendationIds != nil && len(s.RecommendationIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationIds", 1))
	}
	if s.UserIds != nil && len(s.UserIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *ListRecommendationFeedbackInput) SetCodeReviewArn(v string) *ListRecommendationFeedbackInput {
	s.CodeReviewArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendationFeedbackInput) SetMaxResults(v int64) *ListRecommendationFeedbackInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationFeedbackInput) SetNextToken(v string) *ListRecommendationFeedbackInput {
	s.NextToken = &v
	return s
}

// SetRecommendationIds sets the RecommendationIds field's value.
func (s *ListRecommendationFeedbackInput) SetRecommendationIds(v []*string) *ListRecommendationFeedbackInput {
	s.RecommendationIds = v
	return s
}

// SetUserIds sets the UserIds field's value.
func (s *ListRecommendationFeedbackInput) SetUserIds(v []*string) *ListRecommendationFeedbackInput {
	s.UserIds = v
	return s
}

type ListRecommendationFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `min:"1" type:"string"`

	// Recommendation feedback summaries corresponding to the code review ARN.
	RecommendationFeedbackSummaries []*RecommendationFeedbackSummary `type:"list"`
}

// String returns the string representation
func (s ListRecommendationFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationFeedbackOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationFeedbackOutput) SetNextToken(v string) *ListRecommendationFeedbackOutput {
	s.NextToken = &v
	return s
}

// SetRecommendationFeedbackSummaries sets the RecommendationFeedbackSummaries field's value.
func (s *ListRecommendationFeedbackOutput) SetRecommendationFeedbackSummaries(v []*RecommendationFeedbackSummary) *ListRecommendationFeedbackOutput {
	s.RecommendationFeedbackSummaries = v
	return s
}

type ListRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	//
	// CodeReviewArn is a required field
	CodeReviewArn *string `location:"uri" locationName:"CodeReviewArn" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. The default is
	// 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationsInput"}
	if s.CodeReviewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeReviewArn"))
	}
	if s.CodeReviewArn != nil && len(*s.CodeReviewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeReviewArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *ListRecommendationsInput) SetCodeReviewArn(v string) *ListRecommendationsInput {
	s.CodeReviewArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendationsInput) SetMaxResults(v int64) *ListRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsInput) SetNextToken(v string) *ListRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `min:"1" type:"string"`

	// List of recommendations for the requested code review.
	RecommendationSummaries []*RecommendationSummary `type:"list"`
}

// String returns the string representation
func (s ListRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsOutput) SetNextToken(v string) *ListRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendationSummaries sets the RecommendationSummaries field's value.
func (s *ListRecommendationsOutput) SetRecommendationSummaries(v []*RecommendationSummary) *ListRecommendationsOutput {
	s.RecommendationSummaries = v
	return s
}

type ListRepositoryAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository association results returned by ListRepositoryAssociations
	// in paginated output. When this parameter is used, ListRepositoryAssociations
	// only returns maxResults results in a single page with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListRepositoryAssociations request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter is not used, ListRepositoryAssociations
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// List of repository names to use as a filter.
	Names []*string `location:"querystring" locationName:"Name" min:"1" type:"list"`

	// The nextToken value returned from a previous paginated ListRepositoryAssociations
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	//
	// Treat this token as an opaque identifier that is only used to retrieve the
	// next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// List of owners to use as a filter. For AWS CodeCommit, it is the name of
	// the CodeCommit account that was used to associate the repository. For other
	// repository source providers, such as Bitbucket and GitHub Enterprise Server,
	// this is name of the account that was used to associate the repository.
	Owners []*string `location:"querystring" locationName:"Owner" min:"1" type:"list"`

	// List of provider types to use as a filter.
	ProviderTypes []*string `location:"querystring" locationName:"ProviderType" min:"1" type:"list"`

	// List of repository association states to use as a filter.
	//
	// The valid repository association states are:
	//
	//    * Associated: The repository association is complete.
	//
	//    * Associating: CodeGuru Reviewer is: Setting up pull request notifications.
	//    This is required for pull requests to trigger a CodeGuru Reviewer review.
	//    If your repository ProviderType is GitHub, GitHub Enterprise Server, or
	//    Bitbucket, CodeGuru Reviewer creates webhooks in your repository to trigger
	//    CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code
	//    in your repository cannot be triggered. Setting up source code access.
	//    This is required for CodeGuru Reviewer to securely clone code in your
	//    repository.
	//
	//    * Failed: The repository failed to associate or disassociate.
	//
	//    * Disassociating: CodeGuru Reviewer is removing the repository's pull
	//    request notifications and source code access.
	//
	//    * Disassociated: CodeGuru Reviewer successfully disassociated the repository.
	//    You can create a new association with this repository if you want to review
	//    source code in it later. You can control access to code reviews created
	//    in an associated repository with tags after it has been disassociated.
	//    For more information, see Using tags to control access to associated repositories
	//    (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html)
	//    in the Amazon CodeGuru Reviewer User Guide.
	States []*string `location:"querystring" locationName:"State" min:"1" type:"list"`
}

// String returns the string representation
func (s ListRepositoryAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoryAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoryAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositoryAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Owners != nil && len(s.Owners) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Owners", 1))
	}
	if s.ProviderTypes != nil && len(s.ProviderTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderTypes", 1))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("States", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRepositoryAssociationsInput) SetMaxResults(v int64) *ListRepositoryAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ListRepositoryAssociationsInput) SetNames(v []*string) *ListRepositoryAssociationsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoryAssociationsInput) SetNextToken(v string) *ListRepositoryAssociationsInput {
	s.NextToken = &v
	return s
}

// SetOwners sets the Owners field's value.
func (s *ListRepositoryAssociationsInput) SetOwners(v []*string) *ListRepositoryAssociationsInput {
	s.Owners = v
	return s
}

// SetProviderTypes sets the ProviderTypes field's value.
func (s *ListRepositoryAssociationsInput) SetProviderTypes(v []*string) *ListRepositoryAssociationsInput {
	s.ProviderTypes = v
	return s
}

// SetStates sets the States field's value.
func (s *ListRepositoryAssociationsInput) SetStates(v []*string) *ListRepositoryAssociationsInput {
	s.States = v
	return s
}

type ListRepositoryAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListRecommendations request. When
	// the results of a ListRecommendations request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// A list of repository associations that meet the criteria of the request.
	RepositoryAssociationSummaries []*RepositoryAssociationSummary `type:"list"`
}

// String returns the string representation
func (s ListRepositoryAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoryAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoryAssociationsOutput) SetNextToken(v string) *ListRepositoryAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetRepositoryAssociationSummaries sets the RepositoryAssociationSummaries field's value.
func (s *ListRepositoryAssociationsOutput) SetRepositoryAssociationSummaries(v []*RepositoryAssociationSummary) *ListRepositoryAssociationsOutput {
	s.RepositoryAssociationSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object. You can retrieve this ARN by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs used to tag an associated repository. A tag is
	// a custom attribute label with two parts:
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case sensitive.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about the statistics from the code review.
type Metrics struct {
	_ struct{} `type:"structure"`

	// Total number of recommendations found in the code review.
	FindingsCount *int64 `type:"long"`

	// Lines of code metered in the code review. For the initial code review pull
	// request and all subsequent revisions, this includes all lines of code in
	// the files added to the pull request. In subsequent revisions, for files that
	// already existed in the pull request, this includes only the changed lines
	// of code. In both cases, this does not include non-code lines such as comments
	// and import statements. For example, if you submit a pull request containing
	// 5 files, each with 500 lines of code, and in a subsequent revision you added
	// a new file with 200 lines of code, and also modified a total of 25 lines
	// across the initial 5 files, MeteredLinesOfCodeCount includes the first 5
	// files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed
	// lines of code for a total of 2,725 lines of code.
	MeteredLinesOfCodeCount *int64 `type:"long"`
}

// String returns the string representation
func (s Metrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Metrics) GoString() string {
	return s.String()
}

// SetFindingsCount sets the FindingsCount field's value.
func (s *Metrics) SetFindingsCount(v int64) *Metrics {
	s.FindingsCount = &v
	return s
}

// SetMeteredLinesOfCodeCount sets the MeteredLinesOfCodeCount field's value.
func (s *Metrics) SetMeteredLinesOfCodeCount(v int64) *Metrics {
	s.MeteredLinesOfCodeCount = &v
	return s
}

// Information about metrics summaries.
type MetricsSummary struct {
	_ struct{} `type:"structure"`

	// Total number of recommendations found in the code review.
	FindingsCount *int64 `type:"long"`

	// Lines of code metered in the code review. For the initial code review pull
	// request and all subsequent revisions, this includes all lines of code in
	// the files added to the pull request. In subsequent revisions, for files that
	// already existed in the pull request, this includes only the changed lines
	// of code. In both cases, this does not include non-code lines such as comments
	// and import statements. For example, if you submit a pull request containing
	// 5 files, each with 500 lines of code, and in a subsequent revision you added
	// a new file with 200 lines of code, and also modified a total of 25 lines
	// across the initial 5 files, MeteredLinesOfCodeCount includes the first 5
	// files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed
	// lines of code for a total of 2,725 lines of code.
	MeteredLinesOfCodeCount *int64 `type:"long"`
}

// String returns the string representation
func (s MetricsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsSummary) GoString() string {
	return s.String()
}

// SetFindingsCount sets the FindingsCount field's value.
func (s *MetricsSummary) SetFindingsCount(v int64) *MetricsSummary {
	s.FindingsCount = &v
	return s
}

// SetMeteredLinesOfCodeCount sets the MeteredLinesOfCodeCount field's value.
func (s *MetricsSummary) SetMeteredLinesOfCodeCount(v int64) *MetricsSummary {
	s.MeteredLinesOfCodeCount = &v
	return s
}

// The resource specified in the request was not found.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutRecommendationFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	//
	// CodeReviewArn is a required field
	CodeReviewArn *string `min:"1" type:"string" required:"true"`

	// List for storing reactions. Reactions are utf-8 text code for emojis. If
	// you send an empty list it clears all your feedback.
	//
	// Reactions is a required field
	Reactions []*string `type:"list" required:"true"`

	// The recommendation ID that can be used to track the provided recommendations
	// and then to collect the feedback.
	//
	// RecommendationId is a required field
	RecommendationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecommendationFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecommendationFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecommendationFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecommendationFeedbackInput"}
	if s.CodeReviewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeReviewArn"))
	}
	if s.CodeReviewArn != nil && len(*s.CodeReviewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeReviewArn", 1))
	}
	if s.Reactions == nil {
		invalidParams.Add(request.NewErrParamRequired("Reactions"))
	}
	if s.RecommendationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationId"))
	}
	if s.RecommendationId != nil && len(*s.RecommendationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *PutRecommendationFeedbackInput) SetCodeReviewArn(v string) *PutRecommendationFeedbackInput {
	s.CodeReviewArn = &v
	return s
}

// SetReactions sets the Reactions field's value.
func (s *PutRecommendationFeedbackInput) SetReactions(v []*string) *PutRecommendationFeedbackInput {
	s.Reactions = v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *PutRecommendationFeedbackInput) SetRecommendationId(v string) *PutRecommendationFeedbackInput {
	s.RecommendationId = &v
	return s
}

type PutRecommendationFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRecommendationFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecommendationFeedbackOutput) GoString() string {
	return s.String()
}

// Information about the recommendation feedback.
type RecommendationFeedback struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	CodeReviewArn *string `min:"1" type:"string"`

	// The time at which the feedback was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time at which the feedback was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// List for storing reactions. Reactions are utf-8 text code for emojis. You
	// can send an empty list to clear off all your feedback.
	Reactions []*string `type:"list"`

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string `min:"1" type:"string"`

	// The ID of the user that made the API call.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RecommendationFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationFeedback) GoString() string {
	return s.String()
}

// SetCodeReviewArn sets the CodeReviewArn field's value.
func (s *RecommendationFeedback) SetCodeReviewArn(v string) *RecommendationFeedback {
	s.CodeReviewArn = &v
	return s
}

// SetCreatedTimeStamp sets the CreatedTimeStamp field's value.
func (s *RecommendationFeedback) SetCreatedTimeStamp(v time.Time) *RecommendationFeedback {
	s.CreatedTimeStamp = &v
	return s
}

// SetLastUpdatedTimeStamp sets the LastUpdatedTimeStamp field's value.
func (s *RecommendationFeedback) SetLastUpdatedTimeStamp(v time.Time) *RecommendationFeedback {
	s.LastUpdatedTimeStamp = &v
	return s
}

// SetReactions sets the Reactions field's value.
func (s *RecommendationFeedback) SetReactions(v []*string) *RecommendationFeedback {
	s.Reactions = v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *RecommendationFeedback) SetRecommendationId(v string) *RecommendationFeedback {
	s.RecommendationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *RecommendationFeedback) SetUserId(v string) *RecommendationFeedback {
	s.UserId = &v
	return s
}

// Information about recommendation feedback summaries.
type RecommendationFeedbackSummary struct {
	_ struct{} `type:"structure"`

	// List for storing reactions. Reactions are utf-8 text code for emojis.
	Reactions []*string `type:"list"`

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string `min:"1" type:"string"`

	// The ID of the user that gave the feedback.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RecommendationFeedbackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationFeedbackSummary) GoString() string {
	return s.String()
}

// SetReactions sets the Reactions field's value.
func (s *RecommendationFeedbackSummary) SetReactions(v []*string) *RecommendationFeedbackSummary {
	s.Reactions = v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *RecommendationFeedbackSummary) SetRecommendationId(v string) *RecommendationFeedbackSummary {
	s.RecommendationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *RecommendationFeedbackSummary) SetUserId(v string) *RecommendationFeedbackSummary {
	s.UserId = &v
	return s
}

// Information about recommendations.
type RecommendationSummary struct {
	_ struct{} `type:"structure"`

	// A description of the recommendation generated by CodeGuru Reviewer for the
	// lines of code between the start line and the end line.
	Description *string `min:"1" type:"string"`

	// Last line where the recommendation is applicable in the source commit or
	// source branch. For a single line comment the start line and end line values
	// are the same.
	EndLine *int64 `type:"integer"`

	// Name of the file on which a recommendation is provided.
	FilePath *string `min:"1" type:"string"`

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string `min:"1" type:"string"`

	// Start line from where the recommendation is applicable in the source commit
	// or source branch.
	StartLine *int64 `type:"integer"`
}

// String returns the string representation
func (s RecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *RecommendationSummary) SetDescription(v string) *RecommendationSummary {
	s.Description = &v
	return s
}

// SetEndLine sets the EndLine field's value.
func (s *RecommendationSummary) SetEndLine(v int64) *RecommendationSummary {
	s.EndLine = &v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *RecommendationSummary) SetFilePath(v string) *RecommendationSummary {
	s.FilePath = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *RecommendationSummary) SetRecommendationId(v string) *RecommendationSummary {
	s.RecommendationId = &v
	return s
}

// SetStartLine sets the StartLine field's value.
func (s *RecommendationSummary) SetStartLine(v int64) *RecommendationSummary {
	s.StartLine = &v
	return s
}

// Information about an associated AWS CodeCommit repository or an associated
// repository that is managed by AWS CodeStar Connections (for example, Bitbucket).
// This Repository object is not used if your source code is in an associated
// GitHub repository.
type Repository struct {
	_ struct{} `type:"structure"`

	// Information about a Bitbucket repository.
	Bitbucket *ThirdPartySourceRepository `type:"structure"`

	// Information about an AWS CodeCommit repository.
	CodeCommit *CodeCommitRepository `type:"structure"`

	// Information about a GitHub Enterprise Server repository.
	GitHubEnterpriseServer *ThirdPartySourceRepository `type:"structure"`
}

// String returns the string representation
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Repository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Repository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Repository"}
	if s.Bitbucket != nil {
		if err := s.Bitbucket.Validate(); err != nil {
			invalidParams.AddNested("Bitbucket", err.(request.ErrInvalidParams))
		}
	}
	if s.CodeCommit != nil {
		if err := s.CodeCommit.Validate(); err != nil {
			invalidParams.AddNested("CodeCommit", err.(request.ErrInvalidParams))
		}
	}
	if s.GitHubEnterpriseServer != nil {
		if err := s.GitHubEnterpriseServer.Validate(); err != nil {
			invalidParams.AddNested("GitHubEnterpriseServer", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBitbucket sets the Bitbucket field's value.
func (s *Repository) SetBitbucket(v *ThirdPartySourceRepository) *Repository {
	s.Bitbucket = v
	return s
}

// SetCodeCommit sets the CodeCommit field's value.
func (s *Repository) SetCodeCommit(v *CodeCommitRepository) *Repository {
	s.CodeCommit = v
	return s
}

// SetGitHubEnterpriseServer sets the GitHubEnterpriseServer field's value.
func (s *Repository) SetGitHubEnterpriseServer(v *ThirdPartySourceRepository) *Repository {
	s.GitHubEnterpriseServer = v
	return s
}

// A code review type that analyzes all code under a specified branch in an
// associated respository. The assocated repository is specified using its ARN
// when you call CreateCodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
type RepositoryAnalysis struct {
	_ struct{} `type:"structure"`

	// A SourceCodeType (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
	// that specifies the tip of a branch in an associated repository.
	//
	// RepositoryHead is a required field
	RepositoryHead *RepositoryHeadSourceCodeType `type:"structure" required:"true"`
}

// String returns the string representation
func (s RepositoryAnalysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryAnalysis) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryAnalysis) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryAnalysis"}
	if s.RepositoryHead == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryHead"))
	}
	if s.RepositoryHead != nil {
		if err := s.RepositoryHead.Validate(); err != nil {
			invalidParams.AddNested("RepositoryHead", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryHead sets the RepositoryHead field's value.
func (s *RepositoryAnalysis) SetRepositoryHead(v *RepositoryHeadSourceCodeType) *RepositoryAnalysis {
	s.RepositoryHead = v
	return s
}

// Information about a repository association. The DescribeRepositoryAssociation
// (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_DescribeRepositoryAssociation.html)
// operation returns a RepositoryAssociation object.
type RepositoryAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the repository association.
	AssociationArn *string `min:"1" type:"string"`

	// The ID of the repository association.
	AssociationId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
	// Its format is arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id.
	// For more information, see Connection (https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html)
	// in the AWS CodeStar Connections API Reference.
	ConnectionArn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the repository association
	// was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub, GitHub
	// Enterprise Server, or Bitbucket repository, this is the username for the
	// account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The state of the repository association.
	//
	// The valid repository association states are:
	//
	//    * Associated: The repository association is complete.
	//
	//    * Associating: CodeGuru Reviewer is: Setting up pull request notifications.
	//    This is required for pull requests to trigger a CodeGuru Reviewer review.
	//    If your repository ProviderType is GitHub, GitHub Enterprise Server, or
	//    Bitbucket, CodeGuru Reviewer creates webhooks in your repository to trigger
	//    CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code
	//    in your repository cannot be triggered. Setting up source code access.
	//    This is required for CodeGuru Reviewer to securely clone code in your
	//    repository.
	//
	//    * Failed: The repository failed to associate or disassociate.
	//
	//    * Disassociating: CodeGuru Reviewer is removing the repository's pull
	//    request notifications and source code access.
	//
	//    * Disassociated: CodeGuru Reviewer successfully disassociated the repository.
	//    You can create a new association with this repository if you want to review
	//    source code in it later. You can control access to code reviews created
	//    in an associated repository with tags after it has been disassociated.
	//    For more information, see Using tags to control access to associated repositories
	//    (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html)
	//    in the Amazon CodeGuru Reviewer User Guide.
	State *string `type:"string" enum:"RepositoryAssociationState"`

	// A description of why the repository association is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation
func (s RepositoryAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryAssociation) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *RepositoryAssociation) SetAssociationArn(v string) *RepositoryAssociation {
	s.AssociationArn = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *RepositoryAssociation) SetAssociationId(v string) *RepositoryAssociation {
	s.AssociationId = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *RepositoryAssociation) SetConnectionArn(v string) *RepositoryAssociation {
	s.ConnectionArn = &v
	return s
}

// SetCreatedTimeStamp sets the CreatedTimeStamp field's value.
func (s *RepositoryAssociation) SetCreatedTimeStamp(v time.Time) *RepositoryAssociation {
	s.CreatedTimeStamp = &v
	return s
}

// SetLastUpdatedTimeStamp sets the LastUpdatedTimeStamp field's value.
func (s *RepositoryAssociation) SetLastUpdatedTimeStamp(v time.Time) *RepositoryAssociation {
	s.LastUpdatedTimeStamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryAssociation) SetName(v string) *RepositoryAssociation {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *RepositoryAssociation) SetOwner(v string) *RepositoryAssociation {
	s.Owner = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *RepositoryAssociation) SetProviderType(v string) *RepositoryAssociation {
	s.ProviderType = &v
	return s
}

// SetState sets the State field's value.
func (s *RepositoryAssociation) SetState(v string) *RepositoryAssociation {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *RepositoryAssociation) SetStateReason(v string) *RepositoryAssociation {
	s.StateReason = &v
	return s
}

// Summary information about a repository association. The ListRepositoryAssociations
// (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html)
// operation returns a list of RepositoryAssociationSummary objects.
type RepositoryAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object. You can retrieve this ARN by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	AssociationArn *string `min:"1" type:"string"`

	// The repository association ID.
	AssociationId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
	// Its format is arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id.
	// For more information, see Connection (https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html)
	// in the AWS CodeStar Connections API Reference.
	ConnectionArn *string `type:"string"`

	// The time, in milliseconds since the epoch, since the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository association.
	Name *string `min:"1" type:"string"`

	// The owner of the repository. For an AWS CodeCommit repository, this is the
	// AWS account ID of the account that owns the repository. For a GitHub, GitHub
	// Enterprise Server, or Bitbucket repository, this is the username for the
	// account that owns the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The state of the repository association.
	//
	// The valid repository association states are:
	//
	//    * Associated: The repository association is complete.
	//
	//    * Associating: CodeGuru Reviewer is: Setting up pull request notifications.
	//    This is required for pull requests to trigger a CodeGuru Reviewer review.
	//    If your repository ProviderType is GitHub, GitHub Enterprise Server, or
	//    Bitbucket, CodeGuru Reviewer creates webhooks in your repository to trigger
	//    CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code
	//    in your repository cannot be triggered. Setting up source code access.
	//    This is required for CodeGuru Reviewer to securely clone code in your
	//    repository.
	//
	//    * Failed: The repository failed to associate or disassociate.
	//
	//    * Disassociating: CodeGuru Reviewer is removing the repository's pull
	//    request notifications and source code access.
	//
	//    * Disassociated: CodeGuru Reviewer successfully disassociated the repository.
	//    You can create a new association with this repository if you want to review
	//    source code in it later. You can control access to code reviews created
	//    in an associated repository with tags after it has been disassociated.
	//    For more information, see Using tags to control access to associated repositories
	//    (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html)
	//    in the Amazon CodeGuru Reviewer User Guide.
	State *string `type:"string" enum:"RepositoryAssociationState"`
}

// String returns the string representation
func (s RepositoryAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryAssociationSummary) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *RepositoryAssociationSummary) SetAssociationArn(v string) *RepositoryAssociationSummary {
	s.AssociationArn = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *RepositoryAssociationSummary) SetAssociationId(v string) *RepositoryAssociationSummary {
	s.AssociationId = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *RepositoryAssociationSummary) SetConnectionArn(v string) *RepositoryAssociationSummary {
	s.ConnectionArn = &v
	return s
}

// SetLastUpdatedTimeStamp sets the LastUpdatedTimeStamp field's value.
func (s *RepositoryAssociationSummary) SetLastUpdatedTimeStamp(v time.Time) *RepositoryAssociationSummary {
	s.LastUpdatedTimeStamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryAssociationSummary) SetName(v string) *RepositoryAssociationSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *RepositoryAssociationSummary) SetOwner(v string) *RepositoryAssociationSummary {
	s.Owner = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *RepositoryAssociationSummary) SetProviderType(v string) *RepositoryAssociationSummary {
	s.ProviderType = &v
	return s
}

// SetState sets the State field's value.
func (s *RepositoryAssociationSummary) SetState(v string) *RepositoryAssociationSummary {
	s.State = &v
	return s
}

// A SourceCodeType (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
// that specifies the tip of a branch in an associated repository.
type RepositoryHeadSourceCodeType struct {
	_ struct{} `type:"structure"`

	// The name of the branch in an associated repository. The RepositoryHeadSourceCodeType
	// specifies the tip of this branch.
	//
	// BranchName is a required field
	BranchName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RepositoryHeadSourceCodeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryHeadSourceCodeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryHeadSourceCodeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryHeadSourceCodeType"}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *RepositoryHeadSourceCodeType) SetBranchName(v string) *RepositoryHeadSourceCodeType {
	s.BranchName = &v
	return s
}

// The resource specified in the request was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the source code that is analyzed in a code review. A code review
// can analyze the source code that is specified using a pull request diff or
// a branch in an associated repository.
type SourceCodeType struct {
	_ struct{} `type:"structure"`

	// A SourceCodeType (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
	// that specifies a commit diff created by a pull request on an associated repository.
	CommitDiff *CommitDiffSourceCodeType `type:"structure"`

	// A SourceCodeType (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
	// that specifies the tip of a branch in an associated repository.
	RepositoryHead *RepositoryHeadSourceCodeType `type:"structure"`
}

// String returns the string representation
func (s SourceCodeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceCodeType) GoString() string {
	return s.String()
}

// SetCommitDiff sets the CommitDiff field's value.
func (s *SourceCodeType) SetCommitDiff(v *CommitDiffSourceCodeType) *SourceCodeType {
	s.CommitDiff = v
	return s
}

// SetRepositoryHead sets the RepositoryHead field's value.
func (s *SourceCodeType) SetRepositoryHead(v *RepositoryHeadSourceCodeType) *SourceCodeType {
	s.RepositoryHead = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object. You can retrieve this ARN by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// An array of key-value pairs used to tag an associated repository. A tag is
	// a custom attribute label with two parts:
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case sensitive.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Information about a third-party source repository connected to CodeGuru Reviewer.
type ThirdPartySourceRepository struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
	// Its format is arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id.
	// For more information, see Connection (https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html)
	// in the AWS CodeStar Connections API Reference.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`

	// The name of the third party source repository.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket
	// repository, this is the username for the account that owns the repository.
	//
	// Owner is a required field
	Owner *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ThirdPartySourceRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThirdPartySourceRepository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ThirdPartySourceRepository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ThirdPartySourceRepository"}
	if s.ConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Owner != nil && len(*s.Owner) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Owner", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *ThirdPartySourceRepository) SetConnectionArn(v string) *ThirdPartySourceRepository {
	s.ConnectionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ThirdPartySourceRepository) SetName(v string) *ThirdPartySourceRepository {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ThirdPartySourceRepository) SetOwner(v string) *ThirdPartySourceRepository {
	s.Owner = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RepositoryAssociation (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
	// object. You can retrieve this ARN by calling ListRepositoryAssociations (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of the keys for each tag you want to remove from an associated repository.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the specified constraints.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// JobStateCompleted is a JobState enum value
	JobStateCompleted = "Completed"

	// JobStatePending is a JobState enum value
	JobStatePending = "Pending"

	// JobStateFailed is a JobState enum value
	JobStateFailed = "Failed"

	// JobStateDeleting is a JobState enum value
	JobStateDeleting = "Deleting"
)

// JobState_Values returns all elements of the JobState enum
func JobState_Values() []string {
	return []string{
		JobStateCompleted,
		JobStatePending,
		JobStateFailed,
		JobStateDeleting,
	}
}

const (
	// ProviderTypeCodeCommit is a ProviderType enum value
	ProviderTypeCodeCommit = "CodeCommit"

	// ProviderTypeGitHub is a ProviderType enum value
	ProviderTypeGitHub = "GitHub"

	// ProviderTypeBitbucket is a ProviderType enum value
	ProviderTypeBitbucket = "Bitbucket"

	// ProviderTypeGitHubEnterpriseServer is a ProviderType enum value
	ProviderTypeGitHubEnterpriseServer = "GitHubEnterpriseServer"
)

// ProviderType_Values returns all elements of the ProviderType enum
func ProviderType_Values() []string {
	return []string{
		ProviderTypeCodeCommit,
		ProviderTypeGitHub,
		ProviderTypeBitbucket,
		ProviderTypeGitHubEnterpriseServer,
	}
}

const (
	// ReactionThumbsUp is a Reaction enum value
	ReactionThumbsUp = "ThumbsUp"

	// ReactionThumbsDown is a Reaction enum value
	ReactionThumbsDown = "ThumbsDown"
)

// Reaction_Values returns all elements of the Reaction enum
func Reaction_Values() []string {
	return []string{
		ReactionThumbsUp,
		ReactionThumbsDown,
	}
}

const (
	// RepositoryAssociationStateAssociated is a RepositoryAssociationState enum value
	RepositoryAssociationStateAssociated = "Associated"

	// RepositoryAssociationStateAssociating is a RepositoryAssociationState enum value
	RepositoryAssociationStateAssociating = "Associating"

	// RepositoryAssociationStateFailed is a RepositoryAssociationState enum value
	RepositoryAssociationStateFailed = "Failed"

	// RepositoryAssociationStateDisassociating is a RepositoryAssociationState enum value
	RepositoryAssociationStateDisassociating = "Disassociating"

	// RepositoryAssociationStateDisassociated is a RepositoryAssociationState enum value
	RepositoryAssociationStateDisassociated = "Disassociated"
)

// RepositoryAssociationState_Values returns all elements of the RepositoryAssociationState enum
func RepositoryAssociationState_Values() []string {
	return []string{
		RepositoryAssociationStateAssociated,
		RepositoryAssociationStateAssociating,
		RepositoryAssociationStateFailed,
		RepositoryAssociationStateDisassociating,
		RepositoryAssociationStateDisassociated,
	}
}

const (
	// TypePullRequest is a Type enum value
	TypePullRequest = "PullRequest"

	// TypeRepositoryAnalysis is a Type enum value
	TypeRepositoryAnalysis = "RepositoryAnalysis"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypePullRequest,
		TypeRepositoryAnalysis,
	}
}
