/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package android.service.autofill.augmented;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.annotation.TestApi;
import android.app.assist.AssistStructure.ViewNode;
import android.content.ComponentName;
import android.service.autofill.augmented.AugmentedAutofillService.AutofillProxy;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.InlineSuggestionsRequest;

import com.android.internal.util.DataClass;

/**
 * Represents a request to augment-fill an activity.
 * @hide
 */
@SystemApi
// TODO(b/123100811): pass a requestId and/or sessionId?
@TestApi
@DataClass(
        genToString = true,
        genBuilder = false,
        genHiddenConstructor = true)
@DataClass.Suppress({"getProxy"})
public final class FillRequest {

    private final @NonNull AutofillProxy mProxy;

    //TODO(b/146901891): add detailed docs once we have stable APIs.
    /**
     * An optional request for inline suggestions.
     */
    private final @Nullable InlineSuggestionsRequest mInlineSuggestionsRequest;

    /**
     * Gets the task of the activity associated with this request.
     */
    public int getTaskId() {
        return mProxy.mTaskId;
    }

    /**
     * Gets the name of the activity associated with this request.
     */
    @NonNull
    public ComponentName getActivityComponent() {
        return mProxy.mComponentName;
    }

    /**
     * Gets the id of the field that triggered the request.
     */
    @NonNull
    public AutofillId getFocusedId() {
        return mProxy.getFocusedId();
    }

    /**
     * Gets the current value of the field that triggered the request.
     */
    @NonNull
    public AutofillValue getFocusedValue() {
        return mProxy.getFocusedValue();
    }

    /**
     * Gets the current {@link ViewNode} information of the field that triggered the request.
     */
    @Nullable
    public ViewNode getFocusedViewNode() {
        return mProxy.getFocusedViewNode();
    }

    /**
     * Gets the Smart Suggestions object used to embed the autofill UI.
     *
     * @return object used to embed the autofill UI, or {@code null} if not supported.
     */
    @Nullable
    public PresentationParams getPresentationParams() {
        return mProxy.getSmartSuggestionParams();
    }

    String proxyToString() {
        return "FillRequest[act=" + getActivityComponent().flattenToShortString()
                + ", id=" + mProxy.getFocusedId() + "]";
    }




    // Code below generated by codegen v1.0.22.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/service/autofill/augmented/FillRequest.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new FillRequest.
     *
     * @param inlineSuggestionsRequest
     *   An optional request for inline suggestions.
     * @hide
     */
    @DataClass.Generated.Member
    public FillRequest(
            @NonNull AutofillProxy proxy,
            @Nullable InlineSuggestionsRequest inlineSuggestionsRequest) {
        this.mProxy = proxy;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mProxy);
        this.mInlineSuggestionsRequest = inlineSuggestionsRequest;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * An optional request for inline suggestions.
     */
    @DataClass.Generated.Member
    public @Nullable InlineSuggestionsRequest getInlineSuggestionsRequest() {
        return mInlineSuggestionsRequest;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "FillRequest { " +
                "proxy = " + proxyToString() + ", " +
                "inlineSuggestionsRequest = " + mInlineSuggestionsRequest +
        " }";
    }

    @DataClass.Generated(
            time = 1608160139217L,
            codegenVersion = "1.0.22",
            sourceFile = "frameworks/base/core/java/android/service/autofill/augmented/FillRequest.java",
            inputSignatures = "private final @android.annotation.NonNull android.service.autofill.augmented.AugmentedAutofillService.AutofillProxy mProxy\nprivate final @android.annotation.Nullable android.view.inputmethod.InlineSuggestionsRequest mInlineSuggestionsRequest\npublic  int getTaskId()\npublic @android.annotation.NonNull android.content.ComponentName getActivityComponent()\npublic @android.annotation.NonNull android.view.autofill.AutofillId getFocusedId()\npublic @android.annotation.NonNull android.view.autofill.AutofillValue getFocusedValue()\npublic @android.annotation.Nullable android.app.assist.AssistStructure.ViewNode getFocusedViewNode()\npublic @android.annotation.Nullable android.service.autofill.augmented.PresentationParams getPresentationParams()\n  java.lang.String proxyToString()\nclass FillRequest extends java.lang.Object implements []\n@com.android.internal.util.DataClass(genToString=true, genBuilder=false, genHiddenConstructor=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
