# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Recycle(AAZCommand):
    """Recycle a specific instance in a managed instance App Service plan.

    :example: Recycle a specific worker instance in a managed instance App Service plan.
        az appservice plan managed-instance instance recycle --name MyAppServicePlan --resource-group MyResourceGroup --worker-name MyWorkerInstance
    """

    _aaz_info = {
        "version": "2025-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.web/serverfarms/{}/workers/{}/recycleinstance", "2025-03-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["--name"],
            help="Name of the App Service plan.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.worker_name = AAZStrArg(
            options=["--worker-name"],
            help="Name of worker machine.",
            required=True,
            id_part="child_name_1",
            fmt=AAZStrArgFormat(
                pattern="^[a-zA-Z0-9]+$",
            ),
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.AppServicePlansRecycleManagedInstanceWorker(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class AppServicePlansRecycleManagedInstanceWorker(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/recycleinstance",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "workerName", self.ctx.args.worker_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.created_time = AAZStrType(
                serialized_name="createdTime",
            )
            _schema_on_200.errors = AAZListType()
            _schema_on_200.expiration_time = AAZStrType(
                serialized_name="expirationTime",
            )
            _schema_on_200.geo_master_operation_id = AAZStrType(
                serialized_name="geoMasterOperationId",
            )
            _schema_on_200.id = AAZStrType()
            _schema_on_200.modified_time = AAZStrType(
                serialized_name="modifiedTime",
            )
            _schema_on_200.name = AAZStrType()
            _schema_on_200.status = AAZStrType()

            errors = cls._schema_on_200.errors
            errors.Element = AAZObjectType()
            _RecycleHelper._build_schema_error_entity_read(errors.Element)

            return cls._schema_on_200


class _RecycleHelper:
    """Helper class for Recycle"""

    _schema_error_entity_read = None

    @classmethod
    def _build_schema_error_entity_read(cls, _schema):
        if cls._schema_error_entity_read is not None:
            _schema.code = cls._schema_error_entity_read.code
            _schema.details = cls._schema_error_entity_read.details
            _schema.extended_code = cls._schema_error_entity_read.extended_code
            _schema.inner_errors = cls._schema_error_entity_read.inner_errors
            _schema.message = cls._schema_error_entity_read.message
            _schema.message_template = cls._schema_error_entity_read.message_template
            _schema.parameters = cls._schema_error_entity_read.parameters
            _schema.target = cls._schema_error_entity_read.target
            return

        cls._schema_error_entity_read = _schema_error_entity_read = AAZObjectType()

        error_entity_read = _schema_error_entity_read
        error_entity_read.code = AAZStrType()
        error_entity_read.details = AAZListType()
        error_entity_read.extended_code = AAZStrType(
            serialized_name="extendedCode",
        )
        error_entity_read.inner_errors = AAZListType(
            serialized_name="innerErrors",
        )
        error_entity_read.message = AAZStrType()
        error_entity_read.message_template = AAZStrType(
            serialized_name="messageTemplate",
        )
        error_entity_read.parameters = AAZListType()
        error_entity_read.target = AAZStrType()

        details = _schema_error_entity_read.details
        details.Element = AAZObjectType()
        cls._build_schema_error_entity_read(details.Element)

        inner_errors = _schema_error_entity_read.inner_errors
        inner_errors.Element = AAZObjectType()
        cls._build_schema_error_entity_read(inner_errors.Element)

        parameters = _schema_error_entity_read.parameters
        parameters.Element = AAZStrType()

        _schema.code = cls._schema_error_entity_read.code
        _schema.details = cls._schema_error_entity_read.details
        _schema.extended_code = cls._schema_error_entity_read.extended_code
        _schema.inner_errors = cls._schema_error_entity_read.inner_errors
        _schema.message = cls._schema_error_entity_read.message
        _schema.message_template = cls._schema_error_entity_read.message_template
        _schema.parameters = cls._schema_error_entity_read.parameters
        _schema.target = cls._schema_error_entity_read.target


__all__ = ["Recycle"]
