.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkMapRom.man,v 1.1.1.1 2002/10/19 08:27:48 aida_s Exp $ NEC;
.TH "RKMAPROMA" "3"
.SH "NAME"
\f4RkMapRoma\f1 \- perform Romaji-kana conversion by using a specified Romaji-kana conversion table
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkMapRoma(romaji, dst, maxdst, src, srclen, flags, status)
struct RkRxDic *romaji;
unsigned char *dst;
int maxdst;
unsigned char *src;
int srclen;
int flags;
int *status;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkMapRoma\f1 performs Romaji-kana conversion by using a specified Romaji-kana conversion table.  \f2romaji\f1 specifies a pointer to the Romaji-kana conversion table that has been returned by \f2RkOpenRoma(3)\f1.  \f2RkMapRoma\f1 interprets the \f2srclen\f1 bytes of contiguous data starting at the area \f2src\f1 as a Romaji character string and searches through the Romaji-kana conversion table for the rule of Romaji-kana conversion that matches the beginning of the Romaji character string.  If the corresponding conversion rule is found, the corresponding kana character string is stored in the area \f2dst\f1.  The resulting character string is truncated when its byte length exceeds \f2maxdst\f1 -1.  \f2dst\f1 is padded with null characters at the end if possible.
.P
\f2flags\f1 is a combination of the following Romaji-kana conversion flags connected by or:
.P
.RS
.IP "RK_SOKUON" 15n
Enables gemination, in which a sequence of two occurrences of the same character, xx, is converted to small kana character "tsu" only if it is not defined in the Romaji-kana conversion table file.  
.IP "RK_FLUSH"
Converts all Romaji characters compulsorily.  Useful for handling n appearing at the end of a character string.
.RE
.P
The flags listed below specify the type of characters stored in \f2src\f1.  These specified code conversion to be performed on the character string derived from the Romaji-kana conversion table.  These flags can use one by one.  
.P
.RS
.IP "RK_NFER" 15n
No conversion
.IP "RK_XFER"
Hiragana
.IP "RK_HFER"
Single-byte character
.IP "RK_KFER"
Katakana
.IP "RK_ZFER"
Double-byte character
.RE
.P
\f2status\f1 is set to the byte length of the character string set in the area \f2dst\f1.  A negative value means that there is no matching Romaji character string.
.SH "RETURN VALUE"
This function returns the starting byte length of the Romaji character string matched by Romaji-kana conversion.
