{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_fraction: TSFFloatEvent;
    {  }
    public property EventSet_fraction: TSFFloatEvent read FEventSet_fraction;

    strict private FFdEaseInEaseOut: TMFVec2f;
    { Internal wrapper for property @code(EaseInEaseOut). This wrapper API may change, we advise to access simpler @code(EaseInEaseOut) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEaseInEaseOut: TMFVec2f read FFdEaseInEaseOut;
    {  }
    procedure SetEaseInEaseOut(const Value: array of TVector2); overload;
    {  }
    procedure SetEaseInEaseOut(const Value: TVector2List); overload;

    strict private FFdKey: TMFFloat;
    { Internal wrapper for property @code(Key). This wrapper API may change, we advise to access simpler @code(Key) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdKey: TMFFloat read FFdKey;
    {  }
    procedure SetKey(const Value: array of Single); overload;
    {  }
    procedure SetKey(const Value: TSingleList); overload;

    strict private FEventModifiedFraction_changed: TSFFloatEvent;
    {  }
    public property EventModifiedFraction_changed: TSFFloatEvent read FEventModifiedFraction_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TEaseInEaseOutNode ----------------------------------------------- }

procedure TEaseInEaseOutNode.SetEaseInEaseOut(const Value: array of TVector2);
begin
  FdEaseInEaseOut.Send(Value);
end;

procedure TEaseInEaseOutNode.SetEaseInEaseOut(const Value: TVector2List);
begin
  FdEaseInEaseOut.Send(Value);
end;

procedure TEaseInEaseOutNode.SetKey(const Value: array of Single);
begin
  FdKey.Send(Value);
end;

procedure TEaseInEaseOutNode.SetKey(const Value: TSingleList);
begin
  FdKey.Send(Value);
end;

class function TEaseInEaseOutNode.ClassX3DType: String;
begin
  Result := 'EaseInEaseOut';
end;

procedure TEaseInEaseOutNode.CreateNode;
begin
  inherited;

  FEventSet_fraction := TSFFloatEvent.Create(Self, 'set_fraction', true);
  AddEvent(FEventSet_fraction);

  FFdEaseInEaseOut := TMFVec2f.Create(Self, True, 'easeInEaseOut', []);
   FdEaseInEaseOut.ChangeAlways := chNone;
  AddField(FFdEaseInEaseOut);

  FFdKey := TMFFloat.Create(Self, True, 'key', []);
   FdKey.ChangeAlways := chNone;
  AddField(FFdKey);

  FEventModifiedFraction_changed := TSFFloatEvent.Create(Self, 'modifiedFraction_changed', false);
  AddEvent(FEventModifiedFraction_changed);
end;

{$endif read_implementation}
