/* SPDX-License-Identifier: GPL-2.0-only */

/* Driver for BayHub Technology LV2 PCIe to SD bridge */

#include <types.h>

enum {
	LV2_PROTECT			= 0xD0,
	LV2_PROTECT_LOCK_OFF		= 0,
	LV2_PROTECT_LOCK_ON		= BIT(0),
	LV2_PROTECT_OFF			= 0,
	LV2_PROTECT_ON			= BIT(31),
	LV2_PCR_HEX_FC			= 0xFC,
	LV2_PCIE_PHY_P1_ENABLE		= BIT(25),
	LV2_ASPM_L1_TIMER		= 0x000E0000,
	LV2_ASPM_L1_TIMER_MASK		= 0xFFF0FFFF,
	LV2_PCR_HEX_A8			= 0xA8,
	LV2_LTR_ENABLE			= BIT(10),
	LV2_PCR_HEX_E0			= 0xE0,
	LV2_PCI_PM_L1_TIMER		= 0x30000000,
	LV2_PCI_PM_L1_TIMER_MASK	= 0x0FFFFFFF,
	LV2_PCR_HEX_234			= 0x234,
	LV2_MAX_LATENCY_SETTING		= 0x10011001,
	LV2_PCR_HEX_3F4			= 0x3F4,
	LV2_L1_SUBSTATE_OPTIMISE	= 0x0000000A,
	LV2_L1_SUBSTATE_OPTIMISE_MASK	= 0xFFFFFFF0,
	LV2_PCR_HEX_300			= 0x300,
	LV2_TUNING_WINDOW		= 0x00006055,
	LV2_TUNING_WINDOW_MASK		= 0xFFFF0F00,
	LV2_PCR_HEX_304			= 0x304,
	LV2_DRIVER_STRENGTH		= 0x0000224B,
	LV2_DRIVER_STRENGTH_MASK	= 0xFFFF0000,
	LV2_PCR_HEX_308			= 0x308,
	LV2_RESET_DMA_DISABLE		= 0x00C00000,
	LV2_RESET_DMA_DISABLE_MASK	= 0xFF3FFFFF,
};
