/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.jni.FillList;
import geotrans3.jni.JNIDatumLibrary;
import geotrans3.jni.JNIEllipsoidLibrary;
import geotrans3.misc.Info;
import geotrans3.misc.StringHandler;
import geotrans3.utility.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class _7ParamDatumPanel
extends JPanel {
    private JNIDatumLibrary jniDatumLibrary;
    private JNIEllipsoidLibrary jniEllipsoidLibrary;
    private JPanel createDatumPanel;
    private JLabel datumCodeLabel;
    private JTextField datumCodeTextField;
    private JLabel datumNameLabel;
    private JTextField datumNameTextField;
    private JPanel datumPanel;
    private JLabel datumShiftLabel;
    private JPanel deltaPanel;
    private JLabel deltaXLabel;
    private JTextField deltaXTextField;
    private JLabel deltaYLabel;
    private JTextField deltaYTextField;
    private JLabel deltaZLabel;
    private JTextField deltaZTextField;
    private JComboBox ellipsoidComboBox;
    private JLabel ellipsoidLabel;
    private JPanel rotationPanel;
    private JLabel rotationXLabel;
    private JTextField rotationXTextField;
    private JLabel rotationYLabel;
    private JTextField rotationYTextField;
    private JLabel rotationZLabel;
    private JTextField rotationZTextField;
    private JLabel scaleLabel;
    private JPanel scalePanel;
    private JTextField scaleTextField;
    private JPanel selectEllipsoidPanel;

    public _7ParamDatumPanel(JNIDatumLibrary jNIDatumLibrary, JNIEllipsoidLibrary jNIEllipsoidLibrary) {
        this.jniDatumLibrary = jNIDatumLibrary;
        this.jniEllipsoidLibrary = jNIEllipsoidLibrary;
        this.initComponents();
        new FillList(this.jniDatumLibrary, this.jniEllipsoidLibrary, this.ellipsoidComboBox, 1);
        if (Platform.isUnix) {
            this.datumCodeLabel.setFont(new Font("Dialog", 1, 10));
            this.datumNameLabel.setFont(new Font("Dialog", 1, 10));
            this.ellipsoidLabel.setFont(new Font("Dialog", 1, 10));
            this.datumShiftLabel.setFont(new Font("Dialog", 1, 10));
            this.deltaXLabel.setFont(new Font("Dialog", 1, 10));
            this.deltaYLabel.setFont(new Font("Dialog", 1, 10));
            this.deltaZLabel.setFont(new Font("Dialog", 1, 10));
            this.rotationXLabel.setFont(new Font("Dialog", 1, 10));
            this.rotationYLabel.setFont(new Font("Dialog", 1, 10));
            this.rotationZLabel.setFont(new Font("Dialog", 1, 10));
            this.scaleLabel.setFont(new Font("Dialog", 1, 10));
            this.ellipsoidComboBox.setFont(new Font("Dialog", 1, 10));
        }
    }

    private void initComponents() {
        this.createDatumPanel = new JPanel();
        this.datumPanel = new JPanel();
        this.datumCodeLabel = new JLabel();
        this.datumNameLabel = new JLabel();
        this.datumCodeTextField = new JTextField();
        this.datumNameTextField = new JTextField();
        this.selectEllipsoidPanel = new JPanel();
        this.ellipsoidLabel = new JLabel();
        this.ellipsoidComboBox = new JComboBox();
        this.datumShiftLabel = new JLabel();
        this.deltaPanel = new JPanel();
        this.deltaXLabel = new JLabel();
        this.deltaYLabel = new JLabel();
        this.deltaZLabel = new JLabel();
        this.deltaXTextField = new JTextField();
        this.deltaYTextField = new JTextField();
        this.deltaZTextField = new JTextField();
        this.rotationPanel = new JPanel();
        this.rotationXLabel = new JLabel();
        this.rotationYLabel = new JLabel();
        this.rotationZLabel = new JLabel();
        this.rotationXTextField = new JTextField();
        this.rotationYTextField = new JTextField();
        this.rotationZTextField = new JTextField();
        this.scalePanel = new JPanel();
        this.scaleLabel = new JLabel();
        this.scaleTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(361, 204));
        this.createDatumPanel.setLayout(new GridBagLayout());
        this.createDatumPanel.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 18));
        this.createDatumPanel.setMaximumSize(new Dimension(390, 244));
        this.createDatumPanel.setMinimumSize(new Dimension(390, 244));
        this.createDatumPanel.setOpaque(false);
        this.createDatumPanel.setPreferredSize(new Dimension(420, 244));
        this.datumPanel.setLayout(new GridBagLayout());
        this.datumCodeLabel.setHorizontalAlignment(2);
        this.datumCodeLabel.setText("Code:");
        this.datumCodeLabel.setVerticalAlignment(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.datumPanel.add((Component)this.datumCodeLabel, gridBagConstraints);
        this.datumNameLabel.setHorizontalAlignment(2);
        this.datumNameLabel.setText("Name:");
        this.datumNameLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.datumPanel.add((Component)this.datumNameLabel, gridBagConstraints);
        this.datumCodeTextField.setText("WGE");
        this.datumCodeTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.datumCodeTextField.setMinimumSize(new Dimension(179, 19));
        this.datumCodeTextField.setPreferredSize(new Dimension(179, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.datumPanel.add((Component)this.datumCodeTextField, gridBagConstraints);
        this.datumNameTextField.setText("World Geodetic System  1984");
        this.datumNameTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.datumNameTextField.setMinimumSize(new Dimension(179, 19));
        this.datumNameTextField.setPreferredSize(new Dimension(179, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.datumPanel.add((Component)this.datumNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.createDatumPanel.add((Component)this.datumPanel, gridBagConstraints);
        this.selectEllipsoidPanel.setLayout(new GridBagLayout());
        this.selectEllipsoidPanel.setPreferredSize(new Dimension(250, 47));
        this.ellipsoidLabel.setHorizontalAlignment(2);
        this.ellipsoidLabel.setText("Ellipsoid:");
        this.ellipsoidLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.selectEllipsoidPanel.add((Component)this.ellipsoidLabel, gridBagConstraints);
        this.ellipsoidComboBox.setMaximumSize(new Dimension(400, 25));
        this.ellipsoidComboBox.setMinimumSize(new Dimension(126, 8));
        this.ellipsoidComboBox.setPreferredSize(new Dimension(250, 22));
        this.ellipsoidComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                _7ParamDatumPanel.this.ellipsoidComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.selectEllipsoidPanel.add((Component)this.ellipsoidComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.createDatumPanel.add((Component)this.selectEllipsoidPanel, gridBagConstraints);
        this.datumShiftLabel.setHorizontalAlignment(0);
        this.datumShiftLabel.setText("Datum Shift to WGS84");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.createDatumPanel.add((Component)this.datumShiftLabel, gridBagConstraints);
        this.deltaPanel.setLayout(new GridBagLayout());
        this.deltaXLabel.setHorizontalAlignment(2);
        this.deltaXLabel.setText("Delta X (m):");
        this.deltaXLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaXLabel, gridBagConstraints);
        this.deltaYLabel.setHorizontalAlignment(2);
        this.deltaYLabel.setText(" Delta Y (m):");
        this.deltaYLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaYLabel, gridBagConstraints);
        this.deltaZLabel.setHorizontalAlignment(2);
        this.deltaZLabel.setText("Delta Z (m):");
        this.deltaZLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.deltaPanel.add((Component)this.deltaZLabel, gridBagConstraints);
        this.deltaXTextField.setText("0");
        this.deltaXTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.deltaXTextField.setMinimumSize(new Dimension(115, 19));
        this.deltaXTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaXTextField, gridBagConstraints);
        this.deltaYTextField.setText("0");
        this.deltaYTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.deltaYTextField.setMinimumSize(new Dimension(115, 19));
        this.deltaYTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaYTextField, gridBagConstraints);
        this.deltaZTextField.setText("0");
        this.deltaZTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.deltaZTextField.setMinimumSize(new Dimension(115, 19));
        this.deltaZTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.deltaPanel.add((Component)this.deltaZTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.createDatumPanel.add((Component)this.deltaPanel, gridBagConstraints);
        this.rotationPanel.setLayout(new GridBagLayout());
        this.rotationXLabel.setHorizontalAlignment(2);
        this.rotationXLabel.setText("Rotation X:");
        this.rotationXLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.rotationPanel.add((Component)this.rotationXLabel, gridBagConstraints);
        this.rotationYLabel.setHorizontalAlignment(2);
        this.rotationYLabel.setText("Rotation Y:");
        this.rotationYLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.rotationPanel.add((Component)this.rotationYLabel, gridBagConstraints);
        this.rotationZLabel.setHorizontalAlignment(2);
        this.rotationZLabel.setText("Rotation Z:");
        this.rotationZLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.rotationPanel.add((Component)this.rotationZLabel, gridBagConstraints);
        this.rotationXTextField.setText("0");
        this.rotationXTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.rotationXTextField.setMinimumSize(new Dimension(115, 19));
        this.rotationXTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.rotationPanel.add((Component)this.rotationXTextField, gridBagConstraints);
        this.rotationYTextField.setText("0");
        this.rotationYTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.rotationYTextField.setMinimumSize(new Dimension(115, 19));
        this.rotationYTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.rotationPanel.add((Component)this.rotationYTextField, gridBagConstraints);
        this.rotationZTextField.setText("0");
        this.rotationZTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.rotationZTextField.setMinimumSize(new Dimension(115, 19));
        this.rotationZTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.rotationPanel.add((Component)this.rotationZTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.createDatumPanel.add((Component)this.rotationPanel, gridBagConstraints);
        this.scalePanel.setLayout(new GridBagLayout());
        this.scaleLabel.setHorizontalAlignment(2);
        this.scaleLabel.setText("Scale:");
        this.scaleLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.scalePanel.add((Component)this.scaleLabel, gridBagConstraints);
        this.scaleTextField.setText("0");
        this.scaleTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.scaleTextField.setMaximumSize(new Dimension(115, 19));
        this.scaleTextField.setMinimumSize(new Dimension(115, 19));
        this.scaleTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.scalePanel.add((Component)this.scaleTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.createDatumPanel.add((Component)this.scalePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.createDatumPanel, gridBagConstraints);
    }

    private void ellipsoidComboBoxActionPerformed(ActionEvent actionEvent) {
        this.ellipsoidComboBox.getSelectedIndex();
    }

    public boolean createDatum() {
        StringHandler stringHandler = new StringHandler();
        double d = stringHandler.stringToDouble(this.deltaXTextField.getText().trim(), "Invalid Delta X");
        double d2 = stringHandler.stringToDouble(this.deltaYTextField.getText().trim(), "Invalid Delta Y");
        double d3 = stringHandler.stringToDouble(this.deltaZTextField.getText().trim(), "Invalid Delta Z");
        double d4 = stringHandler.stringToDouble(this.rotationXTextField.getText().trim(), "Invalid X Rotation");
        double d5 = stringHandler.stringToDouble(this.rotationYTextField.getText().trim(), "Invalid Y Rotation");
        double d6 = stringHandler.stringToDouble(this.rotationZTextField.getText().trim(), "Invalid Z Rotation");
        double d7 = stringHandler.stringToDouble(this.scaleTextField.getText().trim(), "Invalid Scale");
        if (stringHandler.getError()) {
            stringHandler.displayErrorMsg(this);
        } else {
            try {
                Info info = this.jniEllipsoidLibrary.getEllipsoidInfo(this.ellipsoidComboBox.getSelectedIndex());
                this.jniDatumLibrary.defineDatum(1, this.datumCodeTextField.getText().trim(), this.datumNameTextField.getText().trim(), info.getCode(), d, d2, d3, -1.0, -1.0, -1.0, -Math.PI, Math.PI, -1.5707963267948966, 1.5707963267948966, d4, d5, d6, d7);
                return true;
            }
            catch (CoordinateConversionException coordinateConversionException) {
                stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
            }
        }
        return false;
    }
}

