---
stage: Monitor
group: Platform Insights
description: Track errors, application performance issues, customer behavior patterns and manage incident response.
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Monitor your application

Visualize and analyze errors, traces, metrics, logs, product analytics events collected from your application and its infrastructure. Monitor, identify, and resolve performance and customer behavior related issues and incidents collaboratively.

| | | |
|--|--|--|
| [**Getting started**](../user/get_started/get_started_monitoring.md)<br>Overview of how features fit together. | [**Error tracking**](error_tracking.md)<br>Error tracking, logging, debugging, data retention. | [**Distributed tracing**](tracing.md)<br>Monitoring, troubleshooting, performance analysis, request tracking. |
| [**Metrics**](metrics.md) and [**Logs**](logs.md)<br>Monitoring, visualization, aggregation, retention. Centralized logging, analysis, configuration, filtering. | [**Product Analytics**](product_analytics/index.md)<br>Monitor and analyze your customer's behavior and core usage patterns within your applications. | [**Incident management**](incident_management/index.md)<br>Alert handling, response coordination, escalation procedures. |
