---
stage: Application Security Testing
group: Secret Detection
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Secret detection exclusions

DETAILS:
**Tier:** Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated
**Status:** Experiment

> - [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/14878) as an [experiment](../../../policy/experiment-beta-support.md) in GitLab 17.5 [with a flag](../../feature_flags.md) named `secret_detection_project_level_exclusions`. Enabled by default.

FLAG:
The availability of this feature is controlled by a feature flag.
For more information, see the history.
This feature is available for testing, but not ready for production use.

Secret detection may detect something that's not actually a secret. For example, if you use
a fake value as a placeholder in your code, it might be detected and possibly blocked.

To avoid false positives, define a secret detection exclusion. A secret detection exclusion defines a path, a raw value or a rule from the [default ruleset](https://gitlab.com/gitlab-org/gitlab/-/blob/master/gems/gitlab-secret_detection/lib/gitleaks.toml) to exclude from secret detection. You can define multiples of each type of
exclusion for a project.

In the [first iteration](https://gitlab.com/groups/gitlab-org/-/epics/14878) of this feature:

- Exclusions can only be defined for each project.
- Exclusions apply only to [secret push protection](secret_push_protection/index.md).

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For an overview, see [Secret Detection Exclusions - Demonstration](https://www.youtube.com/watch?v=vh_Uh4_4aoc).
<!-- Video published on 2024-10-12 -->

## Add an exclusion

Define an exclusion to avoid false positives from secret detection.

Note the following before defining an exclusion:

- The maximum number of path-based exclusions per project is 10.
- The maximum depth for path-based exclusions is 20.
- Glob patterns are interpreted with Ruby's [`File.fnmatch`](https://docs.ruby-lang.org/en/master/File.html#method-c-fnmatch)
  with the [flags](https://docs.ruby-lang.org/en/master/File/Constants.html#module-File::Constants-label-Filename+Globbing+Constants+-28File-3A-3AFNM_-2A-29)
  `File::FNM_PATHNAME | File::FNM_DOTMATCH | File::FNM_EXTGLOB`.

Prerequisites:

- You must have the **Maintainer** role for the project.

To define an exclusion:

1. In the left sidebar, select **Search or go to** and navigate to your project or group.
1. Select **Secure > Security configuration**.
1. Scroll down to **Secret push protection**.
1. Turn on the **Secret push protection** toggle.
1. Select **Configure Secret Detection** (**{settings}**).
1. Select **Add exclusion** to open the exclusion form.
1. Enter the details of the exclusion, then select **Add Exclusion**.
