(****************************************************************************)
(*                           the diy toolsuite                              *)
(*                                                                          *)
(* Jade Alglave, University College London, UK.                             *)
(* Luc Maranget, INRIA Paris-Rocquencourt, France.                          *)
(*                                                                          *)
(* Copyright 2014-present Institut National de Recherche en Informatique et *)
(* en Automatique and the authors. All rights reserved.                     *)
(*                                                                          *)
(* This software is governed by the CeCILL-B license under French law and   *)
(* abiding by the rules of distribution of free software. You can use,      *)
(* modify and/ or redistribute the software under the terms of the CeCILL-B *)
(* license as circulated by CEA, CNRS and INRIA at the following URL        *)
(* "http://www.cecill.info". We also give a copy in LICENSE.txt.            *)
(****************************************************************************)

(* Restricted arch, with abstract location *)
module type S = sig
  type arch_reg
  module ScopeGen : ScopeGen.S
  include Fence.S
  type location
  val of_loc : Code.loc -> location
  val of_reg : Code.proc -> arch_reg -> location
  val location_compare : location -> location -> int
  val pp_location : location -> string
  val pp_location_brk : location -> string
  val pp_i : int -> string
end
