/* libjclass - Library for reading java class files
 * Copyright (C) 2003  Nicos Panayides
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: jar.h,v 1.6 2004/03/20 14:21:45 anarxia Exp $
 */

/* This file is a modified version of a MAME source file and it has
 * been relicensed under the GPL for libjclass after permission from
 * the original author (Andrea Mazzoleni).
 */

#ifndef __JCLASS_JAR_H__
#define __JCLASS_JAR_H__

#ifdef _cplusplus
 extern "C" {
#endif 

#include <jclassconfig.h>
#include <stdio.h>
#include <jclass/types.h>
#include <jclass/manifest.h>

/* Jar entry structure */
typedef struct {
	/*< private >*/
	char *name;
	uint8_t version_needed_to_extract;
	uint8_t os_needed_to_extract;
	uint16_t compression_method;
	uint32_t compressed_size;
	uint32_t uncompressed_size;
	uint16_t filename_length;
	uint16_t extra_field_length;
	uint16_t file_comment_length;
	uint16_t disk_number_start;
	uint32_t offset_lcl_hdr_frm_frst_disk;
} JarEntry;

/* JarFile structure. */
typedef struct {
	/*< private >*/
	/* zip handler */
	FILE *fp;
	/* length of zip file */
	long length;
	/* end_of_cent_dir data */
	char *ecd;
	/* end_of_cent_dir length */
	unsigned ecd_length;
	/* cent_dir data */
	char *cd;
	/* position in cent_dir */
	unsigned cd_pos;
	/* buffer for readzip */
	JarEntry ent;

	/* end_of_cent_dir */
	uint32_t end_of_cent_dir_sig;
	uint16_t number_of_this_disk;
	uint16_t number_of_disk_start_cent_dir;
	uint16_t total_entries_cent_dir_this_disk;
	uint16_t total_entries_cent_dir;
	uint32_t size_of_cent_dir;
	uint32_t offset_to_start_of_cent_dir;
} JarFile;

JarFile* jclass_jar_open(const char* filename);
void jclass_jar_close(JarFile* jar);
void jclass_jar_rewind(JarFile* jar);
const JarEntry* jclass_jar_get_next_entry(JarFile* jar);
const JarEntry* jclass_jar_get_entry(JarFile* jar, const char* name);

char* jclass_jar_entry_read(JarFile* jar, const JarEntry* entry);
uint32_t jclass_jar_entry_get_size(const JarEntry *entry);
const char *jclass_jar_entry_get_name(const JarEntry *entry);

Manifest *jclass_jar_get_manifest(JarFile *jar);

#ifdef _cplusplus
 }
#endif 

#endif
