// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX11 %s
// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX11 %s

flat_atomic_add_f32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0x58,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_add_f32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x58,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_add_u32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xd4,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_add_u32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xd4,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_add_u32 v[3:4], v5 slc
// GFX11: encoding: [0x00,0x80,0xd4,0xdc,0x03,0x05,0x7c,0x00]

flat_atomic_add_u64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x0c,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_add_u64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x0c,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_and_b32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xf0,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_and_b32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xf0,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_and_b64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x24,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_and_b64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x24,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] glc slc
// GFX11: encoding: [0x00,0xc0,0xd0,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] glc
// GFX11: encoding: [0x00,0x40,0xd0,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0xd0,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] offset:2047 glc
// GFX11: encoding: [0xff,0x47,0xd0,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_cmpswap_b32 v1, v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0xd0,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_cmpswap_b32 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0xd0,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_cmpswap_b64 v[0:1], v[2:5] offset:64
// GFX11: [0x40,0x00,0x08,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_cmpswap_b64 v[1:2], v[0:1], v[2:5] offset:64 glc
// GFX11: [0x40,0x40,0x08,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] glc slc
// GFX11: encoding: [0x00,0xc0,0x08,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] glc
// GFX11: encoding: [0x00,0x40,0x08,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0x08,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] offset:2047 glc
// GFX11: encoding: [0xff,0x47,0x08,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_cmpswap_f32 v1, v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x40,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_cmpswap_f32 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x40,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_dec_u32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0x00,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_dec_u32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x00,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_dec_u64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x34,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_dec_u64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x34,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_inc_u32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xfc,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_inc_u32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xfc,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_inc_u64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x30,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_inc_u64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x30,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_max_f32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0x48,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_max_f32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x48,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_max_i32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xe8,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_max_i32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xe8,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_max_i64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x1c,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_max_i64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x1c,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_max_u32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xec,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_max_u32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xec,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_max_u64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x20,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_max_u64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x20,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_min_f32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0x44,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_min_f32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x44,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_min_i32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xe0,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_min_i32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xe0,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_min_i64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x14,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_min_i64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x14,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_min_u32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xe4,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_min_u32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xe4,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_min_u64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x18,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_min_u64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x18,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_or_b32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xf4,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_or_b32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xf4,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_or_b64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x28,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_or_b64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x28,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_sub_u32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xd8,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_sub_u32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xd8,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_sub_u64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x10,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_sub_u64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x10,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_swap_b32 v0, v[1:2], v3 glc slc
// GFX11: encoding: [0x00,0xc0,0xcc,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 glc
// GFX11: encoding: [0x00,0x40,0xcc,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0xcc,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 offset:2047 glc
// GFX11: encoding: [0xff,0x47,0xcc,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 offset:2048 glc
// GFX11: encoding: [0x00,0x48,0xcc,0xdc,0x01,0x03,0x7c,0x00]

flat_atomic_swap_b32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xcc,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_swap_b32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xcc,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_swap_b64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x04,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_swap_b64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x04,0xdd,0x00,0x02,0x7c,0x01]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] glc slc
// GFX11: encoding: [0x00,0xc0,0x04,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] glc
// GFX11: encoding: [0x00,0x40,0x04,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0x04,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] offset:2047 glc
// GFX11: encoding: [0xff,0x47,0x04,0xdd,0x03,0x05,0x7c,0x01]

flat_atomic_xor_b32 v1, v[0:1], v2 offset:64 glc
// GFX11: [0x40,0x40,0xf8,0xdc,0x00,0x02,0x7c,0x01]

flat_atomic_xor_b32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0xf8,0xdc,0x00,0x02,0x7c,0x00]

flat_atomic_xor_b64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x2c,0xdd,0x00,0x02,0x7c,0x00]

flat_atomic_xor_b64 v[1:2], v[0:1], v[2:3] offset:64 glc
// GFX11: [0x40,0x40,0x2c,0xdd,0x00,0x02,0x7c,0x01]

flat_load_b128 v[1:4], v[0:1] offset:64
// GFX11: [0x40,0x00,0x5c,0xdc,0x00,0x00,0x7c,0x01]

flat_load_b128 v[1:4], v[5:6]
// GFX11: encoding: [0x00,0x00,0x5c,0xdc,0x05,0x00,0x7c,0x01]

flat_load_b32 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x50,0xdc,0x00,0x00,0x7c,0x01]

flat_load_b32 v1, v[3:4] offset:2047
// GFX11: encoding: [0xff,0x07,0x50,0xdc,0x03,0x00,0x7c,0x01]

flat_load_b32 v1, v[3:4] offset:2048
// GFX11: encoding: [0x00,0x08,0x50,0xdc,0x03,0x00,0x7c,0x01]

flat_load_b32 v1, v[3:4] offset:4 glc slc dlc
// GFX11: encoding: [0x04,0xe0,0x50,0xdc,0x03,0x00,0x7c,0x01]

flat_load_b32 v1, v[3:4] offset:4 glc slc
// GFX11: encoding: [0x04,0xc0,0x50,0xdc,0x03,0x00,0x7c,0x01]

flat_load_b32 v1, v[3:4] offset:4 glc
// GFX11: encoding: [0x04,0x40,0x50,0xdc,0x03,0x00,0x7c,0x01]

flat_load_b32 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x50,0xdc,0x03,0x00,0x7c,0x01]

flat_load_b64 v[1:2], v[0:1] offset:64
// GFX11: [0x40,0x00,0x54,0xdc,0x00,0x00,0x7c,0x01]

flat_load_b64 v[1:2], v[3:4]
// GFX11: encoding: [0x00,0x00,0x54,0xdc,0x03,0x00,0x7c,0x01]

flat_load_b96 v[1:3], v[0:1] offset:64
// GFX11: [0x40,0x00,0x58,0xdc,0x00,0x00,0x7c,0x01]

flat_load_b96 v[1:3], v[5:6]
// GFX11: encoding: [0x00,0x00,0x58,0xdc,0x05,0x00,0x7c,0x01]

flat_load_d16_b16 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x80,0xdc,0x00,0x00,0x7c,0x01]

flat_load_d16_b16 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x80,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_b16 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x80,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_hi_b16 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x8c,0xdc,0x00,0x00,0x7c,0x01]

flat_load_d16_hi_b16 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x8c,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_hi_i8 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x88,0xdc,0x00,0x00,0x7c,0x01]

flat_load_d16_hi_i8 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x88,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_hi_i8 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x88,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_hi_u8 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x84,0xdc,0x00,0x00,0x7c,0x01]

flat_load_d16_hi_u8 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x84,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_i8 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x7c,0xdc,0x00,0x00,0x7c,0x01]

flat_load_d16_i8 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x7c,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_i8 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x7c,0xdc,0x03,0x00,0x7c,0x01]

flat_load_d16_u8 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x78,0xdc,0x00,0x00,0x7c,0x01]

flat_load_d16_u8 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x78,0xdc,0x03,0x00,0x7c,0x01]

flat_load_i16 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x4c,0xdc,0x00,0x00,0x7c,0x01]

flat_load_i16 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x4c,0xdc,0x03,0x00,0x7c,0x01]

flat_load_i8 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x44,0xdc,0x00,0x00,0x7c,0x01]

flat_load_i8 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x44,0xdc,0x03,0x00,0x7c,0x01]

flat_load_u16 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x48,0xdc,0x00,0x00,0x7c,0x01]

flat_load_u16 v1, v[3:4]
// GFX11: encoding: [0x00,0x00,0x48,0xdc,0x03,0x00,0x7c,0x01]

flat_load_u8 v1, v[0:1] offset:64
// GFX11: [0x40,0x00,0x40,0xdc,0x00,0x00,0x7c,0x01]

flat_load_u8 v1, v[3:4]
// GFX11-LABEL: flat_load_u8 v1, v[3:4] ; encoding: [0x00,0x00,0x40,0xdc,0x03,0x00,0x7c,0x01]

flat_store_b128 v[0:1], v[2:5] offset:64
// GFX11: [0x40,0x00,0x74,0xdc,0x00,0x02,0x7c,0x00]

flat_store_b128 v[1:2], v[3:6]
// GFX11: encoding: [0x00,0x00,0x74,0xdc,0x01,0x03,0x7c,0x00]

flat_store_b16 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x64,0xdc,0x00,0x02,0x7c,0x00]

flat_store_b16 v[3:4], v1
// GFX11: encoding: [0x00,0x00,0x64,0xdc,0x03,0x01,0x7c,0x00]

flat_store_b32 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x68,0xdc,0x00,0x02,0x7c,0x00]

flat_store_b32 v[3:4], v1 offset:16
// GFX11: encoding: [0x10,0x00,0x68,0xdc,0x03,0x01,0x7c,0x00]

flat_store_b64 v[0:1], v[2:3] offset:64
// GFX11: [0x40,0x00,0x6c,0xdc,0x00,0x02,0x7c,0x00]

flat_store_b64 v[1:2], v[3:4]
// GFX11: encoding: [0x00,0x00,0x6c,0xdc,0x01,0x03,0x7c,0x00]

flat_store_b8 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x60,0xdc,0x00,0x02,0x7c,0x00]

flat_store_b8 v[3:4], v1
// GFX11: encoding: [0x00,0x00,0x60,0xdc,0x03,0x01,0x7c,0x00]

flat_store_b96 v[0:1], v[2:4] offset:64
// GFX11: [0x40,0x00,0x70,0xdc,0x00,0x02,0x7c,0x00]

flat_store_b96 v[1:2], v[3:5]
// GFX11: encoding: [0x00,0x00,0x70,0xdc,0x01,0x03,0x7c,0x00]

flat_store_d16_hi_b16 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x94,0xdc,0x00,0x02,0x7c,0x00]

flat_store_d16_hi_b16 v[3:4], v1
// GFX11: encoding: [0x00,0x00,0x94,0xdc,0x03,0x01,0x7c,0x00]

flat_store_d16_hi_b8 v[0:1], v2 offset:64
// GFX11: [0x40,0x00,0x90,0xdc,0x00,0x02,0x7c,0x00]

flat_store_d16_hi_b8 v[3:4], v1
// GFX11: encoding: [0x00,0x00,0x90,0xdc,0x03,0x01,0x7c,0x00]

global_atomic_add_f32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x5a,0xdd,0x00,0x02,0x00,0x00]

global_atomic_add_f32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x5a,0xdd,0x00,0x02,0x00,0x01]

global_atomic_add_f32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0x5a,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_add_f32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x5a,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_add_u32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xd6,0xdc,0x00,0x02,0x00,0x00]

global_atomic_add_u32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xd6,0xdc,0x00,0x02,0x00,0x01]

global_atomic_add_u32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xd6,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_add_u32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xd6,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_add_u64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x0e,0xdd,0x00,0x02,0x00,0x00]

global_atomic_add_u64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x0e,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_add_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x0e,0xdd,0x00,0x02,0x00,0x01]

global_atomic_add_u64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x0e,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_and_b32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xf2,0xdc,0x00,0x02,0x00,0x00]

global_atomic_and_b32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xf2,0xdc,0x00,0x02,0x00,0x01]

global_atomic_and_b32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xf2,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_and_b32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xf2,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_and_b64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x26,0xdd,0x00,0x02,0x00,0x00]

global_atomic_and_b64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x26,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_and_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x26,0xdd,0x00,0x02,0x00,0x01]

global_atomic_and_b64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x26,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] glc slc
// GFX11: encoding: [0x00,0xc0,0xd2,0xdc,0x01,0x02,0x02,0x00]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] glc
// GFX11: encoding: [0x00,0x40,0xd2,0xdc,0x01,0x02,0x02,0x00]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0xd2,0xdc,0x01,0x02,0x02,0x00]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] offset:2047 glc
// GFX11: encoding: [0xff,0x47,0xd2,0xdc,0x01,0x02,0x02,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off glc slc
// GFX11: encoding: [0x00,0xc0,0xd2,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off glc
// GFX11: encoding: [0x00,0x40,0xd2,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0xd2,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off offset:2047 glc
// GFX11: encoding: [0xff,0x47,0xd2,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_cmpswap_b32 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0xd2,0xdc,0x00,0x02,0x00,0x00]

global_atomic_cmpswap_b32 v1, v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xd2,0xdc,0x00,0x02,0x00,0x01]

global_atomic_cmpswap_b32 v1, v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0xd2,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_cmpswap_b32 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0xd2,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_cmpswap_b64 v0, v[2:5], s[0:1] offset:64
// GFX11: [0x40,0x00,0x0a,0xdd,0x00,0x02,0x00,0x00]

global_atomic_cmpswap_b64 v[0:1], v[2:5], off offset:64
// GFX11: [0x40,0x00,0x0a,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_cmpswap_b64 v[1:2], v0, v[2:5], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x0a,0xdd,0x00,0x02,0x00,0x01]

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] glc slc
// GFX11: encoding: [0x00,0xc0,0x0a,0xdd,0x03,0x05,0x02,0x01]

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] glc
// GFX11: encoding: [0x00,0x40,0x0a,0xdd,0x03,0x05,0x02,0x01]

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0x0a,0xdd,0x03,0x05,0x02,0x01]

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] offset:2047 glc
// GFX11: encoding: [0xff,0x47,0x0a,0xdd,0x03,0x05,0x02,0x01]

global_atomic_cmpswap_b64 v[1:2], v[0:1], v[2:5], off offset:64 glc
// GFX11: [0x40,0x40,0x0a,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off glc slc
// GFX11: encoding: [0x00,0xc0,0x0a,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off glc
// GFX11: encoding: [0x00,0x40,0x0a,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0x0a,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off offset:2047 glc
// GFX11: encoding: [0xff,0x47,0x0a,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_cmpswap_f32 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x42,0xdd,0x00,0x02,0x00,0x00]

global_atomic_cmpswap_f32 v1, v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x42,0xdd,0x00,0x02,0x00,0x01]

global_atomic_cmpswap_f32 v1, v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x42,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_cmpswap_f32 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x42,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_csub_u32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xde,0xdc,0x00,0x02,0x00,0x01]

global_atomic_csub_u32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xde,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_dec_u32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x02,0xdd,0x00,0x02,0x00,0x00]

global_atomic_dec_u32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x02,0xdd,0x00,0x02,0x00,0x01]

global_atomic_dec_u32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0x02,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_dec_u32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x02,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_dec_u64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x36,0xdd,0x00,0x02,0x00,0x00]

global_atomic_dec_u64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x36,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_dec_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x36,0xdd,0x00,0x02,0x00,0x01]

global_atomic_dec_u64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x36,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_inc_u32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xfe,0xdc,0x00,0x02,0x00,0x00]

global_atomic_inc_u32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xfe,0xdc,0x00,0x02,0x00,0x01]

global_atomic_inc_u32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xfe,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_inc_u32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xfe,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_inc_u64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x32,0xdd,0x00,0x02,0x00,0x00]

global_atomic_inc_u64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x32,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_inc_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x32,0xdd,0x00,0x02,0x00,0x01]

global_atomic_inc_u64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x32,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_max_f32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x4a,0xdd,0x00,0x02,0x00,0x00]

global_atomic_max_f32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x4a,0xdd,0x00,0x02,0x00,0x01]

global_atomic_max_f32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0x4a,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_max_f32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x4a,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_max_i32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xea,0xdc,0x00,0x02,0x00,0x00]

global_atomic_max_i32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xea,0xdc,0x00,0x02,0x00,0x01]

global_atomic_max_i32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xea,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_max_i32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xea,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_max_i64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x1e,0xdd,0x00,0x02,0x00,0x00]

global_atomic_max_i64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x1e,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_max_i64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x1e,0xdd,0x00,0x02,0x00,0x01]

global_atomic_max_i64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x1e,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_max_u32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xee,0xdc,0x00,0x02,0x00,0x00]

global_atomic_max_u32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xee,0xdc,0x00,0x02,0x00,0x01]

global_atomic_max_u32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xee,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_max_u32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xee,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_max_u64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x22,0xdd,0x00,0x02,0x00,0x00]

global_atomic_max_u64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x22,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_max_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x22,0xdd,0x00,0x02,0x00,0x01]

global_atomic_max_u64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x22,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_min_f32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x46,0xdd,0x00,0x02,0x00,0x00]

global_atomic_min_f32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x46,0xdd,0x00,0x02,0x00,0x01]

global_atomic_min_f32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0x46,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_min_f32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x46,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_min_i32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xe2,0xdc,0x00,0x02,0x00,0x00]

global_atomic_min_i32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xe2,0xdc,0x00,0x02,0x00,0x01]

global_atomic_min_i32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xe2,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_min_i32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xe2,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_min_i64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x16,0xdd,0x00,0x02,0x00,0x00]

global_atomic_min_i64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x16,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_min_i64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x16,0xdd,0x00,0x02,0x00,0x01]

global_atomic_min_i64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x16,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_min_u32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xe6,0xdc,0x00,0x02,0x00,0x00]

global_atomic_min_u32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xe6,0xdc,0x00,0x02,0x00,0x01]

global_atomic_min_u32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xe6,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_min_u32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xe6,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_min_u64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x1a,0xdd,0x00,0x02,0x00,0x00]

global_atomic_min_u64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x1a,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_min_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x1a,0xdd,0x00,0x02,0x00,0x01]

global_atomic_min_u64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x1a,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_or_b32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xf6,0xdc,0x00,0x02,0x00,0x00]

global_atomic_or_b32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xf6,0xdc,0x00,0x02,0x00,0x01]

global_atomic_or_b32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xf6,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_or_b32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xf6,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_or_b64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x2a,0xdd,0x00,0x02,0x00,0x00]

global_atomic_or_b64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x2a,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_or_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x2a,0xdd,0x00,0x02,0x00,0x01]

global_atomic_or_b64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x2a,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_sub_u32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xda,0xdc,0x00,0x02,0x00,0x00]

global_atomic_sub_u32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xda,0xdc,0x00,0x02,0x00,0x01]

global_atomic_sub_u32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xda,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_sub_u32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xda,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_sub_u64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x12,0xdd,0x00,0x02,0x00,0x00]

global_atomic_sub_u64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x12,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_sub_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x12,0xdd,0x00,0x02,0x00,0x01]

global_atomic_sub_u64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x12,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_swap_b32 v0, v1, v3, s[2:3] glc slc
// GFX11: encoding: [0x00,0xc0,0xce,0xdc,0x01,0x03,0x02,0x00]

global_atomic_swap_b32 v0, v1, v3, s[2:3] glc
// GFX11: encoding: [0x00,0x40,0xce,0xdc,0x01,0x03,0x02,0x00]

global_atomic_swap_b32 v0, v1, v3, s[2:3] offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0xce,0xdc,0x01,0x03,0x02,0x00]

global_atomic_swap_b32 v0, v1, v3, s[2:3] offset:2047 glc
// GFX11: encoding: [0xff,0x47,0xce,0xdc,0x01,0x03,0x02,0x00]

global_atomic_swap_b32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xce,0xdc,0x00,0x02,0x00,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off glc slc
// GFX11: encoding: [0x00,0xc0,0xce,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off glc
// GFX11: encoding: [0x00,0x40,0xce,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0xce,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off offset:2047 glc
// GFX11: encoding: [0xff,0x47,0xce,0xdc,0x01,0x03,0x7c,0x00]

global_atomic_swap_b32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xce,0xdc,0x00,0x02,0x00,0x01]

global_atomic_swap_b32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xce,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_swap_b32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xce,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_swap_b64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x06,0xdd,0x00,0x02,0x00,0x00]

global_atomic_swap_b64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x06,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_swap_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x06,0xdd,0x00,0x02,0x00,0x01]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] glc slc
// GFX11: encoding: [0x00,0xc0,0x06,0xdd,0x03,0x05,0x02,0x01]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] glc
// GFX11: encoding: [0x00,0x40,0x06,0xdd,0x03,0x05,0x02,0x01]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0x06,0xdd,0x03,0x05,0x02,0x01]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] offset:2047 glc
// GFX11: encoding: [0xff,0x47,0x06,0xdd,0x03,0x05,0x02,0x01]

global_atomic_swap_b64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x06,0xdd,0x00,0x02,0x7c,0x01]

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off glc slc
// GFX11: encoding: [0x00,0xc0,0x06,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off glc
// GFX11: encoding: [0x00,0x40,0x06,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off offset:2047 glc slc
// GFX11: encoding: [0xff,0xc7,0x06,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off offset:2047 glc
// GFX11: encoding: [0xff,0x47,0x06,0xdd,0x03,0x05,0x7c,0x01]

global_atomic_xor_b32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xfa,0xdc,0x00,0x02,0x00,0x00]

global_atomic_xor_b32 v1, v0, v2, s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0xfa,0xdc,0x00,0x02,0x00,0x01]

global_atomic_xor_b32 v1, v[0:1], v2, off offset:64 glc
// GFX11: [0x40,0x40,0xfa,0xdc,0x00,0x02,0x7c,0x01]

global_atomic_xor_b32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0xfa,0xdc,0x00,0x02,0x7c,0x00]

global_atomic_xor_b64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x2e,0xdd,0x00,0x02,0x00,0x00]

global_atomic_xor_b64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x2e,0xdd,0x00,0x02,0x7c,0x00]

global_atomic_xor_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 glc
// GFX11: [0x40,0x40,0x2e,0xdd,0x00,0x02,0x00,0x01]

global_atomic_xor_b64 v[1:2], v[0:1], v[2:3], off offset:64 glc
// GFX11: [0x40,0x40,0x2e,0xdd,0x00,0x02,0x7c,0x01]

global_load_addtid_b32 v1, off offset:64
// GFX11: [0x40,0x00,0xa2,0xdc,0x00,0x00,0x7c,0x01]

global_load_addtid_b32 v1, off
// GFX11: encoding: [0x00,0x00,0xa2,0xdc,0x00,0x00,0x7c,0x01]

global_load_addtid_b32 v1, s[0:1] offset:64
// GFX11: [0x40,0x00,0xa2,0xdc,0x00,0x00,0x00,0x01]

global_load_addtid_b32 v1, s[2:3]
// GFX11: encoding: [0x00,0x00,0xa2,0xdc,0x00,0x00,0x02,0x01]

global_load_b128 v[1:4], v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x5e,0xdc,0x00,0x00,0x00,0x01]

global_load_b128 v[1:4], v5, s[2:3]
// GFX11: encoding: [0x00,0x00,0x5e,0xdc,0x05,0x00,0x02,0x01]

global_load_b128 v[1:4], v[0:1], off offset:64
// GFX11: [0x40,0x00,0x5e,0xdc,0x00,0x00,0x7c,0x01]

global_load_b128 v[1:4], v[5:6], off
// GFX11: encoding: [0x00,0x00,0x5e,0xdc,0x05,0x00,0x7c,0x01]

global_load_b32 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x52,0xdc,0x00,0x00,0x00,0x01]

global_load_b32 v1, v3, s[2:3] offset:2047
// GFX11: encoding: [0xff,0x07,0x52,0xdc,0x03,0x00,0x02,0x01]

global_load_b32 v1, v3, s[2:3] offset:4 glc slc dlc
// GFX11: encoding: [0x04,0xe0,0x52,0xdc,0x03,0x00,0x02,0x01]

global_load_b32 v1, v3, s[2:3] offset:4 glc slc
// GFX11: encoding: [0x04,0xc0,0x52,0xdc,0x03,0x00,0x02,0x01]

global_load_b32 v1, v3, s[2:3] offset:4 glc
// GFX11: encoding: [0x04,0x40,0x52,0xdc,0x03,0x00,0x02,0x01]

global_load_b32 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x52,0xdc,0x03,0x00,0x02,0x01]

global_load_b32 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x52,0xdc,0x00,0x00,0x7c,0x01]

global_load_b32 v1, v[3:4], off offset:2047
// GFX11: encoding: [0xff,0x07,0x52,0xdc,0x03,0x00,0x7c,0x01]

global_load_b32 v1, v[3:4], off offset:4 glc slc dlc
// GFX11: encoding: [0x04,0xe0,0x52,0xdc,0x03,0x00,0x7c,0x01]

global_load_b32 v1, v[3:4], off offset:4 glc slc
// GFX11: encoding: [0x04,0xc0,0x52,0xdc,0x03,0x00,0x7c,0x01]

global_load_b32 v1, v[3:4], off offset:4 glc
// GFX11: encoding: [0x04,0x40,0x52,0xdc,0x03,0x00,0x7c,0x01]

global_load_b32 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x52,0xdc,0x03,0x00,0x7c,0x01]

global_load_b64 v[1:2], v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x56,0xdc,0x00,0x00,0x00,0x01]

global_load_b64 v[1:2], v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x56,0xdc,0x03,0x00,0x02,0x01]

global_load_b64 v[1:2], v[0:1], off offset:64
// GFX11: [0x40,0x00,0x56,0xdc,0x00,0x00,0x7c,0x01]

global_load_b64 v[1:2], v[3:4], off
// GFX11: encoding: [0x00,0x00,0x56,0xdc,0x03,0x00,0x7c,0x01]

global_load_b96 v[1:3], v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x5a,0xdc,0x00,0x00,0x00,0x01]

global_load_b96 v[1:3], v5, s[2:3]
// GFX11: encoding: [0x00,0x00,0x5a,0xdc,0x05,0x00,0x02,0x01]

global_load_b96 v[1:3], v[0:1], off offset:64
// GFX11: [0x40,0x00,0x5a,0xdc,0x00,0x00,0x7c,0x01]

global_load_b96 v[1:3], v[5:6], off
// GFX11: encoding: [0x00,0x00,0x5a,0xdc,0x05,0x00,0x7c,0x01]

global_load_d16_b16 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x82,0xdc,0x00,0x00,0x00,0x01]

global_load_d16_b16 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x82,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_b16 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x82,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_b16 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x82,0xdc,0x00,0x00,0x7c,0x01]

global_load_d16_b16 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x82,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_b16 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x82,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_hi_b16 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x8e,0xdc,0x00,0x00,0x00,0x01]

global_load_d16_hi_b16 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x8e,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_hi_b16 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x8e,0xdc,0x00,0x00,0x7c,0x01]

global_load_d16_hi_b16 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x8e,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_hi_i8 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x8a,0xdc,0x00,0x00,0x00,0x01]

global_load_d16_hi_i8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x8a,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_hi_i8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x8a,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_hi_i8 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x8a,0xdc,0x00,0x00,0x7c,0x01]

global_load_d16_hi_i8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x8a,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_hi_i8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x8a,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_hi_u8 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x86,0xdc,0x00,0x00,0x00,0x01]

global_load_d16_hi_u8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x86,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_hi_u8 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x86,0xdc,0x00,0x00,0x7c,0x01]

global_load_d16_hi_u8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x86,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_i8 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x7e,0xdc,0x00,0x00,0x00,0x01]

global_load_d16_i8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x7e,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_i8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x7e,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_i8 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x7e,0xdc,0x00,0x00,0x7c,0x01]

global_load_d16_i8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x7e,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_i8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x7e,0xdc,0x03,0x00,0x7c,0x01]

global_load_d16_u8 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x7a,0xdc,0x00,0x00,0x00,0x01]

global_load_d16_u8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x7a,0xdc,0x03,0x00,0x02,0x01]

global_load_d16_u8 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x7a,0xdc,0x00,0x00,0x7c,0x01]

global_load_d16_u8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x7a,0xdc,0x03,0x00,0x7c,0x01]

global_load_i16 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x4e,0xdc,0x00,0x00,0x00,0x01]

global_load_i16 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x4e,0xdc,0x03,0x00,0x02,0x01]

global_load_i16 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x4e,0xdc,0x00,0x00,0x7c,0x01]

global_load_i16 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x4e,0xdc,0x03,0x00,0x7c,0x01]

global_load_i8 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x46,0xdc,0x00,0x00,0x00,0x01]

global_load_i8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x46,0xdc,0x03,0x00,0x02,0x01]

global_load_i8 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x46,0xdc,0x00,0x00,0x7c,0x01]

global_load_i8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x46,0xdc,0x03,0x00,0x7c,0x01]

global_load_u16 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x4a,0xdc,0x00,0x00,0x00,0x01]

global_load_u16 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x4a,0xdc,0x03,0x00,0x02,0x01]

global_load_u16 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x4a,0xdc,0x00,0x00,0x7c,0x01]

global_load_u16 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x4a,0xdc,0x03,0x00,0x7c,0x01]

global_load_u8 v1, v0, s[0:1] offset:64
// GFX11: [0x40,0x00,0x42,0xdc,0x00,0x00,0x00,0x01]

global_load_u8 v1, v3, s[2:3]
// GFX11: encoding: [0x00,0x00,0x42,0xdc,0x03,0x00,0x02,0x01]

global_load_u8 v1, v[0:1], off offset:64
// GFX11: [0x40,0x00,0x42,0xdc,0x00,0x00,0x7c,0x01]

global_load_u8 v1, v[3:4], off
// GFX11: encoding: [0x00,0x00,0x42,0xdc,0x03,0x00,0x7c,0x01]

global_store_addtid_b32 v2, off offset:64
// GFX11: [0x40,0x00,0xa6,0xdc,0x00,0x02,0x7c,0x00]

global_store_addtid_b32 v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0xa6,0xdc,0x00,0x02,0x00,0x00]

global_store_b128 v0, v[2:5], s[0:1] offset:64
// GFX11: [0x40,0x00,0x76,0xdc,0x00,0x02,0x00,0x00]

global_store_b128 v1, v[3:6], s[2:3]
// GFX11: encoding: [0x00,0x00,0x76,0xdc,0x01,0x03,0x02,0x00]

global_store_b128 v[0:1], v[2:5], off offset:64
// GFX11: [0x40,0x00,0x76,0xdc,0x00,0x02,0x7c,0x00]

global_store_b128 v[1:2], v[3:6], off
// GFX11: encoding: [0x00,0x00,0x76,0xdc,0x01,0x03,0x7c,0x00]

global_store_b16 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x66,0xdc,0x00,0x02,0x00,0x00]

global_store_b16 v3, v1, s[2:3]
// GFX11: encoding: [0x00,0x00,0x66,0xdc,0x03,0x01,0x02,0x00]

global_store_b16 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x66,0xdc,0x00,0x02,0x7c,0x00]

global_store_b16 v[3:4], v1, off
// GFX11: encoding: [0x00,0x00,0x66,0xdc,0x03,0x01,0x7c,0x00]

global_store_b32 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x6a,0xdc,0x00,0x02,0x00,0x00]

global_store_b32 v3, v1, s[2:3] offset:16
// GFX11: encoding: [0x10,0x00,0x6a,0xdc,0x03,0x01,0x02,0x00]

global_store_b32 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x6a,0xdc,0x00,0x02,0x7c,0x00]

global_store_b32 v[3:4], v1, off offset:16
// GFX11: encoding: [0x10,0x00,0x6a,0xdc,0x03,0x01,0x7c,0x00]

global_store_b64 v0, v[2:3], s[0:1] offset:64
// GFX11: [0x40,0x00,0x6e,0xdc,0x00,0x02,0x00,0x00]

global_store_b64 v1, v[2:3], s[2:3]
// GFX11: encoding: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x02,0x00]

global_store_b64 v[0:1], v[2:3], off offset:64
// GFX11: [0x40,0x00,0x6e,0xdc,0x00,0x02,0x7c,0x00]

global_store_b64 v[1:2], v[3:4], off
// GFX11: encoding: [0x00,0x00,0x6e,0xdc,0x01,0x03,0x7c,0x00]

global_store_b8 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x62,0xdc,0x00,0x02,0x00,0x00]

global_store_b8 v3, v1, s[2:3]
// GFX11: encoding: [0x00,0x00,0x62,0xdc,0x03,0x01,0x02,0x00]

global_store_b8 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x62,0xdc,0x00,0x02,0x7c,0x00]

global_store_b8 v[3:4], v1, off
// GFX11: encoding: [0x00,0x00,0x62,0xdc,0x03,0x01,0x7c,0x00]

global_store_b96 v0, v[2:4], s[0:1] offset:64
// GFX11: [0x40,0x00,0x72,0xdc,0x00,0x02,0x00,0x00]

global_store_b96 v1, v[3:5], s[2:3]
// GFX11: encoding: [0x00,0x00,0x72,0xdc,0x01,0x03,0x02,0x00]

global_store_b96 v[0:1], v[2:4], off offset:64
// GFX11: [0x40,0x00,0x72,0xdc,0x00,0x02,0x7c,0x00]

global_store_b96 v[1:2], v[3:5], off
// GFX11: encoding: [0x00,0x00,0x72,0xdc,0x01,0x03,0x7c,0x00]

global_store_d16_hi_b16 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x96,0xdc,0x00,0x02,0x00,0x00]

global_store_d16_hi_b16 v3, v1, s[2:3]
// GFX11: encoding: [0x00,0x00,0x96,0xdc,0x03,0x01,0x02,0x00]

global_store_d16_hi_b16 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x96,0xdc,0x00,0x02,0x7c,0x00]

global_store_d16_hi_b16 v[3:4], v1, off
// GFX11: encoding: [0x00,0x00,0x96,0xdc,0x03,0x01,0x7c,0x00]

global_store_d16_hi_b8 v0, v2, s[0:1] offset:64
// GFX11: [0x40,0x00,0x92,0xdc,0x00,0x02,0x00,0x00]

global_store_d16_hi_b8 v3, v1, s[2:3]
// GFX11: encoding: [0x00,0x00,0x92,0xdc,0x03,0x01,0x02,0x00]

global_store_d16_hi_b8 v[0:1], v2, off offset:64
// GFX11: [0x40,0x00,0x92,0xdc,0x00,0x02,0x7c,0x00]

global_store_d16_hi_b8 v[3:4], v1, off
// GFX11: encoding: [0x00,0x00,0x92,0xdc,0x03,0x01,0x7c,0x00]

scratch_load_b128 v[1:4], off, off offset:64
// GFX11: [0x40,0x00,0x5d,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_b128 v[1:4], off, s0 offset:64
// GFX11: [0x40,0x00,0x5d,0xdc,0x00,0x00,0x00,0x01]

scratch_load_b128 v[1:4], v0, off offset:64
// GFX11: [0x40,0x00,0x5d,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_b128 v[1:4], v0, s0 offset:64
// GFX11: [0x40,0x00,0x5d,0xdc,0x00,0x00,0x80,0x01]

scratch_load_b128 v[1:4], v2, s1
// GFX11: encoding: [0x00,0x00,0x5d,0xdc,0x02,0x00,0x81,0x01]

scratch_load_b32 v1, off, off offset:2047
// GFX11: encoding: [0xff,0x07,0x51,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_b32 v1, off, off offset:64
// GFX11: [0x40,0x00,0x51,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_b32 v1, off, off
// GFX11: encoding: [0x00,0x00,0x51,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_b32 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x51,0xdc,0x00,0x00,0x00,0x01]

scratch_load_b32 v1, off, s1 offset:2047
// GFX11: encoding: [0xff,0x07,0x51,0xdc,0x00,0x00,0x01,0x01]

scratch_load_b32 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x51,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_b32 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x51,0xdc,0x00,0x00,0x80,0x01]

scratch_load_b32 v1, v2, off offset:2047
// GFX11: encoding: [0xff,0x07,0x51,0xdc,0x02,0x00,0xfc,0x01]

scratch_load_b32 v1, v2, s1 offset:-4096
// GFX11: encoding: [0x00,0x10,0x51,0xdc,0x02,0x00,0x81,0x01]

scratch_load_b32 v1, v2, s1 offset:2047
// GFX11: encoding: [0xff,0x07,0x51,0xdc,0x02,0x00,0x81,0x01]

scratch_load_b32 v1, v2, s1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x51,0xdc,0x02,0x00,0x81,0x01]

scratch_load_b32 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x51,0xdc,0x02,0x00,0x81,0x01]

scratch_load_b64 v[1:2], off, off offset:64
// GFX11: [0x40,0x00,0x55,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_b64 v[1:2], off, s0 offset:64
// GFX11: [0x40,0x00,0x55,0xdc,0x00,0x00,0x00,0x01]

scratch_load_b64 v[1:2], v0, off offset:64
// GFX11: [0x40,0x00,0x55,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_b64 v[1:2], v0, s0 offset:64
// GFX11: [0x40,0x00,0x55,0xdc,0x00,0x00,0x80,0x01]

scratch_load_b64 v[1:2], v2, s1
// GFX11: encoding: [0x00,0x00,0x55,0xdc,0x02,0x00,0x81,0x01]

scratch_load_b96 v[1:3], off, off offset:64
// GFX11: [0x40,0x00,0x59,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_b96 v[1:3], off, s0 offset:64
// GFX11: [0x40,0x00,0x59,0xdc,0x00,0x00,0x00,0x01]

scratch_load_b96 v[1:3], v0, off offset:64
// GFX11: [0x40,0x00,0x59,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_b96 v[1:3], v0, s0 offset:64
// GFX11: [0x40,0x00,0x59,0xdc,0x00,0x00,0x80,0x01]

scratch_load_b96 v[1:3], v2, s1
// GFX11: encoding: [0x00,0x00,0x59,0xdc,0x02,0x00,0x81,0x01]

scratch_load_d16_b16 v1, off, off offset:64
// GFX11: [0x40,0x00,0x81,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_d16_b16 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x81,0xdc,0x00,0x00,0x00,0x01]

scratch_load_d16_b16 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x81,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_d16_b16 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x81,0xdc,0x00,0x00,0x80,0x01]

scratch_load_d16_b16 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x81,0xdc,0x02,0x00,0x81,0x01]

scratch_load_d16_hi_b16 v1, off, off offset:64
// GFX11: [0x40,0x00,0x8d,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_d16_hi_b16 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x8d,0xdc,0x00,0x00,0x00,0x01]

scratch_load_d16_hi_b16 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x8d,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_d16_hi_b16 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x8d,0xdc,0x00,0x00,0x80,0x01]

scratch_load_d16_hi_b16 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x8d,0xdc,0x02,0x00,0x81,0x01]

scratch_load_d16_hi_i8 v1, off, off offset:64
// GFX11: [0x40,0x00,0x89,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_d16_hi_i8 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x89,0xdc,0x00,0x00,0x00,0x01]

scratch_load_d16_hi_i8 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x89,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_d16_hi_i8 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x89,0xdc,0x00,0x00,0x80,0x01]

scratch_load_d16_hi_i8 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x89,0xdc,0x02,0x00,0x81,0x01]

scratch_load_d16_hi_u8 v1, off, off offset:64
// GFX11: [0x40,0x00,0x85,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_d16_hi_u8 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x85,0xdc,0x00,0x00,0x00,0x01]

scratch_load_d16_hi_u8 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x85,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_d16_hi_u8 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x85,0xdc,0x00,0x00,0x80,0x01]

scratch_load_d16_hi_u8 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x85,0xdc,0x02,0x00,0x81,0x01]

scratch_load_d16_i8 v1, off, off offset:64
// GFX11: [0x40,0x00,0x7d,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_d16_i8 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x7d,0xdc,0x00,0x00,0x00,0x01]

scratch_load_d16_i8 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x7d,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_d16_i8 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x7d,0xdc,0x00,0x00,0x80,0x01]

scratch_load_d16_i8 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x7d,0xdc,0x02,0x00,0x81,0x01]

scratch_load_d16_u8 v1, off, off offset:64
// GFX11: [0x40,0x00,0x79,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_d16_u8 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x79,0xdc,0x00,0x00,0x00,0x01]

scratch_load_d16_u8 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x79,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_d16_u8 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x79,0xdc,0x00,0x00,0x80,0x01]

scratch_load_d16_u8 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x79,0xdc,0x02,0x00,0x81,0x01]

scratch_load_i16 v1, off, off offset:64
// GFX11: [0x40,0x00,0x4d,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_i16 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x4d,0xdc,0x00,0x00,0x00,0x01]

scratch_load_i16 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x4d,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_i16 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x4d,0xdc,0x00,0x00,0x80,0x01]

scratch_load_i16 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x4d,0xdc,0x02,0x00,0x81,0x01]

scratch_load_i8 v1, off, off offset:64
// GFX11: [0x40,0x00,0x45,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_i8 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x45,0xdc,0x00,0x00,0x00,0x01]

scratch_load_i8 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x45,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_i8 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x45,0xdc,0x00,0x00,0x80,0x01]

scratch_load_i8 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x45,0xdc,0x02,0x00,0x81,0x01]

scratch_load_u16 v1, off, off offset:64
// GFX11: [0x40,0x00,0x49,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_u16 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x49,0xdc,0x00,0x00,0x00,0x01]

scratch_load_u16 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x49,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_u16 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x49,0xdc,0x00,0x00,0x80,0x01]

scratch_load_u16 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x49,0xdc,0x02,0x00,0x81,0x01]

scratch_load_u8 v1, off, off offset:64
// GFX11: [0x40,0x00,0x41,0xdc,0x00,0x00,0x7c,0x01]

scratch_load_u8 v1, off, s0 offset:64
// GFX11: [0x40,0x00,0x41,0xdc,0x00,0x00,0x00,0x01]

scratch_load_u8 v1, v0, off offset:64
// GFX11: [0x40,0x00,0x41,0xdc,0x00,0x00,0xfc,0x01]

scratch_load_u8 v1, v0, s0 offset:64
// GFX11: [0x40,0x00,0x41,0xdc,0x00,0x00,0x80,0x01]

scratch_load_u8 v1, v2, s1
// GFX11: encoding: [0x00,0x00,0x41,0xdc,0x02,0x00,0x81,0x01]

scratch_store_b128 off, v[2:5], off offset:64
// GFX11: [0x40,0x00,0x75,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b128 off, v[2:5], s0 offset:64
// GFX11: [0x40,0x00,0x75,0xdc,0x00,0x02,0x00,0x00]

scratch_store_b128 v0, v[2:5], off offset:64
// GFX11: [0x40,0x00,0x75,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_b128 v0, v[2:5], s0 offset:64
// GFX11: [0x40,0x00,0x75,0xdc,0x00,0x02,0x80,0x00]

scratch_store_b128 v1, v[2:5], s3
// GFX11: encoding: [0x00,0x00,0x75,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b16 off, v2, off offset:64
// GFX11: [0x40,0x00,0x65,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b16 off, v2, s0 offset:64
// GFX11: [0x40,0x00,0x65,0xdc,0x00,0x02,0x00,0x00]

scratch_store_b16 v0, v2, off offset:64
// GFX11: [0x40,0x00,0x65,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_b16 v0, v2, s0 offset:64
// GFX11: [0x40,0x00,0x65,0xdc,0x00,0x02,0x80,0x00]

scratch_store_b16 v1, v2, s3
// GFX11: encoding: [0x00,0x00,0x65,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b32 off, v2, off offset:2047
// GFX11: encoding: [0xff,0x07,0x69,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b32 off, v2, off offset:64
// GFX11: [0x40,0x00,0x69,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b32 off, v2, off
// GFX11: encoding: [0x00,0x00,0x69,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b32 off, v2, s0 offset:64
// GFX11: [0x40,0x00,0x69,0xdc,0x00,0x02,0x00,0x00]

scratch_store_b32 off, v2, s3 offset:2047
// GFX11: encoding: [0xff,0x07,0x69,0xdc,0x00,0x02,0x03,0x00]

scratch_store_b32 v0, v2, off offset:64
// GFX11: [0x40,0x00,0x69,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_b32 v0, v2, s0 offset:64
// GFX11: [0x40,0x00,0x69,0xdc,0x00,0x02,0x80,0x00]

scratch_store_b32 v1, v2, off offset:2047
// GFX11: encoding: [0xff,0x07,0x69,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b32 v1, v2, s1 offset:-4096
// GFX11: encoding: [0x00,0x10,0x69,0xdc,0x01,0x02,0x81,0x00]

scratch_store_b32 v1, v2, s1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x69,0xdc,0x01,0x02,0x81,0x00]

scratch_store_b32 v1, v2, s3 offset:2047
// GFX11: encoding: [0xff,0x07,0x69,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b32 v1, v2, s3
// GFX11: encoding: [0x00,0x00,0x69,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b64 off, v[2:3], off offset:64
// GFX11: [0x40,0x00,0x6d,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b64 off, v[2:3], s0 offset:64
// GFX11: [0x40,0x00,0x6d,0xdc,0x00,0x02,0x00,0x00]

scratch_store_b64 v0, v[2:3], off offset:64
// GFX11: [0x40,0x00,0x6d,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_b64 v0, v[2:3], s0 offset:64
// GFX11: [0x40,0x00,0x6d,0xdc,0x00,0x02,0x80,0x00]

scratch_store_b64 v1, v[2:3], s3
// GFX11: encoding: [0x00,0x00,0x6d,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b8 off, v2, off offset:64
// GFX11: [0x40,0x00,0x61,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b8 off, v2, s0 offset:64
// GFX11: [0x40,0x00,0x61,0xdc,0x00,0x02,0x00,0x00]

scratch_store_b8 v0, v2, off offset:64
// GFX11: [0x40,0x00,0x61,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_b8 v0, v2, s0 offset:64
// GFX11: [0x40,0x00,0x61,0xdc,0x00,0x02,0x80,0x00]

scratch_store_b8 v1, v2, s3
// GFX11: encoding: [0x00,0x00,0x61,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b96 off, v[2:4], off offset:64
// GFX11: [0x40,0x00,0x71,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b96 off, v[2:4], s0 offset:64
// GFX11: [0x40,0x00,0x71,0xdc,0x00,0x02,0x00,0x00]

scratch_store_b96 v0, v[2:4], off offset:64
// GFX11: [0x40,0x00,0x71,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_b96 v0, v[2:4], s0 offset:64
// GFX11: [0x40,0x00,0x71,0xdc,0x00,0x02,0x80,0x00]

scratch_store_b96 v1, v[2:4], s3
// GFX11: encoding: [0x00,0x00,0x71,0xdc,0x01,0x02,0x83,0x00]

scratch_store_d16_hi_b16 off, v2, off offset:64
// GFX11: [0x40,0x00,0x95,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_d16_hi_b16 off, v2, s0 offset:64
// GFX11: [0x40,0x00,0x95,0xdc,0x00,0x02,0x00,0x00]

scratch_store_d16_hi_b16 v0, v2, off offset:64
// GFX11: [0x40,0x00,0x95,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_d16_hi_b16 v0, v2, s0 offset:64
// GFX11: [0x40,0x00,0x95,0xdc,0x00,0x02,0x80,0x00]

scratch_store_d16_hi_b16 v1, v2, s3
// GFX11: encoding: [0x00,0x00,0x95,0xdc,0x01,0x02,0x83,0x00]

scratch_store_d16_hi_b8 off, v2, off offset:64
// GFX11: [0x40,0x00,0x91,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_d16_hi_b8 off, v2, s0 offset:64
// GFX11: [0x40,0x00,0x91,0xdc,0x00,0x02,0x00,0x00]

scratch_store_d16_hi_b8 v0, v2, off offset:64
// GFX11: [0x40,0x00,0x91,0xdc,0x00,0x02,0xfc,0x00]

scratch_store_d16_hi_b8 v0, v2, s0 offset:64
// GFX11: [0x40,0x00,0x91,0xdc,0x00,0x02,0x80,0x00]

scratch_store_d16_hi_b8 v1, v2, s3
// GFX11: encoding: [0x00,0x00,0x91,0xdc,0x01,0x02,0x83,0x00]

