/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class BuildNumber
extends Task {
    private static final String DEFAULT_PROPERTY_NAME = "build.number";
    private static final String DEFAULT_FILENAME = "build.number";
    private File myFile;

    public void setFile(File file) {
        this.myFile = file;
    }

    public void execute() throws BuildException {
        File savedFile = this.myFile;
        this.validate();
        Properties properties = this.loadProperties();
        int buildNumber = this.getBuildNumber(properties);
        ((Hashtable)properties).put("build.number", String.valueOf(buildNumber + 1));
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.myFile);
            String header = "Build Number for ANT. Do not edit!";
            properties.store(output, "Build Number for ANT. Do not edit!");
        }
        catch (IOException ioe) {
            String message = "Error while writing " + this.myFile;
            throw new BuildException(message, ioe);
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException ioe) {
                    this.getProject().log("error closing output stream " + ioe, 0);
                }
            }
            this.myFile = savedFile;
        }
        this.getProject().setNewProperty("build.number", String.valueOf(buildNumber));
    }

    private int getBuildNumber(Properties properties) throws BuildException {
        String buildNumber = properties.getProperty("build.number", "0").trim();
        try {
            return Integer.parseInt(buildNumber);
        }
        catch (NumberFormatException nfe) {
            String message = this.myFile + " contains a non integer build number: " + buildNumber;
            throw new BuildException(message, nfe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties() throws BuildException {
        Properties properties;
        FileInputStream input = null;
        try {
            Properties properties2 = new Properties();
            input = new FileInputStream(this.myFile);
            properties2.load(input);
            properties = properties2;
            if (null == input) return properties;
        }
        catch (IOException ioe) {
            try {
                throw new BuildException(ioe);
            }
            catch (Throwable throwable) {
                if (null == input) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    this.getProject().log("error closing input stream " + ioe2, 0);
                    throw throwable;
                }
            }
        }
        try {
            input.close();
            return properties;
        }
        catch (IOException ioe) {
            this.getProject().log("error closing input stream " + ioe, 0);
        }
        return properties;
    }

    private void validate() throws BuildException {
        if (null == this.myFile) {
            this.myFile = this.getProject().resolveFile("build.number");
        }
        if (!this.myFile.exists()) {
            try {
                FileUtils.newFileUtils().createNewFile(this.myFile);
            }
            catch (IOException ioe) {
                String message = this.myFile + " doesn't exist and new file can't be created.";
                throw new BuildException(message, ioe);
            }
        }
        if (!this.myFile.canRead()) {
            String message = "Unable to read from " + this.myFile + ".";
            throw new BuildException(message);
        }
        if (!this.myFile.canWrite()) {
            String message = "Unable to write to " + this.myFile + ".";
            throw new BuildException(message);
        }
    }
}

