::
:: windows script to create cuda files for each state count
:: from the generic state count file
:: @author Aaron Darling
:: @author Daniel Ayres
:: @author Marc Suchard

::"C:\Program Files (x86)\Microsoft Visual Studio\2019\Community\VC\Auxiliary\Build\vcvars64.bat"

echo // DO NOT EDIT -- autogenerated file -- edit kernels4.cu instead > tmp_kernels_sp_4.cu
echo #define STATE_COUNT 4 >> tmp_kernels_sp_4.cu
type kernels4.cu >> tmp_kernels_sp_4.cu
nvcc.exe -o tmp_kernels_sp_4.ptx -ptx -arch compute_60 -I../../.. -DCUDA -O3 -m64 tmp_kernels_sp_4.cu

FOR %%G IN (16 32 48 64 80 128 192 256) DO (

echo // DO NOT EDIT -- autogenerated file -- edit kernelsX.cu instead > tmp_kernels_sp_%%G.cu
echo #define STATE_COUNT %%G >> tmp_kernels_sp_%%G.cu
type kernelsX.cu >> tmp_kernels_sp_%%G.cu
nvcc.exe -o tmp_kernels_sp_%%G.ptx -ptx -arch compute_60 -I../../.. -DCUDA -O3 -m64 tmp_kernels_sp_%%G.cu

) 

echo // DO NOT EDIT -- autogenerated file -- edit kernels4.cu instead > tmp_kernels_dp_4.cu
echo #define STATE_COUNT 4 >> tmp_kernels_dp_4.cu
echo #define DOUBLE_PRECISION >> tmp_kernels_dp_4.cu
type kernels4.cu >> tmp_kernels_dp_4.cu
nvcc.exe -o tmp_kernels_dp_4.ptx -ptx -arch compute_60 -I../../.. -DCUDA -O3 -m64 tmp_kernels_dp_4.cu

FOR %%G IN (16 32 48 64 80 128 192 256) DO (

echo // DO NOT EDIT -- autogenerated file -- edit kernelsX.cu instead > tmp_kernels_dp_%%G.cu
echo #define STATE_COUNT %%G >> tmp_kernels_dp_%%G.cu
echo #define DOUBLE_PRECISION >> tmp_kernels_dp_%%G.cu
type kernelsX.cu >> tmp_kernels_dp_%%G.cu
nvcc.exe -o tmp_kernels_dp_%%G.ptx -ptx -arch compute_60 -I../../.. -DCUDA -O3 -m64 tmp_kernels_dp_%%G.cu

) 

set OUTFILE="BeagleCUDA_kernels.h"

echo // auto-generated header file with CUDA kernels code > %OUTFILE%

echo #ifndef __BeagleCUDA_kernels__ >> %OUTFILE%
echo #define __BeagleCUDA_kernels__ >> %OUTFILE%

FOR %%G IN (4 16 32 48 64 80 128 192 256) DO (

..\..\..\project\beagle-vs-2019-wix\bin2c.exe -p 0 -st -n KERNELS_STRING_SP_%%G tmp_kernels_sp_%%G.ptx >> %OUTFILE%
..\..\..\project\beagle-vs-2019-wix\bin2c.exe -p 0 -st -n KERNELS_STRING_DP_%%G tmp_kernels_dp_%%G.ptx >> %OUTFILE%

)

echo #endif 	// __BeagleCUDA_kernels__ >> %OUTFILE%

del tmp_kernels*

