/* ----- decode/1013x2393, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1013x2393_checksums[] = {
  "d14764f92d14444286cd940b7309cbc94dfbfa944288e2a1f126057a1e1b6d0d",
  "fe36c2ad2261b9693e2ad9ab3499e3dd2514bd6bf8ebf023f044d23f14345dd9",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1013x2393_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1013x2393_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1013x2393_ITEMBYTES

static void *storage_decode_1013x2393_x;
static unsigned char *test_decode_1013x2393_x;
static void *storage_decode_1013x2393_s;
static unsigned char *test_decode_1013x2393_s;
static void *storage_decode_1013x2393_x2;
static unsigned char *test_decode_1013x2393_x2;
static void *storage_decode_1013x2393_s2;
static unsigned char *test_decode_1013x2393_s2;

#define precomputed_decode_1013x2393_NUM 4

static const int16_t precomputed_decode_1013x2393_x[precomputed_decode_1013x2393_NUM][crypto_decode_ITEMS] = {
  {-681,2484,3399,-2958,1698,3171,-3354,-3495,3345,2688,3498,3366,-2523,-1959,-2628,1992,1848,1704,-1569,-522,2160,-1485,3408,-3495,456,-2082,2076,-3579,1731,285,-318,825,2862,-3351,-543,954,-3117,-126,210,1395,-546,3096,-3405,-1449,1878,-2091,-2235,768,3036,2580,-2184,2490,-2721,-3273,-831,-723,-1698,-303,-876,-1830,474,3399,-804,-948,1176,-2523,-1602,-2802,-2343,-2787,-2916,3285,-3264,-264,-3132,1293,-1821,-2559,-2502,-864,3252,1677,1995,-480,45,-3018,2679,735,-2400,-2736,-1533,1266,3255,1287,1605,-1800,-1650,-1065,2766,-1203,2937,3027,3315,3198,3291,-417,1293,-852,3300,-921,-810,3093,3438,1209,3222,12,-996,2049,2838,2283,3192,-1848,1311,180,573,714,-2871,2424,-2373,2355,-2157,-2100,1626,1683,3351,3333,-3288,-660,-1590,-3024,3552,1983,3195,1995,-1662,3411,3231,858,-1662,2673,-522,-42,3462,2259,-2841,-135,-2880,-1137,-615,-2466,2295,663,-2097,1506,-2568,-2601,-1527,-288,552,-411,876,-3249,-1446,2163,-1131,-3288,2031,3540,3477,-3126,-2571,-1116,1368,-3081,-2154,1896,-3402,1125,2901,2577,-1638,-150,-2409,888,-3288,-3552,-3045,-1737,3,1491,582,-2706,546,1509,-681,3519,-3492,60,-147,-3318,-564,-1011,1158,-3561,2433,891,1887,-288,1854,2556,3150,-1482,2334,1758,-240,2031,-1482,-2148,552,2982,1713,831,1062,2862,3060,1080,-345,1977,-2421,3150,378,2808,18,-2646,-3015,-783,2013,2052,-2895,660,2985,-1743,159,-2157,1866,2787,969,3207,1344,-456,-3219,2571,1212,-336,237,1863,-1140,-792,3342,-2166,2277,1197,-1695,-2661,2979,2592,3351,2145,-1728,378,-2736,330,1206,-2178,-3444,-1122,-1584,1152,-3321,3513,1011,-18,-1848,39,1098,174,-2373,456,-651,2016,-597,-3171,33,-2970,-366,2226,-1275,-1749,819,1392,-3057,3528,870,-1695,1035,-3222,2163,-108,1053,-1596,267,1770,-114,2178,2034,3573,-753,-2808,951,3495,1638,1215,-3504,1935,-2622,-2916,-3516,-1998,1893,3168,2898,1728,2304,1941,3066,666,2325,-1092,213,303,387,3459,-237,1944,237,123,-3018,-3204,-483,465,3174,-3255,-2295,3057,-867,1767,-2379,-141,-1986,-1968,1689,-3039,288,450,-156,2658,-2487,-3225,-60,2682,-207,-2202,-2964,2613,822,2376,2226,2283,2172,702,3405,1863,2109,1290,-1863,33,-285,3357,1698,-753,-1815,543,-3288,1002,2772,-1014,2973,-1536,-2601,-3420,-1200,1386,696,3573,3501,-3393,-2622,-2415,1638,2178,-333,-366,-3369,2118,753,3435,984,3219,2433,-252,-1476,-735,-387,-2544,2481,-987,-3525,2748,-1323,-3549,-1716,2205,-3237,399,-2154,-2685,84,687,-597,-594,609,2028,1281,1617,1005,-3066,1302,-3288,-3147,-663,-2715,-1419,2763,-948,507,309,-3378,-816,-603,825,-2532,1767,2721,2163,-816,306,3531,1401,-2190,-732,15,2574,3417,-1935,-1338,-2460,-1161,2346,-39,3126,2403,-429,849,738,2751,813,1608,-1209,-216,3147,-609,2271,-1410,-1551,1914,2481,3507,-2367,-102,-1749,3501,-471,-1203,3165,-942,549,2169,-2346,3471,-1581,2601,1614,534,-1671,651,-2220,-1608,-2043,-462,-3357,-2505,-804,-1452,-966,3222,1812,3210,690,-1794,1419,2649,633,1713,3321,-765,-2154,-1230,2349,1239,2007,-1107,-1446,-732,2802,-1047,1368,-1248,1467,1659,-1224,-2172,615,2304,2373,-855,-3585,-573,-858,3300,-648,-2271,456,1776,3555,1149,-3108,-1932,570,-1407,-3459,-2670,2751,2322,834,-2781,-1761,2202,2412,-2964,-1134,-654,-696,-1329,3096,2082,3474,510,-2445,-2919,1203,1482,-531,3051,-2415,831,-873,2346,1641,-411,-2331,2973,-1956,2001,-1590,3237,363,453,-708,-564,3270,-549,-2262,-3039,-1725,1035,297,3018,-1941,2688,-3087,-876,-372,2805,822,1674,3555,-1647,-3348,1317,2028,2712,-1941,3333,2160,462,504,645,636,438,-84,-2889,2325,1899,-2580,3174,-2793,21,-177,666,-2244,1143,2475,-1125,2817,-2787,90,3582,3144,2886,-120,1593,-3339,-1005,2292,-3342,540,1524,897,1050,2967,-3162,2001,246,1380,3192,-2148,-2595,-3417,-2940,-3156,1017,1194,-3327,2700,-1581,2985,1446,1920,-1728,-1863,-3138,-2913,-1524,-3357,1305,-1107,-2925,-2904,2961,-18,-1338,2322,2106,-585,1293,-1680,-894,-2688,243,-774,-3276,-336,84,72,729,-834,45,2121,255,2391,-30,2283,1782,3549,-846,-3585,-2298,-2643,-3588,-2130,2205,-891,-3423,-2376,360,2310,-3279,-1572,1557,1185,-1269,-999,-546,1701,3021,-1056,1119,-2655,2508,-3204,-2970,24,3414,1245,702,-3555,-366,-2709,-2334,2562,1113,708,3039,2166,2766,-471,984,-3453,-1623,-165,1704,-513,1122,-558,48,2364,699,-3345,-1533,-3111,120,-1680,2130,2985,2145,1065,-3459,3147,1866,2895,-1194,270,-1275,1263,2754,972,-2766,-3123,-957,1485,2460,3465,-1140,2283,414,-1833,-3252,1926,2952,-3174,426,3108,3435,-366,1827,3051,3276,1278,-2547,3009,2850,-1656,1164,1701,-1047,-1170,-2064,1356,-2547,519,-2388,249,-2892,1047,-336,2250,-2457,-1419,-420,-42,-3192,-93,1569,-1863,285,-1476,-1212,-3213,3099,2472,-3054,1995,3297,-2772,-1962,3189,-2019,1089,-1002,1074,393,1038,-3339,2598,1257,-2502,-1881,-264,1911,2325,204,426,-1059,-2643,159,-330,45,-270,-420,-693,-3030,714,2460,2208,-3117,1590,-2415,-1377,1128,-2718,1599,1377,-1314,2235,-3063,2070,-2274,-2481,-3303,2814,-2088,996,1476,3270,-3303,282,2949,-816,201,-1263,-1560,156,690,2433,2733,-531,-1920,-3051,-1047,-1302,1434,1245,3063,3270,453,2235,-2817,192,1371,-1638,2814,-1092,3501,-3,-240,-2286,-1239,-3051,1416,-1605,-2010,3045,1311,759,-2499,2568,294,3105,978,-1176,1734,-1104,468,162,1899,999,2964,1134,2796,-192,12,-3360,-2202,-129,2988,-1776,-2400,-1554,3312,-3528,3180,-2058,-3450,1950,426,-3024,-3432,3195,429,-741,1803,-1338,1881,-3234,-2451,861,3453,2403,2124,3093,-876,-1050,3351,3219,3210,-51,2412,-2862,1395,1683,-2400,627,-840},
  {-807,2496,3138,762,387,270,1326,-3165,-1002,1407,1005,3453,-2640,-561,1029,-1995,1128,-1956,-3183,3123,-1395,1656,2994,-723,-1416,2445,1899,1296,-630,-1260,-1359,-756,2544,987,351,-348,3501,-2058,-111,-3066,111,1122,-2187,2124,-2475,372,615,-2031,-3357,2481,-1518,-1956,-3294,168,-582,2559,1611,159,-2679,2358,-636,597,-546,-3537,1389,-2100,1767,3144,297,1314,-12,-2229,594,-2454,1584,-3135,3192,1929,-3177,258,-1269,-2739,2088,453,-552,2301,-3492,1179,-1839,1668,-966,1776,-2673,-441,2439,2487,-3558,-2445,-3162,-348,-3225,3078,-1884,-1353,-2838,3303,-3279,969,2628,1647,-717,-1464,1827,-2367,1341,345,-267,2745,1302,-1899,-810,213,1701,-3309,-3267,-3060,2556,-2448,3567,-2625,900,-3120,2232,1434,1308,360,2631,3,-45,3312,2751,-2883,-2796,3525,654,2835,2952,1767,2487,3069,-2838,-3048,1563,1167,-2541,699,3489,-1956,-1227,-2520,-2184,-1233,909,1704,2793,1152,1557,1128,-2907,351,-2349,1830,369,2496,3027,-2073,1068,1272,-2952,3489,-1848,-1470,-2034,-915,-147,-3330,252,1920,-1554,522,1947,1830,-2139,2112,-345,1149,3069,339,204,1821,-3579,-618,-2373,2817,-3534,1191,1563,-3075,-546,2913,3300,2607,-804,1362,-756,708,627,720,2082,-321,-2115,204,-1863,-2505,-2034,-1839,924,-1068,-3537,3267,3285,-1242,861,315,921,-1182,2460,-1578,1728,2751,555,2184,1335,612,-6,2703,-2865,627,1278,144,3039,-2388,2274,-2229,1782,2304,-3330,153,-699,3312,2142,-3384,-960,1875,-387,-933,-1266,1968,-237,1881,-2406,-2832,-2529,-2355,-3522,-1209,-108,906,-1323,2844,-2607,-1440,3273,-954,-1116,-2547,-2322,2106,2280,-2181,3042,2658,-690,969,1383,-1656,-2238,-1050,2955,2445,-564,-2724,-3408,1896,648,-804,-2664,-1467,-732,-2010,2064,258,858,-1212,-2496,-675,-963,1605,114,1629,-1668,-189,-3474,2565,-813,-951,1230,-1275,-1968,-3528,-2898,2028,-411,-2040,207,228,1533,1494,876,-477,-18,3030,-2385,1968,3000,2991,-3165,594,-2736,-723,-2262,-543,3459,3390,453,-2832,3024,-246,-2004,84,1962,1710,3459,-906,2688,2016,-3177,537,-126,2676,2013,-3144,-2274,-1323,708,1347,2544,3168,-1803,72,-2610,-978,2163,1650,-1323,-2850,-3066,2442,2991,2727,-2589,-2607,3360,-2409,-915,1563,2094,-1137,1797,1926,1110,-1968,3513,1914,-2634,-1815,-612,2337,-2517,3114,837,-2409,-1170,-2553,2919,-987,-2013,1662,-588,-63,2775,879,-687,1839,-3234,1119,-690,-2169,-2844,2172,-3225,3429,-1401,-834,-3135,792,1461,1203,-2988,1356,1950,939,243,-2670,-738,-2712,-1446,-2193,2886,342,1464,2208,3255,2232,2943,-3015,-699,1857,-3345,-1032,3054,2196,-2019,183,-2739,-2538,-1335,3438,-1200,3063,2424,3054,-2625,2988,1326,-2652,-2865,2388,-2949,1851,1890,2475,-2607,2682,-771,396,1539,-1104,1515,489,-3234,-72,-657,444,3384,-2220,168,2490,-777,-2175,-3330,-3462,-1569,18,-1134,-783,564,3252,-2892,-1800,399,1359,3474,-1083,1125,1059,1521,-3447,-1842,417,3102,-570,-3387,-777,2157,594,2082,-687,1776,-3177,-216,-2937,681,-2073,2187,-3423,-2226,-1506,-1569,-2334,3249,-453,1041,1389,-1011,2175,-2625,3171,-1422,3441,909,786,714,2700,255,-1845,1605,1110,-2526,3321,1800,-2442,225,1425,-2478,2319,1173,-1530,-2544,1326,-2874,-2748,-3204,-963,1017,2589,-477,-1278,1362,2649,-1068,-1158,-1647,-546,2745,-2025,1752,1986,-2073,714,3411,-3483,3054,-2565,2541,1353,-837,1992,2754,642,1680,1704,2166,3315,984,3249,2733,918,3315,246,2916,1788,72,-1359,2097,588,279,1044,2103,2649,372,162,390,291,1107,381,66,1317,-504,1704,-1413,3162,687,-2739,-2601,-486,-1227,-1758,-2586,1839,-3105,-1917,2070,3540,3465,-783,-1353,915,2130,2493,-408,1650,-2343,-228,-1923,249,-2628,2217,3339,-2868,3261,-3528,2469,255,-3447,1923,-2718,-2817,-2463,-1080,1086,3294,1671,1605,-2625,1533,-2196,2562,-294,2895,3381,-519,1407,-1902,-1038,-1629,276,1833,-1512,1380,-1878,-2355,1671,2295,-1101,-570,1011,201,-2430,1272,2280,-1926,312,576,1998,-1479,399,2103,-1368,-777,-2361,-1500,-2061,-1098,-3516,2796,-2610,-3222,543,-1773,-2634,-2346,921,3177,1098,1098,-333,1986,1365,3351,-141,2643,39,-3093,-804,-297,24,-2295,1257,513,-2772,-2718,-2697,-1557,-2823,-2067,2886,-420,-1116,-2004,-2403,-3189,1383,3477,-2757,-327,-156,678,-375,1980,2544,1884,870,-1794,-2244,-1635,549,1044,1596,-2169,-3456,-162,1836,-3510,-3570,1809,606,-2853,2820,2616,3339,600,1455,507,2019,-681,2748,1797,2232,-3315,-516,180,-3075,2745,2505,2208,1674,-402,-489,723,-1764,-3039,999,-2580,-1788,-222,-774,-2229,-1560,2250,3510,-1644,120,585,783,2457,2532,1980,0,1461,-2436,1047,3555,-1575,-465,-3312,-1890,1263,2868,606,-1128,2979,-57,1683,171,-1524,-564,3153,1539,1737,-2211,3045,1428,819,-603,-1662,-3231,1359,3420,1254,1956,2121,-1740,-3552,339,-1860,-3411,-729,279,3051,3348,-2925,-3366,1773,2130,-3465,1221,-1743,489,-2781,1425,-765,1641,-942,6,-1410,2640,114,1605,-579,-1758,627,-1047,1509,1821,-2364,-159,-2697,-1689,-3135,2526,-2442,-1506,-2313,3057,2739,618,-447,-1911,1002,714,-1842,-6,2952,-687,1020,2193,1389,1737,-1563,-2097,-1434,2340,960,2961,1284,2949,2901,27,-2349,-2229,960,-1908,3060,3141,-2037,-2376,981,2253,2043,366,1026,261,618,-1242,-1527,-2370,2757,2322,1104,-3324,3186,3264,3474,2301,-2391,-2982,471,3255,-1914,-408,2124,63,1962,1167,501,3243,3237,-153,2709,276,-3351,-177,1914,1962,3204,-3267,696,-1614,3066,-1857,-3351,2364,3492,-1320,-1245,-81,2322,-3213,-3480,1920,114,3531,-2568,2334,3150,-2703,1371,-3426,3585,-2919,3102,-2601,-2877,-1962,-2490,-2076,-2157,-498,-930,1173,696,-2898,-3303,2673,2928,2772,-1140,3243,3378,1614,1569,2145},
  {2595,-291,528,-1740,2688,99,696,1359,-2607,-3120,180,3207,2202,-1497,594,-2619,2595,3399,-2043,-63,2145,528,-2652,-1512,831,-1674,-3570,-1017,-2235,2655,-1287,-135,3552,-3312,-2676,2511,1971,-729,1128,1671,2289,-1254,3489,-3228,2022,1698,-636,2952,1239,915,-414,-2052,3399,-2973,-1023,1683,561,-1602,3156,-1452,3273,1884,-960,270,-705,2637,3177,1020,1239,-1386,-1656,-3546,-1026,-2025,-1290,1974,-3,2493,2148,2322,2130,2544,-1125,180,12,-1032,-384,171,-2808,621,-1344,1857,1035,-609,708,-2421,-2181,2352,789,402,-552,-744,2265,-2697,-366,1431,1227,-132,96,2700,-2634,498,1701,909,2715,-3171,1491,147,3012,-1416,-1791,-2571,2085,-2991,-2097,3258,345,-3168,-2043,-738,-2226,-576,2694,-348,729,3348,-2502,2835,423,318,-2130,-936,-3420,-357,1974,-1080,1812,2427,-2340,-1107,-969,2223,-2088,1026,-207,-2115,1923,-1971,-2079,-3276,-3501,-756,3558,2193,-255,396,-2073,-1287,480,1326,-1317,1752,1911,-2415,-1482,-330,-2904,-2790,819,-1722,-2793,1434,954,963,-720,-2373,2826,-2628,582,-3096,2283,3573,1575,-2385,3285,-213,2532,-372,-1020,3288,1626,-243,-2250,1887,18,1872,-27,1599,660,-573,-2061,-771,-2928,2142,-2139,2328,501,-36,-3369,-3375,-2577,-2655,-207,-2163,2541,2517,-1485,465,-276,-309,-3177,2520,2670,1266,-3060,1917,-1518,-2988,-558,-354,-2907,-3204,-1158,318,-2841,-1509,2793,-843,435,705,-2406,-897,-2784,3411,-393,2229,453,405,-2430,1617,-321,1959,753,-972,-2445,3270,-1314,3564,135,-3414,2139,-615,816,-198,-2367,-159,810,1392,789,-2760,-354,426,-3156,2121,-405,207,2460,2532,-1629,-2250,1104,3441,-1872,-648,495,-954,1920,-2775,363,-3519,-933,-255,723,3543,3489,1110,-954,-1023,249,-3351,-1704,-1425,-39,-1080,-1107,-2226,1974,-744,-1563,-2952,-1671,2331,3426,1545,-1251,2256,-2721,2031,2190,2787,-636,-2937,-1017,2781,-180,3069,1917,129,1455,-1746,3465,-984,-2817,-1137,960,2073,-2433,309,39,-2208,888,663,1725,-1140,-3390,-3147,-888,-975,618,927,3120,-180,1143,-1434,3216,-36,-453,1575,-2550,3264,-492,-2064,1308,504,2751,1728,591,-1713,3534,-2700,-2550,-1551,2262,-849,-345,3405,441,2667,1602,2643,-3246,-468,3138,3489,-1956,-3252,-528,-309,-1185,1821,1437,1197,-543,2154,-258,-1509,3162,87,1119,-297,699,-2304,2364,-570,-1527,2709,2574,-990,2559,3081,1566,1515,2478,2958,-2310,1107,1269,1815,-3129,-3090,-3468,2514,3399,1746,2190,-429,-126,-1491,1911,816,2025,1866,-411,450,924,-246,2082,1572,3516,291,-240,-2607,-2484,3021,345,-2868,267,1830,843,-711,-2346,-447,1446,669,3243,-1140,2175,-3117,2418,-3321,-2019,3153,-1977,-3558,1017,-1725,2100,-1632,-549,2799,-1557,912,1326,2046,183,-1542,3225,903,687,2151,-2598,-183,-2139,-504,489,-3027,-1215,-1209,2511,-2163,-1872,-3138,3330,-525,-2046,-2343,1368,-846,1158,2988,-600,-2520,-132,2277,81,-810,-1374,2445,-522,1026,2304,939,2130,-2226,-2388,615,3339,3105,-1734,-2853,45,3549,-2814,1029,-1770,-306,1101,2133,2496,-402,1671,-2538,2145,-3201,828,-1833,978,2064,-849,-2064,-3396,2892,3432,3093,-2634,2649,927,1569,2772,1839,-2910,2610,630,-3033,-2229,-645,-42,-2844,-2733,-1119,2178,3312,1575,2670,-588,3357,-39,-3375,2346,2520,15,1944,2709,-285,-2655,2208,-3399,-987,-3402,3576,2337,2955,2679,2523,1032,1827,1152,1278,-2895,-1221,-2835,2064,189,-75,-1572,-654,2277,1350,1134,-1659,555,3474,1377,495,516,2730,2889,3456,-2394,-2619,2640,144,1458,-3441,-3354,108,-2340,975,252,-2094,-285,-900,-3195,150,-2793,60,2847,-2154,-2283,-999,600,2025,-2895,2403,-2886,1479,-2937,-2667,-333,1065,-2352,2397,-1692,1341,1398,-963,2418,-144,3012,2061,-2976,2337,276,1368,309,-2466,-60,1248,3459,-216,504,861,-1458,-435,3456,3333,-969,2379,2112,-1320,1332,-1443,2709,2712,2817,2448,3456,735,-2082,-2961,2358,-2163,462,-960,90,1224,-3150,-1461,1923,-2703,840,990,1446,-3360,-1392,-3399,1224,-2151,-2940,-3399,-1752,2964,-2310,3375,2544,-2772,-720,1338,684,1683,-3240,-333,-1494,-3483,1161,1737,57,-3078,969,-885,1035,-2982,870,1131,-3171,-78,-1554,-1203,-663,261,2091,1134,-216,-2529,-2622,-474,-2370,990,-3525,2226,-537,2553,-1137,843,-3219,-1098,-2547,1731,-3585,1911,507,-858,1185,-1929,-2043,-3027,402,669,-1017,1617,2736,-1119,-3237,2256,-2139,-1395,-2991,-2844,2664,-1896,3393,3165,-1881,-3588,-1710,480,-1953,2343,-2913,180,2190,-2460,-192,3270,810,-3366,714,-564,3492,1476,1821,-264,2982,-1632,-2049,-762,2910,-417,1533,2058,-978,789,1650,-60,1278,1746,1929,-3312,-1746,2208,3285,1821,-1569,1530,1014,-3432,1617,3579,1458,2418,-1860,-579,2679,-1152,2412,1740,2586,-939,3300,165,705,264,-720,1284,-1644,1065,156,-3402,-1554,-1572,741,777,2334,1221,1776,3324,2208,-1071,1218,648,-1365,3465,-711,-1704,2652,-2751,2202,-762,1413,-3564,3531,1902,-2574,-579,1824,-2019,-123,-3279,2148,2901,1299,-825,339,1194,30,-1623,-1137,-51,-3081,-144,1590,1023,-2388,-2817,-453,549,-3054,1206,54,675,-1209,-696,2976,3468,2124,306,1005,-2232,3168,-15,-3495,-12,996,-2805,2748,-2754,3096,-3351,-987,-1176,-1056,-2865,-624,3237,2214,2868,-126,1614,3159,834,-792,1032,354,-3525,123,-114,-1944,-693,3423,-2442,-2352,2466,696,834,39,2526,390,-3375,-3381,-765,474,-15,1776,1545,2406,-1938,-2211,2664,-1737,-2493,492,828,-81,60,603,1059,1533,942,-1227,-2946,1662,-75,1293,-3447,-2304,1269,-3300,-2454,-792,-3126,-381,2022,-939,2703,651,-2301,1683,561,-1623,-120,954,2409,-2049,1902,3408,1782,-3588,-498,-84,-2760,2250,3546,318,-2118,2898,2106,1503,1413,-468,321,21,-1311,3177},
  {1761,-786,366,1182,3357,-933,3459,-402,-1800,447,3060,3351,489,114,978,-2808,1971,-792,3564,1086,3174,2172,2595,-318,2013,2652,-927,2583,3390,3423,3408,321,-2982,-6,387,-1512,1842,3135,-1506,-2568,3177,-381,1845,1221,-2142,633,-2253,381,1491,-3423,3129,1284,-1887,-1914,1848,2010,-2787,2646,-1578,2703,1668,-1899,-2496,-459,-2397,1722,-594,-1818,2175,-3387,-1806,930,2931,2724,2154,2202,-1059,1980,888,-366,2007,-1488,-450,-3003,2685,66,2211,-489,921,2037,-318,1092,-2148,24,-3273,2721,-963,846,-2409,-2313,-2376,2346,-2910,435,-36,2826,-1890,3435,1773,1122,-3279,2793,918,-2193,1416,2745,2469,-1827,1350,-1332,-1497,2478,-2781,-1470,2697,2499,-1377,-1686,1869,-2187,-2274,-1119,-2736,2373,3135,171,615,-2634,249,-1533,-1623,-39,-2043,2286,-822,2517,-216,2298,201,-3066,-3336,3216,282,-735,1515,564,1332,-522,2628,2193,-519,-888,2685,2772,-1842,-1614,-36,417,549,3090,2136,2433,-1479,-3030,-3117,-1710,-2142,495,378,1179,2616,3243,1305,-1455,-1749,-1758,42,861,3396,3438,1410,-2772,948,1857,1236,1626,-3012,3024,-1485,2712,-2274,-2511,2742,-3435,-9,-48,-1479,1524,2310,2598,1602,1269,1629,-396,1647,-2808,3135,2838,132,1614,1935,3552,1185,1461,3426,-3036,-3105,2448,2859,-3234,2412,-1236,357,-3018,648,-2865,-3495,141,-1131,2103,1089,2427,-3519,-2922,-2610,1821,-2289,672,-2256,-288,1602,-1416,-732,2472,-3411,705,-792,-12,-3057,-2085,-2715,-693,2709,573,-1803,-1605,510,2457,1284,528,984,-1524,1569,-309,2253,-906,-3066,3423,144,2883,1044,-3198,345,2715,-3516,2340,-885,2283,1131,-3369,2163,3345,-3228,-1611,-1017,-3543,3234,-1047,-3399,3330,3009,366,-615,-3063,2883,-951,-2508,-6,-669,-732,2244,-2958,2562,2151,2448,1425,738,3453,-1005,-2649,-2721,3213,2421,3144,-3165,2724,1317,1440,3435,861,-2535,3078,-825,-3588,3315,-3507,3270,2754,-729,-1731,-1794,-1296,3099,372,-3546,-597,-2253,108,3201,-2121,1563,1683,-3420,2022,2910,-3090,-2844,-2424,-1902,-2619,-678,-984,1941,2337,3285,1725,699,-294,618,-1881,-1542,-1689,-1110,2238,-267,-1161,1428,999,-1845,-390,-588,-459,3363,2109,-2979,1611,579,2421,1938,1890,-2085,-564,3327,-1317,-483,45,-2292,-2040,2781,675,-957,2943,-1347,3018,9,411,-3234,387,-525,-159,-1854,-3399,-699,-2940,2601,-786,1824,669,978,1050,-2346,-2958,-2022,1512,-2805,1236,2652,3321,1251,600,-414,-3306,-3471,-1206,2745,-1110,-1863,2049,837,-1845,-1839,-2637,2727,1491,585,3375,1605,786,-756,2565,2001,2895,711,1275,-690,-1095,-657,2814,18,-3258,-402,-1290,-1452,3237,2499,90,-2478,-3150,-2700,579,1593,-2397,3507,702,876,1311,1737,-2721,-1938,-123,2340,-996,2220,981,1755,3063,-2520,474,-444,1875,-3333,555,-2862,2523,-1551,-3090,1944,-612,-3003,-657,-294,1716,1452,-1560,2421,2844,-1761,249,3108,-621,2313,-648,3153,-1704,1080,-135,-2289,-2121,549,384,-1374,84,3288,-2247,618,2025,1797,480,1260,2136,741,1155,3060,-2043,-1056,-1350,-2145,-3573,1950,-3300,-1266,-2751,2106,2070,-1692,498,-1704,-1815,-2196,2682,-3480,-1056,-936,282,-2469,789,-3573,1977,-87,-3357,-3126,1086,-2961,-2205,-1539,-222,-3561,-645,-192,-222,-636,-336,-1290,-180,-1080,-453,876,1353,-237,-1737,-393,-2481,2661,-3384,1464,3258,-1314,159,498,1830,-2103,3438,1662,-552,-1101,1629,-2085,-246,-192,-1155,3285,123,-2289,-3459,-3177,1857,2685,-2259,2220,-3372,1770,-1479,-3510,-243,1167,1953,-96,807,-2151,666,1731,-2658,2955,-987,-1179,1614,3429,2142,1113,1152,2532,348,3312,333,-1413,2919,2682,-366,420,2010,-1467,-663,-702,6,-2160,21,2871,63,69,-3354,-2280,-2688,-504,2670,2538,-2001,2928,-147,-1101,3273,-2616,-2370,-3207,1824,-246,3309,-2037,-369,-2850,-2670,423,2223,-744,-2127,-678,-1410,336,636,-1761,-2964,-1740,1128,-1461,45,-2703,201,2814,3576,1497,-1893,144,-1392,243,3144,3243,-1710,-576,-1263,2757,-1563,1062,-198,-1314,2691,3261,3090,1269,-18,-2838,-3564,2532,-2913,2526,882,-270,1452,846,2856,-897,3291,2994,1818,12,717,-3525,2913,-3318,-3504,-3231,3453,-3315,-447,-1851,2577,-1047,-1542,1170,2469,-3000,-2343,-489,1911,288,2877,3171,-2187,597,-1665,-273,267,-3282,1443,-75,-1998,-2712,-2835,-186,-2814,-2859,516,-318,-1908,1359,2961,-2979,-444,-2754,1251,-2877,1968,2508,-3159,-936,-585,-3369,-1521,-714,-159,954,-3111,3024,2715,1800,1140,-1002,-192,3150,-96,-726,-3564,-3558,3045,1734,2259,873,-2901,1776,-1887,3060,3231,1098,-2196,-1350,-1152,-1533,1569,-114,3498,-3432,1212,-1467,3159,1320,36,-1074,927,-3561,-2955,-3342,1500,1281,-684,2601,1665,-2793,1152,-2121,405,-87,-912,-2244,1413,1314,87,-270,-3255,-2214,-537,174,2346,3474,-1698,-2502,-1107,435,-1800,2928,3201,-1821,1068,-2274,2079,1083,-2409,2580,2505,1875,-1476,-1422,1020,-1158,-810,-1617,-1650,771,2385,2058,-1533,2592,882,-3423,-72,3078,-1326,1341,2442,678,1347,-2823,-60,-2745,-3588,78,-162,1845,-1389,2772,-3528,2511,-1185,3420,-2946,636,-1233,-2835,2592,-2997,1257,3396,249,177,1896,54,-2727,2208,1686,2898,-2502,3423,489,3564,-2427,-2145,-3459,2838,3012,1614,-1218,3504,2568,-468,1341,3309,1536,-879,-1212,2208,330,1695,1005,3315,-225,144,-873,-741,1053,876,354,2781,-3318,-1911,1428,-2307,-579,-3099,-1680,-2355,-3459,993,-1677,-1830,-1887,-384,138,15,-2694,-2976,1197,-462,-615,1044,2514,3420,783,3231,-486,-1515,-477,-2946,912,1542,2400,1128,-969,-2478,-3552,-2925,-1371,438,-1626,2508,-2571,912,-2766,-3183,879,-3072,-2649,399,-1581,-846,2457,-705,-2562,-3462,-1257,1470,1767,732,3372,-816,-1626,-819,1746,-564,-2256,-330,1563,-1752,-819,1932,-2607,2232},
} ;

static const unsigned char precomputed_decode_1013x2393_s[precomputed_decode_1013x2393_NUM][crypto_decode_STRBYTES] = {
  {113,235,27,180,39,75,21,34,83,108,24,173,42,213,228,235,88,112,239,83,49,160,227,42,202,89,107,35,192,42,169,186,221,234,81,76,207,35,103,171,138,94,30,9,153,63,143,6,104,27,46,252,162,214,154,226,37,254,66,105,251,15,144,37,159,252,172,147,114,193,91,168,160,117,59,105,140,136,22,41,11,30,113,219,201,244,34,166,72,96,47,23,218,94,247,201,231,183,169,15,20,140,99,161,110,161,107,83,9,127,217,84,13,108,14,218,159,159,187,125,120,54,9,227,245,97,163,45,74,87,77,30,159,46,20,70,180,163,246,223,229,215,210,252,151,50,27,38,17,55,236,44,195,51,32,8,245,213,229,171,74,197,67,2,181,4,27,45,143,176,25,38,63,2,247,169,89,201,189,168,203,23,53,50,98,193,105,93,226,17,244,218,61,124,129,209,54,136,66,214,164,193,13,15,98,132,224,102,197,77,147,97,64,187,228,139,141,49,22,207,212,170,60,25,133,104,158,137,194,252,0,208,132,135,156,217,32,192,91,4,94,222,220,123,206,36,227,172,47,181,94,125,182,111,223,158,96,186,96,37,56,247,28,155,172,93,52,11,208,87,38,69,228,74,185,64,104,208,6,72,38,177,164,47,246,3,232,179,64,110,179,121,149,39,16,208,57,58,63,57,56,23,85,138,244,199,32,101,217,162,85,157,45,16,111,122,197,98,227,68,239,59,184,50,45,48,21,130,186,59,103,124,37,57,34,47,90,90,15,66,126,188,103,83,164,207,243,104,220,96,210,202,113,89,8,48,62,173,186,88,101,22,190,226,28,49,8,246,210,185,126,181,254,42,74,10,128,108,50,85,5,227,107,122,226,156,239,124,166,62,204,97,181,102,222,20,32,140,107,136,8,74,78,222,146,92,87,2,193,12,134,141,111,46,212,104,49,72,0,53,159,59,135,115,132,128,201,223,111,162,95,188,39,185,82,176,85,30,105,221,195,132,126,135,131,255,49,13,219,116,71,96,134,96,121,96,34,173,138,154,126,103,53,42,240,115,130,189,74,186,241,46,172,7,222,104,108,194,202,196,199,4,174,39,166,189,211,60,173,188,226,122,25,173,68,153,117,251,225,253,218,83,229,205,121,229,188,229,167,102,114,249,174,52,221,93,109,37,198,118,229,88,133,90,13,172,159,208,215,211,9,228,162,236,166,194,156,26,147,243,70,104,142,30,219,119,21,70,170,31,117,21,58,202,163,85,217,137,201,204,233,41,119,149,232,12,75,62,172,209,91,58,193,247,203,221,2,158,202,148,203,40,36,218,198,61,218,14,50,223,246,54,133,93,196,251,203,238,20,81,221,59,148,79,98,17,177,172,206,80,171,229,209,88,192,31,3,19,174,124,159,39,156,173,60,79,119,20,59,33,56,40,97,181,159,247,87,238,51,97,17,20,31,255,122,211,3,111,78,171,36,249,245,75,239,181,252,136,74,97,198,209,116,248,69,197,122,249,82,62,154,14,197,148,178,62,103,157,171,206,61,7,182,124,180,143,28,22,232,66,41,58,7,137,84,3,218,16,83,1,207,55,117,210,226,56,33,84,61,124,208,241,107,148,119,63,206,247,23,69,68,149,236,144,197,138,82,129,226,202,255,121,17,229,220,109,49,130,246,190,22,219,171,192,162,206,7,138,210,30,12,134,225,99,7,218,64,97,112,180,98,247,49,220,90,205,15,183,84,220,247,79,111,17,125,248,153,170,60,172,61,116,68,231,124,118,190,250,244,208,240,61,41,8,174,169,168,249,99,239,52,248,44,14,178,136,245,169,80,194,55,224,141,120,151,97,110,29,126,18,50,133,135,64,106,213,214,66,218,76,70,140,27,102,133,113,236,46,76,254,55,181,9,107,198,18,212,103,14,45,137,138,158,5,203,185,141,147,249,202,175,244,135,247,121,126,10,239,160,193,69,83,49,75,41,62,109,119,100,255,26,224,206,131,111,172,61,103,157,64,68,93,140,147,171,6,192,234,246,156,32,117,195,226,93,222,255,122,69,236,44,205,86,127,217,26,191,197,94,81,132,148,81,78,126,61,103,139,57,214,157,217,103,129,16,229,13,3,111,194,150,105,174,171,62,221,74,140,81,41,185,189,34,239,207,238,173,123,118,97,202,66,218,169,182,219,190,129,220,93,28,203,167,27,140,22,66,195,240,195,30,168,244,103,150,226,65,143,40,172,195,105,37,86,14,40,112,244,171,88,166,231,222,226,189,21,242,221,82,46,1,79,49,25,236,13,56,103,210,171,106,241,193,71,35,0,159,210,100,37,112,165,120,122,18,107,22,42,126,25,2,98,141,74,120,14,243,158,229,47,247,169,131,112,6,121,142,241,154,70,158,5,218,198,107,214,216,243,220,121,78,170,149,32,3,184,226,85,50,42,19,97,135,71,30,48,209,120,214,98,247,135,17,246,6,47,67,94,67,118,187,14,196,31,99,20,36,224,176,137,91,136,218,178,98,40,222,49,133,98,244,205,70,247,68,237,139,222,199,52,110,179,107,64,97,80,180,15,153,92,66,103,39,24,26,155,148,147,209,125,45,114,243,62,123,56,202,55,110,120,201,194,53,5,151,252,171,196,143,70,69,114,12,52,146,25,233,83,132,68,247,236,36,227,245,238,123,197,158,97,140,194,135,115,48,236,227,97,7,61,80,239,219,87,170,21,89,197,56,194,208,185,54,146,53,223,59,30,152,178,56,167,46,211,219,127,220,153,146,1,195,8,184,143,131,113,138,254,252,7,187,30,133,220,203,198,150,181,31,184,228,57,86,69,89,187,152,210,182,226,148,218,14,97,200,78,48,125,40,26,64,49,118,46,113,144,45,189,121,51,96,111,98,139,13,93,3,180,230,160,144,243,202,85,241,202,242,190,63,211,94,47,92,88,237,82,4,249,243,108,143,57,201,18,17,255,226,255,188,106,217,240,194,79,9,14,11,234,50,75,134,123,77,52,98,174,24,44,204,165,212,81,120,23,179,170,197,231,158,152,54,200,236,103,146,77,1,186,138,73,78,255,106,157,43,51,16,226,155,192,142,21,231,179,186,233,108,62,198,184,109,48,31,234,187,215,226,85,216,112,238,38,119,236,108,21,62,171,41,116,169,46,242,115,194,170,71,210,255,49,128,15,104,189,142,34,223,182,158,245,117,235,255},
  {171,16,220,250,67,250,107,44,55,207,238,184,5,217,158,105,68,227,60,175,143,214,149,231,247,112,33,121,162,89,23,123,41,183,153,116,137,168,5,95,163,88,195,135,91,52,232,248,156,222,210,223,166,183,67,213,254,161,61,96,211,243,223,162,235,34,29,247,33,175,37,143,220,210,59,138,43,47,59,208,104,88,175,54,103,177,141,5,95,251,6,77,226,78,218,248,127,233,6,112,247,34,57,54,139,224,126,119,193,191,225,221,140,227,50,229,58,25,25,149,25,71,56,108,155,109,28,232,234,193,20,184,142,39,228,19,62,189,57,0,244,156,83,148,219,50,21,54,92,14,142,147,190,230,42,47,87,230,215,2,189,171,31,111,155,185,55,109,92,242,123,243,51,18,46,121,68,45,243,35,182,201,201,138,97,40,76,15,240,8,19,249,111,98,44,172,192,212,195,218,49,38,212,246,227,42,40,69,85,36,225,111,66,67,136,77,185,116,251,202,91,41,192,48,181,75,232,177,118,111,209,150,24,135,177,78,206,126,133,46,73,70,33,37,179,150,102,78,210,114,177,163,31,146,202,189,221,136,95,255,26,131,129,129,216,84,226,162,36,149,38,53,68,3,199,244,82,183,83,76,51,38,45,24,219,174,128,79,177,39,116,14,221,122,93,138,224,229,168,118,16,136,192,191,36,232,255,209,150,56,14,215,34,241,255,117,54,56,101,132,101,97,49,228,52,28,81,45,16,189,182,91,135,219,41,119,153,225,85,227,148,145,109,161,253,27,47,231,31,224,153,17,211,247,223,56,230,181,152,179,48,131,251,173,152,61,144,53,106,66,191,110,49,147,125,22,232,66,119,142,188,197,127,200,121,254,120,101,98,229,252,241,173,98,104,181,111,220,1,36,218,189,217,0,181,149,127,33,15,148,100,95,23,156,228,176,115,232,103,235,242,102,176,17,239,74,55,73,120,28,164,104,255,135,43,80,200,86,184,45,211,32,95,49,58,173,115,253,220,221,64,146,93,223,232,1,194,73,133,28,238,110,12,232,201,200,37,135,221,246,138,223,81,11,222,106,121,189,34,52,191,210,225,81,91,129,137,66,28,166,234,203,17,23,156,175,62,255,104,54,240,136,131,230,65,39,16,70,28,196,122,59,125,134,168,149,254,189,101,193,116,196,4,55,29,238,145,86,157,7,213,240,32,118,164,9,12,89,243,69,52,49,202,153,52,40,134,69,97,144,189,66,74,142,254,59,49,53,9,25,210,249,230,8,251,230,177,18,210,208,70,58,179,243,210,52,191,33,57,240,226,150,13,9,96,14,230,222,131,94,72,80,51,124,146,43,57,238,116,132,32,112,115,12,67,61,105,224,75,179,120,119,19,38,87,219,209,101,48,241,186,169,179,59,16,85,45,184,72,109,15,43,244,90,195,194,37,73,55,15,70,87,102,201,62,45,190,209,37,11,38,197,255,230,210,181,247,168,117,204,223,195,60,206,212,19,123,99,27,136,156,201,164,59,180,85,130,220,147,236,186,99,227,139,87,219,63,0,108,122,29,4,154,161,251,190,20,36,182,40,62,66,160,179,173,178,178,73,165,57,145,107,139,80,232,179,176,117,182,28,44,31,214,92,36,15,47,220,148,123,146,219,22,11,1,18,139,193,142,240,226,151,134,185,66,132,142,151,200,74,200,220,52,4,252,177,214,240,111,201,28,162,180,219,19,199,43,102,49,76,50,179,26,250,117,176,163,247,76,139,89,2,30,222,46,105,75,147,55,90,168,224,146,21,155,147,16,206,158,124,255,176,201,74,106,250,39,142,46,17,134,178,107,207,56,153,56,205,199,120,161,107,148,137,13,96,95,13,110,20,57,241,110,44,21,36,31,16,196,214,118,189,61,170,21,117,192,54,62,248,207,131,133,211,93,13,140,204,102,211,221,26,141,64,179,134,18,123,212,215,172,98,113,59,20,135,30,23,118,166,215,79,250,12,227,236,184,220,248,133,196,250,119,135,220,10,121,64,25,224,240,69,142,158,199,25,74,155,154,172,143,57,196,98,31,85,126,3,74,25,209,92,152,236,128,233,15,158,40,145,216,45,109,54,229,24,225,59,110,35,90,115,78,253,98,153,43,104,231,104,20,138,235,145,12,203,208,26,52,169,127,231,11,252,82,178,223,36,172,255,184,228,56,52,121,135,115,243,1,81,46,22,121,115,140,10,212,92,117,78,37,110,174,168,92,95,205,108,12,94,167,42,237,120,67,87,248,211,39,210,101,203,170,127,116,240,171,25,145,239,31,146,241,239,17,212,109,1,170,116,133,64,162,144,23,170,181,97,251,122,118,33,182,228,3,87,11,83,230,12,217,126,92,136,7,1,11,210,139,229,157,135,28,89,23,233,28,171,37,1,39,142,206,94,253,50,53,165,168,121,47,127,26,244,241,195,182,147,121,155,228,151,153,9,224,139,245,50,0,212,108,69,64,0,196,26,50,211,32,118,158,52,91,66,33,202,47,188,145,41,217,212,127,146,191,39,106,62,68,113,24,210,105,186,225,56,97,70,234,127,158,81,84,230,237,238,193,106,182,69,196,59,197,110,107,143,36,69,27,162,108,81,224,111,70,51,64,37,120,80,66,242,36,166,242,35,6,87,219,160,15,232,197,10,36,193,118,93,81,18,150,87,127,138,156,191,103,207,226,227,126,198,58,15,41,244,144,166,59,95,221,77,38,30,175,6,59,67,11,149,88,57,72,178,178,189,162,243,209,163,80,178,3,185,61,120,78,8,216,70,63,100,55,38,68,16,101,162,230,235,219,39,50,127,128,82,223,25,178,162,192,198,252,228,100,229,109,57,64,126,165,127,126,229,102,124,167,3,141,19,105,235,18,73,33,152,167,18,14,219,43,171,100,2,129,129,173,167,71,38,241,184,196,54,163,28,113,134,135,70,108,63,214,242,95,232,239,28,139,180,126,17,12,125,78,79,42,18,134,201,200,255,53,51,173,102,44,208,142,147,244,187,41,216,138,20,167,183,148,8,154,59,223,157,245,74,15,27,95,182,25,76,105,10,51,208,73,119,82,74,21,154,133,254,150,108,202,39,157,145,24,76,7,193,146,168,192,234,89,181,133,100,227,232,156,169,24,57,113,60,32,50,47,234,49,21,2,204,140,234,203,134,222,80,221,203,78,92,206,254,71,123,147},
  {32,41,132,131,113,232,221,59,131,179,89,185,219,122,189,208,190,18,130,233,115,32,204,69,143,81,247,74,60,254,38,10,72,101,249,60,142,211,149,8,33,112,239,106,224,93,188,157,30,213,34,182,94,133,44,43,141,49,80,8,15,163,130,248,36,200,207,30,119,211,98,133,119,9,140,181,94,8,90,246,14,170,221,223,228,32,201,196,199,59,235,72,62,72,213,57,49,78,21,150,136,161,224,223,211,26,197,22,124,141,192,188,6,195,136,27,114,124,76,120,50,99,146,75,75,85,203,33,73,178,210,170,166,119,103,113,191,46,223,143,58,73,165,83,226,141,21,61,35,52,210,189,166,42,26,242,144,181,31,206,77,120,61,102,7,130,160,3,194,212,201,1,24,78,76,170,94,183,251,187,3,33,79,106,137,205,154,183,114,2,128,48,34,171,16,29,168,44,44,180,109,189,55,165,110,121,188,38,237,183,112,75,226,190,119,3,243,64,248,151,112,92,138,92,118,86,108,87,77,237,93,88,168,28,163,1,58,80,184,96,99,173,208,141,230,78,106,113,188,69,99,194,33,49,68,209,254,158,177,91,18,136,207,220,59,122,198,15,3,35,252,54,150,72,246,189,214,162,167,25,96,223,39,125,238,52,24,133,155,75,171,147,240,202,143,20,99,236,36,220,180,148,254,208,165,55,173,59,118,231,29,86,67,139,17,151,210,164,87,192,108,13,249,130,71,36,74,101,75,159,73,240,108,136,227,10,234,68,7,114,243,186,10,214,243,236,28,112,165,208,117,195,155,210,93,94,83,209,179,249,172,131,199,61,124,68,102,219,102,103,164,144,148,212,77,188,186,215,46,216,105,204,7,94,156,33,28,39,215,221,2,250,225,43,16,25,249,236,244,216,14,68,97,231,67,82,171,195,130,20,97,166,126,195,106,167,24,167,216,51,19,35,124,180,191,38,116,201,79,16,74,69,59,245,155,122,133,138,133,161,89,105,21,42,42,179,90,213,197,63,11,245,83,114,143,200,227,246,44,10,157,60,225,214,149,212,22,195,195,71,58,14,132,192,228,178,20,214,30,193,33,200,76,153,3,236,80,178,162,223,225,114,71,139,82,217,200,247,20,96,98,124,247,80,73,41,54,102,62,16,168,3,43,103,181,212,5,113,176,44,73,33,72,155,161,41,164,127,151,244,206,226,13,51,180,244,22,168,34,207,135,206,80,189,33,98,238,208,45,144,48,223,95,90,5,235,128,202,49,22,36,113,207,198,210,211,214,18,60,14,30,3,239,49,187,139,78,156,142,95,197,89,248,59,227,140,170,168,114,50,244,170,86,105,137,238,18,64,52,208,247,203,6,199,162,184,225,33,177,128,199,249,160,184,130,235,187,196,217,204,152,116,155,208,158,252,105,139,34,52,205,187,177,127,201,103,143,124,186,132,235,86,44,236,27,173,148,54,116,166,47,218,171,0,177,249,238,242,59,202,107,30,92,87,25,173,4,225,241,19,231,43,41,99,55,70,230,163,64,162,251,33,71,182,211,127,37,167,159,163,225,95,210,1,110,150,15,228,188,204,74,190,250,204,195,79,203,131,191,77,172,193,147,193,140,246,150,248,101,45,169,158,229,73,70,214,217,57,44,236,63,102,171,117,77,185,9,10,218,220,155,128,29,232,32,232,28,186,215,195,160,194,174,241,9,79,192,190,66,238,179,63,120,55,6,214,133,213,136,93,91,21,177,33,6,179,255,14,56,160,170,58,57,2,222,133,114,50,137,221,62,194,42,125,116,185,10,212,16,172,63,124,58,215,127,103,239,160,245,190,161,73,170,247,120,242,43,99,18,142,198,222,187,77,18,236,84,66,148,32,243,161,117,174,64,225,5,70,227,182,251,231,84,80,191,164,110,72,70,140,122,38,1,144,252,39,59,170,38,149,60,219,19,242,31,56,8,109,60,178,123,219,5,161,223,31,82,199,115,2,142,167,71,57,109,239,20,16,197,235,23,38,233,99,128,94,64,90,195,231,61,54,60,234,178,108,31,135,219,133,135,134,181,141,230,46,43,235,231,94,21,208,199,21,182,155,88,85,59,219,8,63,111,201,107,77,161,62,239,251,46,177,6,216,63,111,221,156,106,92,89,130,211,128,4,29,79,26,78,86,16,197,81,107,250,148,161,41,121,211,241,200,178,189,135,31,202,205,46,163,75,76,124,149,170,175,172,134,115,56,225,3,55,212,106,101,22,156,132,24,84,220,112,233,76,86,44,229,15,152,146,187,184,34,117,114,69,237,127,163,243,157,124,11,38,90,136,41,11,38,155,31,130,167,227,235,72,17,173,143,46,175,52,207,66,32,118,98,182,136,208,118,50,236,19,72,217,38,86,99,230,187,88,253,20,227,155,19,226,40,3,117,108,42,116,250,152,90,187,178,65,33,104,3,8,0,9,254,97,163,30,212,88,145,245,97,125,63,108,70,149,47,217,209,195,80,134,255,53,181,118,131,50,148,80,142,119,233,17,72,144,31,26,127,247,167,201,219,149,8,167,109,150,113,157,209,52,91,103,173,223,251,119,82,152,69,85,16,245,75,153,185,27,187,254,143,50,244,174,204,98,55,116,25,143,47,93,187,148,243,141,107,68,176,248,137,137,129,61,112,6,97,122,114,223,233,73,79,90,188,44,124,127,244,200,122,45,148,141,212,133,230,129,14,79,202,105,183,49,152,3,144,144,48,252,136,83,122,41,22,29,204,118,126,208,100,230,224,122,159,108,219,209,237,169,15,130,18,111,60,249,205,16,110,117,207,219,194,122,39,30,48,85,151,183,174,197,82,191,29,218,113,110,21,55,127,25,77,225,146,223,251,228,87,226,239,116,119,27,220,190,110,130,123,121,254,199,193,105,19,169,212,100,94,20,145,92,193,142,120,209,73,19,58,200,158,173,176,133,250,181,97,183,177,74,100,231,248,115,8,92,245,200,13,224,3,166,206,204,131,175,142,32,36,192,119,251,74,6,225,20,118,255,115,248,161,184,110,167,7,72,122,232,110,48,222,72,191,225,38,208,150,204,74,229,143,124,168,5,179,103,137,238,213,80,96,45,59,49,102,169,100,196,58,84,18,235,215,227,51,226,225,11,130,206,11,222,115,222,147,155,152,245,43,2,190,122,160,158,144,61,150,134,70,252,158,65,209,17,140,58,11,98},
  {173,33,236,19,184,89,99,208,237,30,201,125,81,20,86,132,65,15,246,236,78,36,255,212,107,250,152,31,143,94,27,157,228,153,193,73,43,219,234,108,116,17,94,143,9,98,176,80,188,8,87,85,53,98,206,41,121,225,167,148,147,149,7,23,231,162,4,143,204,121,228,255,245,219,116,128,139,200,54,61,165,150,225,34,157,129,174,191,186,124,154,250,116,248,136,202,65,251,74,134,62,59,23,248,234,21,19,125,205,90,222,170,135,0,107,27,246,118,222,123,175,215,127,200,148,30,75,41,118,20,213,14,231,142,94,201,7,162,36,8,214,52,185,128,21,82,126,168,109,95,208,208,169,190,205,143,182,87,7,101,227,224,51,113,8,9,191,195,69,77,51,80,105,205,63,220,11,180,151,10,177,44,142,252,119,72,77,43,78,141,18,245,231,75,130,124,252,122,209,176,133,29,249,228,229,26,39,59,140,82,157,36,179,224,53,133,111,63,174,85,157,238,82,122,26,193,29,120,107,87,96,168,49,245,77,210,66,99,180,71,36,60,69,27,25,215,93,219,40,44,118,118,252,197,186,64,12,138,222,75,160,61,102,173,32,37,221,152,84,31,36,37,180,239,105,172,39,86,193,199,58,197,140,188,16,39,226,120,134,176,236,105,147,16,129,240,89,246,241,51,205,40,182,103,4,33,130,154,197,198,154,178,19,226,203,11,149,184,46,113,68,200,247,247,5,212,15,57,184,47,221,35,153,3,96,5,224,57,236,157,242,231,157,59,171,103,13,254,216,227,138,46,86,72,44,24,220,43,125,205,142,181,210,36,166,179,79,29,75,204,187,31,96,236,148,142,25,219,223,238,131,25,64,96,72,72,200,40,4,180,101,208,46,173,14,60,20,217,80,235,70,129,117,106,28,177,27,98,92,192,41,79,219,230,197,34,95,215,108,121,160,172,14,21,13,184,199,31,161,255,208,114,49,254,105,49,126,158,192,60,124,149,206,217,88,197,165,67,187,231,144,239,38,54,173,91,183,239,240,8,116,252,179,20,39,204,52,86,13,185,196,133,99,64,137,166,104,148,177,46,24,148,11,164,182,250,30,114,45,130,114,109,31,98,93,18,20,64,108,173,242,146,148,181,51,81,8,182,141,37,99,208,27,247,59,13,178,220,175,93,106,180,91,91,241,86,111,138,164,177,72,192,179,214,166,64,158,48,150,136,5,51,24,229,250,189,235,150,106,82,144,209,238,29,176,71,236,187,84,212,64,228,22,214,189,250,22,210,126,252,180,152,238,125,145,43,103,41,222,139,114,125,199,131,238,89,47,158,48,247,37,134,170,250,208,130,63,175,95,161,0,52,164,147,136,70,46,53,152,168,97,178,189,182,80,119,221,130,217,200,179,88,240,176,249,83,41,199,107,183,24,240,95,194,230,53,140,63,242,39,186,156,64,194,23,239,130,120,225,221,0,246,58,47,227,88,63,234,84,133,106,212,171,223,157,246,14,48,88,45,162,191,3,204,48,134,156,110,177,154,236,104,200,58,62,31,138,58,12,168,88,191,33,245,135,228,91,80,238,173,232,72,155,111,205,80,9,122,179,172,49,63,248,111,98,92,138,116,174,189,12,213,147,106,116,32,22,6,106,179,90,59,178,11,105,234,29,191,11,40,74,242,63,181,40,22,76,109,14,240,107,60,213,94,103,43,32,112,139,244,242,118,96,188,35,69,219,230,201,160,167,64,117,144,210,40,29,192,49,212,9,192,236,146,234,88,114,137,115,175,181,187,131,49,108,98,27,187,225,7,106,247,54,169,76,199,176,67,116,108,164,33,92,34,127,247,100,180,242,237,223,94,206,247,85,178,164,155,171,150,75,224,67,193,233,17,91,36,144,62,56,10,237,51,113,200,59,170,221,173,111,251,182,95,31,49,221,187,210,24,24,211,39,153,220,184,127,10,14,112,171,203,208,144,53,107,115,22,215,241,10,98,204,183,232,202,60,195,106,71,134,217,105,175,39,57,60,249,191,188,107,196,133,127,186,56,76,64,152,168,219,42,212,147,54,93,108,223,160,246,67,2,199,102,223,238,150,183,36,238,182,247,125,16,136,128,162,0,149,81,119,15,94,161,191,57,142,147,108,72,105,182,246,93,75,230,79,62,153,51,42,75,169,60,91,202,56,224,82,198,154,232,165,230,143,210,200,252,156,230,203,104,30,7,48,95,125,110,198,114,25,151,167,128,75,95,39,52,48,188,250,228,189,239,76,58,43,182,71,182,223,247,18,0,81,4,226,226,83,223,3,99,215,58,74,137,107,155,248,199,28,141,129,243,68,112,93,167,198,135,201,87,97,241,97,122,99,103,50,122,146,84,152,16,233,146,225,216,230,179,234,209,37,201,19,40,118,141,30,186,6,210,73,3,88,97,27,21,176,247,103,42,36,230,226,156,254,44,104,221,125,130,42,101,14,130,157,88,132,145,212,11,223,152,124,219,199,8,215,61,187,129,207,231,153,96,51,155,154,55,108,113,3,32,218,7,109,68,100,126,252,254,7,13,242,51,44,44,30,67,198,48,172,148,93,246,136,71,105,246,39,201,184,177,208,9,12,93,11,156,204,93,5,45,154,116,125,184,55,142,23,207,171,171,114,144,49,170,123,62,193,217,217,40,68,95,156,40,217,134,174,94,225,205,37,122,241,229,121,197,107,153,188,180,251,56,225,178,89,54,7,114,136,161,106,211,191,81,185,192,204,16,167,49,24,59,153,35,96,38,51,236,239,32,133,51,138,216,248,98,129,230,140,30,55,68,120,142,47,176,29,54,194,47,182,108,2,111,254,239,236,47,23,174,233,64,203,133,122,73,245,33,135,231,104,133,90,153,83,178,139,126,64,125,219,252,75,146,0,157,14,160,233,54,231,59,19,193,217,106,112,176,50,202,121,251,230,25,102,138,125,59,158,234,124,94,189,15,61,127,215,175,187,116,142,22,117,93,233,37,48,33,52,235,95,161,66,72,48,35,120,21,71,28,96,214,169,112,41,190,113,58,69,201,115,86,112,163,70,198,224,79,198,181,160,198,53,116,80,236,155,14,90,234,54,135,185,83,253,64,95,166,169,32,32,198,48,237,62,220,63,80,213,190,11,59,157,27,79,242,250,123,122,94,90,219,232,156,67,13,8,20,56,203,179,210,223,39,24,75,194,126,78},
} ;

static void test_decode_1013x2393_impl(long long impl)
{
  unsigned char *x = test_decode_1013x2393_x;
  unsigned char *s = test_decode_1013x2393_s;
  unsigned char *x2 = test_decode_1013x2393_x2;
  unsigned char *s2 = test_decode_1013x2393_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1013x2393_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1013x2393(impl);
    printf("decode_1013x2393 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013x2393_implementation(impl),ntruprime_dispatch_decode_1013x2393_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1013x2393;
    printf("decode_1013x2393 selected implementation %s compiler %s\n",ntruprime_decode_1013x2393_implementation(),ntruprime_decode_1013x2393_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1013x2393_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1013x2393_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1013x2393_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1013x2393_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1013x2393_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1013x2393_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1013x2393(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013x2393")) return;
  storage_decode_1013x2393_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1013x2393_x = aligned(storage_decode_1013x2393_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1013x2393_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1013x2393_s = aligned(storage_decode_1013x2393_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1013x2393_x2 = callocplus(maxalloc);
  test_decode_1013x2393_x2 = aligned(storage_decode_1013x2393_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1013x2393_s2 = callocplus(maxalloc);
  test_decode_1013x2393_s2 = aligned(storage_decode_1013x2393_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1013x2393 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1013x2393();++impl)
      forked(test_decode_1013x2393_impl,impl);
    ++test_decode_1013x2393_x;
    ++test_decode_1013x2393_s;
    ++test_decode_1013x2393_x2;
    ++test_decode_1013x2393_s2;
  }
  free(storage_decode_1013x2393_s2);
  free(storage_decode_1013x2393_x2);
  free(storage_decode_1013x2393_s);
  free(storage_decode_1013x2393_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

