/* postpost.c -- DVI command 249.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include "extern.h"


int
DEFUN_VOID (post_postamble)
{
  int format;
  int count;
  int number;

  skip (4);

  format = get_number (1, UNSIGNED);

  if (format != dvi_format)
    die ("%s:%s: Inconsistent DVI format\n", prog_name, dvi_name);

  count = 4 - (dvi_pos % 4);
  if (count < 4)
    count += 4;

  for (; count > 0; --count)
    {
      number = get_number (1, UNSIGNED);
      if (number != 223)
	die ("%s:%s: There is no `223' at position %d\n",
	  prog_name, dvi_name, dvi_pos - 1);
    }

  return (0);
}
