/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.upload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import org.apache.turbine.services.uniqueid.TurbineUniqueId;
import org.apache.turbine.services.upload.TurbineUpload;

public class FileItem
implements DataSource {
    public static final int DEFAULT_UPLOAD_SIZE_THRESHOLD = 10240;
    protected String fileName;
    protected String contentType;
    protected byte[] content;
    protected File storeLocation;
    protected ByteArrayOutputStream byteStream;

    public String getName() {
        return this.getFileName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean inMemory() {
        return this.content != null || this.byteStream != null;
    }

    public long getSize() {
        if (this.storeLocation != null) {
            return this.storeLocation.length();
        }
        if (this.byteStream != null) {
            return this.byteStream.size();
        }
        return this.content.length;
    }

    public byte[] get() {
        if (this.content == null) {
            if (this.storeLocation != null) {
                this.content = new byte[(int)this.getSize()];
                try {
                    FileInputStream fis = new FileInputStream(this.storeLocation);
                    fis.read(this.content);
                }
                catch (Exception e) {
                    this.content = null;
                }
            } else {
                this.content = this.byteStream.toByteArray();
                this.byteStream = null;
            }
        }
        return this.content;
    }

    public String getString() {
        return new String(this.get());
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public InputStream getInputStream() throws IOException {
        return this.getStream();
    }

    public InputStream getStream() throws IOException {
        if (this.content == null) {
            if (this.storeLocation != null) {
                return new FileInputStream(this.storeLocation);
            }
            this.content = this.byteStream.toByteArray();
            this.byteStream = null;
        }
        return new ByteArrayInputStream(this.content);
    }

    public File getStoreLocation() {
        return this.storeLocation;
    }

    protected void finalize() {
        if (this.storeLocation != null && this.storeLocation.exists()) {
            this.storeLocation.delete();
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.storeLocation == null) {
            return this.byteStream;
        }
        return new FileOutputStream(this.storeLocation);
    }

    public static FileItem newInstance(String path, String name, String contentType, int requestSize) {
        FileItem item = new FileItem(name, contentType);
        if (requestSize > TurbineUpload.getSizeThreshold()) {
            String instanceName = TurbineUniqueId.getInstanceId();
            String fileName = TurbineUniqueId.getUniqueId();
            fileName = instanceName + "_upload_" + fileName + ".tmp";
            fileName = path + "/" + fileName;
            item.storeLocation = new File(fileName);
        } else {
            item.byteStream = new ByteArrayOutputStream();
        }
        return item;
    }

    public void write(String file) throws Exception {
        if (this.inMemory()) {
            FileWriter writer = new FileWriter(file);
            writer.write(this.getString());
        } else if (this.storeLocation != null) {
            if (!this.storeLocation.renameTo(new File(file))) {
                throw new Exception("Cannot write uploaded file to disk!");
            }
        } else {
            throw new Exception("Cannot write uploaded file to disk!");
        }
    }

    protected FileItem(String fileName, String contentType) {
        this.fileName = fileName;
        this.contentType = contentType;
    }
}

