%define buildver 0.17
%define specrel 2ark

# CVS versions are pre-releases and must be treated differently than "real"
# releases, because otherwise we end up with a version "xyzCVS", which rpm
# thinks is "newer" than a version "xyz", although in fact it's the other way
# around. The fix for this is to strip off the "CVS" from the version number
# and use it in the "release" field instead.
%define rawversion %(echo "%{buildver}" | %{__sed} -e 's@CVS$@@')
%define cvsrelease %(echo "%{buildver}" | %{__sed} -e 's@^.*CVS$@CVS@')
%define releasever %(if [ "%{cvsrelease}" = "CVS" ]; then echo "0.CVS.%{specrel}"; else echo "%{specrel}"; fi)

Name:		openclipart
Version:	%{rawversion}
Release:	%{releasever}
Summary:	Public domain clip art collection
URL:		http://www.openclipart.org/
Source0:	http://www.openclipart.org/downloads/%{buildver}/openclipart-%{buildver}-full.tar.bz2
License:	Public Domain
Group:		Applications/Publishing
BuildRoot:	%{_tmppath}/%{name}-%{buildver}-%{release}-root
BuildArch:	noarch

# This package is specifically designed to be relocatable
Prefix:		%{_datadir}/clipart

%description
%{summary}.

%prep
%setup -q -n openclipart-%{buildver}-full

%build
%{__make}

%install
%{__rm} -rf %{buildroot}
%{__make} install \
	DESTDIR=%{buildroot} \
	DATADIR=%{_datadir} \
	INSTALL=%{__install}

%files
%defattr(-,root,root,0755)
%{_datadir}/clipart/

%clean
%{__rm} -rf %{buildroot}

%changelog
* Mon Aug 22 2005 Paul Howarth <paul@city-fan.org> - 0.17-2ark
- add hooks for auto-specfile-editing in "make rpm", including sensible
  handling of CVS versions

* Mon Jul 11 2005 Bernhard Rosenkraenzer <bero@...> 0.15-1ark
- 0.15

* Sat May 14 2005 Bernhard Rosenkraenzer <bero@...> 0.13.2-1ark
- initial RPM
